/*
For general Scribus (>=1.3.2) copyright and licensing information please refer
to the COPYING file provided with the program. Following this notice may exist
a copyright and/or license notice that predates the release of Scribus 1.3.2
for which a new license (GPL+exception) is in place.
*/
#include "arrowchooser.h"
#include "arrowchooser.moc"
#include "fpointarray.h"
#include <qpixmap.h>
#include <qlistbox.h>
#include "scpainter.h"
#include <qimage.h>
#include "util.h"

ArrowChooser::ArrowChooser(QWidget* pa, bool direction)  : QComboBox(true, pa)
{
	setEditable(false);
	clear();
	insertItem( tr("None"));
	setMaximumWidth(listBox()->maxItemWidth()*2+22);
	arrowDirection = direction;
}

void ArrowChooser::rebuildList(QValueList<ArrowDesc> *arrowStyles)
{
	clear();
	FPointArray Path;
	Path.resize(0);
	insertItem( tr("None"));
	for (uint a = 0; a < arrowStyles->count(); ++a)
	{
		QPixmap Ico(22, 22);
		ScPainter *painter = new ScPainter(&Ico, 22, 22);
		painter->setBrush(qRgb(0, 0, 0));
		painter->setPen(qRgb(0, 0, 0));
		painter->setFillMode(1);
		painter->translate(3.0, 3.0);
		Path.resize(0);
		Path = (*arrowStyles->at(a)).points.copy();
		FPoint min = getMinClipF(&Path);
		Path.translate(-min.x(), -min.y());
		FPoint max = Path.WidthHeight();
		QWMatrix mm;
		QWMatrix mm2;
		if (arrowDirection)
		{
			mm2.scale(-1, 1);
			mm2.translate(-max.x(), 0);
		}
		mm.scale(16.0 / QMAX(max.x(), max.y()), 16.0 / QMAX(max.x(), max.y()));
		Path.map(mm2 * mm);
		painter->setupPolygon(&Path);
		painter->setLineWidth(1.0);
		painter->drawPolygon();
		painter->drawPolyLine();
		painter->end();
		delete painter;
		QImage image;
		image = Ico.convertToImage();
  		image = image.convertDepth(32);
		image.setAlphaBuffer(true);
		int wi = image.width();
		int hi = image.height();
    	for( int yi=0; yi < hi; ++yi )
		{
			QRgb *s = (QRgb*)(image.scanLine( yi ));
			for(int xi=0; xi < wi; ++xi )
			{
				if((*s) == 0xffffffff)
					(*s) &= 0x00ffffff;
				s++;
			}
    	}
		Ico.convertFromImage(image);
		insertItem(Ico, (*arrowStyles->at(a)).name);
	}
	listBox()->setMinimumWidth(listBox()->maxItemWidth()+24);
}
