/*
            Search and Rescue Master Compile Time Configuration
 */

#ifndef CONFIG_H
#define CONFIG_H


/*
 *      Program name:
 */
#define PROG_NAME	"Search and Rescue"

/*
 *      Program version:
 */
#define PROG_VERSION            "0.7.15"

#define PROG_VERSION_MAJOR      0
#define PROG_VERSION_MINOR      7
#define PROG_VERSION_RELEASE	15


/*
 *      Program usage message:
 */
#define PROG_USAGE_MESG "\
Usage: SearchAndRescue [options] [GUI_options]\n\
\n\
    [options] can be any of the following:\n\
\n\
        --rcfile <file>         Load configuration from <file>.\n\
        -f                      Same as --rcfile.\n\
        --control <type>        Specify which controller to use:\n\
                                   keyboard\n\
                                   joystick\n\
        -c                      Same as --control.\n\
        --hardware_rendering    Use direct hardware rendering (default).\n\
        --software_rendering    Use software rendering instead of direct\n\
                                hardware rendering.\n\
        --display <address>     Specifies display address.\n\
        --fullscreen            Specifies to use full screen mode at startup,\n\
                                use this if and only if the GUI does not allow\n\
                                manual switching to full screen.\n\
        --recorder <address>    Specifies recorder address.\n\
        --nosound               Do not connect to sound server.\n\
        --nomenubg              No menu background images.\n\
        --console_quiet         Do not print routine messages to stdout.\n\
        --runtime_debug         Print runtime detection messages to stdout.\n\
        --internal_debug        Print internal (terse) messages to stdout.\n\
        --help                  Prints (this) help screen and exits.\n\
        --version               Prints version information and exits.\n\
\n\
    Most customizations can be performed in the options menu.\n\
\n\
    Command line options override any options in the configuration file.\n\
\n\
    [GUI_options] can be any options standard to your GUI, consult your\n\
    GUI's manual for available options.\n\
\n"


/*
 *      Program copyright:
 */
#define PROG_COPYRIGHT  "\
Copyright (C) 1999-2001 WolfPack Entertainment.\n\
This program is protected by international copyright laws and treaties,\n\
distribution and/or modification of this software in violation of the\n\
GNU Public License is strictly prohibited. Violators will be prosicuted\n\
to the fullest extent of the law."



/*
 *      Default size (in pixels) of the toplevel game window:
 *
 *	This must be the smallest resolution that is standard on a
 *	majority of platforms, please do not increase this size.
 *
 *	You can always adjust the size of the toplevel window by dragging
 *	the Window Manager's lower right frame corner.
 *
 *	If you need to specify a size at startup for certain conditions
 *	that require the size to be defined at start up (ie Voodoo cards)
 *	then use the argument --geometry WxH+X+Y (see manual page of
 *	this program for more details).
 *
 *	This program will record the last size of the toplevel and use 
 *	that the next time you run it.
 */
#define SAR_DEF_WINDOW_WIDTH    320
#define SAR_DEF_WINDOW_HEIGHT   240


/*
 *	Maximum length of an object name in bytes (include null terminating
 *	byte):
 */
#define SAR_OBJ_NAME_MAX	256

/*
 *	Maximum literal game command (not including argument) length:
 */
#define SAR_CMD_MAX		80

/*
 *      Default directory paths:
 */

/* Local game dir, user's $HOME directory will be prefixed to this. */
#define SAR_DEF_LOCAL_DATA_DIR  ".SearchAndRescue"

/* Global game dir. */
#define SAR_DEF_GLOBAL_DATA_DIR "/usr/share/games/SearchAndRescue"

/* Subdirs, one of each in the local and global game dirs. */
#define SAR_DEF_AIRCRAFTS_DIR		"aircrafts"
#define SAR_DEF_CONTROL_PANELS_DIR	"control_panels"
#define SAR_DEF_IMAGES_DIR		"images"
#define SAR_DEF_MISSIONS_DIR		"missions"
#define SAR_DEF_OBJECTS_DIR		"objects"
#define SAR_DEF_SCENERY_DIR		"scenery"
#define SAR_DEF_SOUNDS_DIR		"sounds"
#define SAR_DEF_TEXTURES_DIR		"textures"

/* Environment variable name that contains the value for the global 
 * directory.
 */
#define SAR_DEF_ENV_GLOBAL_DIR	"SEARCHANDRESCUE_DATA"


/*
 *	Default file paths:
 */

/* Run time preferances file. */
#define SAR_DEF_RC_FILE			"SearchAndRescue.ini"

/* Texture referance names and file names list file. */
#define SAR_DEF_TEXTURES_FILE		"textures.ini"

/* Human data presets file. */
#define SAR_DEF_HUMAN_FILE		"human.ini"

/* Weather data presets file. */
#define SAR_DEF_WEATHER_FILE		"weather.ini"

/* Icon paths. */
#ifdef __MSW__
# define SAR_DEF_SAR_ICON_FILE		"SearchAndRescue.ico"
#else
# define SAR_DEF_SAR_ICON_FILE		"/usr/share/icons/SearchAndRescue.xpm"
#endif

/* Standard texture referance names that must be defined in
 * the SAR_DEF_TEXTURES_FILE.
 */
#define SAR_STD_TEXNAME_BASKET_BOTTOM		"sar_basket_bottom"
#define SAR_STD_TEXNAME_BASKET_END		"sar_basket_end"
#define SAR_STD_TEXNAME_BASKET_SIDE		"sar_basket_side"
#define SAR_STD_TEXNAME_EXPLOSION		"sar_explosion"
#define SAR_STD_TEXNAME_FIRE			"sar_fire"
#define SAR_STD_TEXNAME_HELIPAD_PAVED		"sar_helipad_paved"
#define SAR_STD_TEXNAME_HELIPAD_BARE		"sar_helipad_bare"
#define SAR_STD_TEXNAME_HELIPAD_BUILDING	"sar_helipad_building"
#define SAR_STD_TEXNAME_HELIPAD_VEHICLE		"sar_helipad_vehicle"
#define SAR_STD_TEXNAME_RUNWAY			"sar_runway"
#define SAR_STD_TEXNAME_ROTOR_WASH		"sar_rotor_wash"
#define SAR_STD_TEXNAME_SPLASH			"sar_splash"		/* Water splash. */
#define SAR_STD_TEXNAME_SMOKE_LIGHT		"sar_smoke_light"
#define SAR_STD_TEXNAME_SMOKE_MEDIUM		"sar_smoke_medium"
#define SAR_STD_TEXNAME_SMOKE_DARK		"sar_smoke_dark"
#define SAR_STD_TEXNAME_WATER_RIPPLE		"sar_water_ripple"

/* Menu background images. */
#define SAR_DEF_MENU_BGIMG_STANDARD_FILE	"images/menu_std_bg.tga"
#define SAR_DEF_MENU_BGIMG_FREE_FLIGHT_FILE	"images/menu_free_flight.tga"
#define SAR_DEF_MENU_BGIMG_MAIN_FILE		"images/menu_main.tga"
#define SAR_DEF_MENU_BGIMG_MISSION_FILE		"images/menu_mission.tga"
#define SAR_DEF_MENU_BGIMG_OPTIONS_FILE		"images/menu_options.tga"
#define SAR_DEF_MENU_BGIMG_PROGRESS_FILE	"images/menu_progress.tga"

/* Mission map icon images. */
#define SAR_DEF_MISSION_MAPICON_HELIPAD_FILE	"images/mi_helipad.tga"
#define SAR_DEF_MISSION_MAPICON_INTERCEPT_FILE	"images/mi_intercept.tga"
#define SAR_DEF_MISSION_MAPICON_HELICOPTER_FILE	"images/mi_helicopter.tga"
#define SAR_DEF_MISSION_MAPICON_VICTIM_FILE	"images/mi_victim.tga"
#define SAR_DEF_MISSION_MAPICON_BOAT_FILE	"images/mi_boat.tga"


/* Sound objects. */
#define SAR_DEF_SOUND_LAND_WHEEL_SKID	"sounds/land_wheel_skid.wav"
#define SAR_DEF_SOUND_LAND_SKI_SKID	"sounds/land_ski_skid.wav"
#define SAR_DEF_SOUND_LAND_SKI		"sounds/land_ski.wav"
#define SAR_DEF_SOUND_LAND_BELLY	"sounds/land_belly.wav"
#define SAR_DEF_SOUND_CRASH_OBSTRUCTION	"sounds/crash_obstruction.wav"
#define SAR_DEF_SOUND_CRASH_GROUND	"sounds/crash_ground.wav"
#define SAR_DEF_SOUND_SPLASH_AIRCRAFT	"sounds/splash_aircraft.wav"
#define SAR_DEF_SOUND_SPLASH_HUMAN	"sounds/splash_human.wav"

/*
 *	Standard human preset names, corresonds to human preset data
 *	entries in the file SAR_DEF_HUMAN_FILE.
 */
#define SAR_HUMAN_PRESET_NAME_STANDARD		"standard"
#define SAR_HUMAN_PRESET_NAME_DIVER		"diver"


/*
 *	Comment character (for program's file formats):
 */
#define SAR_COMMENT_CHAR	'#'

/*
 *	Program configuration deliminator character.
 */
#define SAR_CFG_DELIM_CHAR	'='


/*
 *      Show messages for this many milliseconds when a new one is
 *      printed.
 */
#define SAR_MESSAGE_SHOW_INT    5000


/*
 *	Human contact cylendrical bounds (origin at base of feet)
 *	in meters:
 */
#define SAR_HUMAN_CONTACT_RADIUS	1.2
#define SAR_HUMAN_CONTACT_ZMAX		1.8
#define SAR_HUMAN_CONTACT_ZMIN		0.0


/*
 *      Smoke puff respawn interval in milliseconds:
 */
#define SAR_DEF_SMOKE_SPAWN_INT     3000

/*
 *      Smoke puff life span in milliseconds:
 */
#define SAR_DEF_SMOKE_LIFE_SPAN     12000

/*
 *      Explosion frame increment interval in milliseconds:
 */
#define SAR_DEF_EXPLOSION_FRAME_INT	500

/*
 *	Splash frame increment interval in milliseconds:
 */
#define SAR_DEF_SPLASH_FRAME_INT	600

/*
 *	Firy explosions caused by crashes last this long in
 *	milliseconds:
 */
#define SAR_DEF_CRASH_EXPLOSION_LIFE_SPAN   60000

/*
 *	Dropped fuel tanks life span after hitting ground in
 *	milliseconds:
 */
#define SAR_DEF_FUEL_TANK_LIFE_SPAN	30000

/*
 *	Lightning life span in milliseconds:
 */
#define SAR_DEF_LIGHTNING_ON_INT	750

/*
 *	Human object fall rate (in meters per cycle):
 */
#define SAR_DEF_HUMAN_FALL_RATE		-3.0


/*
 *	Default planetary mean radius (in meters):
 *
 *	Here we use Earth's mean radius.
 */
#define SAR_DEF_PLANET_RADIUS		6371000
/* #define SAR_DEF_PLANET_RADIUS	6367470.96322 */

/*
 *	Rotor wash visiblity coefficient:
 */
#define SAR_DEF_ROTOR_WASH_VIS_COEFF	0.5

/*
 *	Default ground base graphics tiling (in meters):
 */
#define SAR_DEF_GROUND_BASE_TILE_WIDTH		400
#define SAR_DEF_GROUND_BASE_TILE_HEIGHT		400
#define SAR_DEF_GROUND_BASE_TILE_CLOSE_RANGE	1600


/*
 *	Default cloud layer graphics tiling (in meters):
 */
#define SAR_DEF_CLOUD_TILE_WIDTH		8000
#define SAR_DEF_CLOUD_TILE_HEIGHT		8000
#define SAR_DEF_CLOUD_TILE_CLOSE_RANGE		16000

/*
 *	Default hollow surface contact z tolorance (in meters):
 */
#define SAR_DEF_SURFACE_CONTACT_Z_TOLORANCE	0.25

/*
 *	Default helipad visual range (in meters):
 */
#define SAR_HELIPAD_DEF_RANGE		5000


/*
 *	Default human visual range (in meters):
 */
#define SAR_HUMAN_DEF_RANGE		1200

/*
 *	Human animation rate (in animation units per cycle):
 */
#define SAR_HUMAN_ANIM_RATE	50000


/*
 *	Mission map default meters to pixels coefficient (for zooming):
 */
#define SAR_MAP_DEF_MTOP_COEFF	0.01

/*
 *	Default aircraft engine sound carry distance in meters:
 */
#define SAR_DEF_AIRCRAFT_ENGINE_SOUND_DISTANCE	1300


/*
 *	Keyboard functions help message, array of strings. Each
 *	pair of strings defines one line where the first string is
 *	the key name and the second string is the description.
 */
#define SAR_KEYS_HELP_MESSAGES	{ \
 "F1", "Display key functions.", \
 "F2", "Cockpit view.", \
 "F3", "Spot view.", \
 "F4", "Fly by tower view.", \
 "F5", "Rescue basket view.", \
 "CURSORS", "Attitude control.", \
 "SHIFT + CURSORS", "Move/orbit view.", \
 "BKSP", "Normalize view.", \
 "PGUP/PGDN", "Throttle/Collective.", \
 "SHIFT + PGUP/PGDN", "Throttle/Collective fast.", \
 "CTRL + CURSORS", "Rudder/steering.", \
 "HOME", "Elevator trim down or slew up.", \
 "END", "Elevator trim up or slew down.", \
 "CTRL + HOME", "Elevator trim center.", \
 "-/+", "Zoom in/out.", \
 "CTRL + -/+", "Hoist in/out.", \
 "E", "Start up engines.", \
 "SHIFT + E", "Turn engines off.", \
 "G", "Raise/lower landing gears.", \
 "P", "Select hoist deployment type.", \
 "D", "Open/close door.", \
 "O", "Strobes on/off.", \
 "L", "Lights on/off.", \
 "H", "HUD and text brighten.", \
 "SHIFT + H", "HUD and text darken.", \
 "M", "Map.", \
 "W", "Select waypoint.", \
 "F", "Fuel status.", \
 "SHIFT + F", "Transfer external fuel tanks.", \
 "CTRL + F", "Jetteson external fuel tanks.", \
 "S", "Scores/mission status.", \
 ".", "Wheel brakes.", \
 "SHIFT + .", "Parking brakes.", \
 "R", "Refuel/repair (helipad permitting).", \
 "Z", "Decelerate time (slow-motion).", \
 "SHIFT + Z", "Accelerate time (compress).", \
 "/", "Literal (cheat) command.", \
 "CTRL + A", "Slew (cheat) toggle.", \
 "T", "Increase time of day.", \
 "SHIFT + T", "Decrease time of day.", \
 "CTRL + D", "Flight physics.", \
 "CTRL + S", "Sound level.", \
 "F9", "Toggle ground texture.", \
 "F10", "Toggle atmosphere.", \
 "F11", "Toggle object texture.", \
 "F12", "Toggle clouds.", \
 "SHIFT + F12", "Toggle prop wash." \
}

/*
 *	Help page heading (page number & total pages appended to
 *	string):
 */
#define SAR_MESG_HELP_PAGE_HEADING	"Help Page"

/*
 *	Longest line length in SAR_KEYS_HELP_MESSAGES plus 2 extra
 *	characters for tolorance:
 */
#define SAR_KEYS_HELP_MESSAGE_LINE_MAX	80


/*
 *	Various messages:
 */
#define SAR_MESG_NO_ROOM_LEFT_FOR_PASSENGERS	"\
No room left for additional passengers!"

#define SAR_MESG_NO_SUCH_COMMAND	"\
No such command"

#define SAR_MESG_NO_SUCH_OBJECT		"\
No such object"

#define SAR_MESG_PASSENGERS		"\
Passengers"


#define SAR_MESG_HOIST_END_SELECT_DIVER		"\
Hoist Rope Deployment: Diver Ready"

#define SAR_MESG_HOIST_END_SELECT_BASKET	"\
Hoist Rope Deploymeny: Basket Ready"

#define SAR_MESG_HOIST_END_SELECT_ROPE_OUT	"\
Hoist rope is currently deployed"


#define SAR_MESG_MISSION_IN_PROGRESS_ENROUTE	"\
Mission in progress, enroute to"

#define SAR_MESG_TIME_LEFT		"\
Time left"

#define SAR_MESG_MISSION_ACCOMPLISHED_BANNER	"\
MISSION ACCOMPLISHED"

#define SAR_MESG_MISSION_FAILED_BANNER		"\
MISSION FAILED"

#define SAR_MESG_MISSION_POST_FAILED_BANNER	"\
PRESS SPACE TO CONTINUE"


#define SAR_MESG_MISSION_OBJECTIVE_ACHIEVED	"\
Mission objective achieved!"

#define SAR_MESG_MISSION_OBJECT_FAILED		"\
Mission objective failed!"

#define SAR_MESG_MISSION_ARRIVE_COMPLETE	"\
Arrive mission complete!"

#define SAR_MESG_MISSION_ARRIVE_FAILED_TIME	"\
Arrive mission failed, time ran out!"

#define SAR_MESG_MISSION_RESCUE_COMPLETE	"\
Rescue mission complete!"

#define SAR_MESG_MISSION_RESCUE_FAILED_TIME	"\
Rescue mission failed, time ran out!"

#define SAR_MESG_MISSION_RESCUE_IN_PROGRESS	"\
Rescue in progress"

#define SAR_MESG_MISSION_MORE_TO_FIND		"\
more to find..."

#define SAR_MESG_MISSION_ALL_FOUND		"\
all found!"

#define SAR_MESG_MISSION_TO_GET_ALL_TO_SAFETY	"\
to get all to safety!"

#define SAR_MESG_MISSION_TO_PICK_UP_ALL		"\
to pick up all!"


/* Super imposed messages. */
#define SAR_MESG_PARKING_BRAKES			"\
PARKING BRAKES ON"
#define SAR_MESG_WHEEL_BRAKES			"\
WHEEL BRAKES ON"
#define SAR_MESG_OVERSPEED			"\
OVERSPEED"



#define SAR_MESG_TIME_OF_DAY			"\
Time of day"

#define SAR_MESG_CANNOT_CLOSE_DOOR_BASKET	"\
Cannot close door, basket is still out!"


#define SAR_MESG_CRASH_BANNER			"\
CRASH"

#define SAR_MESG_COLLISION_BANNER		"\
COLLISION"

#define SAR_MESG_POST_CRASH_BANNER		"\
PRESS SPACE TO CONTINUE"

#define SAR_MESG_CRASH_OVERSPEED_BANNER		"\
STRUCTURE OVERSPEED FAILURE"


#define SAR_MESG_CRASH_ROTATION_TOO_STEEP	"\
*** ROTATION TOO STEEP! ***"

#define SAR_MESG_CRASH_SPLASH			"\
*** SPLASH! ***"

/* The "%.0f%%" will be replaced with the percentage of intolorable
 * damage to the object.
 */
#define SAR_MESG_CRASH_IMPACTED_PAST_TOLORANCE	"\
*** IMPACTED %.0f%% OF TOLORANCE ***"

#define SAR_MESG_CRASH_OBSTRUCTION	"\
*** OBSTRUCTION ***"

#define SAR_MESG_CRASH_GROUND		"\
*** GROUND ***"

#define SAR_MESG_CRASH_MOUNTAIN		"\
*** MOUNTAIN ***"

#define SAR_MESG_CRASH_BOULDING		"\
*** BUILDING ***"

#define SAR_MESG_CRASH_AIRCRAFT		"\
*** AIRCRAFT ***"


#define SAR_MESG_FLIGHT_PHYSICS_UNSUPPORTED	"\
Unsupported flight physics mode"

#define SAR_MESG_FLIGHT_PHYSICS_EASY		"\
Flight Physics: Easy"

#define SAR_MESG_FLIGHT_PHYSICS_MODERATE	"\
Flight Physics: Moderate"

#define SAR_MESG_FLIGHT_PHYSICS_REALISTIC	"\
Flight Physics: Realistic"


#define SAR_MESG_NO_RESERVE_FUEL_TO_TRANSFER	"\
No reserved fuel to transfer"

/* %.0f is replaced with the amount of reserved fuel transfered from
 * reserved tanks to main tanks in lbs.
 */
#define SAR_MESG_RESERVE_FUEL_TRANSFERED	"\
Transfered %.0f lbs of fuel"


#endif	/* CONFIG_H */
