/*
        Graphics IO Wrapper (easier to use and more powerful than GLUT)
 */

#ifndef GW_H
#define GW_H

#ifdef __cplusplus
# define NOMANGLE
extern "C"
{
#endif	/* NOMANGLE */


#include <sys/types.h>

#include "../include/os.h"

/* Include OS specific header files. */
#if defined(__MSW__)

#else
# include <GL/glx.h>
#endif

#include "stategl.h"


/*
 *	Type make-ups:
 */
#ifndef Pixel
# define Pixel		unsigned long
#endif
#ifndef Bool
# define Bool		char
#endif
#ifndef Boolean
# define Boolean	Bool
#endif

#ifdef __MSW__
# ifndef False
#  define False	0
# endif
# ifndef True
#  define True	1
# endif
#endif	/* __MSW__ */

#ifdef __MSW__
# ifndef u_int8_t
#  define u_int8_t	unsigned char
# endif
# ifndef u_int16_t
#  define u_int16_t	unsigned short
# endif
# ifndef u_int32_t   
#  define u_int32_t	unsigned int
# endif
#endif	/* __MSW__ */

#ifndef BYTES_PER_PIXEL8
# define BYTES_PER_PIXEL8	1
#endif
#ifndef BYTES_PER_PIXEL15
# define BYTES_PER_PIXEL15	2
#endif
#ifndef BYTES_PER_PIXEL16
# define BYTES_PER_PIXEL16	2
#endif
#ifndef BYTES_PER_PIXEL24
# define BYTES_PER_PIXEL24	4
#endif
#ifndef BYTES_PER_PIXEL32
# define BYTES_PER_PIXEL32	4
#endif


/*
 *	Toplevel window size bounds (in pixels):
 */
#define GW_MIN_TOPLEVEL_WIDTH	100
#define GW_MIN_TOPLEVEL_HEIGHT	70

#define GW_MIN_TOPLEVEL_WIDTH_INC	1
#define GW_MIN_TOPLEVEL_HEIGHT_INC	1

/*
 *	Reasonable max size for geometry string:
 */
#define GW_GEOMETRY_STRING_MAX	256


/*
 *	Non-ascii key values for GW sent to calling functions:
 */
#define GWKeyAlt	0x0100
#define GWKeyCtrl	0x0101
#define GWKeyShift	0x0102

#define GWKeyF1         0x0200
#define GWKeyF2         0x0201
#define GWKeyF3         0x0202
#define GWKeyF4         0x0203
#define GWKeyF5         0x0204
#define GWKeyF6         0x0205
#define GWKeyF7		0x0206
#define GWKeyF8         0x0207
#define GWKeyF9         0x0208
#define GWKeyF10        0x0209
#define GWKeyF11        0x020a
#define GWKeyF12        0x020b
#define GWKeyF13        0x020c
#define GWKeyF14        0x020d
#define GWKeyF15        0x020e
#define GWKeyF16        0x020f
#define GWKeyF17        0x0210
#define GWKeyF18        0x0211
#define GWKeyF19        0x0212
#define GWKeyF20        0x0213

#define GWKeyUp		0x0300
#define GWKeyDown       0x0301
#define GWKeyLeft       0x0302
#define GWKeyRight      0x0303
#define GWKeyCenter     0x0304
#define GWKeyHome	0x0305
#define GWKeyEnd	0x0306
#define GWKeyPageUp	0x0307
#define GWKeyPageDown	0x0308

#define GWKeyBackSpace	0x0400
#define GWKeyDelete	0x0401
#define GWKeyInsert     0x0402

#define GWKeyPause	0x0500
#define GWKeyScrollLock	0x0501
#define GWKeySysReq	0x0502


/*
 *	GW Visibility Function Callback Values:
 */
#define GWVisibilityUnobscured		0
#define GWVisibilityPartiallyObscured	1
#define GWVisibilityFullyObscured	2

/*
 *	GW Pointer Event Code:
 */
#define GWEventTypeButtonPress		1
#define GWEventTypeButtonRelease	2
#define GWEventTypePointerMotion	3

/*
 *	GW Pointer Cursor Codes:
 */
#define GWPointerCursorStandard		1	/* Basic arrow. */
#define GWPointerCursorBusy		2	/* Usually hourglass or watch. */
#define GWPointerCursorTranslate	3	/* 4 arrows in all directions. */
#define GWPointerCursorZoom		4	/* Square with smaller square. */


/*
 *	GW Color Structure:
 */
typedef struct {

	double a, r, g, b;

} GWColor;


/*
 *	GW Font Type:
 */
#define GWFont	u_int8_t

/*
 *      Accelerator key structure:
 */
typedef struct {

	/* Any character value or GWKey*. */
	int key;

	/* GWKeyAlt, GWKeyCtrl, GWKeyShift, or 0. */
	int modifier;

} gw_accelerator_struct;


#ifdef X_H
/*
 *	Button widget for X:
 */
typedef struct {

	Window toplevel;
        Pixmap toplevel_buf;
	int x, y;		/* Position coefficients. */
	unsigned int width, height;
	Boolean in_focus, map_state;
	Window parent;

#define GWX_BUTTON_FLAG_CAN_DEFAULT	(1 << 0)
#define GWX_BUTTON_FLAG_HAS_DEFAULT	(1 << 1)
#define GWX_BUTTON_FLAG_SENSITIVE	(1 << 2)
	unsigned int flags;

#define GWX_BUTTON_STATE_UNARMED	0
#define GWX_BUTTON_STATE_ARMED		1
#define GWX_BUTTON_STATE_HIGHLIGHTED	2
	int state;	/* One of GWX_BUTTON_STATE_*. */

	/* Accelerator keys. */
	gw_accelerator_struct **accelerator;
	int total_accelerators;

	/* Colors. */
	Pixel	color_fg, color_bg, color_fg_insensitive,
		color_bg_highlighted, color_highlight, color_shade;
	Boolean colors_initialized;

	XFontStruct *font;
	char *label;
	int label_len_pixels, label_height_pixels;

	/* Button press callback, btn_ptr, client_data. */
	void *client_data;
	void (*func_cb)(void *, void *);

} gwx_button_struct;

#define GWX_ICON_INFO		1
#define GWX_ICON_WARNING	2
#define GWX_ICON_ERROR		3
#define GWX_ICON_QUESTION	4

/*
 *	Message dialog for X:
 */
typedef struct {

#define GWX_DIALOG_TYPE_MESG		0
#define GWX_DIALOG_TYPE_CONF		1
#define GWX_DIALOG_TYPE_CONF_CANCEL	2	/* With cancel. */

	int type;		/* One of GWX_DIALOG_TYPE_*. */

	Window toplevel;
        Pixmap toplevel_buf;
	int x, y;		/* Position coefficients. */
        unsigned int width, height, margin;
        Boolean in_focus, map_state;

        Pixel   color_fg, color_bg, color_highlight, color_shade;
	Boolean	colors_initialized;
	Window	icon_w;
	Pixmap	icon, icon_mask;
	unsigned int icon_width, icon_height;

        XFontStruct *font;

	/* Lines of messages. */
	char **strv;
	int strc, longest_line;
	int longest_line_pixels, line_height_pixels, lines_height_pixels;

	gwx_button_struct ok_btn, yes_btn, no_btn, cancel_btn;

} gwx_dialog_struct;
#endif	/* X_H */


/*
 *	GW Display Structure:
 */
typedef struct {

	int gl_version_major, gl_version_minor;
	double aspect_offset;		/* Addition to calculated aspects. */

#ifdef X_H
	int glx_version_major, glx_version_minor;
	Boolean direct_rendering;
	Display *display;
	XVisualInfo *visual_info;
	Boolean has_double_buffer;
	int alpha_channel_bits;
	Boolean has_vidmode_ext;
	int vidmode_ext_event_offset;
	GC gc;
	int depth;
	Pixel black_pix;
	Pixel white_pix;
	Colormap colormap;
	GLXContext glx_context;
	Atom	atom_wm_motif_all_clients,
		atom_wm_motif_hints,
		atom_wm_motif_info,
		atom_wm_motif_menu,
		atom_wm_motif_messages,
		atom_wm_motif_offset,
		atom_wm_motif_query,
		atom_wm_close_window,   /* _NET_CLOSE_WINDOW */
		atom_wm_delete_window,	/* WM_DELETE_WINDOW */
		atom_wm_ping,
		atom_wm_save_yourself,
		atom_wm_state,
		atom_wm_take_focus,
		atom_wm_workarea;	/* _NET_WORKAREA */

	char *def_xfont_name;

	Cursor	cursor_standard,
		cursor_busy,
		cursor_translate,
		cursor_zoom;

	int root_width, root_height;
	int viewport_x, viewport_y, viewport_width, viewport_height;
	Window root;

	int x, y;
	int width, height;	/* Size of toplevel window. */
	Window toplevel;

	/* Last video mode sizes for `fullscreen' and gui, used only
	 * if has_vidmode_ext is True. All values reflect coordinate and
	 * size of window.
	 */
	int	vidmode_last_fullscreen_x,
		vidmode_last_fullscreen_y,
		vidmode_last_fullscreen_width,	/* Also implies res. */
		vidmode_last_fullscreen_height;
	int	vidmode_last_gui_x,
		vidmode_last_gui_y,
		vidmode_last_gui_width,
		vidmode_last_gui_height;

	gwx_dialog_struct mesg_dialog;
	gwx_dialog_struct conf_dialog;
#endif	/* X_H */
#ifdef __MSW__
	int glw_version_major, glw_version_minor;
        void *dc;       /* Device context (HDC). */
        void *rc;       /* Rendering context (HGLRC). */
        void *toplevel; /* Window (HWND). */
	Boolean has_double_buffer;
	int alpha_channel_bits;
	int x, y;
        int width, height;
        void *pid;      /* (HINSTANCE). */

        void *root;
        int root_width, root_height;

	Boolean keyboard_autorepeat;
        Boolean fullscreen;
	Boolean fullscreen_hide_cursor;
#endif  /* __MSW__ */


	/* Need draw callback; client_data */
	void (*func_draw)(void *);
	void *func_draw_data;

	/* Resize callback; client_data, x, y, width, height */
	void (*func_resize)(void *, int, int, int, int);
	void *func_resize_data;

	/* Keypress callback; client_data, key, state */
	void (*func_keyboard)(void *, int, Boolean, long);
	void *func_keyboard_data;

	/* Pointer callback; client_data, x, y, type, btn_num */
	void (*func_pointer)(void *, int, int, int, int, long);
        void *func_pointer_data;

	/* Visibility change callback; client_data, vis_code */
	void (*func_visibility)(void *, int);
	void *func_visibility_data;

        /* Save yourself callback; client_data */
        void (*func_save_yourself)(void *);
        void *func_save_yourself_data;

	/* Close window callback; client_data, window */
	void (*func_close)(void *, void *);
	void *func_close_data;

	/* Timeout callback; client_data */
	void (*func_timeout)(void *);
	void *func_timeout_data;

	Boolean	alt_key_state,
		ctrl_key_state,
		shift_key_state;

	GWFont *current_font;
	GWColor *current_color;

	/* OpenGL state record structure for our GL context. */
	state_gl_struct state_gl;

} gw_display_struct;


extern void GWSetWindowIconFile(
        gw_display_struct *display,
        const char *icon_path, const char *icon_name
);
#ifdef X_H
extern Window GWCreateWindow(
	gw_display_struct *display,
	Window parent,
	int x, int y,
	int width, int height,
	const char *title
);
#endif	/* X_H */
extern gw_display_struct *GWInit(int argc, char **argv);
extern void GWManage(gw_display_struct *display);
extern void GWShutdown(gw_display_struct *display);

#define GWOutputMessageTypeGeneral	0
#define GWOutputMessageTypeWarning	1
#define GWOutputMessageTypeError	2
#define GWOutputMessageTypeQuestion	3
extern void GWOutputMessage( 
        gw_display_struct *display,
	int type,	/* One of GWOutputMessageType*. */
	const char *subject,
	const char *message,
	const char *help_details
);
#define GWConfirmationNotAvailable	-1
#define GWConfirmationNo		0
#define GWConfirmationYes		1
#define GWConfirmationCancel		2
extern int GWConfirmation(
        gw_display_struct *display,
        int type,       /* One of GWOutputMessageType*. */
        const char *subject,
        const char *message,
        const char *help_details
);
extern int GWConfirmationSimple(
        gw_display_struct *display,
        const char *message
);

extern void GWSetDrawCB(
        gw_display_struct *display,
        void (*func)(void *),
	void *data
);
extern void GWSetResizeCB(
        gw_display_struct *display, 
        void (*func)(void *, int, int, int, int),
        void *data
);
extern void GWSetKeyboardCB(
        gw_display_struct *display,
        void (*func)(void *, int, Boolean, long),
        void *data
);
extern void GWSetPointerCB(
	gw_display_struct *display,
        void (*func)(void *, int, int, int, int, long),
        void *data
);
extern void GWSetVisibilityCB(
        gw_display_struct *display,
        void (*func)(void *, int),
        void *data
);
extern void GWSetSaveYourselfCB(
        gw_display_struct *display,
        void (*func)(void *),
        void *data
);
extern void GWSetCloseCB(
        gw_display_struct *display,
        void (*func)(void *, void *),
        void *data
);
extern void GWSetTimeoutCB(
        gw_display_struct *display,
        void (*func)(void *),
        void *data
);

extern void GWPostRedraw(gw_display_struct *display);
extern void GWSwapBuffer(gw_display_struct *display);

extern void GWOrtho2D(gw_display_struct *display);
extern void GWKeyboardAutoRepeat(gw_display_struct *display, Boolean b);

extern gw_accelerator_struct *GWAcceleratorNew(
        int key, int modifier
);
extern void GWAcceleratorDelete(gw_accelerator_struct *a);
extern int GWAcceleratorListAdd(
        gw_accelerator_struct ***a, int *total,
        int key, int modifier
);
extern void GWAcceleratorListDelete(
        gw_accelerator_struct ***a, int *total
);
extern Boolean GWAcceleratorListCheck(
        gw_accelerator_struct **a, int total,
        int key, int modifier
);

extern void GWSetPointerCursor(
        gw_display_struct *display, 
        int cursor      /* One of GWPointerCursor*. */     
);
extern void GWSetInputBusy(gw_display_struct *display);
extern void GWSetInputReady(gw_display_struct *display);

extern GWFont *GWLoadFont(gw_display_struct *display, char *path);
extern void GWSetFont(gw_display_struct *display, GWFont *font);
extern int GWGetFontSize(
	GWFont *font,
	int *width, int *height,
	int *character_spacing, int *line_spacing
);
extern void GWUnloadFont(gw_display_struct *display, GWFont *font);
extern GWColor *GWLoadColor(
        gw_display_struct *display,  
        double a, double r, double g, double b
);
extern void GWSetColor(gw_display_struct *display, GWColor *color);
extern void GWUnloadColor(gw_display_struct *display, GWColor *color);

extern void GWDrawString(
        gw_display_struct *display,
        int x, int y,
        const char *string
);
extern void GWDrawCharacter(
        gw_display_struct *display,
        int x, int y,
        char c
);
extern void GWDrawLine(
        gw_display_struct *display,
        int x1, int y1,
        int x2, int y2
);


#ifdef X_H
/* In gwx_dialog.c */
extern int GWXButtonCreate(
        gw_display_struct *display, gwx_button_struct *btn,
        Window parent,
	int x, int y,
        unsigned int width, unsigned int height,
        const char *label,
	void *client_data,
        void (*func_cb)(void *, void *)
);
extern void GWXButtonResize(gw_display_struct *display, gwx_button_struct *btn);
extern void GWXButtonDraw(gw_display_struct *display, gwx_button_struct *btn);
extern int GWXButtonManage(
        gw_display_struct *display,
        gwx_button_struct *btn,
        XEvent *event
);
extern void GWXButtonDestroy(gw_display_struct *display, gwx_button_struct *btn);

extern void GWXDialogLoadIcon(
        gw_display_struct *display,
        gwx_dialog_struct *md,
        int icon_code           /* One of GWX_ICON_*. */
);
extern int GWXDialogCreate(
        gw_display_struct *display, gwx_dialog_struct *md,
        int type                /* One of GWX_DIALOG_TYPE_*. */
);
extern void GWXDialogResize(
	gw_display_struct *display,
	gwx_dialog_struct *md
);
extern void GWXDialogDraw(
	gw_display_struct *display,
	gwx_dialog_struct *md
);
extern int GWXDialogManage(
	gw_display_struct *display,
	gwx_dialog_struct *md,
	XEvent *event
);
extern void GWXDialogDestroy(
	gw_display_struct *display,
	gwx_dialog_struct *md
);

extern void GWXDialogNoBtnCB(
        void *object, void *client_data
);      
extern void GWXDialogYesBtnCB(
        void *object, void *client_data
);      
extern void GWXDialogCancelBtnCB(
        void *object, void *client_data
);
extern void GWXDialogOKBtnCB(
        void *object, void *client_data
);
extern void GWXDialogSetMesg(
        gw_display_struct *display,
        gwx_dialog_struct *md,
	const char *title,
	const char *mesg,
	const char *details
);
extern void GWXDialogMap(
        gw_display_struct *display,
        gwx_dialog_struct *md
);
extern void GWXDialogUnmap(
        gw_display_struct *display,
        gwx_dialog_struct *md
);
extern int GWXDoBlockUntilConf(gw_display_struct *display);


#endif	/* X_H */





#ifdef NOMANGLE
# undef NOMANGLE
}
#endif	/* NOMANGLE */

#endif	/* GW_H */
