/*
	Definations for sardraw*.c sources only, shouldn't #include these
	anywhere else.
 */

#ifndef SARDRAWDEFS_H
#define SARDRAWDEFS_H

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)	(MIN(MAX((a),(l)),(h)))

#define RADTODEG(r)	((r) * 180.0 / PI)
#define DEGTORAD(d)	((d) * PI / 180.0)


/* Get camera orientation back from GL (can be True or False)?
 * Note: This supposedly slows GL down dramatically if True
 */
#define GET_CAM_DIR	False

/* Turns on GL_DEPTH_TEST and sets the DepthFunc. */
#define SAR_DRAW_DEPTH_TEST_ON		\
{ \
 StateGLEnable(&display->state_gl, GL_DEPTH_TEST); \
 StateGLDepthFunc(&display->state_gl, GL_LEQUAL); \
}
/* Turns off GL_DEPTH_TEST and sets the DepthFunc. */
#define SAR_DRAW_DEPTH_TEST_OFF		\
{ \
 StateGLDisable(&display->state_gl, GL_DEPTH_TEST); \
 StateGLDepthFunc(&display->state_gl, GL_ALWAYS); \
}

/* Turns on GL_TEXTURE_1D and sets the TexEnv. */
#define SAR_DRAW_TEXTURE_1D_ON		\
{ \
 StateGLEnable(&display->state_gl, GL_TEXTURE_1D); \
 StateGLTexEnvI( \
  &display->state_gl, \
  GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE \
 ); \
}
/* Turns off GL_TEXTURE_1D. */
#define SAR_DRAW_TEXTURE_1D_OFF		\
{ \
 StateGLDisable(&display->state_gl, GL_TEXTURE_1D); \
}

/* Turns on GL_TEXTURE_2D and sets the TexEnv. */
#define SAR_DRAW_TEXTURE_2D_ON		\
{ \
 StateGLEnable(&display->state_gl, GL_TEXTURE_2D); \
 StateGLTexEnvI( \
  &display->state_gl, \
  GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE \
 ); \
}
/* Turns off GL_TEXTURE_2D. */
#define SAR_DRAW_TEXTURE_2D_OFF		\
{ \
 StateGLDisable(&display->state_gl, GL_TEXTURE_2D); \
}

/* Force disable of certain states which might have been enabled during
 * a SARVisualModelCallList().
 */
#define POST_CALLLIST_RESET_STATES	\
{ \
 StateGLDisableF(&display->state_gl, GL_BLEND, GL_TRUE); \
}



#endif	/* SARDRAWDEFS_H */
