#include <linux/flask/syscalls.h>
#include <linux/flask/flask.h>

/* Individual AVC calls. */

extern int avc_toggle(void);

extern int avc_enforcing(void);

/* Individual security server calls. */

extern int security_compute_av(struct security_query *query, 
				struct security_response *response);

extern int security_notify_perm(security_id_t ssid, 
				 security_id_t tsid, 
				 security_class_t tclass, 
				 access_vector_t requested);

extern int security_transition_sid(security_id_t ssid, 
				    security_id_t tsid, 
				    security_class_t tclass, 
				    security_id_t *out_sid);

extern int security_member_sid(security_id_t ssid, 
				security_id_t tsid, 
				security_class_t tclass, 
				security_id_t *out_sid);

extern int security_change_sid(security_id_t ssid, 
				security_id_t tsid, 
				security_class_t tclass, 
				security_id_t *out_sid);

extern int security_sid_to_context(security_id_t sid, 
				    security_context_t scontext, 
				    __u32 *scontext_len);

extern int security_context_to_sid(const security_context_t scontext, 
				    __u32 scontext_len, 
				    security_id_t *out_sid);

extern int security_load_policy(const char *path,
				 __u32 pathlen);

extern int security_get_sids(security_id_t *sids, 
			      __u32 *nel);

extern int security_get_user_sids(security_id_t fromsid,
				   const char *username, 
				   __u32 namelen, 
				   security_id_t *sids, 
				   __u32 *nel);


/* Some helper functions for dealing with security classes
   and access vectors. */

extern security_class_t string_to_security_class(const char *s);

extern void print_access_vector(security_class_t tclass, 
				access_vector_t av);
