#include <ipc_secure.h>
#include <lsm.h>

int semsid (int semid, security_id_t *sid)
{
	unsigned long args[2];
	long err = 0;
	args[0] = (unsigned long)semid;
	args[1] = (unsigned long)sid;
	err = lsm(SELINUX_MAGIC, SELINUXCALL_SEMSID, args);
	if (err < 0) {
		*sid = SECINITSID_UNLABELED;
	}

	return err;
}
