/*
 * Security Context Mapping Protocol Daemon
 *
 * UDP transport routines.
 *
 * Copyright (c) 2001-2002 James Morris <jmorris@intercode.com.au>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 */
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <linux/flask/selopt.h>
#include <stdarg.h>
#include <string.h>
#include <syslog.h>

#include "libflnetlink.h"
#include "libflutil.h"

#include "server.h"
#include "protocol.h"
#include "transport.h"
#include "scmp.h"

#define BUFSIZE		SCMP_MSGLEN_MAX

int transport_fd = -1;

int transport_init(void)
{
	int rc;
	struct sockaddr_in laddr;
	
	transport_fd = socket(PF_INET, SOCK_DGRAM, 0);
	if (transport_fd < 0) {
		syslog(LOG_ERR, "socket: %m");
		return -1;
	}
	
	memset(&laddr, 0, sizeof(laddr));
	
	laddr.sin_family       = AF_INET;
	laddr.sin_addr.s_addr  = htonl(INADDR_ANY);
	laddr.sin_port         = htons(SCMP_PORT);
	
	rc = bind(transport_fd, (struct sockaddr*)&laddr, sizeof(laddr));
	if (rc < 0) {
		syslog(LOG_ERR, "bind: %m");
		return -1;
	}

	return 0;
}

void transport_pollin(void)
{
	int rc, ralen;
	struct sockaddr_in saddr;
	struct in_addr inaddr;
	unsigned char buf[BUFSIZE];
	
	ralen = sizeof(struct sockaddr_in);
	
	rc = recvfrom(transport_fd, buf, BUFSIZE, 0,
	              (struct sockaddr *)&saddr, &ralen);
	if (rc < 0)
		die(0, "transport_pollin: recvfrom: %m");
		
	if (rc == 0)
		return;

	if (ralen != sizeof(struct sockaddr_in))
		die(0, "transport_pollin: recvfrom: invalid addr len %d", ralen);
	
	inaddr = saddr.sin_addr;
	scmp_recv(buf, &inaddr, rc);
	
	return;
}

int transport_send(unsigned char *buf, struct in_addr *peer, int len)
{
	struct sockaddr_in saddr = {
		sin_family:	AF_INET,
		sin_addr:	{ s_addr: peer->s_addr },
		sin_port:	htons(SCMP_PORT)
	};
	
	return sendto(transport_fd, buf,  len, 0,
	              (struct sockaddr *)&saddr, sizeof(saddr));
}

void transport_exit(void)
{
	if (transport_fd != -1)
		close(transport_fd);
}
