 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_SEQUENCE_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_SEQUENCE_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Alloc

template <typename TSpec > struct Alloc;       	// "projects/library/seqan/sequence/string_base.h"(34)

//____________________________________________________________________________
// AllowsFastRandomAccess

template <typename T> struct AllowsFastRandomAccess;       	// "projects/library/seqan/sequence/sequence_interface.h"(172)

//____________________________________________________________________________
// Array

template <unsigned int ISize> struct Array;       	// "projects/library/seqan/sequence/string_array.h"(42)

//____________________________________________________________________________
// Block

template <unsigned int SPACE > struct Block;       	// "projects/library/seqan/sequence/string_stack.h"(47)

//____________________________________________________________________________
// CStyle

struct CStyle;       	// "projects/library/seqan/sequence/string_cstyle.h"(67)

//____________________________________________________________________________
// Comparator

template <typename T> struct Comparator;       	// "projects/library/seqan/sequence/lexical.h"(180)

//____________________________________________________________________________
// ConcatDirect

template <typename TDelimiter > struct ConcatDirect;       	// "projects/library/seqan/sequence/sequence_multiple.h"(67)

//____________________________________________________________________________
// ConcatVirtual

template <typename TDelimiter > struct ConcatVirtual;       	// "projects/library/seqan/sequence/sequence_multiple.h"(1987)

//____________________________________________________________________________
// Concatenator

template <typename TObject> struct Concatenator;       	// "projects/library/seqan/sequence/sequence_multiple.h"(95)

//____________________________________________________________________________
// ConcatenatorNto1

template <typename TStringSet> struct ConcatenatorNto1;       	// "projects/library/seqan/sequence/sequence_multiple.h"(1806)

//____________________________________________________________________________
// DefaultOverflowExplicit

template <typename T> struct DefaultOverflowExplicit;       	// "projects/library/seqan/sequence/sequence_interface.h"(109)
template <typename TValue> struct DefaultOverflowExplicit;       	// "projects/library/seqan/sequence/string_pointer.h"(69)

//____________________________________________________________________________
// DefaultOverflowImplicit

template <typename T> struct DefaultOverflowImplicit;       	// "projects/library/seqan/sequence/sequence_interface.h"(89)
template <typename TValue> struct DefaultOverflowImplicit;       	// "projects/library/seqan/sequence/string_pointer.h"(44)

//____________________________________________________________________________
// DefaultPrefixOrder

template <typename T> struct DefaultPrefixOrder;       	// "projects/library/seqan/sequence/lexical.h"(58)

//____________________________________________________________________________
// Dependent

template <typename TSpec > struct Dependent;       	// "projects/library/seqan/sequence/sequence_multiple.h"(50)

//____________________________________________________________________________
// HostIterator

template <typename T> struct HostIterator;       	// "projects/library/seqan/sequence/string_packed.h"(772)

//____________________________________________________________________________
// Infix

template <typename THost> struct Infix;       	// "projects/library/seqan/sequence/segment_infix.h"(437)

//____________________________________________________________________________
// InfixSegment

struct InfixSegment;       	// "projects/library/seqan/sequence/segment_base.h"(45)
struct InfixSegment;       	// "projects/library/seqan/sequence/segment_suffix.h"(343)
struct InfixSegment;       	// "projects/library/seqan/sequence/segment_prefix.h"(344)

//____________________________________________________________________________
// IsContiguous

template <typename T> struct IsContiguous;       	// "projects/library/seqan/sequence/sequence_interface.h"(130)
template <typename TValue> struct IsContiguous;       	// "projects/library/seqan/sequence/string_pointer.h"(97)

//____________________________________________________________________________
// IsSequence

template <typename T> struct IsSequence;       	// "projects/library/seqan/sequence/sequence_interface.h"(151)

//____________________________________________________________________________
// Lexical

template <typename TSpec > struct Lexical;       	// "projects/library/seqan/sequence/lexical.h"(117)

//____________________________________________________________________________
// MapType

template <typename T> struct MapType;       	// "projects/library/seqan/sequence/string_value_expand.h"(216)

//____________________________________________________________________________
// Owner

template <typename TSpec > struct Owner;       	// "projects/library/seqan/sequence/sequence_multiple.h"(84)

//____________________________________________________________________________
// Packed

template <typename THostspec > struct Packed;       	// "projects/library/seqan/sequence/string_packed.h"(33)

//____________________________________________________________________________
// Prefix

template <typename THost> struct Prefix;       	// "projects/library/seqan/sequence/segment_prefix.h"(349)

//____________________________________________________________________________
// PrefixSegment

struct PrefixSegment;       	// "projects/library/seqan/sequence/segment_suffix.h"(342)
struct PrefixSegment;       	// "projects/library/seqan/sequence/segment_prefix.h"(50)

//____________________________________________________________________________
// Segment

template <typename THost, typename TSpec > class Segment;       	// "projects/library/seqan/sequence/segment_base.h"(49)

//____________________________________________________________________________
// String

template <typename TValue, typename TSpec > class String;       	// "projects/library/seqan/sequence/string_base.h"(54)

//____________________________________________________________________________
// StringSet

template <typename TString, typename TSpec > class StringSet;       	// "projects/library/seqan/sequence/sequence_multiple.h"(92)

//____________________________________________________________________________
// StringSetLimits

template <typename TString> struct StringSetLimits;       	// "projects/library/seqan/sequence/sequence_multiple.h"(110)

//____________________________________________________________________________
// StringSetPosition

template <typename TString> struct StringSetPosition;       	// "projects/library/seqan/sequence/sequence_multiple.h"(120)

//____________________________________________________________________________
// Suffix

template <typename THost> struct Suffix;       	// "projects/library/seqan/sequence/segment_suffix.h"(347)

//____________________________________________________________________________
// SuffixSegment

struct SuffixSegment;       	// "projects/library/seqan/sequence/segment_suffix.h"(49)
struct SuffixSegment;       	// "projects/library/seqan/sequence/segment_prefix.h"(345)

//____________________________________________________________________________
// TagExact_

struct TagExact_;       	// "projects/library/seqan/sequence/sequence_interface.h"(69)

//____________________________________________________________________________
// TagGenerous_

struct TagGenerous_;       	// "projects/library/seqan/sequence/sequence_interface.h"(65)

//____________________________________________________________________________
// TagInsist_

struct TagInsist_;       	// "projects/library/seqan/sequence/sequence_interface.h"(56)

//____________________________________________________________________________
// TagLimit_

struct TagLimit_;       	// "projects/library/seqan/sequence/sequence_interface.h"(61)

//____________________________________________________________________________
// TagPrefixGreater_

struct TagPrefixGreater_;       	// "projects/library/seqan/sequence/lexical.h"(43)

//____________________________________________________________________________
// TagPrefixLess_

struct TagPrefixLess_;       	// "projects/library/seqan/sequence/lexical.h"(40)

//____________________________________________________________________________
// ValueExpand

template <typename THost, typename TMap, typename TSpec > struct ValueExpand;       	// "projects/library/seqan/sequence/string_value_expand.h"(31)

//____________________________________________________________________________
// ValueExpandIter

struct ValueExpandIter;       	// "projects/library/seqan/sequence/string_value_expand.h"(33)

//____________________________________________________________________________
// _Append_Sequence_2_Segment

template <typename TExpand> struct _Append_Sequence_2_Segment;       	// "projects/library/seqan/sequence/segment_base.h"(664)

//____________________________________________________________________________
// _Append_String

template <typename TExpand> struct _Append_String;       	// "projects/library/seqan/sequence/string_base.h"(977)

//____________________________________________________________________________
// _Append_Value_2_Segment

template <typename TExpand> struct _Append_Value_2_Segment;       	// "projects/library/seqan/sequence/segment_base.h"(826)

//____________________________________________________________________________
// _Append_Value_2_String

template <typename TExpand> struct _Append_Value_2_String;       	// "projects/library/seqan/sequence/string_base.h"(1094)

//____________________________________________________________________________
// _Assign_Segment

template <typename TExpand> struct _Assign_Segment;       	// "projects/library/seqan/sequence/segment_base.h"(446)

//____________________________________________________________________________
// _Assign_String

template <typename TExpand> struct _Assign_String;       	// "projects/library/seqan/sequence/string_base.h"(753)

//____________________________________________________________________________
// _Assign_String_2_StringArray

template <typename TExpand, bool IS_CONTIGUOUS> struct _Assign_String_2_StringArray;       	// "projects/library/seqan/sequence/string_cstyle.h"(452)

//____________________________________________________________________________
// _ClearSpace_Expand_String_Base_

template <typename TExpand> struct _ClearSpace_Expand_String_Base_;       	// "projects/library/seqan/sequence/string_base.h"(426)

//____________________________________________________________________________
// _ClearSpace_String_Base_

template <typename TExpand> struct _ClearSpace_String_Base_;       	// "projects/library/seqan/sequence/string_base.h"(214)

//____________________________________________________________________________
// _ClearSpace_String_Packed_

template <typename TExpand> struct _ClearSpace_String_Packed_;       	// "projects/library/seqan/sequence/string_packed.h"(541)

//____________________________________________________________________________
// _Create_ArrayString

template <typename TExpand> struct _Create_ArrayString;       	// "projects/library/seqan/sequence/string_cstyle.h"(615)

//____________________________________________________________________________
// _Create_ArrayString_Expand

template <typename TExpand> struct _Create_ArrayString_Expand;       	// "projects/library/seqan/sequence/string_cstyle.h"(561)

//____________________________________________________________________________
// _Fill_String

template <typename TExpand> struct _Fill_String;       	// "projects/library/seqan/sequence/string_base.h"(1587)

//____________________________________________________________________________
// _Insert_Value_2_Segment

template <typename TExpand> struct _Insert_Value_2_Segment;       	// "projects/library/seqan/sequence/segment_base.h"(868)

//____________________________________________________________________________
// _Insert_Value_2_String

template <typename TExpand> struct _Insert_Value_2_String;       	// "projects/library/seqan/sequence/string_base.h"(1140)

//____________________________________________________________________________
// _PackedConsts

template <typename TPackedContainer> struct _PackedConsts;       	// "projects/library/seqan/sequence/string_packed.h"(293)

//____________________________________________________________________________
// _Replace_Sequence_2_Segment

template <typename TExpand> struct _Replace_Sequence_2_Segment;       	// "projects/library/seqan/sequence/segment_base.h"(921)

//____________________________________________________________________________
// _Replace_String

template <typename TExpand> struct _Replace_String;       	// "projects/library/seqan/sequence/string_base.h"(1179)

//____________________________________________________________________________
// _Resize_String

template <typename TExpand> struct _Resize_String;       	// "projects/library/seqan/sequence/string_base.h"(1532)

//____________________________________________________________________________
// _TempCopy

template <typename T> struct _TempCopy;       	// "projects/library/seqan/sequence/string_base.h"(108)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// CharString

typedef String<char, Alloc<void> > CharString;       	// "projects/library/seqan/sequence/sequence_shortcuts.h"(37)

//____________________________________________________________________________
// Dna5String

typedef String<Dna5, Alloc<void> > Dna5String;       	// "projects/library/seqan/sequence/sequence_shortcuts.h"(119)

//____________________________________________________________________________
// DnaString

typedef String<Dna, Alloc<void> > DnaString;       	// "projects/library/seqan/sequence/sequence_shortcuts.h"(90)

//____________________________________________________________________________
// Exact

typedef Tag<TagExact_> const Exact;       	// "projects/library/seqan/sequence/sequence_interface.h"(70)

//____________________________________________________________________________
// Generous

typedef Tag<TagGenerous_> const Generous;       	// "projects/library/seqan/sequence/sequence_interface.h"(66)

//____________________________________________________________________________
// Insist

typedef Tag<TagInsist_> const Insist;       	// "projects/library/seqan/sequence/sequence_interface.h"(57)

//____________________________________________________________________________
// IupacString

typedef String<Iupac, Alloc<void> > IupacString;       	// "projects/library/seqan/sequence/sequence_shortcuts.h"(148)

//____________________________________________________________________________
// Limit

typedef Tag<TagLimit_> const Limit;       	// "projects/library/seqan/sequence/sequence_interface.h"(62)

//____________________________________________________________________________
// Peptide

typedef String<AminoAcid, Alloc<void> > Peptide;       	// "projects/library/seqan/sequence/sequence_shortcuts.h"(176)

//____________________________________________________________________________
// TagPrefixGreater

typedef Tag<TagPrefixGreater_> const TagPrefixGreater;       	// "projects/library/seqan/sequence/lexical.h"(44)

//____________________________________________________________________________
// TagPrefixLess

typedef Tag<TagPrefixLess_> const TagPrefixLess;       	// "projects/library/seqan/sequence/lexical.h"(41)

//____________________________________________________________________________
// Tight

typedef Tag<TagInsist_> const Tight;       	// "projects/library/seqan/sequence/sequence_interface.h"(58)

//____________________________________________________________________________
// UnicodeString

typedef String<wchar_t, Alloc<void> > UnicodeString;       	// "projects/library/seqan/sequence/sequence_shortcuts.h"(63)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _allocateStorage

template <typename TValue, typename TSpec> inline typename Value<String<TValue, Alloc<TSpec> > >::Type * _allocateStorage( String<TValue, Alloc<TSpec> > & me, size_t new_capacity);       	// "projects/library/seqan/sequence/string_alloc.h"(303)

//____________________________________________________________________________
// _assignValue_packed_string_iterator

template <typename TIter, typename TValue> inline void _assignValue_packed_string_iterator(TIter & me, TValue & _value);       	// "projects/library/seqan/sequence/string_packed.h"(987)

//____________________________________________________________________________
// _assign_copy_packed_string

template <typename TTarget, typename TSource, typename TTag> inline void _assign_copy_packed_string(TTarget & target, TSource & source, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_packed.h"(335)
template <typename TTarget, typename TSource, typename TSize, typename TTag> inline void _assign_copy_packed_string(TTarget & target, TSource & source, TSize limit, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_packed.h"(353)

//____________________________________________________________________________
// _begin_default

template <typename T> inline typename Iterator<T, Standard>::Type _begin_default(T & me, Standard);       	// "projects/library/seqan/sequence/sequence_interface.h"(278)
template <typename T> inline typename Iterator<T const, Standard>::Type _begin_default(T const & me, Standard);       	// "projects/library/seqan/sequence/sequence_interface.h"(286)
template <typename T> inline typename Iterator<T, Rooted>::Type _begin_default(T & me, Rooted);       	// "projects/library/seqan/sequence/sequence_interface.h"(298)
template <typename T> inline typename Iterator<T const, Rooted>::Type _begin_default(T const & me, Rooted);       	// "projects/library/seqan/sequence/sequence_interface.h"(307)

//____________________________________________________________________________
// _bitpos

template <typename TContainer, typename THostspec> inline unsigned char & _bitpos(Iter<TContainer, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(901)
template <typename TContainer, typename THostspec> inline unsigned char _bitpos(Iter<TContainer, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(908)

//____________________________________________________________________________
// _capacityReturned

template <typename T, typename TSize, typename TExpand> inline typename Size<T>::Type _capacityReturned( T & me, TSize, Tag<TExpand> const);       	// "projects/library/seqan/sequence/sequence_interface.h"(1301)
template <typename T, typename TSize> inline typename Size<T>::Type _capacityReturned( T &, TSize new_capacity, Insist);       	// "projects/library/seqan/sequence/sequence_interface.h"(1311)

//____________________________________________________________________________
// _clearSpace

template <typename TValue, typename THostspec, typename TExpand> inline typename Size< String<TValue, Packed<THostspec> > >::Type _clearSpace(String<TValue, Packed<THostspec> > & me, typename Size< String<TValue, Packed<THostspec> > >::Type size, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_packed.h"(690)
template <typename TValue, typename THostspec, typename TExpand> inline typename Size< String<TValue, Packed<THostspec> > >::Type _clearSpace(String<TValue, Packed<THostspec> > & me, typename Size< String<TValue, Packed<THostspec> > >::Type size, typename Size< String<TValue, Packed<THostspec> > >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_packed.h"(701)
template <typename TValue, typename THostspec, typename TPosition, typename TExpand> inline typename Size< String<TValue, Packed<THostspec> > >::Type _clearSpace(String<TValue, Packed<THostspec> > & me, typename Size< String<TValue, Packed<THostspec> > >::Type size, TPosition pos_begin, TPosition pos_end, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_packed.h"(713)
template <typename TValue, typename THostspec, typename TPosition, typename TExpand> inline typename Size< String<TValue, Packed<THostspec> > >::Type _clearSpace(String<TValue, Packed<THostspec> > & me, typename Size< String<TValue, Packed<THostspec> > >::Type size, TPosition pos_begin, TPosition pos_end, typename Size< String<TValue, Packed<THostspec> > >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_packed.h"(726)
template <typename TValue, typename TSpec, typename TSize, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type _clearSpace(String<TValue, TSpec> & me, TSize size, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(631)
template <typename TValue, typename TSpec, typename TSize, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type _clearSpace(String<TValue, TSpec> & me, TSize size, TSize limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(642)
template <typename TValue, typename TSpec, typename TSize, typename TPosition, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type _clearSpace(String<TValue, TSpec> & me, TSize size, TPosition pos_begin, TPosition pos_end, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(654)
template <typename TValue, typename TSpec, typename TSize, typename TPosition, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type _clearSpace(String<TValue, TSpec> & me, TSize size, TPosition pos_begin, TPosition pos_end, TSize limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(667)
template <typename TValue, typename TExpand> inline size_t _clearSpace(TValue * me, size_t size, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(392)
template <typename TValue, typename TExpand> inline size_t _clearSpace(TValue * me, size_t size, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(403)
template <typename TValue, typename TPosition, typename TExpand> inline size_t _clearSpace(TValue * me, size_t size, TPosition pos_begin, TPosition pos_end, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(415)
template <typename TValue, typename TPosition, typename TExpand> inline size_t _clearSpace(TValue * me, size_t size, TPosition pos_begin, TPosition pos_end, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(428)

//____________________________________________________________________________
// _computeSize4Capacity

template <typename T, typename TSize> inline TSize _computeSize4Capacity(T const & , TSize capacity);       	// "projects/library/seqan/sequence/sequence_interface.h"(900)

//____________________________________________________________________________
// _countNonZeroValues

template <typename TValue, typename TSpec, typename TPos > inline typename Size< String<TValue, TSpec> >::Type _countNonZeroValues(String<TValue, TSpec> const &me, TPos i);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1020)

//____________________________________________________________________________
// _dataHost

template <typename TValue, typename THost, typename TMap, typename TSpec> inline Holder<THost> & _dataHost(String<TValue, ValueExpand<THost, TMap, TSpec> > & me);       	// "projects/library/seqan/sequence/string_value_expand.h"(87)

//____________________________________________________________________________
// _dataMap

template <typename TValue, typename THost, typename TMap, typename TSpec> inline Holder<TMap> & _dataMap(String<TValue, ValueExpand<THost, TMap, TSpec> > & me);       	// "projects/library/seqan/sequence/string_value_expand.h"(95)

//____________________________________________________________________________
// _deallocateStorage

template <typename TValue> inline void _deallocateStorage( String <TValue, CStyle > & me, TValue * ptr, size_t capacity);       	// "projects/library/seqan/sequence/string_cstyle.h"(308)
template <typename TValue, typename TSpec, typename TPtr> inline void _deallocateStorage( String<TValue, Alloc<TSpec> > & me, TPtr * ptr, size_t capacity);       	// "projects/library/seqan/sequence/string_alloc.h"(333)

//____________________________________________________________________________
// _end_default

template <typename T> inline typename Iterator<T, Standard>::Type _end_default(T & me, Standard);       	// "projects/library/seqan/sequence/sequence_interface.h"(461)
template <typename T> inline typename Iterator<T const, Standard>::Type _end_default(T const & me, Standard);       	// "projects/library/seqan/sequence/sequence_interface.h"(469)
template <typename T> inline typename Iterator<T, Rooted>::Type _end_default(T & me, Rooted);       	// "projects/library/seqan/sequence/sequence_interface.h"(481)
template <typename T> inline typename Iterator<T const, Rooted>::Type _end_default(T const & me, Rooted);       	// "projects/library/seqan/sequence/sequence_interface.h"(490)

//____________________________________________________________________________
// _findIthNonZeroValue

template <typename TValue, typename TSpec, typename TPos > inline typename Size< String<TValue, TSpec> >::Type _findIthNonZeroValue(String<TValue, TSpec> const &me, TPos i);       	// "projects/library/seqan/sequence/sequence_multiple.h"(999)

//____________________________________________________________________________
// _getMap

template <typename TValue, typename THost, typename TMap, typename TSpec> inline TMap & _getMap(String< TValue, ValueExpand<THost, TMap, TSpec> > & me);       	// "projects/library/seqan/sequence/string_value_expand.h"(235)
template <typename TValue, typename THost, typename TMap, typename TSpec> inline TMap & _getMap(String< TValue, ValueExpand<THost, TMap, TSpec> > const & me);       	// "projects/library/seqan/sequence/string_value_expand.h"(241)

//____________________________________________________________________________
// _getValueExpandFlagValue

template <typename TValue, typename THost, typename TMap, typename TSpec> inline typename Value<THost>::Type _getValueExpandFlagValue(String< TValue, ValueExpand<THost, TMap, TSpec> > const & me);       	// "projects/library/seqan/sequence/string_value_expand.h"(250)

//____________________________________________________________________________
// _moveContiguous

template <typename TTarget, typename TSource> void _moveContiguous(TTarget & target, TSource & source);       	// "projects/library/seqan/sequence/string_base.h"(862)

//____________________________________________________________________________
// _reallocateStorage

template <typename TValue> inline TValue * _reallocateStorage( String <TValue, CStyle > & me, size_t new_capacity, Exact);       	// "projects/library/seqan/sequence/string_cstyle.h"(282)
template <typename TValue, typename TSpec> inline typename Value<String<TValue, TSpec> >::Type * _reallocateStorage( String<TValue, TSpec> & me, typename Size< String<TValue, TSpec> >::Type new_capacity);       	// "projects/library/seqan/sequence/string_base.h"(1347)
template <typename TValue, typename TSpec> inline typename Value<String<TValue, TSpec> >::Type * _reallocateStorage( String<TValue, TSpec> & me, typename Size< String<TValue, TSpec> >::Type new_capacity, Exact);       	// "projects/library/seqan/sequence/string_base.h"(1358)
template <typename TValue, typename TSpec> inline typename Value<String<TValue, TSpec> >::Type * _reallocateStorage( String<TValue, TSpec> & me, typename Size< String<TValue, TSpec> >::Type new_capacity, typename Size< String<TValue, TSpec> >::Type limit, Exact);       	// "projects/library/seqan/sequence/string_base.h"(1375)
template <typename TValue, typename TSpec> inline typename Value<String<TValue, TSpec> >::Type * _reallocateStorage( String<TValue, TSpec> & me, typename Size< String<TValue, TSpec> >::Type new_capacity, Generous);       	// "projects/library/seqan/sequence/string_base.h"(1392)
template <typename TValue, typename TSpec> inline typename Value<String<TValue, TSpec> >::Type * _reallocateStorage( String<TValue, TSpec> & me, typename Size< String<TValue, TSpec> >::Type new_capacity, typename Size< String<TValue, TSpec> >::Type limit, Generous);       	// "projects/library/seqan/sequence/string_base.h"(1409)
template <typename TValue, typename TSpec> inline typename Value<String<TValue, TSpec> >::Type * _reallocateStorage( String<TValue, TSpec> &, typename Size< String<TValue, TSpec> >::Type, Insist);       	// "projects/library/seqan/sequence/string_base.h"(1426)
template <typename TValue, typename TSpec> inline typename Value<String<TValue, TSpec> >::Type * _reallocateStorage( String<TValue, TSpec> &, typename Size< String<TValue, TSpec> >::Type, typename Size< String<TValue, TSpec> >::Type, Insist);       	// "projects/library/seqan/sequence/string_base.h"(1437)
template <typename TValue, typename TSpec> inline typename Value<String<TValue, TSpec> >::Type * _reallocateStorage( String<TValue, TSpec> &, typename Size< String<TValue, TSpec> >::Type, Limit);       	// "projects/library/seqan/sequence/string_base.h"(1447)
template <typename TValue, typename TSpec> inline typename Value<String<TValue, TSpec> >::Type * _reallocateStorage( String<TValue, TSpec> &, typename Size< String<TValue, TSpec> >::Type, typename Size< String<TValue, TSpec> >::Type, Limit);       	// "projects/library/seqan/sequence/string_base.h"(1458)

//____________________________________________________________________________
// _refreshStringSetLimits

template <typename T > inline void _refreshStringSetLimits(T &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(968)
template <typename TString, typename TSpec > inline void _refreshStringSetLimits(StringSet< TString, Owner<ConcatDirect<TSpec> > > &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(971)
template <typename TString, typename TSpec > inline void _refreshStringSetLimits(StringSet< TString, TSpec > &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(975)

//____________________________________________________________________________
// _reserveStorage

template <typename TValue, typename TSpec, typename _TSize> inline void _reserveStorage( String<TValue, TSpec> & , _TSize , Insist);       	// "projects/library/seqan/sequence/string_base.h"(1471)
template <typename TValue, typename TSpec, typename _TSize> inline void _reserveStorage( String<TValue, TSpec> & , _TSize , Limit);       	// "projects/library/seqan/sequence/string_base.h"(1481)
template <typename TValue, typename TSpec, typename _TSize, typename TExpand> inline void _reserveStorage( String<TValue, TSpec> & seq, _TSize new_capacity, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_base.h"(1491)

//____________________________________________________________________________
// _setBegin

template <typename TValue, typename TValue2> inline void _setBegin(String <TValue, CStyle > & me, TValue2 new_begin);       	// "projects/library/seqan/sequence/string_cstyle.h"(225)
template <typename TValue, typename TSpec, typename TPtr> inline void _setBegin( String<TValue, Alloc<TSpec> > & me, TPtr * new_begin);       	// "projects/library/seqan/sequence/string_alloc.h"(242)

//____________________________________________________________________________
// _setCapacity

template <typename TValue, typename TSpec> inline void _setCapacity( String<TValue, Alloc<TSpec> > & me, size_t new_capacity);       	// "projects/library/seqan/sequence/string_alloc.h"(278)

//____________________________________________________________________________
// _setEnd

template <typename TValue, typename TValue2> inline void _setEnd(String <TValue, CStyle > & me, TValue2 new_end);       	// "projects/library/seqan/sequence/string_cstyle.h"(253)

//____________________________________________________________________________
// _setLength

template <typename THost_> inline void _setLength( Segment<THost_, InfixSegment> & me, typename Size<THost_>::Type new_length);       	// "projects/library/seqan/sequence/segment_infix.h"(393)
template <typename TValue, typename THostspec, typename TSize> inline void _setLength( String<TValue, Packed<THostspec> > & me, TSize new_length);       	// "projects/library/seqan/sequence/string_packed.h"(187)
template <typename THost_, typename TSize> inline void _setLength(Segment<THost_, SuffixSegment> &, TSize);       	// "projects/library/seqan/sequence/segment_suffix.h"(325)
template <typename TValue, unsigned int ISize> inline void _setLength( String<TValue, Array<ISize> > & me, size_t new_length);       	// "projects/library/seqan/sequence/string_array.h"(203)
template <typename TValue> inline void _setLength(TValue * me, size_t new_length);       	// "projects/library/seqan/sequence/string_pointer.h"(354)
template <typename THost_, typename TSize> inline void _setLength( Segment<THost_, PrefixSegment> & me, TSize new_length);       	// "projects/library/seqan/sequence/segment_prefix.h"(309)
template <typename TValue, typename TSpec> inline void _setLength( String<TValue, Alloc<TSpec> > & me, size_t new_length);       	// "projects/library/seqan/sequence/string_alloc.h"(263)

//____________________________________________________________________________
// _validStringSetLimits

template <typename T > inline bool _validStringSetLimits(T const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(950)
template <typename TString, typename TSpec > inline bool _validStringSetLimits(StringSet< TString, TSpec > const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(955)
template <typename TString, typename TSpec > inline bool _validStringSetLimits(StringSet< TString, Owner<ConcatDirect<TSpec> > > const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(960)

//____________________________________________________________________________
// append

template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> & target, TSource & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(738)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> & target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(748)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> & target, TSource & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(760)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> & target, TSource const & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(771)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> const & target, TSource & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(782)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> const & target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(792)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> const & target, TSource & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(804)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> const & target, TSource const & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(815)
template <typename TValue, unsigned int SPACE, typename TSource, typename TExpand> inline void append( String<TValue, Block<SPACE> >& me, TSource const& source, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_stack.h"(368)
template <typename TTargetValue, typename TTargetSpec, typename TSource, typename TExpand> inline void append(String<TTargetValue, TTargetSpec> & target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1042)
template <typename TTargetValue, typename TTargetSpec, typename TSource, typename TExpand> inline void append(String<TTargetValue, TTargetSpec> & target, TSource const & source, typename Size< String<TTargetValue, TTargetSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1054)
template <typename TTargetValue, typename TTargetSpec, typename TSourceValue, typename TExpand> inline void append(String<TTargetValue, TTargetSpec> & target, TSourceValue * source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1068)
template <typename TTargetValue, typename TTargetSpec, typename TSourceValue, typename TExpand> inline void append(String<TTargetValue, TTargetSpec> & target, TSourceValue * source, typename Size< String<TTargetValue, TTargetSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1080)
template <typename TTarget, typename TSource> inline void append(TTarget & target, TSource & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1026)
template <typename TTarget, typename TSource> inline void append(TTarget const & target, TSource & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1034)
template <typename TTarget, typename TSource> inline void append(TTarget & target, TSource const & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1042)
template <typename TTarget, typename TSource> inline void append(TTarget const & target, TSource const & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1050)
template <typename TTarget, typename TSource> inline void append(TTarget & target, TSource & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1062)
template <typename TTarget, typename TSource> inline void append(TTarget const & target, TSource & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1071)
template <typename TTarget, typename TSource> inline void append(TTarget & target, TSource const & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1080)
template <typename TTarget, typename TSource> inline void append(TTarget const & target, TSource const & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1089)
template <typename TTargetValue, typename TSource, typename TExpand> inline void append(TTargetValue * target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(544)
template <typename TTargetValue, typename TSource, typename TExpand> inline void append(TTargetValue * target, TSource const & source, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(555)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void append(TTargetValue * target, TSourceValue const * source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(568)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void append(TTargetValue * target, TSourceValue const * source, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(579)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void append(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, Generous);       	// "projects/library/seqan/sequence/std_string.h"(425)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void append(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Generous);       	// "projects/library/seqan/sequence/std_string.h"(436)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void append(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, Limit);       	// "projects/library/seqan/sequence/std_string.h"(463)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void append(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Limit);       	// "projects/library/seqan/sequence/std_string.h"(474)

//____________________________________________________________________________
// appendValue

template <typename THost, typename TSpec, typename TValue, typename TExpand> inline void appendValue(Segment<THost, TSpec> & me, TValue const & _value, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(848)
template <typename THost, typename TSpec, typename TValue, typename TExpand> inline void appendValue(Segment<THost, TSpec> const & me, TValue const & _value, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(857)
template <typename TValue, unsigned int SPACE, typename TVal, typename TExpand> inline void appendValue( String<TValue, Block<SPACE> >& me, TVal const& source, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_stack.h"(384)
template <typename TString, typename TString2, typename TExpand > inline void appendValue( StringSet< TString, Owner<Default> > &me, TString2 const &obj, Tag<TExpand> const &tag);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1056)
template <typename TString, typename TString2, typename TExpand > inline void appendValue( StringSet< TString, Owner<ConcatDirect<void> > > &me, TString2 const &obj, Tag<TExpand> const &tag);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1067)
template <typename TString, typename TDelimiter, typename TString2, typename TExpand > inline void appendValue( StringSet< TString, Owner<ConcatDirect<TDelimiter> > > &me, TString2 const &obj, Tag<TExpand> const);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1077)
template <typename TString, typename TExpand > inline void appendValue( StringSet<TString, Dependent<Generous> > &me, TString const &obj, Tag<TExpand> const);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1089)
template <typename TString, typename TExpand > inline void appendValue( StringSet<TString, Dependent<Tight> > &me, TString const &obj, Tag<TExpand> const);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1101)
template <typename TTargetValue, typename TTargetSpec, typename TValue, typename TExpand> inline void appendValue(String<TTargetValue, TTargetSpec> & me, TValue const & _value, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1126)
template <typename T, typename TValue> inline void appendValue(T & me, TValue const & _value);       	// "projects/library/seqan/sequence/sequence_interface.h"(1115)
template <typename T, typename TValue> inline void appendValue(T const & me, TValue const & _value);       	// "projects/library/seqan/sequence/sequence_interface.h"(1123)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TValue, typename TTag> inline void appendValue(::std::basic_string<TChar, TCharTraits, TAlloc> & me, TValue const & _value, TTag);       	// "projects/library/seqan/sequence/std_string.h"(492)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TValue> inline void appendValue(::std::basic_string<TChar, TCharTraits, TAlloc> & me, TValue const & _value, Limit);       	// "projects/library/seqan/sequence/std_string.h"(502)

//____________________________________________________________________________
// assign

template <typename THost, typename TSpec, typename TSource> inline void assign(Segment<THost, TSpec> & target, TSource & source);       	// "projects/library/seqan/sequence/segment_base.h"(406)
template <typename THost, typename TSpec, typename TSource> inline void assign(Segment<THost, TSpec> & target, TSource const & source);       	// "projects/library/seqan/sequence/segment_base.h"(415)
template <typename THost, typename TSpec, typename TSource> inline void assign(Segment<THost, TSpec> const & target, TSource & source);       	// "projects/library/seqan/sequence/segment_base.h"(427)
template <typename THost, typename TSpec, typename TSource> inline void assign(Segment<THost, TSpec> const & target, TSource const & source);       	// "projects/library/seqan/sequence/segment_base.h"(436)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> & target, TSource & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(524)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> & target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(533)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> & target, TSource & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(544)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> & target, TSource const & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(554)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> const & target, TSource & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(566)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> const & target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(575)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> const & target, TSource & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(586)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> const & target, TSource const & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(596)
template <typename TValue> inline void assign(String <TValue, CStyle > & target, TValue * source);       	// "projects/library/seqan/sequence/string_cstyle.h"(341)
template <typename TTargetValue, typename TSource, typename TExpand> inline void assign(String<TTargetValue, CStyle> & target, TSource & source, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_cstyle.h"(384)
template <typename TTargetValue, typename TSource, typename TExpand> inline void assign(String<TTargetValue, CStyle> & target, TSource const & source, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_cstyle.h"(394)
template <typename TTargetValue, typename TSource, typename TSize, typename TExpand> inline void assign(String<TTargetValue, CStyle> & target, TSource & source, TSize limit, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_cstyle.h"(405)
template <typename TTargetValue, typename TSource, typename TSize, typename TExpand> inline void assign(String<TTargetValue, CStyle> & target, TSource const & source, TSize limit, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_cstyle.h"(416)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void assign(String<TTargetValue, CStyle> & target, TSourceValue const * source, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_cstyle.h"(430)
template <typename TTargetValue, typename TSourceValue, typename TSize, typename TExpand> inline void assign(String<TTargetValue, CStyle> & target, TSourceValue const * source, TSize limit, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_cstyle.h"(441)
template <typename TValue, typename TSourceSpec, typename TExpand> inline void assign(String<TValue, CStyle> & target, String<TValue, TSourceSpec> & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_cstyle.h"(517)
template <typename TValue, typename THostspec, typename TTag> inline void assign(String<TValue, Packed<THostspec> > & target, String<TValue, Packed<THostspec> > & source, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_packed.h"(377)
template <typename TValue, typename THostspec, typename TTag> inline void assign(String<TValue, Packed<THostspec> > & target, String<TValue, Packed<THostspec> > const & source, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_packed.h"(385)
template <typename TValue, typename THostspec, typename TSize, typename TTag> void assign(String<TValue, Packed<THostspec> > & target, String<TValue, Packed<THostspec> > & source, TSize limit, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_packed.h"(394)
template <typename TValue, typename THostspec, typename TSize, typename TTag> void assign(String<TValue, Packed<THostspec> > & target, String<TValue, Packed<THostspec> > const & source, TSize limit, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_packed.h"(402)
template <typename TValue, unsigned int SPACE, typename TSource> inline void assign( String<TValue, Block<SPACE> >& target, TSource const& source);       	// "projects/library/seqan/sequence/string_stack.h"(226)
template <typename TTargetValue, typename TTargetSpec, typename TSource> inline void assign(String<TTargetValue, TTargetSpec> & target, TSource & source);       	// "projects/library/seqan/sequence/string_base.h"(734)
template <typename TTargetValue, typename TTargetSpec, typename TSource> inline void assign(String<TTargetValue, TTargetSpec> & target, TSource const & source);       	// "projects/library/seqan/sequence/string_base.h"(743)
template <typename TTargetValue, typename TTargetSpec, typename TSource, typename TExpand> inline void assign(String<TTargetValue, TTargetSpec> & target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(810)
template <typename TTargetValue, typename TTargetSpec, typename TSource, typename TSize, typename TExpand> inline void assign(String<TTargetValue, TTargetSpec> & target, TSource const & source, TSize limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(820)
template <typename TTargetValue, typename TTargetSpec, typename TSourceValue, typename TExpand> inline void assign(String<TTargetValue, TTargetSpec> & target, TSourceValue const * source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(833)
template <typename TTargetValue, typename TTargetSpec, typename TSourceValue, typename TSize, typename TExpand> inline void assign(String<TTargetValue, TTargetSpec> & target, TSourceValue const * source, TSize limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(843)
template <typename TTarget, typename TSource> inline void assign(TTarget & target, TSource & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(971)
template <typename TTarget, typename TSource> inline void assign(TTarget const & target, TSource & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(980)
template <typename TTarget, typename TSource> inline void assign(TTarget & target, TSource const & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(989)
template <typename TTarget, typename TSource> inline void assign(TTarget const & target, TSource const & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(998)
template <typename TTargetValue, typename TSource> inline void assign(TTargetValue * target, TSource & source);       	// "projects/library/seqan/sequence/string_pointer.h"(446)
template <typename TTargetValue, typename TSource> inline void assign(TTargetValue * target, TSource const & source);       	// "projects/library/seqan/sequence/string_pointer.h"(455)
template <typename TTargetValue, typename TSource, typename TExpand> inline void assign(TTargetValue * target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(468)
template <typename TTargetValue, typename TSource, typename TExpand> inline void assign(TTargetValue * target, TSource const & source, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(479)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void assign(TTargetValue * target, TSourceValue const * source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(492)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void assign(TTargetValue * target, TSourceValue const * source, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(503)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource & source);       	// "projects/library/seqan/sequence/std_string.h"(272)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source);       	// "projects/library/seqan/sequence/std_string.h"(280)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource, typename TSize> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource & source, TSize limit);       	// "projects/library/seqan/sequence/std_string.h"(290)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource, typename TSize> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, TSize limit);       	// "projects/library/seqan/sequence/std_string.h"(299)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource & source, Generous);       	// "projects/library/seqan/sequence/std_string.h"(311)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, Generous);       	// "projects/library/seqan/sequence/std_string.h"(320)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Generous);       	// "projects/library/seqan/sequence/std_string.h"(347)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Generous);       	// "projects/library/seqan/sequence/std_string.h"(357)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource & source, Limit);       	// "projects/library/seqan/sequence/std_string.h"(369)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, Limit);       	// "projects/library/seqan/sequence/std_string.h"(378)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Limit);       	// "projects/library/seqan/sequence/std_string.h"(389)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Limit);       	// "projects/library/seqan/sequence/std_string.h"(404)

//____________________________________________________________________________
// assignValue

template <typename TContainer, typename TIterator, typename TValue> inline void assignValue(Iter<TContainer, AdaptorIterator<TIterator, ValueExpandIter> > & me, TValue const & _value);       	// "projects/library/seqan/sequence/string_value_expand.h"(458)
template <typename TContainer, typename TIterator, typename TValue> inline void assignValue(Iter<TContainer, AdaptorIterator<TIterator, ValueExpandIter> > const & me, TValue const & _value);       	// "projects/library/seqan/sequence/string_value_expand.h"(478)
template <typename TContainer, typename THostspec, typename TValue> inline void assignValue(Iter<TContainer, Packed<THostspec> > & me, TValue const & _value);       	// "projects/library/seqan/sequence/string_packed.h"(1004)
template <typename TContainer, typename THostspec, typename TValue> inline void assignValue(Iter<TContainer, Packed<THostspec> > const & me, TValue const & _value);       	// "projects/library/seqan/sequence/string_packed.h"(1014)
template <typename TValue, typename TSpec, typename TValue2> inline void assignValue(String<TValue, TSpec> & me, TValue2 const & _value);       	// "projects/library/seqan/sequence/string_base.h"(715)
template <typename T, typename TValue, typename TPos> inline void assignValue(T & me, TPos pos, TValue const & _value);       	// "projects/library/seqan/sequence/sequence_interface.h"(775)
template <typename TValue, typename TPos> inline void assignValue(TValue * me, TPos pos, TValue const & _value);       	// "projects/library/seqan/sequence/string_pointer.h"(266)

//____________________________________________________________________________
// assignValueById

template <typename TString, typename TSpec, typename TString2> inline typename Id<StringSet<TString, TSpec> >::Type assignValueById(StringSet<TString, TSpec>& me, TString2& obj);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1441)
template <typename TString, typename TString2> inline typename Id<StringSet<TString, Dependent<Tight> > >::Type assignValueById(StringSet<TString, Dependent<Tight> >& me, TString2& obj);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1452)
template <typename TString, typename TSpec, typename TId> inline typename Id<StringSet<TString, Owner<TSpec> > >::Type assignValueById(StringSet<TString, Owner<TSpec> >& me, TString& obj, TId id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1465)
template <typename TString, typename TId> inline typename Id<StringSet<TString, Dependent<Generous> > >::Type assignValueById(StringSet<TString, Dependent<Generous> >& me, TString& obj, TId id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1481)
template <typename TString, typename TId1> inline typename Id<StringSet<TString, Dependent<Tight> > >::Type assignValueById(StringSet<TString, Dependent<Tight> >& me, TString& obj, TId1 id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1500)
template <typename TString, typename TSpec1, typename TSpec2, typename TId> inline typename Id<StringSet<TString, TSpec1> >::Type assignValueById(StringSet<TString, TSpec1>& dest, StringSet<TString, TSpec2>& source, TId id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1527)

//____________________________________________________________________________
// assign_std_string_Generous_impl

template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign_std_string_Generous_impl(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit);       	// "projects/library/seqan/sequence/std_string.h"(331)

//____________________________________________________________________________
// atBegin

template <typename THost> inline bool atBegin(Segment<THost, InfixSegment> & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(516)
template <typename THost> inline bool atBegin(Segment<THost, InfixSegment> const & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(523)
template <typename TSSet, typename TSpec> inline bool atBegin(Iter<TSSet, ConcatVirtual<TSpec> > &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2347)
template <typename TSSet, typename TSpec> inline bool atBegin(Iter<TSSet, ConcatVirtual<TSpec> > const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2354)
template <typename THost> inline bool atBegin(Segment<THost, SuffixSegment> const & segment);       	// "projects/library/seqan/sequence/segment_suffix.h"(422)
template <typename THost> inline bool atBegin(Segment<THost, PrefixSegment> const & segment);       	// "projects/library/seqan/sequence/segment_prefix.h"(425)

//____________________________________________________________________________
// atEnd

template <typename THost> inline bool atEnd(Segment<THost, InfixSegment> & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(533)
template <typename THost> inline bool atEnd(Segment<THost, InfixSegment> const & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(540)
template <typename TValue, unsigned int SPACE, typename TIteratorSpec> inline bool atEnd( Iter<String<TValue, Block<SPACE> >, TIteratorSpec>& it, String<TValue, Block<SPACE> >& container);       	// "projects/library/seqan/sequence/string_stack.h"(260)
template <typename TSSet, typename TSpec> inline bool atEnd(Iter<TSSet, ConcatVirtual<TSpec> > &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2365)
template <typename TSSet, typename TSpec> inline bool atEnd(Iter<TSSet, ConcatVirtual<TSpec> > const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2372)
template <typename THost> inline bool atEnd(Segment<THost, SuffixSegment> const & segment);       	// "projects/library/seqan/sequence/segment_suffix.h"(432)
template <typename TValue> inline bool atEnd(TValue * pos);       	// "projects/library/seqan/sequence/string_pointer.h"(290)
template <typename TValue> inline bool atEnd(TValue * pos, TValue const * container);       	// "projects/library/seqan/sequence/string_pointer.h"(301)
template <typename THost> inline bool atEnd(Segment<THost, PrefixSegment> const & segment);       	// "projects/library/seqan/sequence/segment_prefix.h"(435)

//____________________________________________________________________________
// atEndOfSequence

template <typename TIterator> inline bool atEndOfSequence(TIterator const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2383)
template <typename TSSet, typename TSpec> inline bool atEndOfSequence(Iter<TSSet, ConcatVirtual<TSpec> > const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2390)
template <typename TIterator> inline bool atEndOfSequence(TIterator &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2397)

//____________________________________________________________________________
// back

template <typename T> inline typename Reference<T const>::Type back(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(679)
template <typename T> inline typename Reference<T>::Type back(T & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(687)

//____________________________________________________________________________
// begin

template <typename TValue, typename THost, typename TMap, typename TSpec, typename TTag> inline typename Iterator<String< TValue, ValueExpand<THost, TMap, TSpec> >, Tag<TTag> const>::Type begin(String< TValue, ValueExpand<THost, TMap, TSpec> > & me, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/string_value_expand.h"(298)
template <typename TValue, typename THost, typename TMap, typename TSpec, typename TTag> inline typename Iterator<String< TValue, ValueExpand<THost, TMap, TSpec> > const, Tag<TTag> const>::Type begin(String< TValue, ValueExpand<THost, TMap, TSpec> > const & me, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/string_value_expand.h"(306)
template <typename THost_> inline typename Iterator<Segment<THost_, InfixSegment>, Standard>::Type begin(Segment<THost_, InfixSegment> & me, Standard);       	// "projects/library/seqan/sequence/segment_infix.h"(213)
template <typename THost_> inline typename Iterator<Segment<THost_, InfixSegment> const, Standard>::Type begin(Segment<THost_, InfixSegment> const & me, Standard);       	// "projects/library/seqan/sequence/segment_infix.h"(221)
template <typename TValue> inline typename Iterator<String<TValue, CStyle >, Standard>::Type begin(String <TValue, CStyle > & me, Standard);       	// "projects/library/seqan/sequence/string_cstyle.h"(207)
template <typename TValue> inline typename Iterator<String<TValue, CStyle > const, Standard>::Type begin(String <TValue, CStyle > const & me, Standard);       	// "projects/library/seqan/sequence/string_cstyle.h"(215)
template <typename TValue, typename THostspec, typename TTag> inline typename Iterator<String<TValue, Packed<THostspec> >, Tag<TTag> const>::Type begin(String<TValue, Packed<THostspec> > & me, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/string_packed.h"(448)
template <typename TValue, typename THostspec, typename TTag> inline typename Iterator<String<TValue, Packed<THostspec> > const, Tag<TTag> const>::Type begin(String<TValue, Packed<THostspec> > const & me, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/string_packed.h"(456)
template <typename TValue, unsigned int SPACE, typename TSpec> inline typename Iterator<String<TValue, Block<SPACE> >, Tag<TSpec> const >::Type begin(String<TValue, Block<SPACE> > &me, Tag<TSpec> const);       	// "projects/library/seqan/sequence/string_stack.h"(191)
template <typename TValue, unsigned int SPACE, typename TSpec> inline typename Iterator<String<TValue, Block<SPACE> > const, Tag<TSpec> const>::Type begin(String<TValue, Block<SPACE> > const &me, Tag<TSpec> const);       	// "projects/library/seqan/sequence/string_stack.h"(199)
template <typename TString, typename TSpec, typename TTag> inline typename Iterator< StringSet< TString, TSpec >, Tag<TTag> const>::Type begin(StringSet< TString, TSpec > & me, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1232)
template <typename TString, typename TSpec, typename TTag> inline typename Iterator< StringSet< TString, TSpec > const, Tag<TTag> const>::Type begin(StringSet< TString, TSpec > const & me, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1239)
template <typename TStringSet, typename TSpec > inline typename Iterator< ConcatenatorNto1<TStringSet const>, Tag<TSpec> const >::Type begin(ConcatenatorNto1<TStringSet const> concat, Tag<TSpec> const);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1895)
template <typename TStringSet, typename TSpec > inline typename Iterator< ConcatenatorNto1<TStringSet>, Tag<TSpec> const >::Type begin(ConcatenatorNto1<TStringSet> concat, Tag<TSpec> const);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1902)
template <typename T> inline typename Iterator<T, typename DefaultGetIteratorSpec<T>::Type>::Type begin(T & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(259)
template <typename T> inline typename Iterator<T const, typename DefaultGetIteratorSpec<T>::Type>::Type begin(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(266)
template <typename T, typename TSpec> inline typename Iterator<T, Tag<TSpec> const>::Type begin(T & me, Tag<TSpec> const tag_);       	// "projects/library/seqan/sequence/sequence_interface.h"(327)
template <typename T, typename TSpec> inline typename Iterator<T const, Tag<TSpec> const>::Type begin(T const & me, Tag<TSpec> const tag_);       	// "projects/library/seqan/sequence/sequence_interface.h"(335)
template <typename THost_> inline typename Iterator<Segment<THost_, SuffixSegment>, Standard>::Type begin(Segment<THost_, SuffixSegment> & me, Standard);       	// "projects/library/seqan/sequence/segment_suffix.h"(219)
template <typename THost_> inline typename Iterator<Segment<THost_, SuffixSegment> const, Standard>::Type begin(Segment<THost_, SuffixSegment> const & me, Standard);       	// "projects/library/seqan/sequence/segment_suffix.h"(227)
template <typename TValue, unsigned int ISize> inline typename Iterator<String<TValue, Array<ISize> >, Standard>::Type begin(String<TValue, Array<ISize> > & me, Standard);       	// "projects/library/seqan/sequence/string_array.h"(130)
template <typename TValue, unsigned int ISize> inline typename Iterator<String<TValue, Array<ISize> > const, Standard>::Type begin(String<TValue, Array<ISize> > const & me, Standard);       	// "projects/library/seqan/sequence/string_array.h"(138)
template <typename T> inline typename Iterator<T *, typename DefaultGetIteratorSpec<T>::Type>::Type begin(T * me);       	// "projects/library/seqan/sequence/string_pointer.h"(147)
template <typename TValue> inline typename Iterator<TValue *, Standard>::Type begin(TValue * me, Standard);       	// "projects/library/seqan/sequence/string_pointer.h"(158)
template <typename TValue> inline typename Iterator<TValue const *, Standard>::Type begin(TValue const * me, Standard);       	// "projects/library/seqan/sequence/string_pointer.h"(168)
template <typename TValue, typename TSpec> inline typename Iterator<TValue *, Tag<TSpec> const>::Type begin(TValue * me, Tag<TSpec> const);       	// "projects/library/seqan/sequence/string_pointer.h"(177)
template <typename TValue, typename TSpec> inline typename Iterator<TValue const *, Tag<TSpec> const>::Type begin(TValue const * me, Tag<TSpec> const);       	// "projects/library/seqan/sequence/string_pointer.h"(187)
template <typename THost_> inline typename Iterator<Segment<THost_, PrefixSegment>, Standard>::Type begin(Segment<THost_, PrefixSegment> & me, Standard);       	// "projects/library/seqan/sequence/segment_prefix.h"(218)
template <typename THost_> inline typename Iterator<Segment<THost_, PrefixSegment> const, Standard>::Type begin(Segment<THost_, PrefixSegment> const & me, Standard);       	// "projects/library/seqan/sequence/segment_prefix.h"(226)
template <typename TChar, typename TCharTraits, typename TAlloc> inline typename Iterator< ::std::basic_string<TChar, TCharTraits, TAlloc>, Standard>::Type begin(::std::basic_string<TChar, TCharTraits, TAlloc> & me, Standard);       	// "projects/library/seqan/sequence/std_string.h"(159)
template <typename TChar, typename TCharTraits, typename TAlloc> inline typename Iterator< ::std::basic_string<TChar, TCharTraits, TAlloc> const, Standard>::Type begin(::std::basic_string<TChar, TCharTraits, TAlloc> const & me, Standard);       	// "projects/library/seqan/sequence/std_string.h"(167)
template <typename TValue, typename TSpec> inline typename Iterator<String<TValue, Alloc<TSpec> >, Standard>::Type begin(String<TValue, Alloc<TSpec> > & me, Standard);       	// "projects/library/seqan/sequence/string_alloc.h"(166)
template <typename TValue, typename TSpec> inline typename Iterator<String<TValue, Alloc<TSpec> > const, Standard>::Type begin(String<TValue, Alloc<TSpec> > const & me, Standard);       	// "projects/library/seqan/sequence/string_alloc.h"(174)

//____________________________________________________________________________
// beginPosition

template <typename THost_> inline typename Position<Segment<THost_, InfixSegment> >::Type beginPosition(Segment<THost_, InfixSegment> & me);       	// "projects/library/seqan/sequence/segment_infix.h"(233)
template <typename THost_> inline typename Position<Segment<THost_, InfixSegment> const>::Type beginPosition(Segment<THost_, InfixSegment> const & me);       	// "projects/library/seqan/sequence/segment_infix.h"(240)
template <typename T> inline typename Position<T>::Type beginPosition(T &);       	// "projects/library/seqan/sequence/sequence_interface.h"(406)
template <typename T> inline typename Position<T>::Type beginPosition(T const &);       	// "projects/library/seqan/sequence/sequence_interface.h"(413)
template <typename THost_> inline typename Position<Segment<THost_, SuffixSegment> const>::Type beginPosition(Segment<THost_, SuffixSegment> const & me);       	// "projects/library/seqan/sequence/segment_suffix.h"(237)
template <typename THost_> inline typename Position<Segment<THost_, SuffixSegment> >::Type beginPosition(Segment<THost_, SuffixSegment> & me);       	// "projects/library/seqan/sequence/segment_suffix.h"(244)
template <typename THost_> inline typename Position<Segment<THost_, PrefixSegment> const>::Type beginPosition(Segment<THost_, PrefixSegment> const & );       	// "projects/library/seqan/sequence/segment_prefix.h"(236)
template <typename THost_> inline typename Position<Segment<THost_, PrefixSegment> >::Type beginPosition(Segment<THost_, PrefixSegment> & );       	// "projects/library/seqan/sequence/segment_prefix.h"(243)

//____________________________________________________________________________
// capacity

template <typename TValue, typename THost, typename TMap, typename TSpec> inline typename Size<String< TValue, ValueExpand<THost, TMap, TSpec> > const>::Type capacity(String< TValue, ValueExpand<THost, TMap, TSpec> > const & me);       	// "projects/library/seqan/sequence/string_value_expand.h"(366)
template <typename THost, typename TSpec> inline typename Size< Segment<THost, TSpec> const>::Type capacity(Segment<THost, TSpec> const & me);       	// "projects/library/seqan/sequence/segment_base.h"(270)
template <typename TValue> inline size_t capacity(String <TValue, CStyle > const & me);       	// "projects/library/seqan/sequence/string_cstyle.h"(265)
template <typename TValue, typename THostspec> inline typename Size<String<TValue, Packed<THostspec> > const>::Type capacity(String<TValue, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(513)
template <typename TValue, unsigned int SPACE> inline typename Size<String<TValue, Block<SPACE> > >::Type capacity(String<TValue, Block<SPACE> > const & me);       	// "projects/library/seqan/sequence/string_stack.h"(522)
template <typename T> inline typename Size<T const>::Type capacity(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(856)
template <typename TValue, unsigned int ISize> inline size_t capacity(String<TValue, Array<ISize> > &);       	// "projects/library/seqan/sequence/string_array.h"(167)
template <typename TValue, unsigned int ISize> inline size_t capacity(String<TValue, Array<ISize> > const &);       	// "projects/library/seqan/sequence/string_array.h"(175)
template <typename TChar, typename TCharTraits, typename TAlloc> inline typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type capacity(::std::basic_string<TChar, TCharTraits, TAlloc> const & me);       	// "projects/library/seqan/sequence/std_string.h"(233)
template <typename TValue, typename TSpec> inline size_t capacity(String<TValue, Alloc<TSpec> > & me);       	// "projects/library/seqan/sequence/string_alloc.h"(203)
template <typename TValue, typename TSpec> inline size_t capacity(String<TValue, Alloc<TSpec> > const & me);       	// "projects/library/seqan/sequence/string_alloc.h"(211)

//____________________________________________________________________________
// clear

template <typename THost, typename TSpec> inline void clear(Segment<THost, TSpec> & target);       	// "projects/library/seqan/sequence/segment_base.h"(1192)
template <typename TValue> inline void clear(String<TValue, CStyle> & me);       	// "projects/library/seqan/sequence/string_cstyle.h"(529)
template <typename TValue, typename THostspec> inline void clear(String<TValue, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(528)
template <typename TValue, unsigned int SPACE> inline void clear(String<TValue, Block<SPACE> >& me);       	// "projects/library/seqan/sequence/string_stack.h"(271)
template <typename TString > inline void clear(StringSet< TString, Owner<Default> > &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1124)
template <typename TString, typename TDelimiter > inline void clear(StringSet< TString, Owner<ConcatDirect<TDelimiter> > > &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1133)
template <typename TString > inline void clear(StringSet< TString, Dependent<Generous> > & me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1141)
template <typename TString > inline void clear(StringSet<TString, Dependent<Tight> >& me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1150)
template <typename TValue, typename TSpec> inline void clear(String<TValue, TSpec> & me);       	// "projects/library/seqan/sequence/string_base.h"(204)
template <typename TValue> inline void clear(TValue * me);       	// "projects/library/seqan/sequence/string_pointer.h"(366)
template <typename TChar, typename TCharTraits, typename TAlloc> inline void clear(::std::basic_string<TChar, TCharTraits, TAlloc> & me);       	// "projects/library/seqan/sequence/std_string.h"(257)

//____________________________________________________________________________
// compare

template <typename TSpec, typename TLeft, typename TRight> inline void compare(Lexical<TSpec> & lexical, TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/lexical.h"(279)
template <typename TSpec, typename TLeftValue, typename TRight> inline void compare(Lexical<TSpec> & lexical, TLeftValue const * left, TRight const & right);       	// "projects/library/seqan/sequence/lexical.h"(289)
template <typename TSpec, typename TLeftValue, typename TRightValue> inline void compare(Lexical<TSpec> & lexical, TLeftValue const * left, TRightValue const * right);       	// "projects/library/seqan/sequence/lexical.h"(297)
template <typename TSpec, typename TLeft, typename TRightValue> inline void compare(Lexical<TSpec> & lexical, TLeft const & left, TRightValue const * right);       	// "projects/library/seqan/sequence/lexical.h"(305)

//____________________________________________________________________________
// compare_

template <typename TSpec, typename TLeft, typename TRight> inline void compare_(Lexical<TSpec> & lexical, TLeft & left, TRight & right);       	// "projects/library/seqan/sequence/lexical.h"(237)

//____________________________________________________________________________
// computeGenerousCapacity

template <typename T, typename TSize> inline TSize computeGenerousCapacity(T const & , TSize capacity);       	// "projects/library/seqan/sequence/sequence_interface.h"(928)

//____________________________________________________________________________
// concat

template <typename TString> inline typename Concatenator<TString>::Type & concat(TString &string);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1943)
template <typename TString> inline typename Concatenator<TString const>::Type & concat(TString const &string);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1949)
template <typename TString, typename TSpec> inline typename Concatenator< StringSet<TString, TSpec> >::Type & concat(StringSet<TString, TSpec> &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1955)
template <typename TString, typename TSpec> inline typename Concatenator< StringSet<TString, TSpec> const>::Type & concat(StringSet<TString, TSpec> const &const_me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1962)
template <typename TString, typename TSpec> inline typename Concatenator< StringSet<TString, Owner<ConcatDirect<TSpec> > > >::Type & concat(StringSet<TString, Owner<ConcatDirect<TSpec> > > &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1970)
template <typename TString, typename TSpec> inline typename Concatenator< StringSet<TString, Owner<ConcatDirect<TSpec> > > const>::Type & concat(StringSet<TString, Owner<ConcatDirect<TSpec> > > const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1976)

//____________________________________________________________________________
// container

template <typename TContainer, typename THostspec> inline typename _Parameter<TContainer>::Type container(Iter<TContainer, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(855)
template <typename TContainer, typename THostspec> inline typename _Parameter<TContainer>::Type container(Iter<TContainer, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(862)
template <typename TSSet, typename TSpec> inline typename Concatenator<TSSet>::Type container(Iter<TSSet, ConcatVirtual<TSpec> > &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2329)
template <typename TSSet, typename TSpec> inline typename Concatenator<TSSet>::Type container(Iter<TSSet, ConcatVirtual<TSpec> > const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2336)

//____________________________________________________________________________
// countSequences

template <typename TString> inline unsigned countSequences(TString const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(620)
template <typename TString, typename TSpec> inline typename Size<StringSet<TString, TSpec> >::Type countSequences(StringSet<TString, TSpec> const &stringSet);       	// "projects/library/seqan/sequence/sequence_multiple.h"(626)

//____________________________________________________________________________
// create

template <typename TTargetValue, typename TSource> inline void create(String<TTargetValue, CStyle> & target, TSource & source);       	// "projects/library/seqan/sequence/string_cstyle.h"(708)
template <typename TTargetValue, typename TSource, typename TSize> inline void create(String<TTargetValue, CStyle> & target, TSource & source, TSize limit);       	// "projects/library/seqan/sequence/string_cstyle.h"(719)
template <typename TTargetValue, typename TSource, typename TExpand> inline void create(String<TTargetValue, CStyle> & target, TSource & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_cstyle.h"(732)
template <typename TTargetValue, typename TSource, typename TSize, typename TExpand> inline void create(String<TTargetValue, CStyle> & target, TSource & source, TSize limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_cstyle.h"(743)
template <typename TTargetValue, typename TSource, typename TExpand> inline void create(String<TTargetValue, CStyle> & target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_cstyle.h"(753)
template <typename TTargetValue, typename TSource, typename TSize, typename TExpand> inline void create(String<TTargetValue, CStyle> & target, TSource const & source, TSize limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_cstyle.h"(764)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void create(String<TTargetValue, CStyle> & target, TSourceValue const * source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_cstyle.h"(777)
template <typename TTargetValue, typename TSourceValue, typename TSize, typename TExpand> inline void create(String<TTargetValue, CStyle> & target, TSourceValue const * source, TSize limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_cstyle.h"(788)

//____________________________________________________________________________
// dependent

template <typename TValue> inline bool dependent(String <TValue, CStyle > & me);       	// "projects/library/seqan/sequence/string_cstyle.h"(330)

//____________________________________________________________________________
// empty

template <typename TValue, unsigned int SPACE> inline bool empty(String<TValue, Block<SPACE> > const& me);       	// "projects/library/seqan/sequence/string_stack.h"(503)
template <typename T> inline bool empty(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(879)
template <typename TValue> inline bool empty(TValue * me);       	// "projects/library/seqan/sequence/string_pointer.h"(379)
template <typename TChar, typename TCharTraits, typename TAlloc> inline bool empty(::std::basic_string<TChar, TCharTraits, TAlloc> const & me);       	// "projects/library/seqan/sequence/std_string.h"(245)

//____________________________________________________________________________
// end

template <typename TValue, typename THost, typename TMap, typename TSpec, typename TTag> inline typename Iterator<String< TValue, ValueExpand<THost, TMap, TSpec> >, Tag<TTag> const>::Type end(String< TValue, ValueExpand<THost, TMap, TSpec> > & me, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/string_value_expand.h"(317)
template <typename TValue, typename THost, typename TMap, typename TSpec, typename TTag> inline typename Iterator<String< TValue, ValueExpand<THost, TMap, TSpec> > const, Tag<TTag> const>::Type end(String< TValue, ValueExpand<THost, TMap, TSpec> > const & me, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/string_value_expand.h"(325)
template <typename THost_> inline typename Iterator<Segment<THost_, InfixSegment>, Standard>::Type end(Segment<THost_, InfixSegment> & me, Standard);       	// "projects/library/seqan/sequence/segment_infix.h"(302)
template <typename THost_> inline typename Iterator<Segment<THost_, InfixSegment> const, Standard>::Type end(Segment<THost_, InfixSegment> const & me, Standard);       	// "projects/library/seqan/sequence/segment_infix.h"(310)
template <typename TValue> inline typename Iterator<String <TValue, CStyle >, Standard>::Type end(String <TValue, CStyle > & me, Standard);       	// "projects/library/seqan/sequence/string_cstyle.h"(235)
template <typename TValue> inline typename Iterator<String <TValue, CStyle > const, Standard>::Type end(String <TValue, CStyle > const & me, Standard);       	// "projects/library/seqan/sequence/string_cstyle.h"(243)
template <typename TValue, typename THostspec, typename TTag> inline typename Iterator<String<TValue, Packed<THostspec> >, Tag<TTag> const>::Type end(String<TValue, Packed<THostspec> > & me, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/string_packed.h"(469)
template <typename TValue, typename THostspec, typename TTag> inline typename Iterator<String<TValue, Packed<THostspec> > const, Tag<TTag> const>::Type end(String<TValue, Packed<THostspec> > const & me, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/string_packed.h"(477)
template <typename TValue, unsigned int SPACE, typename TSpec> inline typename Iterator<String<TValue, Block<SPACE> >, Tag<TSpec> const >::Type end(String<TValue, Block<SPACE> > &me, Tag<TSpec> const);       	// "projects/library/seqan/sequence/string_stack.h"(208)
template <typename TValue, unsigned int SPACE, typename TSpec> inline typename Iterator<String<TValue, Block<SPACE> > const, Tag<TSpec> const>::Type end(String<TValue, Block<SPACE> > const &me, Tag<TSpec> const);       	// "projects/library/seqan/sequence/string_stack.h"(216)
template <typename TString, typename TSpec, typename TTag> inline typename Iterator< StringSet< TString, TSpec >, Tag<TTag> const>::Type end(StringSet< TString, TSpec > & me, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1251)
template <typename TString, typename TSpec, typename TTag> inline typename Iterator< StringSet< TString, TSpec > const, Tag<TTag> const>::Type end(StringSet< TString, TSpec > const & me, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1258)
template <typename TStringSet, typename TSpec > inline typename Iterator< ConcatenatorNto1<TStringSet const>, Tag<TSpec> const >::Type end(ConcatenatorNto1<TStringSet const> concat, Tag<TSpec> const);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1912)
template <typename TStringSet, typename TSpec > inline typename Iterator< ConcatenatorNto1<TStringSet>, Tag<TSpec> const >::Type end(ConcatenatorNto1<TStringSet> concat, Tag<TSpec> const);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1920)
template <typename T> inline typename Iterator<T, typename DefaultGetIteratorSpec<T>::Type>::Type end(T & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(442)
template <typename T> inline typename Iterator<T const, typename DefaultGetIteratorSpec<T>::Type>::Type end(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(449)
template <typename T, typename TSpec> inline typename Iterator<T, Tag<TSpec> const>::Type end(T & me, Tag<TSpec> const tag_);       	// "projects/library/seqan/sequence/sequence_interface.h"(502)
template <typename T, typename TSpec> inline typename Iterator<T const, Tag<TSpec> const>::Type end(T const & me, Tag<TSpec> const tag_);       	// "projects/library/seqan/sequence/sequence_interface.h"(510)
template <typename THost_> inline typename Iterator<Segment<THost_, SuffixSegment>, Standard>::Type end(Segment<THost_, SuffixSegment> & me, Standard);       	// "projects/library/seqan/sequence/segment_suffix.h"(282)
template <typename THost_> inline typename Iterator<Segment<THost_, SuffixSegment> const, Standard>::Type end(Segment<THost_, SuffixSegment> const & me, Standard);       	// "projects/library/seqan/sequence/segment_suffix.h"(290)
template <typename TValue, unsigned int ISize> inline typename Iterator<String<TValue, Array<ISize> >, Standard>::Type end(String<TValue, Array<ISize> > & me, Standard);       	// "projects/library/seqan/sequence/string_array.h"(149)
template <typename TValue, unsigned int ISize> inline typename Iterator<String<TValue, Array<ISize> > const, Standard>::Type end(String<TValue, Array<ISize> > const & me, Standard);       	// "projects/library/seqan/sequence/string_array.h"(157)
template <typename TValue> inline typename Iterator<TValue *, Standard>::Type end(TValue * me, Standard);       	// "projects/library/seqan/sequence/string_pointer.h"(201)
template <typename TValue> inline typename Iterator<TValue const *, Standard>::Type end(TValue const * me, Standard);       	// "projects/library/seqan/sequence/string_pointer.h"(211)
template <typename TValue, typename TSpec> inline typename Iterator<TValue *, Tag<TSpec> const>::Type end(TValue * me, Tag<TSpec> const tag_);       	// "projects/library/seqan/sequence/string_pointer.h"(220)
template <typename TValue, typename TSpec> inline typename Iterator<TValue const *, Tag<TSpec> const>::Type end(TValue const * me, Tag<TSpec> const tag_);       	// "projects/library/seqan/sequence/string_pointer.h"(229)
template <typename THost_> inline typename Iterator<Segment<THost_, PrefixSegment>, Standard>::Type end(Segment<THost_, PrefixSegment> & me, Standard);       	// "projects/library/seqan/sequence/segment_prefix.h"(262)
template <typename THost_> inline typename Iterator<Segment<THost_, PrefixSegment> const, Standard>::Type end(Segment<THost_, PrefixSegment> const & me, Standard);       	// "projects/library/seqan/sequence/segment_prefix.h"(270)
template <typename TChar, typename TCharTraits, typename TAlloc> inline typename Iterator< ::std::basic_string<TChar, TCharTraits, TAlloc>, Standard>::Type end(::std::basic_string<TChar, TCharTraits, TAlloc> & me, Standard);       	// "projects/library/seqan/sequence/std_string.h"(180)
template <typename TChar, typename TCharTraits, typename TAlloc> inline typename Iterator< ::std::basic_string<TChar, TCharTraits, TAlloc> const, Standard>::Type end(::std::basic_string<TChar, TCharTraits, TAlloc> const & me, Standard);       	// "projects/library/seqan/sequence/std_string.h"(188)
template <typename TValue, typename TSpec> inline typename Iterator<String<TValue, Alloc<TSpec> >, Standard>::Type end(String<TValue, Alloc<TSpec> > & me, Standard);       	// "projects/library/seqan/sequence/string_alloc.h"(185)
template <typename TValue, typename TSpec> inline typename Iterator<String<TValue, Alloc<TSpec> > const, Standard>::Type end(String<TValue, Alloc<TSpec> > const & me, Standard);       	// "projects/library/seqan/sequence/string_alloc.h"(193)

//____________________________________________________________________________
// endPosition

template <typename THost_> inline typename Position<Segment<THost_, InfixSegment> >::Type endPosition(Segment<THost_, InfixSegment> & me);       	// "projects/library/seqan/sequence/segment_infix.h"(322)
template <typename THost_> inline typename Position<Segment<THost_, InfixSegment> >::Type endPosition(Segment<THost_, InfixSegment> const & me);       	// "projects/library/seqan/sequence/segment_infix.h"(329)
template <typename T> inline typename Position<T>::Type endPosition(T & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(535)
template <typename T> inline typename Position<T>::Type endPosition(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(542)
template <typename THost_> inline typename Position<Segment<THost_, SuffixSegment> >::Type endPosition(Segment<THost_, SuffixSegment> & me);       	// "projects/library/seqan/sequence/segment_suffix.h"(301)
template <typename THost_> inline typename Position<Segment<THost_, SuffixSegment> const>::Type endPosition(Segment<THost_, SuffixSegment> const & me);       	// "projects/library/seqan/sequence/segment_suffix.h"(309)
template <typename THost_> inline typename Position<Segment<THost_, PrefixSegment> >::Type endPosition(Segment<THost_, PrefixSegment> & me);       	// "projects/library/seqan/sequence/segment_prefix.h"(319)
template <typename THost_> inline typename Position<Segment<THost_, PrefixSegment> const>::Type endPosition(Segment<THost_, PrefixSegment> const & me);       	// "projects/library/seqan/sequence/segment_prefix.h"(326)

//____________________________________________________________________________
// erase

template <typename T, typename TPosition> inline void erase(T & me, TPosition pos, TPosition pos_end);       	// "projects/library/seqan/sequence/sequence_interface.h"(1441)
template <typename T, typename TPosition> inline void erase(T & me, TPosition pos);       	// "projects/library/seqan/sequence/sequence_interface.h"(1450)

//____________________________________________________________________________
// fill

template <typename TValue, typename TSpec, typename TSize, typename TValue2, typename TExpand> inline TSize fill(String<TValue, TSpec> & me, TSize new_length, TValue2 const & val, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1632)
template <typename T, typename TSize, typename TValue> inline typename Size<T>::Type fill( T & me, TSize new_length, TValue const & val);       	// "projects/library/seqan/sequence/sequence_interface.h"(1491)
template <typename TValue, typename TExpand> inline size_t fill( TValue * me, size_t new_length, TValue const & val, Tag<TExpand> const &);       	// "projects/library/seqan/sequence/string_pointer.h"(692)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSize, typename TExpand> inline typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type fill( ::std::basic_string<TChar, TCharTraits, TAlloc> & me, TSize new_length, TChar const & val, Tag<TExpand> const &);       	// "projects/library/seqan/sequence/std_string.h"(687)

//____________________________________________________________________________
// front

template <typename T> inline typename Reference<T>::Type front(T & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(645)
template <typename T> inline typename Reference<T const>::Type front(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(652)

//____________________________________________________________________________
// getSeqNo

template <typename TPosition> inline TPosition getSeqNo(TPosition const &, Nothing const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(214)
template <typename TPosition> inline TPosition getSeqNo(TPosition const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(225)
template <typename T1, typename T2, typename TCompression, typename TLimitsString> inline T1 getSeqNo(Pair<T1, T2, TCompression> const &pos, TLimitsString const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(239)
template <typename T1, typename T2, typename TCompression> inline T1 getSeqNo(Pair<T1, T2, TCompression> const &pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(244)
template <typename TPos, typename TLimitsString> inline TPos getSeqNo(TPos const &pos, TLimitsString const &limits);       	// "projects/library/seqan/sequence/sequence_multiple.h"(264)

//____________________________________________________________________________
// getSeqOffset

template <typename TPosition> inline TPosition getSeqOffset(TPosition const &pos, Nothing const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(219)
template <typename TPosition> inline TPosition getSeqOffset(TPosition const &pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(230)
template <typename T1, typename T2, typename TCompression, typename TLimitsString> inline T2 getSeqOffset(Pair<T1, T2, TCompression> const &pos, TLimitsString const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(250)
template <typename T1, typename T2, typename TCompression> inline T1 getSeqOffset(Pair<T1, T2, TCompression> const &pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(255)
template <typename TPos, typename TLimitsString> inline TPos getSeqOffset(TPos const &pos, TLimitsString const &limits);       	// "projects/library/seqan/sequence/sequence_multiple.h"(273)

//____________________________________________________________________________
// getValue

template <typename TContainer, typename TIterator> inline typename Value<TContainer>::Type getValue(Iter<TContainer, AdaptorIterator<TIterator, ValueExpandIter> > & me);       	// "projects/library/seqan/sequence/string_value_expand.h"(401)
template <typename TContainer, typename TIterator> inline void getValue(Iter<TContainer, AdaptorIterator<TIterator, ValueExpandIter> > const & me);       	// "projects/library/seqan/sequence/string_value_expand.h"(418)
template <typename TContainer, typename THostspec> inline typename GetValue<Iter<TContainer, Packed<THostspec> > >::Type getValue(Iter<TContainer, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(967)
template <typename TContainer, typename THostspec> inline typename GetValue<Iter<TContainer, Packed<THostspec> > const>::Type getValue(Iter<TContainer, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(974)
template <typename T, typename TPos> inline typename GetValue<T>::Type getValue(T & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_interface.h"(610)
template <typename T, typename TPos> inline typename GetValue<T const>::Type getValue(T const & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_interface.h"(618)

//____________________________________________________________________________
// getValueById

template <typename TString, typename TSpec, typename TId> inline typename Reference<StringSet<TString, Owner<TSpec> > >::Type getValueById(StringSet<TString, Owner<TSpec> >& me, TId const id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1358)
template <typename TString, typename TId> inline typename Reference<StringSet<TString, Dependent<Generous> > >::Type getValueById(StringSet<TString, Dependent<Generous> >& me, TId const id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1369)
template <typename TString, typename TId> inline typename Reference<StringSet<TString, Dependent<Tight> > >::Type getValueById(StringSet<TString, Dependent<Tight> >&me, TId const id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1381)

//____________________________________________________________________________
// goBegin

template <typename THost> inline void goBegin(Segment<THost, InfixSegment> & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(551)
template <typename THost, typename THost2> inline void goBegin(Segment<THost, InfixSegment> & segment, THost2 &);       	// "projects/library/seqan/sequence/segment_infix.h"(560)
template <typename THost, typename THost2> inline void goBegin(Segment<THost, InfixSegment> & segment, THost2 const &);       	// "projects/library/seqan/sequence/segment_infix.h"(567)
template <typename THost> inline void goBegin(Segment<THost, SuffixSegment> & segment, THost &);       	// "projects/library/seqan/sequence/segment_suffix.h"(443)
template <typename THost> inline void goBegin(Segment<THost, SuffixSegment> & segment);       	// "projects/library/seqan/sequence/segment_suffix.h"(451)
template <typename THost> inline void goBegin(Segment<THost, PrefixSegment> & segment, THost &);       	// "projects/library/seqan/sequence/segment_prefix.h"(446)
template <typename THost> inline void goBegin(Segment<THost, PrefixSegment> & segment);       	// "projects/library/seqan/sequence/segment_prefix.h"(454)

//____________________________________________________________________________
// goEnd

template <typename THost> inline void goEnd(Segment<THost, InfixSegment> & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(577)
template <typename THost, typename THost2> inline void goEnd(Segment<THost, InfixSegment> & segment, THost2 &);       	// "projects/library/seqan/sequence/segment_infix.h"(586)
template <typename THost, typename THost2> inline void goEnd(Segment<THost, InfixSegment> & segment, THost2 const &);       	// "projects/library/seqan/sequence/segment_infix.h"(593)
template <typename THost> inline void goEnd(Segment<THost, SuffixSegment> & segment, THost &);       	// "projects/library/seqan/sequence/segment_suffix.h"(461)
template <typename THost> inline void goEnd(Segment<THost, SuffixSegment> & segment);       	// "projects/library/seqan/sequence/segment_suffix.h"(469)
template <typename THost> inline void goEnd(Segment<THost, PrefixSegment> & segment, THost &);       	// "projects/library/seqan/sequence/segment_prefix.h"(464)
template <typename THost> inline void goEnd(Segment<THost, PrefixSegment> & segment);       	// "projects/library/seqan/sequence/segment_prefix.h"(472)

//____________________________________________________________________________
// goNext

template <typename TContainer, typename THostspec> inline void goNext(Iter<TContainer, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(1163)
template <typename TStringSet, typename TSpec> inline void goNext(Iter<TStringSet, ConcatVirtual<TSpec> > & me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2187)

//____________________________________________________________________________
// goPrevious

template <typename TContainer, typename THostspec> inline void goPrevious(Iter<TContainer, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(1184)
template <typename TStringSet, typename TSpec> inline void goPrevious(Iter<TStringSet, ConcatVirtual<TSpec> > & me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2213)

//____________________________________________________________________________
// hasNoHost

template <typename THost, typename TSpec> inline bool hasNoHost(Segment<THost, TSpec> const & target);       	// "projects/library/seqan/sequence/segment_base.h"(281)

//____________________________________________________________________________
// hasPrefix

template <typename TLeft, typename TRight > inline bool hasPrefix(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/lexical.h"(708)
template <typename TSpec> inline bool hasPrefix(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/lexical.h"(716)

//____________________________________________________________________________
// host

template <typename THost_> inline typename _Parameter<THost_>::Type host(Segment<THost_, InfixSegment> & me);       	// "projects/library/seqan/sequence/segment_infix.h"(191)
template <typename THost_> inline typename _Parameter<THost_>::Type host(Segment<THost_, InfixSegment> const & me);       	// "projects/library/seqan/sequence/segment_infix.h"(199)
template <typename TValue, typename THostspec> inline typename Host<String<TValue, Packed<THostspec> > >::Type & host(String<TValue, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(149)
template <typename TValue, typename THostspec> inline typename Host<String<TValue, Packed<THostspec> > const>::Type const & host(String<TValue, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(157)
template <typename THost_> inline typename _Parameter<THost_>::Type host(Segment<THost_, SuffixSegment> & me);       	// "projects/library/seqan/sequence/segment_suffix.h"(189)
template <typename THost_> inline typename _Parameter<THost_>::Type host(Segment<THost_, SuffixSegment> const & me);       	// "projects/library/seqan/sequence/segment_suffix.h"(197)
template <typename THost_> inline typename _Parameter<THost_>::Type host(Segment<THost_, PrefixSegment> & me);       	// "projects/library/seqan/sequence/segment_prefix.h"(189)
template <typename THost_> inline typename _Parameter<THost_>::Type host(Segment<THost_, PrefixSegment> const & me);       	// "projects/library/seqan/sequence/segment_prefix.h"(197)

//____________________________________________________________________________
// hostIterator

template <typename TContainer, typename THostspec> inline typename HostIterator<Iter<TContainer, Packed<THostspec> > >::Type & hostIterator(Iter<TContainer, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(884)
template <typename TContainer, typename THostspec> inline typename HostIterator<Iter<TContainer, Packed<THostspec> > const>::Type & hostIterator(Iter<TContainer, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(891)

//____________________________________________________________________________
// id

template <typename TValue, typename THost, typename TMap, typename TSpec> inline void const * id(String< TValue, ValueExpand<THost, TMap, TSpec> > const & me);       	// "projects/library/seqan/sequence/string_value_expand.h"(262)
template <typename THost, typename TSpec> inline void const * id(Segment<THost, TSpec> const & me);       	// "projects/library/seqan/sequence/segment_base.h"(246)
template <typename TValue, typename THostspec> inline void const * id(String<TValue, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(414)
template <typename T> inline void const * id(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(208)
template <typename TChar, typename TCharTraits, typename TAlloc> inline void const * id(::std::basic_string<TChar, TCharTraits, TAlloc> const & me);       	// "projects/library/seqan/sequence/std_string.h"(147)

//____________________________________________________________________________
// idToPosition

template <typename TString, typename TSpec, typename TId> inline typename Id<StringSet<TString, Owner<TSpec> > >::Type idToPosition(StringSet<TString, Owner<TSpec> > const&, TId const id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1687)
template <typename TString, typename TId> inline typename Id<StringSet<TString, Dependent<Generous> > >::Type idToPosition(StringSet<TString, Dependent<Generous> > const& me, TId const id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1696)
template <typename TString, typename TId> inline typename Id<StringSet<TString, Dependent<Tight> > >::Type idToPosition(StringSet<TString, Dependent<Tight> > const&me, TId const id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1705)

//____________________________________________________________________________
// infix

template <typename T, typename TPosBegin, typename TPosEnd> inline typename Infix<T>::Type infix(T & t, TPosBegin pos_begin, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_infix.h"(683)
template <typename T, typename TPosBegin, typename TPosEnd> inline typename Infix<T *>::Type infix(T * t, TPosBegin pos_begin, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_infix.h"(691)
template <typename T, typename TSpec, typename TPosBegin, typename TPosEnd> inline typename Infix<Segment<T, TSpec> >::Type infix(Segment<T, TSpec> & t, TPosBegin pos_begin, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_infix.h"(699)
template <typename T, typename TSpec, typename TPosBegin, typename TPosEnd> inline typename Infix<Segment<T, TSpec> const>::Type infix(Segment<T, TSpec> const & t, TPosBegin pos_begin, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_infix.h"(710)

//____________________________________________________________________________
// infixWithLength

template <typename T, typename TPosBegin, typename TSize> inline typename Infix<T>::Type infixWithLength(T & t, TPosBegin pos_begin, TSize length);       	// "projects/library/seqan/sequence/segment_infix.h"(741)
template <typename T, typename TPosBegin, typename TSize> inline typename Infix<T *>::Type infixWithLength(T * t, TPosBegin pos_begin, TSize length);       	// "projects/library/seqan/sequence/segment_infix.h"(749)
template <typename T, typename TSpec, typename TPosBegin, typename TSize> inline typename Infix<Segment<T, TSpec> >::Type infixWithLength(Segment<T, TSpec> & t, TPosBegin pos_begin, TSize length);       	// "projects/library/seqan/sequence/segment_infix.h"(757)
template <typename T, typename TSpec, typename TPosBegin, typename TSize> inline typename Infix<Segment<T, TSpec> const>::Type infixWithLength(Segment<T, TSpec> const & t, TPosBegin pos_begin, TSize length);       	// "projects/library/seqan/sequence/segment_infix.h"(768)
template <typename TString, typename TSpec, typename TPosition, typename TSize > inline typename Infix<TString>::Type infixWithLength(StringSet< TString, TSpec > &me, TPosition pos, TSize length);       	// "projects/library/seqan/sequence/sequence_multiple.h"(468)
template <typename TString, typename TSpec, typename TPosition, typename TSize > inline typename Infix<TString const>::Type infixWithLength(StringSet< TString, TSpec > const &me, TPosition pos, TSize length);       	// "projects/library/seqan/sequence/sequence_multiple.h"(482)
template <typename TString, typename TDelimiter, typename TPosition, typename TSize > inline typename Infix<TString>::Type infixWithLength(StringSet< TString, Owner<ConcatDirect<TDelimiter> > > &me, TPosition pos, TSize length);       	// "projects/library/seqan/sequence/sequence_multiple.h"(496)
template <typename TString, typename TDelimiter, typename TPosition, typename TSize > inline typename Infix<TString const>::Type infixWithLength(StringSet< TString, Owner<ConcatDirect<TDelimiter> > > const &me, TPosition pos, TSize length);       	// "projects/library/seqan/sequence/sequence_multiple.h"(503)

//____________________________________________________________________________
// insertValue

template <typename THost, typename TSpec, typename TPosition, typename TValue, typename TExpand> inline void insertValue(Segment<THost, TSpec> & me, TPosition pos, TValue const & _value, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(892)
template <typename THost, typename TSpec, typename TPosition, typename TValue, typename TExpand> inline void insertValue(Segment<THost, TSpec> const & me, TPosition pos, TValue const & _value, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(902)
template <typename TTargetValue, typename TTargetSpec, typename TPosition, typename TValue, typename TExpand> inline void insertValue(String<TTargetValue, TTargetSpec> & me, TPosition pos, TValue const & _value, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1165)
template <typename T, typename TPosition, typename TValue> inline void insertValue(T & me, TPosition pos, TValue const & _value);       	// "projects/library/seqan/sequence/sequence_interface.h"(1150)
template <typename T, typename TPosition, typename TValue> inline void insertValue(T const & me, TPosition pos, TValue const & _value);       	// "projects/library/seqan/sequence/sequence_interface.h"(1159)

//____________________________________________________________________________
// isEqual

template <typename TLeftValue, typename TRight > inline bool isEqual(TLeftValue * left, TRight const & right);       	// "projects/library/seqan/sequence/string_pointer.h"(717)
template <typename TLeft, typename TRight > inline bool isEqual(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/lexical.h"(330)
template <typename TSpec> inline bool isEqual(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/lexical.h"(338)

//____________________________________________________________________________
// isGreater

template <typename TLeftValue, typename TRight> inline bool isGreater(TLeftValue * left, TRight const & right);       	// "projects/library/seqan/sequence/string_pointer.h"(802)
template <typename TLeft, typename TRight, typename TPrefixOrder > inline bool isGreater(TLeft const & left, TRight const & right, Tag<TPrefixOrder> const tag);       	// "projects/library/seqan/sequence/lexical.h"(541)
template <typename TLeft, typename TRight> inline bool isGreater(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/lexical.h"(550)
template <typename TSpec> inline bool isGreater(Lexical<TSpec> const & _lex, TagPrefixLess);       	// "projects/library/seqan/sequence/lexical.h"(559)
template <typename TSpec> inline bool isGreater(Lexical<TSpec> const & _lex, TagPrefixGreater);       	// "projects/library/seqan/sequence/lexical.h"(567)
template <typename TSpec> inline bool isGreater(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/lexical.h"(574)

//____________________________________________________________________________
// isGreaterOrEqual

template <typename TLeftValue, typename TRight> inline bool isGreaterOrEqual(TLeftValue * left, TRight const & right);       	// "projects/library/seqan/sequence/string_pointer.h"(822)
template <typename TLeft, typename TRight, typename TPrefixOrder > inline bool isGreaterOrEqual(TLeft const & left, TRight const & right, Tag<TPrefixOrder> const tag);       	// "projects/library/seqan/sequence/lexical.h"(609)
template <typename TLeft, typename TRight> inline bool isGreaterOrEqual(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/lexical.h"(618)
template <typename TSpec> inline bool isGreaterOrEqual(Lexical<TSpec> const & _lex, TagPrefixLess);       	// "projects/library/seqan/sequence/lexical.h"(627)
template <typename TSpec> inline bool isGreaterOrEqual(Lexical<TSpec> const & _lex, TagPrefixGreater);       	// "projects/library/seqan/sequence/lexical.h"(635)
template <typename TSpec> inline bool isGreaterOrEqual(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/lexical.h"(642)

//____________________________________________________________________________
// isLess

template <typename TLeftValue, typename TRight> inline bool isLess(TLeftValue * left, TRight const & right);       	// "projects/library/seqan/sequence/string_pointer.h"(762)
template <typename TLeft, typename TRight, typename TPrefixOrder > inline bool isLess(TLeft const & left, TRight const & right, Tag<TPrefixOrder> const tag);       	// "projects/library/seqan/sequence/lexical.h"(406)
template <typename TLeft, typename TRight> inline bool isLess(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/lexical.h"(415)
template <typename TSpec> inline bool isLess(Lexical<TSpec> const & _lex, TagPrefixLess);       	// "projects/library/seqan/sequence/lexical.h"(424)
template <typename TSpec> inline bool isLess(Lexical<TSpec> const & _lex, TagPrefixGreater);       	// "projects/library/seqan/sequence/lexical.h"(432)
template <typename TSpec> inline bool isLess(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/lexical.h"(439)

//____________________________________________________________________________
// isLessOrEqual

template <typename TLeftValue, typename TRight> inline bool isLessOrEqual(TLeftValue * left, TRight const & right);       	// "projects/library/seqan/sequence/string_pointer.h"(782)
template <typename TLeft, typename TRight, typename TPrefixOrder > inline bool isLessOrEqual(TLeft const & left, TRight const & right, Tag<TPrefixOrder> const tag);       	// "projects/library/seqan/sequence/lexical.h"(474)
template <typename TLeft, typename TRight> inline bool isLessOrEqual(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/lexical.h"(483)
template <typename TSpec> inline bool isLessOrEqual(Lexical<TSpec> const & _lex, TagPrefixLess);       	// "projects/library/seqan/sequence/lexical.h"(492)
template <typename TSpec> inline bool isLessOrEqual(Lexical<TSpec> const & _lex, TagPrefixGreater);       	// "projects/library/seqan/sequence/lexical.h"(500)
template <typename TSpec> inline bool isLessOrEqual(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/lexical.h"(507)

//____________________________________________________________________________
// isNotEqual

template <typename TLeftValue, typename TRight > inline bool isNotEqual(TLeftValue * left, TRight const & right);       	// "projects/library/seqan/sequence/string_pointer.h"(739)
template <typename TLeft, typename TRight > inline bool isNotEqual(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/lexical.h"(364)
template <typename TSpec> inline bool isNotEqual(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/lexical.h"(372)

//____________________________________________________________________________
// isPrefix

template <typename TLeft, typename TRight > inline bool isPrefix(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/lexical.h"(670)
template <typename TSpec> inline bool isPrefix(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/lexical.h"(678)

//____________________________________________________________________________
// iter

template <typename TValue, typename THost, typename TMap, typename TPos, typename TSpec, typename TTag> inline typename Iterator<String< TValue, ValueExpand<THost, TMap, TSpec> >, Tag<TTag> const>::Type iter(String< TValue, ValueExpand<THost, TMap, TSpec> > & me, TPos pos_, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/string_value_expand.h"(274)
template <typename TValue, typename THost, typename TMap, typename TPos, typename TSpec, typename TTag> inline typename Iterator<String< TValue, ValueExpand<THost, TMap, TSpec> > const, Tag<TTag> const>::Type iter(String< TValue, ValueExpand<THost, TMap, TSpec> > const & me, TPos pos_, Tag<TTag> const tag_ );       	// "projects/library/seqan/sequence/string_value_expand.h"(285)
template <typename TValue, typename THostspec, typename TPos, typename TTag> inline typename Iterator<String<TValue, Packed<THostspec> >, Tag<TTag> const>::Type iter(String<TValue, Packed<THostspec> > & me, TPos pos_, Tag<TTag> const);       	// "projects/library/seqan/sequence/string_packed.h"(426)
template <typename TValue, typename THostspec, typename TPos, typename TTag> inline typename Iterator<String<TValue, Packed<THostspec> > const, Tag<TTag> const>::Type iter(String<TValue, Packed<THostspec> > const & me, TPos pos_, Tag<TTag> const);       	// "projects/library/seqan/sequence/string_packed.h"(436)
template <typename TString, typename TSpec, typename TPos, typename TTag> inline typename Iterator< StringSet< TString, TSpec >, Tag<TTag> const>::Type iter(StringSet< TString, TSpec > & me, TPos pos, Tag<TTag> const);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1206)
template <typename TString, typename TSpec, typename TPos, typename TTag> inline typename Iterator< StringSet< TString, TSpec > const, Tag<TTag> const>::Type iter(StringSet< TString, TSpec > const & me, TPos pos, Tag<TTag> const);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1217)
template <typename T, typename TPos> inline typename Iterator<T, typename DefaultGetIteratorSpec<T>::Type>::Type iter(T & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_interface.h"(720)
template <typename T, typename TPos> inline typename Iterator<T const, typename DefaultGetIteratorSpec<T>::Type>::Type iter(T const & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_interface.h"(728)
template <typename T, typename TPos, typename TTag> inline typename Iterator<T, Tag<TTag> const>::Type iter(T & me, TPos pos, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/sequence_interface.h"(739)
template <typename T, typename TPos, typename TTag> inline typename Iterator<T const, Tag<TTag> const>::Type iter(T const & me, TPos pos, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/sequence_interface.h"(748)

//____________________________________________________________________________
// lcpLength

template <typename TLeft, typename TRight > inline typename Size<TLeft>::Type lcpLength(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/lexical.h"(740)
template <typename TSpec> inline typename Size< Lexical<TSpec> >::Type lcpLength(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/lexical.h"(749)

//____________________________________________________________________________
// length

template <typename TValue, typename THost, typename TMap, typename TSpec> inline typename Size<String< TValue, ValueExpand<THost, TMap, TSpec> > const>::Type length(String< TValue, ValueExpand<THost, TMap, TSpec> > const & me);       	// "projects/library/seqan/sequence/string_value_expand.h"(356)
template <typename THost, typename TSpec> inline typename Size<Segment<THost, TSpec> const>::Type length(Segment<THost, TSpec> const & me);       	// "projects/library/seqan/sequence/segment_base.h"(258)
template <typename TValue, typename THostspec> inline typename Size<String<TValue, Packed<THostspec> > >::Type length(String<TValue, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(167)
template <typename TValue, typename THostspec> inline typename Size<String<TValue, Packed<THostspec> > const>::Type length(String<TValue, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(175)
template <typename TValue, unsigned int SPACE> inline typename Size<String<TValue, Block<SPACE> > >::Type length(String<TValue, Block<SPACE> > const & me);       	// "projects/library/seqan/sequence/string_stack.h"(511)
template <typename TString, typename TSpec > inline typename Size< StringSet< TString, TSpec > >::Type length(StringSet< TString, TSpec > const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1167)
template <typename TString> inline typename Size<StringSet<TString, Dependent<Tight> > >::Type length(StringSet<TString, Dependent<Tight> > const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1174)
template <typename TStringSet > inline typename Size< ConcatenatorNto1<TStringSet> >::Type length(ConcatenatorNto1<TStringSet> const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1885)
template <typename TValue, typename TSpec> inline typename Size< String<TValue, TSpec> const>::Type length(String<TValue, TSpec> const & me);       	// "projects/library/seqan/sequence/string_base.h"(179)
template <typename T> inline typename Size<T>::Type length(T const & );       	// "projects/library/seqan/sequence/sequence_interface.h"(829)
template <typename TValue> inline size_t length(TValue * me);       	// "projects/library/seqan/sequence/string_pointer.h"(313)
template <typename TValue> inline size_t length(TValue const * me);       	// "projects/library/seqan/sequence/string_pointer.h"(325)
inline size_t length(char * me);       	// "projects/library/seqan/sequence/string_pointer.h"(336)
inline size_t length(char const * me);       	// "projects/library/seqan/sequence/string_pointer.h"(343)
template <typename TChar, typename TCharTraits, typename TAlloc> inline typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type length(::std::basic_string<TChar, TCharTraits, TAlloc> const & me);       	// "projects/library/seqan/sequence/std_string.h"(221)

//____________________________________________________________________________
// lengthSum

template <typename TString > inline typename Size<TString>::Type lengthSum(TString const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1034)
template <typename TString, typename TSpec > inline typename Size<TString>::Type lengthSum(StringSet< TString, TSpec > const &me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1040)

//____________________________________________________________________________
// move

template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void move(Segment<THost, TSpec> & target, TSource & source);       	// "projects/library/seqan/sequence/segment_base.h"(611)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void move(Segment<THost, TSpec> & target, TSource const & source);       	// "projects/library/seqan/sequence/segment_base.h"(620)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void move(Segment<THost, TSpec> const & target, TSource & source);       	// "projects/library/seqan/sequence/segment_base.h"(632)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void move(Segment<THost, TSpec> const & target, TSource const & source);       	// "projects/library/seqan/sequence/segment_base.h"(641)
template <typename TValue> inline void move( String <TValue, CStyle > & target, String <TValue, CStyle > & source);       	// "projects/library/seqan/sequence/string_cstyle.h"(188)
template <typename TTargetValue, typename TTargetSpec, typename TSource> inline void move(String<TTargetValue, TTargetSpec> & target, TSource & source);       	// "projects/library/seqan/sequence/string_base.h"(915)
template <typename TTargetValue, typename TTargetSpec, typename TSource> inline void move(String<TTargetValue, TTargetSpec> & target, TSource const & source);       	// "projects/library/seqan/sequence/string_base.h"(924)
template <typename TTargetValue, typename TTargetSpec, typename TSource, typename TTag> inline void move(String<TTargetValue, TTargetSpec> & target, TSource & source, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_base.h"(937)
template <typename TTargetValue, typename TTargetSpec, typename TSource, typename TTag> inline void move(String<TTargetValue, TTargetSpec> & target, TSource const & source, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_base.h"(947)
template <typename TTargetValue, typename TSource> inline void move(TTargetValue * & target, TSource & source);       	// "projects/library/seqan/sequence/string_pointer.h"(518)
template <typename TTargetValue, typename TSource> inline void move(TTargetValue * & target, TSource const & source);       	// "projects/library/seqan/sequence/string_pointer.h"(526)
template <typename TTargetValue, typename TSourceValue, typename TSpec> inline void move(String<TTargetValue, Alloc<TSpec> > & target, String<TSourceValue, Alloc<TSpec> > & source);       	// "projects/library/seqan/sequence/string_alloc.h"(369)
template <typename TTargetValue, typename TSourceValue, typename TSpec> inline void move(String<TTargetValue, Alloc<TSpec> > & target, String<TSourceValue, Alloc<TSpec> > const & source);       	// "projects/library/seqan/sequence/string_alloc.h"(376)
template <typename TValue, typename TSpec> inline void move(String<TValue, Alloc<TSpec> > & target, String<TValue, Alloc<TSpec> > & source);       	// "projects/library/seqan/sequence/string_alloc.h"(384)
template <typename TValue, typename TSpec> inline void move(String<TValue, Alloc<TSpec> > & target, String<TValue, Alloc<TSpec> > const & source);       	// "projects/library/seqan/sequence/string_alloc.h"(398)

//____________________________________________________________________________
// moveValue

template <typename TContainer, typename TIterator, typename TValue> inline void moveValue(Iter<TContainer, AdaptorIterator<TIterator, ValueExpandIter> > & me, TValue const & _value);       	// "projects/library/seqan/sequence/string_value_expand.h"(501)
template <typename TContainer, typename TIterator, typename TValue> inline void moveValue(Iter<TContainer, AdaptorIterator<TIterator, ValueExpandIter> > const & me, TValue const & _value);       	// "projects/library/seqan/sequence/string_value_expand.h"(509)
template <typename TContainer, typename THostspec, typename TValue> inline void moveValue(Iter<TContainer, Packed<THostspec> > & me, TValue const & _value);       	// "projects/library/seqan/sequence/string_packed.h"(1029)
template <typename TContainer, typename THostspec, typename TValue> inline void moveValue(Iter<TContainer, Packed<THostspec> > const & me, TValue const & _value);       	// "projects/library/seqan/sequence/string_packed.h"(1037)
template <typename T, typename TValue, typename TPos> inline void moveValue(T & me, TPos pos, TValue const & _value);       	// "projects/library/seqan/sequence/sequence_interface.h"(804)
template <typename TValue, typename TPos> inline void moveValue(TValue * me, TPos pos, TValue const & _value);       	// "projects/library/seqan/sequence/string_pointer.h"(280)

//____________________________________________________________________________
// operation_2_set

template <typename THost, typename TSpec, typename TSource> inline bool operation_2_set(Segment<THost, TSpec> &, TSource &);       	// "projects/library/seqan/sequence/segment_base.h"(300)
template <typename THost, typename TSpec, typename TSpec2> inline bool operation_2_set(Segment<THost, TSpec> & target, Segment<THost, TSpec2> & source);       	// "projects/library/seqan/sequence/segment_base.h"(307)
template <typename THost, typename TSpec, typename TSpec2> inline bool operation_2_set(Segment<THost, TSpec> & target, Segment<THost, TSpec2> const & source);       	// "projects/library/seqan/sequence/segment_base.h"(319)
template <typename THost, typename TSpec> inline bool operation_2_set(Segment<THost, TSpec> & target, THost & source);       	// "projects/library/seqan/sequence/segment_base.h"(331)
template <typename THost, typename TSpec, typename TSource, typename TSize> inline bool operation_2_set(Segment<THost, TSpec> & target, TSource & source, TSize);       	// "projects/library/seqan/sequence/segment_base.h"(346)
template <typename THost, typename TSpec, typename TSpec2, typename TSize> inline bool operation_2_set(Segment<THost, TSpec> & target, Segment<THost, TSpec2> & source, TSize limit);       	// "projects/library/seqan/sequence/segment_base.h"(354)
template <typename THost, typename TSpec, typename TSize> inline bool operation_2_set(Segment<THost, TSpec> & target, THost & source, TSize limit);       	// "projects/library/seqan/sequence/segment_base.h"(373)

//____________________________________________________________________________
// operator!=

template <typename TLeftHost, typename TLeftSpec, typename TRight > inline bool operator!= (Segment<TLeftHost, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/segment_base.h"(1228)
template <typename TContainer, typename THostspec> inline bool operator!= (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1099)
template <typename TSSetL, typename TSpecL, typename TSSetR, typename TSpecR> inline bool operator!= ( Iter<TSSetL, ConcatVirtual<TSpecL> > const &L, Iter<TSSetR, ConcatVirtual<TSpecR> > const &R);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2293)
template <typename TLeftValue, typename TLeftSpec, typename TRight > inline bool operator!=(String<TLeftValue, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/string_base.h"(1705)
template <typename TLeftValue, typename TRightValue, typename TRightSpec > inline bool operator!= (TLeftValue * left, String<TRightValue, TRightSpec> const & right);       	// "projects/library/seqan/sequence/string_base.h"(1714)

//____________________________________________________________________________
// operator*

template <typename TStringSet, typename TSpec> inline typename Reference< Iter< TStringSet, ConcatVirtual<TSpec> > const>::Type operator* (Iter<TStringSet, ConcatVirtual<TSpec> > const & me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2171)
template <typename TStringSet, typename TSpec> inline typename Reference< Iter< TStringSet, ConcatVirtual<TSpec> > >::Type operator* (Iter<TStringSet, ConcatVirtual<TSpec> > & me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2177)

//____________________________________________________________________________
// operator+

template <typename TContainer, typename THostspec, typename TIntegral> inline Iter<TContainer, Packed<THostspec> > operator+ (Iter<TContainer, Packed<THostspec> > const & left, TIntegral right);       	// "projects/library/seqan/sequence/string_packed.h"(1206)
template <typename TContainer, typename THostspec, typename TIntegral> inline Iter<TContainer, Packed<THostspec> > operator+ (TIntegral left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1214)
template <typename TStringSet, typename TSpec, typename TDelta> inline Iter<TStringSet, ConcatVirtual<TSpec> > operator+ (Iter<TStringSet, ConcatVirtual<TSpec> > const & me, TDelta delta);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2239)
template <typename TStringSet, typename TSpec, typename T1, typename T2, typename TCompression> inline Iter<TStringSet, ConcatVirtual<TSpec> > operator+ (Iter<TStringSet, ConcatVirtual<TSpec> > const & me, Pair<T1, T2, TCompression> delta);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2247)

//____________________________________________________________________________
// operator++

template <typename THost> inline Segment<THost, InfixSegment> & operator++(Segment<THost, InfixSegment> & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(602)
template <typename TStringSet, typename TSpec> inline Iter<TStringSet, ConcatVirtual<TSpec> > const & operator++ (Iter<TStringSet, ConcatVirtual<TSpec> > & me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2194)
template <typename TStringSet, typename TSpec> inline Iter<TStringSet, ConcatVirtual<TSpec> > const & operator++ (Iter<TStringSet, ConcatVirtual<TSpec> > & me, int);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2201)
template <typename THost> inline Segment<THost, SuffixSegment> & operator++(Segment<THost, SuffixSegment> & segment);       	// "projects/library/seqan/sequence/segment_suffix.h"(478)
template <typename THost> inline Segment<THost, PrefixSegment> & operator++(Segment<THost, PrefixSegment> & segment);       	// "projects/library/seqan/sequence/segment_prefix.h"(481)

//____________________________________________________________________________
// operator+=

template <typename TLeftValue, typename TLeftSpec, typename TRight> Segment<TLeftValue, TLeftSpec> const & operator+= (Segment<TLeftValue, TLeftSpec> & left, TRight const & right);       	// "projects/library/seqan/sequence/segment_base.h"(1203)
template <typename TContainer, typename THostspec, typename TIntegral> inline Iter<TContainer, Packed<THostspec> > & operator+= (Iter<TContainer, Packed<THostspec> > & left, TIntegral right);       	// "projects/library/seqan/sequence/string_packed.h"(1227)
template <typename TLeftValue, typename TLeftSpec, typename TRight > String<TLeftValue, TLeftSpec> const & operator+= (String<TLeftValue, TLeftSpec> & left, TRight const & right);       	// "projects/library/seqan/sequence/string_base.h"(1672)

//____________________________________________________________________________
// operator-

template <typename TContainer, typename THostspec, typename TIntegral> inline Iter<TContainer, Packed<THostspec> > operator- (Iter<TContainer, Packed<THostspec> > const & left, TIntegral right);       	// "projects/library/seqan/sequence/string_packed.h"(1241)
template <typename TContainer, typename THostspec> inline typename Difference<Iter<TContainer, Packed<THostspec> > >::Type operator- (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1252)
template <typename TContainer, typename THostspec> inline typename Difference<Iter<TContainer, Packed<THostspec> > >::Type operator- (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > & right);       	// "projects/library/seqan/sequence/string_packed.h"(1261)
template <typename TSSetL, typename TSpecL, typename TSSetR, typename TSpecR> typename Difference<Iter<TSSetL, ConcatVirtual<TSpecL> > >::Type operator- ( Iter<TSSetL, ConcatVirtual<TSpecL> > const &L, Iter<TSSetR, ConcatVirtual<TSpecR> > const &R);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2262)
template <typename TStringSet, typename TSpec, typename TDelta> inline Iter<TStringSet, ConcatVirtual<TSpec> > operator- (Iter<TStringSet, ConcatVirtual<TSpec> > const & me, TDelta delta);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2268)

//____________________________________________________________________________
// operator--

template <typename THost> inline Segment<THost, InfixSegment> & operator--(Segment<THost, InfixSegment> & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(622)
template <typename TStringSet, typename TSpec> inline Iter<TStringSet, ConcatVirtual<TSpec> > const & operator-- (Iter<TStringSet, ConcatVirtual<TSpec> > & me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2220)
template <typename TStringSet, typename TSpec> inline Iter<TStringSet, ConcatVirtual<TSpec> > const & operator-- (Iter<TStringSet, ConcatVirtual<TSpec> > & me, int);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2227)
template <typename THost> inline Segment<THost, SuffixSegment> & operator--(Segment<THost, SuffixSegment> & segment);       	// "projects/library/seqan/sequence/segment_suffix.h"(488)
template <typename THost> inline Segment<THost, PrefixSegment> & operator--(Segment<THost, PrefixSegment> & segment);       	// "projects/library/seqan/sequence/segment_prefix.h"(491)

//____________________________________________________________________________
// operator-=

template <typename TContainer, typename THostspec, typename TIntegral> inline Iter<TContainer, Packed<THostspec> > & operator-= (Iter<TContainer, Packed<THostspec> > & left, TIntegral right);       	// "projects/library/seqan/sequence/string_packed.h"(1274)

//____________________________________________________________________________
// operator<

template <typename TLeftHost, typename TLeftSpec, typename TRight> inline bool operator< (Segment<TLeftHost, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/segment_base.h"(1240)
template <typename TContainer, typename THostspec> inline bool operator< (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1138)
template <typename TSSetL, typename TSpecL, typename TSSetR, typename TSpecR> inline bool operator< ( Iter<TSSetL, ConcatVirtual<TSpecL> > const &L, Iter<TSSetR, ConcatVirtual<TSpecR> > const &R);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2307)
template <typename TLeftValue, typename TLeftSpec, typename TRight> inline bool operator< (String<TLeftValue, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/string_base.h"(1726)
template <typename TLeftValue, typename TRightValue, typename TRightSpec > inline bool operator< (TLeftValue * left, String<TRightValue, TRightSpec> const & right);       	// "projects/library/seqan/sequence/string_base.h"(1734)

//____________________________________________________________________________
// operator<<

template <typename TStream, typename THost, typename TSpec> inline TStream & operator<< (TStream & target, Segment<THost, TSpec> const & source);       	// "projects/library/seqan/sequence/segment_base.h"(1286)
template <typename TStream, typename TValue, typename TSpec> inline TStream & operator<< (TStream & target, String<TValue, TSpec> const & source);       	// "projects/library/seqan/sequence/string_base.h"(1804)

//____________________________________________________________________________
// operator<=

template <typename TLeftHost, typename TLeftSpec, typename TRight> inline bool operator<= (Segment<TLeftHost, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/segment_base.h"(1251)
template <typename TContainer, typename THostspec> inline bool operator<= (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1151)
template <typename TLeftValue, typename TLeftSpec, typename TRight> inline bool operator<= (String<TLeftValue, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/string_base.h"(1745)
template <typename TLeftValue, typename TRightValue, typename TRightSpec > inline bool operator<= (TLeftValue * left, String<TRightValue, TRightSpec> const & right);       	// "projects/library/seqan/sequence/string_base.h"(1753)

//____________________________________________________________________________
// operator==

template <typename TLeftHost, typename TLeftSpec, typename TRight > inline bool operator== (Segment<TLeftHost, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/segment_base.h"(1216)
template <typename TContainer, typename THostspec> inline bool operator== (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1086)
template <typename TSSetL, typename TSpecL, typename TSSetR, typename TSpecR> inline bool operator== ( Iter<TSSetL, ConcatVirtual<TSpecL> > const &L, Iter<TSSetR, ConcatVirtual<TSpecR> > const &R);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2283)
template <typename TLeftValue, typename TLeftSpec, typename TRight > inline bool operator== (String<TLeftValue, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/string_base.h"(1684)
template <typename TLeftValue, typename TRightValue, typename TRightSpec > inline bool operator== (TLeftValue * left, String<TRightValue, TRightSpec> const & right);       	// "projects/library/seqan/sequence/string_base.h"(1693)

//____________________________________________________________________________
// operator>

template <typename TLeftHost, typename TLeftSpec, typename TRight> inline bool operator> (Segment<TLeftHost, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/segment_base.h"(1261)
template <typename TContainer, typename THostspec> inline bool operator> (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1112)
template <typename TSSetL, typename TSpecL, typename TSSetR, typename TSpecR> inline bool operator> ( Iter<TSSetL, ConcatVirtual<TSpecL> > const &L, Iter<TSSetR, ConcatVirtual<TSpecR> > const &R);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2317)
template <typename TLeftValue, typename TLeftSpec, typename TRight> inline bool operator> (String<TLeftValue, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/string_base.h"(1764)
template <typename TLeftValue, typename TRightValue, typename TRightSpec > inline bool operator> (TLeftValue * left, String<TRightValue, TRightSpec> const & right);       	// "projects/library/seqan/sequence/string_base.h"(1772)

//____________________________________________________________________________
// operator>=

template <typename TLeftHost, typename TLeftSpec, typename TRight> inline bool operator>= (Segment<TLeftHost, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/segment_base.h"(1272)
template <typename TContainer, typename THostspec> inline bool operator>= (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1125)
template <typename TLeftValue, typename TLeftSpec, typename TRight> inline bool operator>= (String<TLeftValue, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/string_base.h"(1783)
template <typename TLeftValue, typename TRightValue, typename TRightSpec > inline bool operator>= (TLeftValue * left, String<TRightValue, TRightSpec> const & right);       	// "projects/library/seqan/sequence/string_base.h"(1791)

//____________________________________________________________________________
// operator>>

template <typename TStream, typename THost, typename TSpec> inline TStream & operator>> (TStream & source, Segment<THost, TSpec> & target);       	// "projects/library/seqan/sequence/segment_base.h"(1298)
template <typename TStream, typename THost, typename TSpec> inline TStream & operator>> (TStream & source, Segment<THost, TSpec> const & target);       	// "projects/library/seqan/sequence/segment_base.h"(1307)
template <typename TStream, typename TValue, typename TSpec> inline TStream & operator>> (TStream & source, String<TValue, TSpec> & target);       	// "projects/library/seqan/sequence/string_base.h"(1816)

//____________________________________________________________________________
// ordValue

template <typename TValue> inline unsigned ordValue(TValue const &c);       	// "projects/library/seqan/sequence/lexical.h"(771)
template <typename TValue, typename TSpec> inline unsigned ordValue(SimpleType<TValue,TSpec> const &c);       	// "projects/library/seqan/sequence/lexical.h"(777)

//____________________________________________________________________________
// pop

template <typename TValue, unsigned int SPACE> inline void pop(String<TValue, Block<SPACE> >& me);       	// "projects/library/seqan/sequence/string_stack.h"(474)

//____________________________________________________________________________
// pop_back

template <typename TValue, unsigned int SPACE> inline void pop_back(String<TValue, Block<SPACE> >& me);       	// "projects/library/seqan/sequence/string_stack.h"(496)

//____________________________________________________________________________
// posAdd

template <typename TPos, typename TDelta> inline TPos posAdd(TPos pos, TDelta delta);       	// "projects/library/seqan/sequence/sequence_multiple.h"(547)
template <typename T1, typename T2, typename TCompression, typename TDelta> inline Pair<T1, T2, TCompression> posAdd(Pair<T1, T2, TCompression> const &pos, TDelta delta);       	// "projects/library/seqan/sequence/sequence_multiple.h"(553)

//____________________________________________________________________________
// posAtFirstLocal

template <typename TPos, typename TLimitsString> inline bool posAtFirstLocal(TPos pos, TLimitsString const &limits);       	// "projects/library/seqan/sequence/sequence_multiple.h"(513)
template <typename TPos> inline bool posAtFirstLocal(TPos pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(517)

//____________________________________________________________________________
// posCompare

template <typename TPos> inline int posCompare(TPos const &a, TPos const &b);       	// "projects/library/seqan/sequence/sequence_multiple.h"(589)
template <typename T1, typename T2, typename TCompression> inline int posCompare(Pair<T1, T2, TCompression> const &a, Pair<T1, T2, TCompression> const &b);       	// "projects/library/seqan/sequence/sequence_multiple.h"(596)

//____________________________________________________________________________
// posGlobalize

template <typename TPosition> inline TPosition posGlobalize(TPosition const &pos, Nothing const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(300)
template <typename T1, typename T2, typename TCompression> inline T2 posGlobalize(Pair<T1, T2, TCompression> const &pos, Nothing const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(306)
template <typename TLimitsString, typename TPosition> inline TPosition posGlobalize(TPosition const &pos, TLimitsString const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(312)
template <typename TLimitsString, typename T1, typename T2, typename TCompression> inline typename Value<TLimitsString>::Type posGlobalize(Pair<T1, T2, TCompression> const &pos, TLimitsString const &limits);       	// "projects/library/seqan/sequence/sequence_multiple.h"(319)

//____________________________________________________________________________
// posLess

template <typename TPos> inline bool posLess(TPos const &a, TPos const &b);       	// "projects/library/seqan/sequence/sequence_multiple.h"(577)
template <typename T1, typename T2, typename TCompression> inline bool posLess(Pair<T1, T2, TCompression> const &a, Pair<T1, T2, TCompression> const &b);       	// "projects/library/seqan/sequence/sequence_multiple.h"(582)

//____________________________________________________________________________
// posLocalize

template <typename TResult, typename TPosition> inline void posLocalize(TResult &result, TPosition const &pos, Nothing const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(343)
template <typename T1, typename T2, typename TCompression, typename TPosition> inline void posLocalize(Pair<T1, T2, TCompression> &result, TPosition const &pos, Nothing const &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(348)
template <typename TResult, typename TSize, typename TSpec, typename TPosition> inline void posLocalize(TResult &result, TPosition const &pos, String<TSize, TSpec> const &limits);       	// "projects/library/seqan/sequence/sequence_multiple.h"(355)
template <typename TResult, typename TSize, typename TSpec, typename T1, typename T2, typename TCompression> inline void posLocalize(TResult &result, Pair<T1, T2, TCompression> const &pos, String<TSize, TSpec> const & );       	// "projects/library/seqan/sequence/sequence_multiple.h"(365)

//____________________________________________________________________________
// posNext

template <typename TPos> inline TPos posNext(TPos pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(535)
template <typename T1, typename T2, typename TCompression> inline Pair<T1, T2, TCompression> posNext(Pair<T1, T2, TCompression> const &pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(541)

//____________________________________________________________________________
// posPrev

template <typename TPos> inline TPos posPrev(TPos pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(524)
template <typename T1, typename T2, typename TCompression> inline Pair<T1, T2, TCompression> posPrev(Pair<T1, T2, TCompression> const &pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(529)

//____________________________________________________________________________
// posSub

template <typename TA, typename TB> inline TA posSub(TA a, TB b);       	// "projects/library/seqan/sequence/sequence_multiple.h"(559)
template <typename TA1, typename TA2, typename TACompression, typename TB1, typename TB2, typename TBCompression > inline TA2 posSub(Pair<TA1, TA2, TACompression> const &a, Pair<TB1, TB2, TBCompression> const &b);       	// "projects/library/seqan/sequence/sequence_multiple.h"(568)

//____________________________________________________________________________
// position

template <typename TContainer, typename THostspec> inline typename Position<Iter<TContainer, Packed<THostspec> > const>::Type position(Iter<TContainer, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(920)

//____________________________________________________________________________
// positionToId

template <typename TString, typename TSpec, typename TPos> inline typename Id<StringSet<TString, Owner<TSpec> > >::Type positionToId(StringSet<TString, Owner<TSpec> >&, TPos const pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1617)
template <typename TString, typename TSpec, typename TPos> inline typename Id<StringSet<TString, Owner<TSpec> > >::Type positionToId(StringSet<TString, Owner<TSpec> > const&, TPos const pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1626)
template <typename TString, typename TPos> inline typename Id<StringSet<TString, Dependent<Generous> > >::Type positionToId(StringSet<TString, Dependent<Generous> >& me, TPos const pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1636)
template <typename TString, typename TPos> inline typename Id<StringSet<TString, Dependent<Generous> > >::Type positionToId(StringSet<TString, Dependent<Generous> > const& me, TPos const pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1645)
template <typename TString, typename TPos> inline typename Id<StringSet<TString, Dependent<Tight> > >::Type positionToId(StringSet<TString, Dependent<Tight> >&me, TPos const pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1654)
template <typename TString, typename TPos> inline typename Id<StringSet<TString, Dependent<Tight> > >::Type positionToId(StringSet<TString, Dependent<Tight> > const&me, TPos const pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1663)

//____________________________________________________________________________
// prefix

template <typename TString, typename TSpec, typename TPosition > inline typename Prefix<TString>::Type prefix(StringSet< TString, TSpec > &me, TPosition pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(376)
template <typename TString, typename TSpec, typename TPosition > inline typename Prefix<TString const>::Type prefix(StringSet< TString, TSpec > const &me, TPosition pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(390)
template <typename TString, typename TDelimiter, typename TPosition > inline typename Infix<TString>::Type prefix(StringSet< TString, Owner<ConcatDirect<TDelimiter> > > &me, TPosition pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(404)
template <typename TString, typename TDelimiter, typename TPosition > inline typename Infix<TString const>::Type prefix(StringSet< TString, Owner<ConcatDirect<TDelimiter> > > const &me, TPosition pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(411)
template <typename T, typename TPosEnd> inline typename Prefix<T>::Type prefix(T & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(520)
template <typename T, typename TPosEnd> inline typename Prefix<T const>::Type prefix(T const & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(527)
template <typename T, typename TPosEnd> inline typename Prefix<T *>::Type prefix(T * t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(535)
template <typename T, typename TPosEnd> inline typename Prefix<Segment<T, PrefixSegment> >::Type prefix(Segment<T, PrefixSegment> & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(545)
template <typename T, typename TPosEnd> inline typename Prefix<Segment<T, PrefixSegment> const>::Type prefix(Segment<T, PrefixSegment> const & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(554)
template <typename T, typename TPosEnd> inline typename Prefix<Segment<T, InfixSegment> >::Type prefix(Segment<T, InfixSegment> & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(566)
template <typename T, typename TPosEnd> inline typename Prefix<Segment<T, InfixSegment> const>::Type prefix(Segment<T, InfixSegment> const & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(576)
template <typename T, typename TPosEnd> inline typename Prefix<Segment<T, SuffixSegment> >::Type prefix(Segment<T, SuffixSegment> & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(590)
template <typename T, typename TPosEnd> inline typename Prefix<Segment<T, SuffixSegment> const>::Type prefix(Segment<T, SuffixSegment> const & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(600)

//____________________________________________________________________________
// push

template <typename TValue, unsigned int SPACE, typename TVal> inline void push( String<TValue, Block<SPACE> >& me, TVal const& source);       	// "projects/library/seqan/sequence/string_stack.h"(403)
template <typename TValue, unsigned int SPACE> inline void push(String<TValue, Block<SPACE> >& me);       	// "projects/library/seqan/sequence/string_stack.h"(410)

//____________________________________________________________________________
// push_back

template <typename TValue, unsigned int SPACE, typename TVal> inline void push_back( String<TValue, Block<SPACE> >& me, TVal const& source);       	// "projects/library/seqan/sequence/string_stack.h"(429)

//____________________________________________________________________________
// removeValueById

template <typename TString, typename TSpec, typename TId> inline void removeValueById(StringSet<TString, Owner<TSpec> >& me, TId const id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1551)
template <typename TString, typename TId> inline void removeValueById(StringSet<TString, Dependent<Generous> >& me, TId const id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1561)
template <typename TString, typename TId> inline void removeValueById(StringSet<TString, Dependent<Tight> >& me, TId const id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1575)

//____________________________________________________________________________
// replace

template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> & target, typename Position< Segment<THost, TSpec> >::Type pos_begin, typename Position< Segment<THost, TSpec> >::Type pos_end, TSource & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(1006)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> & target, typename Position< Segment<THost, TSpec> >::Type pos_begin, typename Position< Segment<THost, TSpec> >::Type pos_end, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(1018)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> & target, typename Position< Segment<THost, TSpec> >::Type pos_begin, typename Position< Segment<THost, TSpec> >::Type pos_end, TSource & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(1032)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> & target, typename Position< Segment<THost, TSpec> >::Type pos_begin, typename Position< Segment<THost, TSpec> >::Type pos_end, TSource const & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(1045)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> const & target, typename Position< Segment<THost, TSpec> const>::Type pos_begin, typename Position< Segment<THost, TSpec> const>::Type pos_end, TSource & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(1058)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> const & target, typename Position< Segment<THost, TSpec> const>::Type pos_begin, typename Position< Segment<THost, TSpec> const>::Type pos_end, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(1070)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> const & target, typename Position< Segment<THost, TSpec> const>::Type pos_begin, typename Position< Segment<THost, TSpec> const>::Type pos_end, TSource & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const );       	// "projects/library/seqan/sequence/segment_base.h"(1084)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> const & target, typename Position< Segment<THost, TSpec> const>::Type pos_begin, typename Position< Segment<THost, TSpec> const>::Type pos_end, TSource const & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(1097)
template <typename TTargetValue, typename TTargetSpec, typename TSource, typename TExpand> inline void replace(String<TTargetValue, TTargetSpec> & target, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_begin, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_end, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1247)
template <typename TTargetValue, typename TTargetSpec, typename TSource, typename TExpand> inline void replace(String<TTargetValue, TTargetSpec> & target, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_begin, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_end, TSource const & source, typename Size< String<TTargetValue, TTargetSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1261)
template <typename TTargetValue, typename TTargetSpec, typename TSourceValue, typename TExpand> inline void replace(String<TTargetValue, TTargetSpec> & target, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_begin, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_end, TSourceValue const * source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1277)
template <typename TTargetValue, typename TTargetSpec, typename TSourceValue, typename TExpand> inline void replace(String<TTargetValue, TTargetSpec> & target, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_begin, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_end, TSourceValue const * source, typename Size< String<TTargetValue, TTargetSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1291)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1196)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget const & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1205)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource const & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1214)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget const & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource const & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1223)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1236)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget const & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1246)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource const & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1256)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget const & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource const & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1266)
template <typename TTargetValue, typename TSource, typename TExpand> inline void replace(TTargetValue * target, size_t pos_begin, size_t pos_end, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(598)
template <typename TTargetValue, typename TSource, typename TExpand> inline void replace(TTargetValue * target, size_t pos_begin, size_t pos_end, TSource const & source, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(611)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void replace(TTargetValue * target, size_t pos_begin, size_t pos_end, TSourceValue const * source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(625)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void replace(TTargetValue * target, size_t pos_begin, size_t pos_end, TSourceValue const * source, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_pointer.h"(638)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void replace(::std::basic_string<TChar, TCharTraits, TAlloc> & target, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_begin, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_end, TSource const & source, Generous);       	// "projects/library/seqan/sequence/std_string.h"(520)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void replace(::std::basic_string<TChar, TCharTraits, TAlloc> & target, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_begin, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_end, TSource const & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Generous);       	// "projects/library/seqan/sequence/std_string.h"(533)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void replace(::std::basic_string<TChar, TCharTraits, TAlloc> & target, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_begin, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_end, TSource const & source, Limit);       	// "projects/library/seqan/sequence/std_string.h"(569)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void replace(::std::basic_string<TChar, TCharTraits, TAlloc> & target, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_begin, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_end, TSource const & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Limit);       	// "projects/library/seqan/sequence/std_string.h"(582)

//____________________________________________________________________________
// reserve

template <typename TValue, typename THost, typename TMap, typename TSpec, typename TSize, typename TExpand> inline TSize reserve(String< TValue, ValueExpand<THost, TMap, TSpec> > & me, TSize new_length, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_value_expand.h"(389)
template <typename TValue, typename TSpec, typename _TSize, typename TExpand> inline typename Size< String<TValue, Packed<TSpec> > >::Type reserve( String<TValue, Packed<TSpec> > & seq, _TSize new_capacity, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_packed.h"(743)
template <typename TValue, unsigned int SPACE, typename TSize, typename TExpand> inline typename Size< String<TValue, Block<SPACE> > >::Type reserve(String<TValue, Block<SPACE> > & me, TSize new_capacity, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_stack.h"(356)
template <typename TValue, typename TSpec, typename _TSize, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type reserve( String<TValue, TSpec> & seq, _TSize new_capacity, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_base.h"(1521)
template <typename T, typename TSize, typename TExpand> inline typename Size<T>::Type reserve( T & me, TSize new_capacity, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/sequence_interface.h"(1321)
template <typename T, typename TSize> inline typename Size<T>::Type reserve( T & me, TSize new_capacity);       	// "projects/library/seqan/sequence/sequence_interface.h"(1331)
template <typename TValue, unsigned int ISize, typename TExpand> inline size_t reserve( String<TValue, Array<ISize> > & me, size_t, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_array.h"(187)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSize, typename TExpand> inline typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type reserve( ::std::basic_string<TChar, TCharTraits, TAlloc> & seq, TSize new_capacity, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/std_string.h"(630)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSize> inline typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type reserve( ::std::basic_string<TChar, TCharTraits, TAlloc> & seq, TSize new_capacity, Insist);       	// "projects/library/seqan/sequence/std_string.h"(642)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSize> inline typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type reserve( ::std::basic_string<TChar, TCharTraits, TAlloc> & seq, TSize new_capacity, Limit);       	// "projects/library/seqan/sequence/std_string.h"(654)

//____________________________________________________________________________
// resize

template <typename TValue, typename THost, typename TMap, typename TSpec, typename TSize> inline TSize resize(String< TValue, ValueExpand<THost, TMap, TSpec> > & me, TSize new_length);       	// "projects/library/seqan/sequence/string_value_expand.h"(377)
template <typename THost, typename TSpec, typename TExpand> inline typename Size< Segment<THost, TSpec> >::Type resize( Segment<THost, TSpec> & me, typename Size< Segment<THost, TSpec> >::Type new_length, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/segment_base.h"(1166)
template <typename TValue, unsigned int SPACE, typename TSize2, typename TExpand> inline typename Size< String<TValue, Block<SPACE> > >::Type resize(String<TValue, Block<SPACE> > & me, TSize2 new_length, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_stack.h"(308)
template <typename TValue, unsigned int SPACE, typename TSize2> inline typename Size< String<TValue, Block<SPACE> > >::Type resize(String<TValue, Block<SPACE> > & me, TSize2 new_length, Limit);       	// "projects/library/seqan/sequence/string_stack.h"(329)
template <typename TString, typename TSpec, typename TSize, typename TExpand > inline typename Size< StringSet< TString, TSpec > >::Type resize(StringSet< TString, TSpec > &me, TSize new_size, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1184)
template <typename TString, typename TSpec, typename TSize, typename TExpand > inline typename Size< StringSet< TString, Owner<ConcatDirect<TSpec> > > >::Type resize(StringSet< TString, Owner<ConcatDirect<TSpec> > > &me, TSize new_size, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1193)
template <typename TValue, typename TSpec, typename TSize, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type resize( String<TValue, TSpec> & me, TSize new_length, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1576)
template <typename T, typename TSize> inline typename Size<T>::Type resize( T & me, TSize new_length);       	// "projects/library/seqan/sequence/sequence_interface.h"(1366)
template <typename TValue, typename TExpand> inline size_t resize( TValue * me, size_t new_length, Tag<TExpand> const &);       	// "projects/library/seqan/sequence/string_pointer.h"(677)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSize, typename TExpand> inline typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type resize( ::std::basic_string<TChar, TCharTraits, TAlloc> & me, TSize new_length, Tag<TExpand> const &);       	// "projects/library/seqan/sequence/std_string.h"(670)

//____________________________________________________________________________
// resizeSpace

template <typename TValue, typename TSpec, typename TPosition, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type resizeSpace(String<TValue, TSpec> & me, typename Size< String<TValue, TSpec> >::Type size, TPosition pos_begin, TPosition pos_end, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_base.h"(685)
template <typename TValue, typename TSpec, typename TPosition, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type resizeSpace(String<TValue, TSpec> & me, typename Size< String<TValue, TSpec> >::Type size, TPosition pos_begin, TPosition pos_end, typename Size< String<TValue, TSpec> >::Type limit, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_base.h"(700)
template <typename T, typename TSize, typename TPosition> inline TSize resizeSpace(T & me, TSize size, TPosition pos_begin, TPosition pos_end);       	// "projects/library/seqan/sequence/sequence_interface.h"(1401)
template <typename T, typename TSize, typename TPosition> inline TSize resizeSpace(T & me, TSize size, TPosition pos_begin, TPosition pos_end, TSize limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1413)

//____________________________________________________________________________
// sequenceLength

template <typename TSeqNo, typename TString> inline typename Size<TString>::Type sequenceLength(TSeqNo , TString const &string);       	// "projects/library/seqan/sequence/sequence_multiple.h"(634)
template <typename TSeqNo, typename TString, typename TSpec> inline typename Size<StringSet<TString, TSpec> >::Type sequenceLength(TSeqNo seqNo, StringSet<TString, TSpec> const &stringSet);       	// "projects/library/seqan/sequence/sequence_multiple.h"(640)

//____________________________________________________________________________
// set

template <typename THost, typename TPosition1, typename TPosition2> inline void set(Segment<THost, InfixSegment> & me, THost & host_, TPosition1 begin_, TPosition2 end_);       	// "projects/library/seqan/sequence/segment_infix.h"(459)
template <typename THost> inline void set(Segment<THost, InfixSegment> & me, THost & host_);       	// "projects/library/seqan/sequence/segment_infix.h"(471)
template <typename THost> inline void set(Segment<THost, InfixSegment> & me, THost const & host_);       	// "projects/library/seqan/sequence/segment_infix.h"(481)
template <typename THost, typename TSpec> inline void set(Segment<THost, InfixSegment> & me, Segment<THost, TSpec> & source);       	// "projects/library/seqan/sequence/segment_infix.h"(494)
template <typename THost, typename TSpec> inline void set(Segment<THost, InfixSegment> & me, Segment<THost, TSpec> const & source);       	// "projects/library/seqan/sequence/segment_infix.h"(504)
template <typename THost, typename TPosition> inline void set(Segment<THost, SuffixSegment> & me, THost & host_, TPosition begin_);       	// "projects/library/seqan/sequence/segment_suffix.h"(378)
template <typename THost> inline void set(Segment<THost, SuffixSegment> & me, THost & host_);       	// "projects/library/seqan/sequence/segment_suffix.h"(389)
template <typename THost, typename TSpec> inline void set(Segment<THost, SuffixSegment> & me, Segment<THost, TSpec> & source);       	// "projects/library/seqan/sequence/segment_suffix.h"(401)
template <typename THost, typename TSpec> inline void set(Segment<THost, SuffixSegment> & me, Segment<THost, TSpec> const & source);       	// "projects/library/seqan/sequence/segment_suffix.h"(411)
template <typename THost, typename TPosition> inline void set(Segment<THost, PrefixSegment> & me, THost & host_, TPosition end_);       	// "projects/library/seqan/sequence/segment_prefix.h"(381)
template <typename THost> inline void set(Segment<THost, PrefixSegment> & me, THost & host_);       	// "projects/library/seqan/sequence/segment_prefix.h"(392)
template <typename THost, typename TSpec> inline void set(Segment<THost, PrefixSegment> & me, Segment<THost, TSpec> & source);       	// "projects/library/seqan/sequence/segment_prefix.h"(404)
template <typename THost, typename TSpec> inline void set(Segment<THost, PrefixSegment> & me, Segment<THost, TSpec> const & source);       	// "projects/library/seqan/sequence/segment_prefix.h"(414)

//____________________________________________________________________________
// setBegin

template <typename THost_, typename TIterator> inline void setBegin(Segment<THost_, InfixSegment> & me, TIterator new_begin);       	// "projects/library/seqan/sequence/segment_infix.h"(263)
template <typename TIterator> inline void setBegin(TIterator new_begin);       	// "projects/library/seqan/sequence/segment_infix.h"(783)
template <typename THost_, typename TIterator> inline void setBegin(Segment<THost_, SuffixSegment> & me, TIterator new_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(253)
template <typename THost_> inline void setBegin(typename Iterator<Segment<THost_, SuffixSegment>, Rooted>::Type new_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(261)
template <typename THost_, typename TIterator> inline void setBegin(Segment<THost_, PrefixSegment> &, TIterator);       	// "projects/library/seqan/sequence/segment_prefix.h"(253)

//____________________________________________________________________________
// setBeginPosition

template <typename THost_, typename TPosition> inline void setBeginPosition(Segment<THost_, InfixSegment> & me, TPosition new_begin);       	// "projects/library/seqan/sequence/segment_infix.h"(289)
template <typename THost_, typename TPosition> inline void setBeginPosition(Segment<THost_, SuffixSegment> & me, TPosition new_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(271)

//____________________________________________________________________________
// setContainer

template <typename TContainer, typename THostspec, typename TContainer2> inline void setContainer(Iter<TContainer, Packed<THostspec> > & me, TContainer2 container_);       	// "projects/library/seqan/sequence/string_packed.h"(871)

//____________________________________________________________________________
// setEnd

template <typename THost_, typename TIterator> inline void setEnd(Segment<THost_, InfixSegment> & me, TIterator new_end);       	// "projects/library/seqan/sequence/segment_infix.h"(354)
template <typename TIterator> inline void setEnd(TIterator new_end);       	// "projects/library/seqan/sequence/segment_infix.h"(795)
template <typename TIterator, typename THost_> inline void setEnd(Segment<THost_, SuffixSegment> &, TIterator);       	// "projects/library/seqan/sequence/segment_suffix.h"(319)
template <typename THost_, typename TIterator> inline void setEnd(Segment<THost_, PrefixSegment> & me, TIterator new_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(289)
template <typename THost_> inline void setEnd(typename Iterator<Segment<THost_, PrefixSegment>, Rooted>::Type new_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(297)

//____________________________________________________________________________
// setEndPosition

template <typename THost_, typename TPosition> inline void setEndPosition(Segment<THost_, InfixSegment> & me, TPosition new_end);       	// "projects/library/seqan/sequence/segment_infix.h"(381)
template <typename THost_, typename TPosition> inline void setEndPosition(Segment<THost_, PrefixSegment> & me, TPosition new_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(281)

//____________________________________________________________________________
// setHost

template <typename THost_> inline void setHost(Segment<THost_, InfixSegment> & me, typename _Parameter<THost_>::Type _host);       	// "projects/library/seqan/sequence/segment_infix.h"(418)
template <typename THost_> inline void setHost(Segment<THost_, SuffixSegment> & me, typename _Parameter<THost_>::Type _host);       	// "projects/library/seqan/sequence/segment_suffix.h"(207)
template <typename THost_> inline void setHost(Segment<THost_, PrefixSegment> & me, typename _Parameter<THost_>::Type _host);       	// "projects/library/seqan/sequence/segment_prefix.h"(207)

//____________________________________________________________________________
// setPosition

template <typename TContainer, typename THostspec, typename TPosition> inline void setPosition(Iter<TContainer, Packed<THostspec> > & me, TPosition pos_);       	// "projects/library/seqan/sequence/string_packed.h"(935)

//____________________________________________________________________________
// shareResources

template <typename TValue, typename TSpec> inline bool shareResources(String<TValue, TSpec> const & obj1, TValue const & obj2);       	// "projects/library/seqan/sequence/string_base.h"(132)
template <typename TValue, typename TSpec> inline bool shareResources(TValue const & obj1, String<TValue, TSpec> const & obj2);       	// "projects/library/seqan/sequence/string_base.h"(141)
template <typename T1, typename T2> inline bool shareResources(T1 const & obj1, T2 const & obj2);       	// "projects/library/seqan/sequence/sequence_interface.h"(230)

//____________________________________________________________________________
// shrinkToFit

template <typename T, typename TSize, typename TValue> inline void shrinkToFit(T & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(1516)

//____________________________________________________________________________
// stringSetLimits

template <typename TStringSet> inline typename StringSetLimits<TStringSet>::Type stringSetLimits(TStringSet &);       	// "projects/library/seqan/sequence/sequence_multiple.h"(157)
template <typename TString, typename TSpec> inline typename StringSetLimits< StringSet<TString, TSpec> >::Type & stringSetLimits(StringSet<TString, TSpec> &stringSet);       	// "projects/library/seqan/sequence/sequence_multiple.h"(163)
template <typename TString, typename TSpec> inline typename StringSetLimits< StringSet<TString, TSpec> const>::Type & stringSetLimits(StringSet<TString, TSpec> const &stringSet);       	// "projects/library/seqan/sequence/sequence_multiple.h"(171)

//____________________________________________________________________________
// suffix

template <typename TString, typename TSpec, typename TPosition > inline typename Suffix<TString>::Type suffix(StringSet< TString, TSpec > &me, TPosition pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(422)
template <typename TString, typename TSpec, typename TPosition > inline typename Suffix<TString const>::Type suffix(StringSet< TString, TSpec > const &me, TPosition pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(436)
template <typename TString, typename TDelimiter, typename TPosition > inline typename Infix<TString>::Type suffix(StringSet< TString, Owner<ConcatDirect<TDelimiter> > > &me, TPosition pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(450)
template <typename TString, typename TDelimiter, typename TPosition > inline typename Infix<TString const>::Type suffix(StringSet< TString, Owner<ConcatDirect<TDelimiter> > > const &me, TPosition pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(457)
template <typename T, typename TPosBegin> inline typename Suffix<T>::Type suffix(T & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(516)
template <typename T, typename TPosBegin> inline typename Suffix<T const>::Type suffix(T const & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(523)
template <typename T, typename TPosBegin> inline typename Suffix<T *>::Type suffix(T * t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(531)
template <typename T, typename TPosBegin> inline typename Suffix<Segment<T, PrefixSegment> >::Type suffix(Segment<T, PrefixSegment> & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(541)
template <typename T, typename TPosBegin> inline typename Suffix<Segment<T, PrefixSegment> const>::Type suffix(Segment<T, PrefixSegment> const & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(551)
template <typename T, typename TPosBegin> inline typename Suffix<Segment<T, InfixSegment> >::Type suffix(Segment<T, InfixSegment> & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(564)
template <typename T, typename TPosBegin> inline typename Suffix<Segment<T, InfixSegment> const>::Type suffix(Segment<T, InfixSegment> const & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(574)
template <typename T, typename TPosBegin> inline typename Suffix<Segment<T, SuffixSegment> >::Type suffix(Segment<T, SuffixSegment> & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(588)
template <typename T, typename TPosBegin> inline typename Suffix<Segment<T, SuffixSegment> const>::Type suffix(Segment<T, SuffixSegment> const & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(597)

//____________________________________________________________________________
// suffixLength

template <typename TPos, typename TString> inline typename Size<TString>::Type suffixLength(TPos pos, TString const &string);       	// "projects/library/seqan/sequence/sequence_multiple.h"(606)
template <typename TPos, typename TString, typename TSpec> inline typename Size<TString>::Type suffixLength(TPos pos, StringSet<TString, TSpec> const &stringSet);       	// "projects/library/seqan/sequence/sequence_multiple.h"(612)

//____________________________________________________________________________
// toCString

template <typename TValue> inline TValue * toCString(TValue * me);       	// "projects/library/seqan/sequence/string_cstyle.h"(811)
template <typename TValue> inline TValue const * toCString(TValue const * me);       	// "projects/library/seqan/sequence/string_cstyle.h"(819)
template <typename TValue> inline TValue * toCString(String<TValue, CStyle> & me);       	// "projects/library/seqan/sequence/string_cstyle.h"(827)
template <typename TValue> inline TValue const * toCString(String<TValue, CStyle> const & me);       	// "projects/library/seqan/sequence/string_cstyle.h"(835)
template <typename T> inline typename Value<T>::Type * toCString(T & me);       	// "projects/library/seqan/sequence/string_cstyle.h"(843)
template <typename T> inline typename Value<T>::Type * toCString(T const & me);       	// "projects/library/seqan/sequence/string_cstyle.h"(857)

//____________________________________________________________________________
// top

template <typename TValue, unsigned int SPACE> inline TValue & top(String<TValue, Block<SPACE> > & me);       	// "projects/library/seqan/sequence/string_stack.h"(436)
template <typename TValue, unsigned int SPACE> inline TValue const & top(String<TValue, Block<SPACE> > const& me);       	// "projects/library/seqan/sequence/string_stack.h"(444)

//____________________________________________________________________________
// topPrev

template <typename TValue, unsigned int SPACE> inline TValue & topPrev(String<TValue, Block<SPACE> > & me);       	// "projects/library/seqan/sequence/string_stack.h"(452)
template <typename TValue, unsigned int SPACE> inline TValue const & topPrev(String<TValue, Block<SPACE> > const& me);       	// "projects/library/seqan/sequence/string_stack.h"(463)

//____________________________________________________________________________
// value

template <typename TValue, typename THost, typename TMap, typename TSpec, typename TPos> inline typename Reference<String< TValue, ValueExpand<THost, TMap, TSpec> > >::Type value(String< TValue, ValueExpand<THost, TMap, TSpec> > & me, TPos pos);       	// "projects/library/seqan/sequence/string_value_expand.h"(336)
template <typename TValue, typename THost, typename TMap, typename TSpec, typename TPos> inline typename Reference<String< TValue, ValueExpand<THost, TMap, TSpec> > const>::Type value(String< TValue, ValueExpand<THost, TMap, TSpec> > const & me, TPos pos);       	// "projects/library/seqan/sequence/string_value_expand.h"(345)
template <typename TContainer, typename TIterator> inline typename Reference<Iter<TContainer, AdaptorIterator<TIterator, ValueExpandIter> > >::Type value(Iter<TContainer, AdaptorIterator<TIterator, ValueExpandIter> > & me);       	// "projects/library/seqan/sequence/string_value_expand.h"(438)
template <typename TContainer, typename TIterator> inline typename Reference<Iter<TContainer, AdaptorIterator<TIterator, ValueExpandIter> > >::Type value(Iter<TContainer, AdaptorIterator<TIterator, ValueExpandIter> > const & me);       	// "projects/library/seqan/sequence/string_value_expand.h"(446)
template <typename THost, typename TSpec, typename TPos> inline typename Reference< Segment<THost, TSpec> >::Type value(Segment<THost, TSpec> & me, TPos pos);       	// "projects/library/seqan/sequence/segment_infix.h"(645)
template <typename THost, typename TSpec, typename TPos> inline typename Reference< Segment<THost, TSpec> const >::Type value(Segment<THost, TSpec> const & me, TPos pos);       	// "projects/library/seqan/sequence/segment_infix.h"(654)
template <typename TValue, typename THostspec, typename TPos> inline typename Reference<String<TValue, Packed<THostspec> > >::Type value(String<TValue, Packed<THostspec> > & me, TPos pos);       	// "projects/library/seqan/sequence/string_packed.h"(490)
template <typename TValue, typename THostspec, typename TPos> inline typename Reference<String<TValue, Packed<THostspec> > const>::Type value(String<TValue, Packed<THostspec> > const & me, TPos pos);       	// "projects/library/seqan/sequence/string_packed.h"(499)
template <typename TContainer, typename THostspec> inline typename Reference<Iter<TContainer, Packed<THostspec> > >::Type value(Iter<TContainer, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(948)
template <typename TContainer, typename THostspec> inline typename Reference<Iter<TContainer, Packed<THostspec> > const>::Type value(Iter<TContainer, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(955)
template <typename TValue, unsigned int SPACE, typename TPos> inline typename Reference<String<TValue, Block<SPACE> > >::Type value( String<TValue, Block<SPACE> >& stack, TPos const pos);       	// "projects/library/seqan/sequence/string_stack.h"(240)
template <typename TValue, unsigned int SPACE, typename TPos> inline typename Reference<String<TValue, Block<SPACE> > >::Type value( String<TValue, Block<SPACE> > const& stack, TPos const pos);       	// "projects/library/seqan/sequence/string_stack.h"(250)
template <typename TString, typename TPos > inline typename Reference< StringSet< TString, Owner<Default> > >::Type value(StringSet< TString, Owner<Default> > & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1270)
template <typename TString, typename TPos > inline typename Reference< StringSet< TString, Owner<Default> > const >::Type value(StringSet< TString, Owner<Default> > const & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1277)
template <typename TString, typename TSpec, typename TPos > inline typename Infix<TString>::Type value(StringSet< TString, Owner<ConcatDirect<TSpec> > > & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1285)
template <typename TString, typename TSpec, typename TPos > inline typename Infix<TString const>::Type value(StringSet< TString, Owner<ConcatDirect<TSpec> > > const & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1292)
template <typename TString, typename TPos > inline typename Reference<StringSet< TString, Dependent<Tight> > >::Type value(StringSet< TString, Dependent<Tight> >& me, TPos pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1300)
template <typename TString, typename TPos > inline typename Reference<StringSet< TString, Dependent<Tight> > const >::Type value(StringSet< TString, Dependent<Tight> >const & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1308)
template <typename TString, typename TPos > inline typename Reference<StringSet< TString, Dependent<Generous> > >::Type value(StringSet< TString, Dependent<Generous> >& me, TPos pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1316)
template <typename TString, typename TPos > inline typename Reference< StringSet< TString, Dependent<Generous> > const >::Type value(StringSet< TString, Dependent<Generous> > const & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1328)
template <typename TStringSet, typename TPos > inline typename Reference< ConcatenatorNto1<TStringSet> >::Type value(ConcatenatorNto1<TStringSet> &me, TPos globalPos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1864)
template <typename TStringSet, typename TPos > inline typename Reference< ConcatenatorNto1<TStringSet> const >::Type value(ConcatenatorNto1<TStringSet> const &me, TPos globalPos);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1873)
template <typename TStringSet, typename TSpec> inline typename Reference< Iter< TStringSet, ConcatVirtual<TSpec> > const>::Type value(Iter<TStringSet, ConcatVirtual<TSpec> > const & me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2159)
template <typename TStringSet, typename TSpec> inline typename Reference< Iter< TStringSet, ConcatVirtual<TSpec> > >::Type value(Iter<TStringSet, ConcatVirtual<TSpec> > & me);       	// "projects/library/seqan/sequence/sequence_multiple.h"(2165)
template <typename TValue, typename TSpec, typename TPos> inline typename Reference< String<TValue, TSpec> >::Type value(String<TValue, TSpec> & me, TPos pos);       	// "projects/library/seqan/sequence/string_base.h"(158)
template <typename TValue, typename TSpec, typename TPos> inline typename Reference< String<TValue, TSpec> const >::Type value(String<TValue, TSpec> const & me, TPos pos);       	// "projects/library/seqan/sequence/string_base.h"(167)
template <typename T, typename TPos> inline typename Reference<T>::Type value(T & me, TPos );       	// "projects/library/seqan/sequence/sequence_interface.h"(568)
template <typename T, typename TPos> inline typename Reference<T const>::Type value(T const & me, TPos );       	// "projects/library/seqan/sequence/sequence_interface.h"(576)
template <typename TValue, typename TPos> inline TValue & value(TValue * me, TPos pos);       	// "projects/library/seqan/sequence/string_pointer.h"(243)
template <typename TValue, typename TPos> inline TValue const & value(TValue const * me, TPos pos);       	// "projects/library/seqan/sequence/string_pointer.h"(252)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TPos> inline typename GetValue< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type value(::std::basic_string<TChar, TCharTraits, TAlloc> & me, TPos pos);       	// "projects/library/seqan/sequence/std_string.h"(201)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TPos> inline typename GetValue< ::std::basic_string<TChar, TCharTraits, TAlloc> const>::Type value(::std::basic_string<TChar, TCharTraits, TAlloc> const & me, TPos pos);       	// "projects/library/seqan/sequence/std_string.h"(209)

//____________________________________________________________________________
// valueById

template <typename TString, typename TSpec, typename TId> inline typename Reference<StringSet<TString, TSpec> >::Type valueById(StringSet<TString, TSpec>& me, TId const id);       	// "projects/library/seqan/sequence/sequence_multiple.h"(1408)

//____________________________________________________________________________
// valueConstruct

template <typename TContainer, typename THostspec> inline void valueConstruct(Iter<TContainer, Packed<THostspec> > const & );       	// "projects/library/seqan/sequence/string_packed.h"(1050)
template <typename TContainer, typename THostspec, typename TParam> inline void valueConstruct(Iter<TContainer, Packed<THostspec> > const & it, TParam const & param_);       	// "projects/library/seqan/sequence/string_packed.h"(1056)
template <typename TContainer, typename THostspec, typename TParam> inline void valueConstruct(Iter<TContainer, Packed<THostspec> > const & it, TParam const & param_, Move tag);       	// "projects/library/seqan/sequence/string_packed.h"(1064)

//____________________________________________________________________________
// valueDestruct

template <typename TContainer, typename THostspec> inline void valueDestruct(Iter<TContainer, Packed<THostspec> > const & );       	// "projects/library/seqan/sequence/string_packed.h"(1075)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

