#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: mason_materializer
class: CommandLineTool
cwlVersion: v1.0
doc: "Apply variants from IN.vcf to IN.fa and write the results to out.fa.\n\n\n\n\
  For more information, visit http://www.seqan.de"
inputs:
- default: 'false'
  doc: Low verbosity.
  id: param_quiet
  inputBinding:
    prefix: -quiet
  label: Low verbosity.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Higher verbosity.
  id: param_verbose
  inputBinding:
    prefix: -verbose
  label: Higher verbosity.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Highest verbosity.
  id: param_very-verbose
  inputBinding:
    prefix: -very-verbose
  label: Highest verbosity.
  type:
  - 'null'
  - string
- default: '0'
  doc: Seed for random number generation.
  id: param_seed
  inputBinding:
    prefix: -seed
  label: Seed for random number generation.
  type:
  - 'null'
  - int
- default: '0'
  doc: Seed for methylation simulation random number generation.
  id: param_meth-seed
  inputBinding:
    prefix: -meth-seed
  label: Seed for methylation simulation random number generation.
  type:
  - 'null'
  - int
- doc: Filename for out output file
  id: param_out_filename
  inputBinding:
    prefix: -out
  label: Filename for out output file
  type: string
- doc: Filename for out-breakpoints output file
  id: param_out-breakpoints_filename
  inputBinding:
    prefix: -out-breakpoints
  label: Filename for out-breakpoints output file
  type:
  - 'null'
  - string
- default: /
  doc: String separating contig name from haplotype number.
  id: param_haplotype-name-sep
  inputBinding:
    prefix: -haplotype-name-sep
  label: String separating contig name from haplotype number.
  type:
  - 'null'
  - string
- doc: FASTA file with methylation levels of the input file.
  id: param_meth-fasta-in
  inputBinding:
    prefix: -meth-fasta-in
  label: FASTA file with methylation levels of the input file.
  type:
  - 'null'
  - File
- doc: Filename for meth-fasta-out output file
  id: param_meth-fasta-out_filename
  inputBinding:
    prefix: -meth-fasta-out
  label: Filename for meth-fasta-out output file
  type:
  - 'null'
  - string
- doc: Path to FASTA file to read the reference from.
  id: param_input-reference
  inputBinding:
    prefix: -input-reference
  label: Path to FASTA file to read the reference from.
  type: File
- doc: Path to the VCF file with variants to apply.
  id: param_input-vcf
  inputBinding:
    prefix: -input-vcf
  label: Path to the VCF file with variants to apply.
  type:
  - 'null'
  - File
- default: 'false'
  doc: Enable methylation level simulation.
  id: param_methylation-levels
  inputBinding:
    prefix: -methylation-levels
  label: Enable methylation level simulation.
  type:
  - 'null'
  - string
- default: '0.6'
  doc: Median of beta distribution for methylation level of CpG loci.
  id: param_meth-cg-mu
  inputBinding:
    prefix: -meth-cg-mu
  label: Median of beta distribution for methylation level of CpG loci.
  type:
  - 'null'
  - double
- default: '0.03'
  doc: Standard deviation of beta distribution for methylation level of CpG loci.
  id: param_meth-cg-sigma
  inputBinding:
    prefix: -meth-cg-sigma
  label: Standard deviation of beta distribution for methylation level of CpG loci.
  type:
  - 'null'
  - double
- default: '0.08'
  doc: Median of beta distribution for methylation level of CHG loci.
  id: param_meth-chg-mu
  inputBinding:
    prefix: -meth-chg-mu
  label: Median of beta distribution for methylation level of CHG loci.
  type:
  - 'null'
  - double
- default: '0.008'
  doc: Standard deviation of beta distribution for methylation level of CHG loci.
  id: param_meth-chg-sigma
  inputBinding:
    prefix: -meth-chg-sigma
  label: Standard deviation of beta distribution for methylation level of CHG loci.
  type:
  - 'null'
  - double
- default: '0.05'
  doc: Median of beta distribution for methylation level of CHH loci.
  id: param_meth-chh-mu
  inputBinding:
    prefix: -meth-chh-mu
  label: Median of beta distribution for methylation level of CHH loci.
  type:
  - 'null'
  - double
- default: '0.005'
  doc: Standard deviation of beta distribution for methylation level of CHH loci.
  id: param_meth-chh-sigma
  inputBinding:
    prefix: -meth-chh-sigma
  label: Standard deviation of beta distribution for methylation level of CHH loci.
  type:
  - 'null'
  - double
label: VCF Materialization
outputs:
- doc: Output of materialized contigs.
  id: param_out
  label: Output of materialized contigs.
  outputBinding:
    glob: $(inputs.param_out_filename)
  type: File
- doc: TSV file to write breakpoints in variants to.
  id: param_out-breakpoints
  label: TSV file to write breakpoints in variants to.
  outputBinding:
    glob: $(inputs.param_out-breakpoints_filename)
  type:
  - 'null'
  - File
- doc: FASTA file with methylation levels of the output file.
  id: param_meth-fasta-out
  label: FASTA file with methylation levels of the output file.
  outputBinding:
    glob: $(inputs.param_meth-fasta-out_filename)
  type:
  - 'null'
  - File
