/* $Id: pathrevoke.C,v 1.5 2000/12/23 08:27:32 dm Exp $ */

/*
 *
 * Copyright (C) 1999 David Mazieres (dm@uun.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include "sfscd.h"

static ihash<sfs_hash, revocation,
  &revocation::hostid, &revocation::hlink> revtab;

revocation::revocation (const sfs_pathrevoke &c)
{
  cert = c;

  bool ok = sfs_mkhostid (&hostid, c.msg.path);
  assert (ok);
  srvinfo::revoke (sfs_hostinfo2path (c.msg.path));

  if (cert.msg.redirect)
    setres (sfs_hostinfo2path (c.msg.redirect->hostinfo));
  else
    setres (":REVOKED:");

  revtab.insert (this);
}

void
revocation::update (const sfs_pathrevoke &c)
{
  if (!cert.msg.redirect || !sfs_checkrevoke (c))
    return;
  if (c.msg.redirect && c.msg.redirect->serial < cert.msg.redirect->serial)
    return;
  cert = c;

  if (cert.msg.redirect)
    setres (sfs_hostinfo2path (c.msg.redirect->hostinfo));
  else
    setres (":REVOKED:");
}

revocation::~revocation ()
{
  revtab.remove (this);
}

ptr<revocation>
revocation::alloc (const sfs_pathrevoke &c)
{
  sfs_hash hostid;
  if (!sfs_mkhostid (&hostid, c.msg.path) || !sfs_checkrevoke (c))
    return NULL;

  if (revocation *r = revtab[hostid]) {
    r->update (c);
    return mkref (r);
  }
  else {
    srvinfo::revoke (c.msg.path.hostname << ":"
		     << armor32 (hostid.base (), hostid.size ()));
    return New refcounted<revocation> (c);
  }
}

ptr<revocation>
revocation::lookup (const str &path)
{
  sfs_hash hostid;
  if (!sfs_parsepath (path, NULL, &hostid))
    return NULL;
  revocation *r = revtab[hostid];
  if (r)
    return mkref (r);
  return NULL;
}
