/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    main.h

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "config.h"


#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <dirent.h>
#include <linux/version.h>
#include <signal.h>
#include <getopt.h>
#include <ncurses.h>
#include <mcheck.h>


#include "dump.h"
#include "error.h"
#include "html.h"
#include "loadinfo.h"
#include "tools.h"

#ifdef HAVE_LIBNCURSES
#include "color.h"
#include "ps.h"
#endif


// Global Variables
// File Handles
extern FILE *fstdout;
extern FILE *pipes;
// Kernel Variables
extern int KERNEL;
#define VER24	24
#define VER22	22
#define VER20	20
// Display Mode Definitions
#define DISPLAY_MODE_DUMP	0
#define DISPLAY_MODE_COLOR	1
#define DISPLAY_MODE_PS		2
#define DISPLAY_MODE_HTML	3
#define DISPLAY_MODE_DATA	4
#define DISPLAY_MODE_GTK	5
// Command-Line Argument Variables
extern int OPT_SHOW_SYSTEM;
extern int OPT_SHOW_HARDWARE;
extern int OPT_SHOW_MEMORY;
extern int OPT_SHOW_KERNEL;
extern int OPT_SHOW_FILESYS;
extern int OPT_SHOW_NETWORK;
extern int OPT_SHOW_PROCESS;
extern int OPT_OUTPUT_PAGER;
extern int OPT_OUTPUT_FILE;
extern int OPT_DISABLE_PAGER;
extern int OPT_DISPLAY_MODE;
extern int OPT_DISABLE_CMDLINE;
extern char OUTPUT_FILE [INPUT_STRING];


// Function Definitions
//	in main.c
extern int main (int argc, char **argv, char **arg);
extern void signal_handler (int signum);
extern void exit_program (int retval);
extern void kernelversion ();
extern int command_line (int argc, char **argv, char **arg);
extern void configuration_file ();
//	in loadinfo.c
extern int loadinfo ();
extern void handleproc (int procnum, char *filename);
extern int readprocline (char *shortname, string *dataarray[READPROCLINE_COUNT]);
extern int readproc (char *shortname, char *string);
//	in modules.c
extern void handlemodules ();
extern void handlemodulesv20 ();
//	in time.c
extern void handletime ();
extern void handletimev20 ();
//	in cpu.c
extern void handlecpu ();
extern void handlecpuv20 ();
extern void handlecpuv22 ();
extern void initializecpu ();
//	in devices.c
extern void handledevices ();
extern void handledevicesv20 ();
extern void initializedev ();
//	in interrupts.c
extern void handleinterrupts ();
extern void handleinterruptsv20 ();
extern void handleinterruptsv22 ();
//	in stat.c
extern void handlestat ();
extern void handlestatv20 ();
extern void handlestatv22 ();
extern void handlestatv24 ();
//	in meminfo.c
extern void handlememinfo ();
extern void handlememinfov20 ();
//	in mounts.c
extern void handlemounts ();
extern void handlemountsv20 ();
//	in swaps.c
extern void handleswaps ();
extern void handleswapsv20 ();
//	in processes.c
extern void handleprocesses ();
extern void handleprocessesv20 ();
extern void initializeproc ();
//	in scsi.c
extern void handlescsi ();
extern void handlescsiv20 ();
//	in tty.c
extern void handletty ();
extern void handlettyv22 ();
//	in sound.c
extern void handlesound ();
extern void handlesoundv20 ();
//	in mtrr.c
extern void handlemtrr ();
extern void handlemtrrv20 ();
//	in ide.c
extern void handleide ();
extern void handleidev20 ();
extern void initializeidedev ();
//	in parport.c
extern void handleparport ();
extern void handleparportv20 ();
//	in misc.c
extern void handlemisc ();
extern void handlemiscv20 ();
//	in isadma.c
extern void handleisadma ();
extern void handleisadmav20 ();
//	in filesys.c
extern void handlefilesys ();
extern void handlefilesysv20 ();
//	in data.c
extern void display_data ();
extern void dumpstr (char *field, int num, char *string);
extern void dumpint (char *field, int num, int value);
extern void dumpexp (char *field, int num, const char *format, ...);
// 	in dump.c
extern void display_dump ();
// 	in tools.c
extern int fgetstr (FILE *point, char *string, int len);
extern int killcrlf (char *string, int len);
extern int cinstr (char *string, char character);
extern int rstring (char *string, int start, char *retstring);
extern int fillstring (char *string, char chr, int length);
extern int nostr (char *string, char character);
extern int rnostr (char *string, char character);
extern void ltrim (char *string);
extern void rtrim (char *string);
extern void trim (char *string);
//	in error.c
extern void error_handler (int errval);
//	in html.c
extern void display_html ();
#ifdef HAVE_LIBNCURSES
//	in color.c
extern void display_color ();
extern void ncurses_init ();
extern void headattr ();
extern void subattr ();
extern void dataattr ();
//	in ps.c
extern void display_ps ();
#endif

