/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    modules.c

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


// handlemodules ()
//	determine the correct procedure to use
void handlemodules () {
	//  proc/modules in all kernels are compatible
	handlemodulesv20 ();
}

// handlemodulesv20() Function
void handlemodulesv20 () {
	FILE *filep;
	char filename [INPUT_STRING];
	char tmpstring [INPUT_STRING];
	int c=0;
	int tmplength;
	
	// Open /proc/modules
	sprintf (filename, "%smodules", PROCLOC);
	filep=fopen(filename, "r");
	if (filep==NULL) return;
	// Fill Modules Structure
	do {
		fgets (tmpstring, INPUT_STRING-1, filep);
		if (feof(filep)!=0) break;
		tmplength=killcrlf(tmpstring, strlen(tmpstring));
		if (strlen(tmpstring)==1) continue;
		MODULES[c]=malloc(STRING_ARRAY_SIZE);
		if (MODULES[c]==NULL) error_handler(ERROR_MALLOC);
		(*MODULES[c])[0]=0;
		strncpy (*MODULES[c], tmpstring, STORAGE_STRING-1);
		(*MODULES[c])[STORAGE_STRING-1]=0;
		c++;
		if (c==MODULES_COUNT_MAX) break;
	} while (0==0);
	NUM_MODULES=c-1;
	// Close and Cleanup
	fclose (filep);
	return;
}

