/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    mounts.c

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


// handlemounts ()
//	determine the correct procedure to use
void handlemounts () {
	//  proc/mounts in all kernels are compatible
	handlemountsv20 ();
}

// handlemountsv20() Function
void handlemountsv20 () {
	FILE *filep;
	char filename [INPUT_STRING];
	char tmpstring [INPUT_STRING];
	int c=0;

	sprintf (filename, "%smounts", PROCLOC);
	filep=fopen(filename, "r");
	if (filep==NULL) return;
	do {
		fgets (tmpstring, INPUT_STRING, filep);
		if (feof(filep)!=0) break;
		MOUNTS[c]=malloc(MOUNTS_STRUCT_SIZE);
		if (MOUNTS[c]==NULL) error_handler(ERROR_MALLOC);
		MOUNTS[c]->DEVICE[0]=0;
		MOUNTS[c]->MOUNTPOINT[0]=0;
		MOUNTS[c]->FILESYS[0]=0;
		MOUNTS[c]->MODE[0]=0;
		sscanf (tmpstring, "%s %s %s %s", MOUNTS[c]->DEVICE, MOUNTS[c]->MOUNTPOINT, MOUNTS[c]->FILESYS, MOUNTS[c]->MODE);
		c++;
		if (c==MOUNTS_COUNT_MAX) break;
	} while (0==0);
	NUM_MOUNTS=c-1;
	// Cleanup
	fclose (filep);
	return;
}

