/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    ps.c

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


#ifdef HAVE_LIBNCURSES
/*
// ncurses Variables
WINDOW *win;
short COLOR_HEAD  = 1;
short COLOR_SUB   = 2;
short COLOR_DATA  = 3;
short COLOR_TOCH  = 4;
short COLOR_TOCS  = 5;
short COLOR_TITLE = 6;
*/


// display_ps() Function
void display_ps () {
	int i=0;
	char col1 [STORAGE_STRING];
	char col2 [STORAGE_STRING];
	char col3 [STORAGE_STRING];

	// Start ncurses
	ncurses_init ();
	// Processes
	for (i=0; i<24-((NUM_PROC/3)+8); i++)
		printw ("\n");
	headattr ();
	printw ("Process Information:\n");
	// processes
		subattr ();
		printw ("  Number of Processes Run:                ");
		dataattr ();
		printw ("%5d\n", atoi(PROCINFO[PROC_PROCESS]));
	// number of currently running processes
		subattr ();
		printw ("  Number of Currently Running Processes:  ");
		dataattr ();
		printw ("%5d\n", NUM_PROC + 1);
	// process information
		subattr ();
		printw ("  Currently Running Processes:\n");
		dataattr ();
		for (i=0; i<=(NUM_PROC/3); i++) {
			if (i<=NUM_PROC)
				sprintf (col1, "    %s (%ld)", PROC[i]->NAME, PROC[i]->PID);
			else
				sprintf (col1, " ");
			if (i+(NUM_PROC/3)+1 <= NUM_PROC)
				sprintf (col2, "    %s (%ld)", PROC[i+(NUM_PROC/3)+1]->NAME, PROC[i+(NUM_PROC/3)+1]->PID);
			else
				sprintf (col2, " ");
			if (i+(2*NUM_PROC/3)+2 <= NUM_PROC)
				sprintf (col3, "    %s (%ld)", PROC[i+(2*NUM_PROC/3)+2]->NAME, PROC[i+(2*NUM_PROC/3)+2]->PID);
			else
				sprintf (col3, " ");
			printw ("%20s%20s%20s\n", col1, col2, col3);
		}
	// Flush Output
	refresh ();
	// Quit Program
	endwin ();
	return;
}
#endif

