/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    scsi.c

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


// handlescsi ()
//	determine the correct procedure to use
void handlescsi () {
	//  proc/scsi in all kernels are compatible
	handlescsiv20 ();
}

// handlescsiv20() Function
void handlescsiv20 () {
	char filename [INPUT_STRING];
	char tmpstring [INPUT_STRING];
	FILE *filep;
	DIR *scsidir;
	struct dirent *dirname;
	int c=-1;

	// Open /proc/scsi
	sprintf (filename, "%sscsi/scsi", PROCLOC);
	filep=fopen(filename, "r");
	if (filep!=NULL) {
		do {
			fgets (tmpstring, INPUT_STRING, filep);
			if (feof(filep)!=0) break;
			killcrlf (tmpstring, strlen(tmpstring));
			if (strncmp(tmpstring, "Attached devices:", 17)==0) continue;
			if (strncmp(tmpstring, "Host:", 5)==0) {
				c++;
				if (c==SCSIDEV_COUNT_MAX) break;
				SCSIDEV[c]=malloc(SCSIDEV_STRUCT_SIZE);
				if (SCSIDEV[c]==NULL) error_handler(ERROR_MALLOC);
				sscanf (tmpstring, "%*5s %5s %*8s %2d %*3s %2d %*4s %2d", SCSIDEV[c]->HOST, &SCSIDEV[c]->CHANNEL, &SCSIDEV[c]->ID, &SCSIDEV[c]->LUN);
			}
			if (strncmp(tmpstring, "  Vendor:", 9)==0) {
				strncpy (SCSIDEV[c]->VENDOR, tmpstring + 10, 9);
				SCSIDEV[c]->VENDOR[9]=0;
				trim (SCSIDEV[c]->VENDOR);
				strncpy (SCSIDEV[c]->MODEL, tmpstring + 26, 17);
				SCSIDEV[c]->MODEL[17]=0;
				trim (SCSIDEV[c]->MODEL);
				strncpy (SCSIDEV[c]->REV, tmpstring + 48, STORAGE_STRING);
				SCSIDEV[c]->REV[STORAGE_STRING]=0;
				trim (SCSIDEV[c]->REV);
			}
			if (strncmp(tmpstring, "  Type:", 7)==0) {
				strncpy (SCSIDEV[c]->TYPE, tmpstring + 7, 33);
				SCSIDEV[c]->TYPE[33]=0;
				trim (SCSIDEV[c]->TYPE);
				strncpy (SCSIDEV[c]->ANSIREV, tmpstring + 62, STORAGE_STRING-1);
				SCSIDEV[c]->ANSIREV[STORAGE_STRING-1]=0;
				trim (SCSIDEV[c]->ANSIREV);
			}
		} while (0==0);
		NUM_SCSIDEV=c;
		fclose (filep);
	}
	// Find SCSI Drivers
	c=0;
	sprintf (filename, "%sscsi", PROCLOC);
	scsidir=opendir(filename);
	if (scsidir==NULL) return;
	// Read Entries
	do {
		dirname=readdir(scsidir);
		if (dirname==NULL) break;
		strncpy (tmpstring, dirname->d_name, INPUT_STRING-1);
		tmpstring[INPUT_STRING-1]=0;
		if (strcmp(tmpstring, "scsi")==0) continue;
		if (tmpstring[0]=='.') continue;
		SCSIDRV[c]=malloc(SCSIDRV_STRUCT_SIZE);
		if (SCSIDRV[c]==NULL) error_handler(ERROR_MALLOC);
		strncpy (SCSIDRV[c]->NAME, tmpstring, STORAGE_STRING-1);
		SCSIDRV[c]->NAME[STORAGE_STRING-1]=0;
		c++;
		if (c==SCSIDRV_COUNT_MAX) break;
	} while (0==0);
	NUM_SCSIDRV=c-1;
	// Read Descriptions
	for (c=0; c<=NUM_SCSIDRV; c++) {
		// scsi driver information from /proc/scsi/drvname/0
		sprintf (filename, "%sscsi/%s/0", PROCLOC, SCSIDRV[c]->NAME);
		filep=fopen(filename, "r");
		if (filep!=NULL) {
			fgetstr (filep, SCSIDRV[c]->DESC, STORAGE_STRING);
			fclose (filep);
			continue;
		}
		// scsi driver information from /proc/scsi/drvname/host_strs
		sprintf (filename, "%sscsi/%s/host_strs", PROCLOC, SCSIDRV[c]->NAME);
		filep=fopen(filename, "r");
		if (filep!=NULL) {
			fgetstr (filep, SCSIDRV[c]->DESC, STORAGE_STRING);
			fclose (filep);
			continue;
		}
		// if neither file is present
		SCSIDRV[c]->DESC[0]=0;
	}
	// Return
	return;
}

