/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    swaps.c

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


// handleswaps ()
//	determine the correct procedure to use
void handleswaps () {
	//  proc/swaps in all kernels are compatible
	handleswapsv20 ();
}

// handleswapsv20() Function
void handleswapsv20 () {
	FILE *filep;
	char tmpstring [INPUT_STRING];
	char filename [INPUT_STRING];
	char size [INPUT_STRING];
	char used [INPUT_STRING];
	int c=0;

	if (KERNEL==VER20) return;
	sprintf (filename, "%sswaps", PROCLOC);
	filep=fopen(filename, "r");
	if (filep==NULL) return;
	do {
		fgets (tmpstring, INPUT_STRING, filep);
		if (feof(filep)!=0) break;
		sscanf (tmpstring, "%s %*s %s %s %*s", filename, size, used);
		if (strcmp(filename, "Filename")==0) continue;
		SWAPS[c]=malloc(STRING_ARRAY_SIZE);
		if (SWAPS[c]==NULL) error_handler(ERROR_MALLOC);
		(*SWAPS[c])[0]=0;
		sprintf (*SWAPS[c], "%-20s%-10s%-10s", filename, size, used);
		c++;
		if (c==SWAPS_COUNT_MAX) break;
	} while (0==0);
	NUM_SWAPS=c-1;
	// Cleanup
	fclose (filep);
	return;
}

