//  libsigcperl -- a helper library for writing XSUB wrappers of libsigc++
//  Copyright (C) 2002 Ron Steinke
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this library; if not, write to the 
//  Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
//  Boston, MA  02111-1307  USA.

dnl Ignore the next line
// This is a generated file, do not edit. Generated from __file__.

include(template.macros.m4)
include(sigcperl.macros.m4)

#ifndef SIGC_PERL_SIGNAL_WRAP_H
#define SIGC_PERL_SIGNAL_WRAP_H

#include <sigcperl/signal_base.h>
#include <sigc++/adaptor.h>

define([PERL_SIGNAL],[// ---------- Perl Signal NUM($1) ----------

PERL_SIGNAL_IMPL(R,[$1])
PERL_SIGNAL_IMPL(void,[$1])
template<LIST(class R,ARG_CLASS($1),class Marsh)>
SignalBase* WrapSignal([SigC::Signal]NUM($1)<LIST(R,ARG_TYPE($1),Marsh)> &signal,
	SV *parent = 0) throw()
{
  return new [SignalWrapper]NUM($1)<LIST(R,ARG_TYPE($1),Marsh)>(signal, parent);
}
])dnl

define([PERL_SIGNAL_IMPL],[dnl
ifelse($1,void,[dnl
template <LIST(ARG_CLASS($2),class Marsh)>
class [SignalWrapper]NUM($2)<LIST(void,ARG_TYPE($2),Marsh)> : public SignalBase
],[dnl
template <LIST(class $1,ARG_CLASS($2),class Marsh=SigC::Marshal<$1> )>
class [SignalWrapper]NUM($2) : public SignalBase
])dnl
{
 public:
  typedef [SigC::Signal]NUM($2)<LIST($1,ARG_TYPE($2),Marsh)> SignalType;
  typedef [SigC::Slot]NUM($2)<LIST($1,ARG_TYPE($2))> SlotType;

  [SignalWrapper]NUM($2)(SignalType &signal, SV *parent = 0) throw()
    : m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    // std::cerr << "Called emit\n";

    ifelse(NUM($2),0,[],[if(data.size() < NUM($2))
      throw BadConvertVal();

    Data::Iter itr = data.begin();
    ARG_LOOP([DECLARE_SET_ARGS],[[;
    ]],$2);])

    // std::cerr << "Ready to emit\n";

    ifelse($1,void,[],[$1 val = ])m_signal.emit(
      ARG_LOOP([ARG_BOX_VALS],[[, ]],$2));

    // std::cerr << "Did the emit\n";

    ifelse($1,void,[return Data();],
    [if(VoidContext(flags))
      return Data();
    return Returns<$1>::getRetData(val);])
  }

 private:
  static $1 conv_func(LIST(NAMESPACE_ARG_REF($2),SigC::AdaptorSlotNode* node))
  {
    Data data;
    I32 flags = ifelse($1,void,[G_VOID],[Returns<$1>::getFlags()]);
    ifelse($1,void,[],[R val;])

    dSP;
    ENTER;
    SAVETMPS;

    ifelse(NUM($2),0,[],[ARG_LOOP([PUSH_SV_ARGS],[[;
    ]],$2);])

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ifelse($1,void,[],[Data data_out =
      ])((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    ifelse($1,void,[],[try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return value 
    }])

    SPAGAIN;
    FREETMPS;
    LEAVE;
    ifelse($1,void,[],[return val;])
  }

  [SignalWrapper]NUM($2)(const [SignalWrapper]NUM($2)&);
  [SignalWrapper]NUM($2)& operator=(const [SignalWrapper]NUM($2)&);

  SignalType &m_signal;
  ParentBox m_parent;
};
])dnl

namespace SigCPerl {
PERL_SIGNAL(ARGS(P,0))
PERL_SIGNAL(ARGS(P,1))
PERL_SIGNAL(ARGS(P,2))
PERL_SIGNAL(ARGS(P,3))
PERL_SIGNAL(ARGS(P,4))
PERL_SIGNAL(ARGS(P,5))
} // namespace SigCPerl

#endif // SIGC_PERL_SIGNAL_WRAP_H
