/* SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Copyright:
 *   2020      Evan Nemerson <evan@nemerson.com>
 *   2020      Christopher Moore <moore@free.fr>
 */

#define SIMDE_TEST_X86_AVX512_INSN insert

#include <test/x86/avx512/test-avx512.h>
#include <simde/x86/avx512/set.h>
#include <simde/x86/avx512/insert.h>

static int
test_simde_mm512_insertf32x4(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512 a;
    simde__m128 b;
    simde__m512 r0;
    simde__m512 r1;
    simde__m512 r2;
    simde__m512 r3;
  } test_vec[8] = {
    { simde_mm512_set_ps(SIMDE_FLOAT32_C(  -563.83), SIMDE_FLOAT32_C(   799.30), SIMDE_FLOAT32_C(   938.85), SIMDE_FLOAT32_C(  -576.01),
                         SIMDE_FLOAT32_C(  -465.05), SIMDE_FLOAT32_C(   439.15), SIMDE_FLOAT32_C(  -104.57), SIMDE_FLOAT32_C(   -28.15),
                         SIMDE_FLOAT32_C(  -431.26), SIMDE_FLOAT32_C(   481.25), SIMDE_FLOAT32_C(   -57.75), SIMDE_FLOAT32_C(  -784.26),
                         SIMDE_FLOAT32_C(   438.04), SIMDE_FLOAT32_C(   549.03), SIMDE_FLOAT32_C(   729.46), SIMDE_FLOAT32_C(   582.53)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(  -202.49), SIMDE_FLOAT32_C(  -470.36), SIMDE_FLOAT32_C(   966.37), SIMDE_FLOAT32_C(   135.20)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -563.83), SIMDE_FLOAT32_C(   799.30), SIMDE_FLOAT32_C(   938.85), SIMDE_FLOAT32_C(  -576.01),
                         SIMDE_FLOAT32_C(  -465.05), SIMDE_FLOAT32_C(   439.15), SIMDE_FLOAT32_C(  -104.57), SIMDE_FLOAT32_C(   -28.15),
                         SIMDE_FLOAT32_C(  -431.26), SIMDE_FLOAT32_C(   481.25), SIMDE_FLOAT32_C(   -57.75), SIMDE_FLOAT32_C(  -784.26),
                         SIMDE_FLOAT32_C(  -202.49), SIMDE_FLOAT32_C(  -470.36), SIMDE_FLOAT32_C(   966.37), SIMDE_FLOAT32_C(   135.20)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -563.83), SIMDE_FLOAT32_C(   799.30), SIMDE_FLOAT32_C(   938.85), SIMDE_FLOAT32_C(  -576.01),
                         SIMDE_FLOAT32_C(  -465.05), SIMDE_FLOAT32_C(   439.15), SIMDE_FLOAT32_C(  -104.57), SIMDE_FLOAT32_C(   -28.15),
                         SIMDE_FLOAT32_C(  -202.49), SIMDE_FLOAT32_C(  -470.36), SIMDE_FLOAT32_C(   966.37), SIMDE_FLOAT32_C(   135.20),
                         SIMDE_FLOAT32_C(   438.04), SIMDE_FLOAT32_C(   549.03), SIMDE_FLOAT32_C(   729.46), SIMDE_FLOAT32_C(   582.53)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -563.83), SIMDE_FLOAT32_C(   799.30), SIMDE_FLOAT32_C(   938.85), SIMDE_FLOAT32_C(  -576.01),
                         SIMDE_FLOAT32_C(  -202.49), SIMDE_FLOAT32_C(  -470.36), SIMDE_FLOAT32_C(   966.37), SIMDE_FLOAT32_C(   135.20),
                         SIMDE_FLOAT32_C(  -431.26), SIMDE_FLOAT32_C(   481.25), SIMDE_FLOAT32_C(   -57.75), SIMDE_FLOAT32_C(  -784.26),
                         SIMDE_FLOAT32_C(   438.04), SIMDE_FLOAT32_C(   549.03), SIMDE_FLOAT32_C(   729.46), SIMDE_FLOAT32_C(   582.53)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -202.49), SIMDE_FLOAT32_C(  -470.36), SIMDE_FLOAT32_C(   966.37), SIMDE_FLOAT32_C(   135.20),
                         SIMDE_FLOAT32_C(  -465.05), SIMDE_FLOAT32_C(   439.15), SIMDE_FLOAT32_C(  -104.57), SIMDE_FLOAT32_C(   -28.15),
                         SIMDE_FLOAT32_C(  -431.26), SIMDE_FLOAT32_C(   481.25), SIMDE_FLOAT32_C(   -57.75), SIMDE_FLOAT32_C(  -784.26),
                         SIMDE_FLOAT32_C(   438.04), SIMDE_FLOAT32_C(   549.03), SIMDE_FLOAT32_C(   729.46), SIMDE_FLOAT32_C(   582.53)) },
    { simde_mm512_set_ps(SIMDE_FLOAT32_C(  -743.10), SIMDE_FLOAT32_C(  -688.01), SIMDE_FLOAT32_C(   442.76), SIMDE_FLOAT32_C(   931.17),
                         SIMDE_FLOAT32_C(   120.10), SIMDE_FLOAT32_C(   -64.06), SIMDE_FLOAT32_C(  -620.03), SIMDE_FLOAT32_C(   559.81),
                         SIMDE_FLOAT32_C(   185.23), SIMDE_FLOAT32_C(  -423.61), SIMDE_FLOAT32_C(   -11.91), SIMDE_FLOAT32_C(   407.56),
                         SIMDE_FLOAT32_C(   355.11), SIMDE_FLOAT32_C(  -787.72), SIMDE_FLOAT32_C(   472.82), SIMDE_FLOAT32_C(  -703.51)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(  -859.51), SIMDE_FLOAT32_C(   -69.45), SIMDE_FLOAT32_C(    40.36), SIMDE_FLOAT32_C(    95.61)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -743.10), SIMDE_FLOAT32_C(  -688.01), SIMDE_FLOAT32_C(   442.76), SIMDE_FLOAT32_C(   931.17),
                         SIMDE_FLOAT32_C(   120.10), SIMDE_FLOAT32_C(   -64.06), SIMDE_FLOAT32_C(  -620.03), SIMDE_FLOAT32_C(   559.81),
                         SIMDE_FLOAT32_C(   185.23), SIMDE_FLOAT32_C(  -423.61), SIMDE_FLOAT32_C(   -11.91), SIMDE_FLOAT32_C(   407.56),
                         SIMDE_FLOAT32_C(  -859.51), SIMDE_FLOAT32_C(   -69.45), SIMDE_FLOAT32_C(    40.36), SIMDE_FLOAT32_C(    95.61)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -743.10), SIMDE_FLOAT32_C(  -688.01), SIMDE_FLOAT32_C(   442.76), SIMDE_FLOAT32_C(   931.17),
                         SIMDE_FLOAT32_C(   120.10), SIMDE_FLOAT32_C(   -64.06), SIMDE_FLOAT32_C(  -620.03), SIMDE_FLOAT32_C(   559.81),
                         SIMDE_FLOAT32_C(  -859.51), SIMDE_FLOAT32_C(   -69.45), SIMDE_FLOAT32_C(    40.36), SIMDE_FLOAT32_C(    95.61),
                         SIMDE_FLOAT32_C(   355.11), SIMDE_FLOAT32_C(  -787.72), SIMDE_FLOAT32_C(   472.82), SIMDE_FLOAT32_C(  -703.51)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -743.10), SIMDE_FLOAT32_C(  -688.01), SIMDE_FLOAT32_C(   442.76), SIMDE_FLOAT32_C(   931.17),
                         SIMDE_FLOAT32_C(  -859.51), SIMDE_FLOAT32_C(   -69.45), SIMDE_FLOAT32_C(    40.36), SIMDE_FLOAT32_C(    95.61),
                         SIMDE_FLOAT32_C(   185.23), SIMDE_FLOAT32_C(  -423.61), SIMDE_FLOAT32_C(   -11.91), SIMDE_FLOAT32_C(   407.56),
                         SIMDE_FLOAT32_C(   355.11), SIMDE_FLOAT32_C(  -787.72), SIMDE_FLOAT32_C(   472.82), SIMDE_FLOAT32_C(  -703.51)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -859.51), SIMDE_FLOAT32_C(   -69.45), SIMDE_FLOAT32_C(    40.36), SIMDE_FLOAT32_C(    95.61),
                         SIMDE_FLOAT32_C(   120.10), SIMDE_FLOAT32_C(   -64.06), SIMDE_FLOAT32_C(  -620.03), SIMDE_FLOAT32_C(   559.81),
                         SIMDE_FLOAT32_C(   185.23), SIMDE_FLOAT32_C(  -423.61), SIMDE_FLOAT32_C(   -11.91), SIMDE_FLOAT32_C(   407.56),
                         SIMDE_FLOAT32_C(   355.11), SIMDE_FLOAT32_C(  -787.72), SIMDE_FLOAT32_C(   472.82), SIMDE_FLOAT32_C(  -703.51)) },
    { simde_mm512_set_ps(SIMDE_FLOAT32_C(   -98.08), SIMDE_FLOAT32_C(   464.19), SIMDE_FLOAT32_C(   711.12), SIMDE_FLOAT32_C(   282.83),
                         SIMDE_FLOAT32_C(  -774.08), SIMDE_FLOAT32_C(   841.24), SIMDE_FLOAT32_C(  -414.07), SIMDE_FLOAT32_C(    79.76),
                         SIMDE_FLOAT32_C(   193.01), SIMDE_FLOAT32_C(  -435.27), SIMDE_FLOAT32_C(   -84.06), SIMDE_FLOAT32_C(   298.40),
                         SIMDE_FLOAT32_C(   208.07), SIMDE_FLOAT32_C(   -94.60), SIMDE_FLOAT32_C(   834.28), SIMDE_FLOAT32_C(   260.50)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(  -157.33), SIMDE_FLOAT32_C(  -819.46), SIMDE_FLOAT32_C(   541.44), SIMDE_FLOAT32_C(   112.81)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   -98.08), SIMDE_FLOAT32_C(   464.19), SIMDE_FLOAT32_C(   711.12), SIMDE_FLOAT32_C(   282.83),
                         SIMDE_FLOAT32_C(  -774.08), SIMDE_FLOAT32_C(   841.24), SIMDE_FLOAT32_C(  -414.07), SIMDE_FLOAT32_C(    79.76),
                         SIMDE_FLOAT32_C(   193.01), SIMDE_FLOAT32_C(  -435.27), SIMDE_FLOAT32_C(   -84.06), SIMDE_FLOAT32_C(   298.40),
                         SIMDE_FLOAT32_C(  -157.33), SIMDE_FLOAT32_C(  -819.46), SIMDE_FLOAT32_C(   541.44), SIMDE_FLOAT32_C(   112.81)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   -98.08), SIMDE_FLOAT32_C(   464.19), SIMDE_FLOAT32_C(   711.12), SIMDE_FLOAT32_C(   282.83),
                         SIMDE_FLOAT32_C(  -774.08), SIMDE_FLOAT32_C(   841.24), SIMDE_FLOAT32_C(  -414.07), SIMDE_FLOAT32_C(    79.76),
                         SIMDE_FLOAT32_C(  -157.33), SIMDE_FLOAT32_C(  -819.46), SIMDE_FLOAT32_C(   541.44), SIMDE_FLOAT32_C(   112.81),
                         SIMDE_FLOAT32_C(   208.07), SIMDE_FLOAT32_C(   -94.60), SIMDE_FLOAT32_C(   834.28), SIMDE_FLOAT32_C(   260.50)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   -98.08), SIMDE_FLOAT32_C(   464.19), SIMDE_FLOAT32_C(   711.12), SIMDE_FLOAT32_C(   282.83),
                         SIMDE_FLOAT32_C(  -157.33), SIMDE_FLOAT32_C(  -819.46), SIMDE_FLOAT32_C(   541.44), SIMDE_FLOAT32_C(   112.81),
                         SIMDE_FLOAT32_C(   193.01), SIMDE_FLOAT32_C(  -435.27), SIMDE_FLOAT32_C(   -84.06), SIMDE_FLOAT32_C(   298.40),
                         SIMDE_FLOAT32_C(   208.07), SIMDE_FLOAT32_C(   -94.60), SIMDE_FLOAT32_C(   834.28), SIMDE_FLOAT32_C(   260.50)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -157.33), SIMDE_FLOAT32_C(  -819.46), SIMDE_FLOAT32_C(   541.44), SIMDE_FLOAT32_C(   112.81),
                         SIMDE_FLOAT32_C(  -774.08), SIMDE_FLOAT32_C(   841.24), SIMDE_FLOAT32_C(  -414.07), SIMDE_FLOAT32_C(    79.76),
                         SIMDE_FLOAT32_C(   193.01), SIMDE_FLOAT32_C(  -435.27), SIMDE_FLOAT32_C(   -84.06), SIMDE_FLOAT32_C(   298.40),
                         SIMDE_FLOAT32_C(   208.07), SIMDE_FLOAT32_C(   -94.60), SIMDE_FLOAT32_C(   834.28), SIMDE_FLOAT32_C(   260.50)) },
    { simde_mm512_set_ps(SIMDE_FLOAT32_C(  -887.47), SIMDE_FLOAT32_C(   336.35), SIMDE_FLOAT32_C(  -396.24), SIMDE_FLOAT32_C(    99.21),
                         SIMDE_FLOAT32_C(    -2.60), SIMDE_FLOAT32_C(   -38.88), SIMDE_FLOAT32_C(   165.88), SIMDE_FLOAT32_C(   218.73),
                         SIMDE_FLOAT32_C(   375.27), SIMDE_FLOAT32_C(  -966.90), SIMDE_FLOAT32_C(  -512.98), SIMDE_FLOAT32_C(  -737.78),
                         SIMDE_FLOAT32_C(   664.52), SIMDE_FLOAT32_C(  -224.13), SIMDE_FLOAT32_C(   633.65), SIMDE_FLOAT32_C(  -834.15)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(   141.08), SIMDE_FLOAT32_C(  -832.50), SIMDE_FLOAT32_C(  -990.15), SIMDE_FLOAT32_C(   438.46)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -887.47), SIMDE_FLOAT32_C(   336.35), SIMDE_FLOAT32_C(  -396.24), SIMDE_FLOAT32_C(    99.21),
                         SIMDE_FLOAT32_C(    -2.60), SIMDE_FLOAT32_C(   -38.88), SIMDE_FLOAT32_C(   165.88), SIMDE_FLOAT32_C(   218.73),
                         SIMDE_FLOAT32_C(   375.27), SIMDE_FLOAT32_C(  -966.90), SIMDE_FLOAT32_C(  -512.98), SIMDE_FLOAT32_C(  -737.78),
                         SIMDE_FLOAT32_C(   141.08), SIMDE_FLOAT32_C(  -832.50), SIMDE_FLOAT32_C(  -990.15), SIMDE_FLOAT32_C(   438.46)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -887.47), SIMDE_FLOAT32_C(   336.35), SIMDE_FLOAT32_C(  -396.24), SIMDE_FLOAT32_C(    99.21),
                         SIMDE_FLOAT32_C(    -2.60), SIMDE_FLOAT32_C(   -38.88), SIMDE_FLOAT32_C(   165.88), SIMDE_FLOAT32_C(   218.73),
                         SIMDE_FLOAT32_C(   141.08), SIMDE_FLOAT32_C(  -832.50), SIMDE_FLOAT32_C(  -990.15), SIMDE_FLOAT32_C(   438.46),
                         SIMDE_FLOAT32_C(   664.52), SIMDE_FLOAT32_C(  -224.13), SIMDE_FLOAT32_C(   633.65), SIMDE_FLOAT32_C(  -834.15)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -887.47), SIMDE_FLOAT32_C(   336.35), SIMDE_FLOAT32_C(  -396.24), SIMDE_FLOAT32_C(    99.21),
                         SIMDE_FLOAT32_C(   141.08), SIMDE_FLOAT32_C(  -832.50), SIMDE_FLOAT32_C(  -990.15), SIMDE_FLOAT32_C(   438.46),
                         SIMDE_FLOAT32_C(   375.27), SIMDE_FLOAT32_C(  -966.90), SIMDE_FLOAT32_C(  -512.98), SIMDE_FLOAT32_C(  -737.78),
                         SIMDE_FLOAT32_C(   664.52), SIMDE_FLOAT32_C(  -224.13), SIMDE_FLOAT32_C(   633.65), SIMDE_FLOAT32_C(  -834.15)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   141.08), SIMDE_FLOAT32_C(  -832.50), SIMDE_FLOAT32_C(  -990.15), SIMDE_FLOAT32_C(   438.46),
                         SIMDE_FLOAT32_C(    -2.60), SIMDE_FLOAT32_C(   -38.88), SIMDE_FLOAT32_C(   165.88), SIMDE_FLOAT32_C(   218.73),
                         SIMDE_FLOAT32_C(   375.27), SIMDE_FLOAT32_C(  -966.90), SIMDE_FLOAT32_C(  -512.98), SIMDE_FLOAT32_C(  -737.78),
                         SIMDE_FLOAT32_C(   664.52), SIMDE_FLOAT32_C(  -224.13), SIMDE_FLOAT32_C(   633.65), SIMDE_FLOAT32_C(  -834.15)) },
    { simde_mm512_set_ps(SIMDE_FLOAT32_C(  -179.98), SIMDE_FLOAT32_C(   258.23), SIMDE_FLOAT32_C(   246.22), SIMDE_FLOAT32_C(    97.85),
                         SIMDE_FLOAT32_C(   666.32), SIMDE_FLOAT32_C(   364.80), SIMDE_FLOAT32_C(   759.27), SIMDE_FLOAT32_C(  -524.19),
                         SIMDE_FLOAT32_C(  -726.51), SIMDE_FLOAT32_C(   381.71), SIMDE_FLOAT32_C(   819.12), SIMDE_FLOAT32_C(   145.28),
                         SIMDE_FLOAT32_C(   -99.37), SIMDE_FLOAT32_C(  -151.02), SIMDE_FLOAT32_C(   551.65), SIMDE_FLOAT32_C(   155.58)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(   184.91), SIMDE_FLOAT32_C(  -432.97), SIMDE_FLOAT32_C(  -455.33), SIMDE_FLOAT32_C(   164.52)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -179.98), SIMDE_FLOAT32_C(   258.23), SIMDE_FLOAT32_C(   246.22), SIMDE_FLOAT32_C(    97.85),
                         SIMDE_FLOAT32_C(   666.32), SIMDE_FLOAT32_C(   364.80), SIMDE_FLOAT32_C(   759.27), SIMDE_FLOAT32_C(  -524.19),
                         SIMDE_FLOAT32_C(  -726.51), SIMDE_FLOAT32_C(   381.71), SIMDE_FLOAT32_C(   819.12), SIMDE_FLOAT32_C(   145.28),
                         SIMDE_FLOAT32_C(   184.91), SIMDE_FLOAT32_C(  -432.97), SIMDE_FLOAT32_C(  -455.33), SIMDE_FLOAT32_C(   164.52)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -179.98), SIMDE_FLOAT32_C(   258.23), SIMDE_FLOAT32_C(   246.22), SIMDE_FLOAT32_C(    97.85),
                         SIMDE_FLOAT32_C(   666.32), SIMDE_FLOAT32_C(   364.80), SIMDE_FLOAT32_C(   759.27), SIMDE_FLOAT32_C(  -524.19),
                         SIMDE_FLOAT32_C(   184.91), SIMDE_FLOAT32_C(  -432.97), SIMDE_FLOAT32_C(  -455.33), SIMDE_FLOAT32_C(   164.52),
                         SIMDE_FLOAT32_C(   -99.37), SIMDE_FLOAT32_C(  -151.02), SIMDE_FLOAT32_C(   551.65), SIMDE_FLOAT32_C(   155.58)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -179.98), SIMDE_FLOAT32_C(   258.23), SIMDE_FLOAT32_C(   246.22), SIMDE_FLOAT32_C(    97.85),
                         SIMDE_FLOAT32_C(   184.91), SIMDE_FLOAT32_C(  -432.97), SIMDE_FLOAT32_C(  -455.33), SIMDE_FLOAT32_C(   164.52),
                         SIMDE_FLOAT32_C(  -726.51), SIMDE_FLOAT32_C(   381.71), SIMDE_FLOAT32_C(   819.12), SIMDE_FLOAT32_C(   145.28),
                         SIMDE_FLOAT32_C(   -99.37), SIMDE_FLOAT32_C(  -151.02), SIMDE_FLOAT32_C(   551.65), SIMDE_FLOAT32_C(   155.58)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   184.91), SIMDE_FLOAT32_C(  -432.97), SIMDE_FLOAT32_C(  -455.33), SIMDE_FLOAT32_C(   164.52),
                         SIMDE_FLOAT32_C(   666.32), SIMDE_FLOAT32_C(   364.80), SIMDE_FLOAT32_C(   759.27), SIMDE_FLOAT32_C(  -524.19),
                         SIMDE_FLOAT32_C(  -726.51), SIMDE_FLOAT32_C(   381.71), SIMDE_FLOAT32_C(   819.12), SIMDE_FLOAT32_C(   145.28),
                         SIMDE_FLOAT32_C(   -99.37), SIMDE_FLOAT32_C(  -151.02), SIMDE_FLOAT32_C(   551.65), SIMDE_FLOAT32_C(   155.58)) },
    { simde_mm512_set_ps(SIMDE_FLOAT32_C(   481.68), SIMDE_FLOAT32_C(   170.00), SIMDE_FLOAT32_C(  -341.91), SIMDE_FLOAT32_C(   366.57),
                         SIMDE_FLOAT32_C(   254.48), SIMDE_FLOAT32_C(  -211.73), SIMDE_FLOAT32_C(   755.70), SIMDE_FLOAT32_C(   908.31),
                         SIMDE_FLOAT32_C(  -363.93), SIMDE_FLOAT32_C(  -144.11), SIMDE_FLOAT32_C(   789.10), SIMDE_FLOAT32_C(  -343.92),
                         SIMDE_FLOAT32_C(   344.74), SIMDE_FLOAT32_C(   961.65), SIMDE_FLOAT32_C(   652.93), SIMDE_FLOAT32_C(   754.42)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(  -846.10), SIMDE_FLOAT32_C(  -248.07), SIMDE_FLOAT32_C(  -411.92), SIMDE_FLOAT32_C(   -88.91)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   481.68), SIMDE_FLOAT32_C(   170.00), SIMDE_FLOAT32_C(  -341.91), SIMDE_FLOAT32_C(   366.57),
                         SIMDE_FLOAT32_C(   254.48), SIMDE_FLOAT32_C(  -211.73), SIMDE_FLOAT32_C(   755.70), SIMDE_FLOAT32_C(   908.31),
                         SIMDE_FLOAT32_C(  -363.93), SIMDE_FLOAT32_C(  -144.11), SIMDE_FLOAT32_C(   789.10), SIMDE_FLOAT32_C(  -343.92),
                         SIMDE_FLOAT32_C(  -846.10), SIMDE_FLOAT32_C(  -248.07), SIMDE_FLOAT32_C(  -411.92), SIMDE_FLOAT32_C(   -88.91)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   481.68), SIMDE_FLOAT32_C(   170.00), SIMDE_FLOAT32_C(  -341.91), SIMDE_FLOAT32_C(   366.57),
                         SIMDE_FLOAT32_C(   254.48), SIMDE_FLOAT32_C(  -211.73), SIMDE_FLOAT32_C(   755.70), SIMDE_FLOAT32_C(   908.31),
                         SIMDE_FLOAT32_C(  -846.10), SIMDE_FLOAT32_C(  -248.07), SIMDE_FLOAT32_C(  -411.92), SIMDE_FLOAT32_C(   -88.91),
                         SIMDE_FLOAT32_C(   344.74), SIMDE_FLOAT32_C(   961.65), SIMDE_FLOAT32_C(   652.93), SIMDE_FLOAT32_C(   754.42)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   481.68), SIMDE_FLOAT32_C(   170.00), SIMDE_FLOAT32_C(  -341.91), SIMDE_FLOAT32_C(   366.57),
                         SIMDE_FLOAT32_C(  -846.10), SIMDE_FLOAT32_C(  -248.07), SIMDE_FLOAT32_C(  -411.92), SIMDE_FLOAT32_C(   -88.91),
                         SIMDE_FLOAT32_C(  -363.93), SIMDE_FLOAT32_C(  -144.11), SIMDE_FLOAT32_C(   789.10), SIMDE_FLOAT32_C(  -343.92),
                         SIMDE_FLOAT32_C(   344.74), SIMDE_FLOAT32_C(   961.65), SIMDE_FLOAT32_C(   652.93), SIMDE_FLOAT32_C(   754.42)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -846.10), SIMDE_FLOAT32_C(  -248.07), SIMDE_FLOAT32_C(  -411.92), SIMDE_FLOAT32_C(   -88.91),
                         SIMDE_FLOAT32_C(   254.48), SIMDE_FLOAT32_C(  -211.73), SIMDE_FLOAT32_C(   755.70), SIMDE_FLOAT32_C(   908.31),
                         SIMDE_FLOAT32_C(  -363.93), SIMDE_FLOAT32_C(  -144.11), SIMDE_FLOAT32_C(   789.10), SIMDE_FLOAT32_C(  -343.92),
                         SIMDE_FLOAT32_C(   344.74), SIMDE_FLOAT32_C(   961.65), SIMDE_FLOAT32_C(   652.93), SIMDE_FLOAT32_C(   754.42)) },
    { simde_mm512_set_ps(SIMDE_FLOAT32_C(  -382.22), SIMDE_FLOAT32_C(   146.15), SIMDE_FLOAT32_C(  -320.26), SIMDE_FLOAT32_C(   360.04),
                         SIMDE_FLOAT32_C(  -199.21), SIMDE_FLOAT32_C(   134.15), SIMDE_FLOAT32_C(  -764.34), SIMDE_FLOAT32_C(  -376.86),
                         SIMDE_FLOAT32_C(  -985.32), SIMDE_FLOAT32_C(   485.76), SIMDE_FLOAT32_C(   234.60), SIMDE_FLOAT32_C(   786.03),
                         SIMDE_FLOAT32_C(   859.59), SIMDE_FLOAT32_C(   489.95), SIMDE_FLOAT32_C(  -409.35), SIMDE_FLOAT32_C(   796.52)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(   713.78), SIMDE_FLOAT32_C(  -342.76), SIMDE_FLOAT32_C(  -632.29), SIMDE_FLOAT32_C(  -698.47)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -382.22), SIMDE_FLOAT32_C(   146.15), SIMDE_FLOAT32_C(  -320.26), SIMDE_FLOAT32_C(   360.04),
                         SIMDE_FLOAT32_C(  -199.21), SIMDE_FLOAT32_C(   134.15), SIMDE_FLOAT32_C(  -764.34), SIMDE_FLOAT32_C(  -376.86),
                         SIMDE_FLOAT32_C(  -985.32), SIMDE_FLOAT32_C(   485.76), SIMDE_FLOAT32_C(   234.60), SIMDE_FLOAT32_C(   786.03),
                         SIMDE_FLOAT32_C(   713.78), SIMDE_FLOAT32_C(  -342.76), SIMDE_FLOAT32_C(  -632.29), SIMDE_FLOAT32_C(  -698.47)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -382.22), SIMDE_FLOAT32_C(   146.15), SIMDE_FLOAT32_C(  -320.26), SIMDE_FLOAT32_C(   360.04),
                         SIMDE_FLOAT32_C(  -199.21), SIMDE_FLOAT32_C(   134.15), SIMDE_FLOAT32_C(  -764.34), SIMDE_FLOAT32_C(  -376.86),
                         SIMDE_FLOAT32_C(   713.78), SIMDE_FLOAT32_C(  -342.76), SIMDE_FLOAT32_C(  -632.29), SIMDE_FLOAT32_C(  -698.47),
                         SIMDE_FLOAT32_C(   859.59), SIMDE_FLOAT32_C(   489.95), SIMDE_FLOAT32_C(  -409.35), SIMDE_FLOAT32_C(   796.52)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -382.22), SIMDE_FLOAT32_C(   146.15), SIMDE_FLOAT32_C(  -320.26), SIMDE_FLOAT32_C(   360.04),
                         SIMDE_FLOAT32_C(   713.78), SIMDE_FLOAT32_C(  -342.76), SIMDE_FLOAT32_C(  -632.29), SIMDE_FLOAT32_C(  -698.47),
                         SIMDE_FLOAT32_C(  -985.32), SIMDE_FLOAT32_C(   485.76), SIMDE_FLOAT32_C(   234.60), SIMDE_FLOAT32_C(   786.03),
                         SIMDE_FLOAT32_C(   859.59), SIMDE_FLOAT32_C(   489.95), SIMDE_FLOAT32_C(  -409.35), SIMDE_FLOAT32_C(   796.52)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   713.78), SIMDE_FLOAT32_C(  -342.76), SIMDE_FLOAT32_C(  -632.29), SIMDE_FLOAT32_C(  -698.47),
                         SIMDE_FLOAT32_C(  -199.21), SIMDE_FLOAT32_C(   134.15), SIMDE_FLOAT32_C(  -764.34), SIMDE_FLOAT32_C(  -376.86),
                         SIMDE_FLOAT32_C(  -985.32), SIMDE_FLOAT32_C(   485.76), SIMDE_FLOAT32_C(   234.60), SIMDE_FLOAT32_C(   786.03),
                         SIMDE_FLOAT32_C(   859.59), SIMDE_FLOAT32_C(   489.95), SIMDE_FLOAT32_C(  -409.35), SIMDE_FLOAT32_C(   796.52)) },
    { simde_mm512_set_ps(SIMDE_FLOAT32_C(  -766.40), SIMDE_FLOAT32_C(  -462.89), SIMDE_FLOAT32_C(  -495.88), SIMDE_FLOAT32_C(  -905.06),
                         SIMDE_FLOAT32_C(  -794.42), SIMDE_FLOAT32_C(   266.49), SIMDE_FLOAT32_C(  -263.27), SIMDE_FLOAT32_C(  -537.47),
                         SIMDE_FLOAT32_C(    74.85), SIMDE_FLOAT32_C(  -705.33), SIMDE_FLOAT32_C(   127.81), SIMDE_FLOAT32_C(   699.62),
                         SIMDE_FLOAT32_C(   197.25), SIMDE_FLOAT32_C(   358.04), SIMDE_FLOAT32_C(   348.19), SIMDE_FLOAT32_C(  -974.37)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(   156.66), SIMDE_FLOAT32_C(   658.18), SIMDE_FLOAT32_C(   198.89), SIMDE_FLOAT32_C(  -330.38)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -766.40), SIMDE_FLOAT32_C(  -462.89), SIMDE_FLOAT32_C(  -495.88), SIMDE_FLOAT32_C(  -905.06),
                         SIMDE_FLOAT32_C(  -794.42), SIMDE_FLOAT32_C(   266.49), SIMDE_FLOAT32_C(  -263.27), SIMDE_FLOAT32_C(  -537.47),
                         SIMDE_FLOAT32_C(    74.85), SIMDE_FLOAT32_C(  -705.33), SIMDE_FLOAT32_C(   127.81), SIMDE_FLOAT32_C(   699.62),
                         SIMDE_FLOAT32_C(   156.66), SIMDE_FLOAT32_C(   658.18), SIMDE_FLOAT32_C(   198.89), SIMDE_FLOAT32_C(  -330.38)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -766.40), SIMDE_FLOAT32_C(  -462.89), SIMDE_FLOAT32_C(  -495.88), SIMDE_FLOAT32_C(  -905.06),
                         SIMDE_FLOAT32_C(  -794.42), SIMDE_FLOAT32_C(   266.49), SIMDE_FLOAT32_C(  -263.27), SIMDE_FLOAT32_C(  -537.47),
                         SIMDE_FLOAT32_C(   156.66), SIMDE_FLOAT32_C(   658.18), SIMDE_FLOAT32_C(   198.89), SIMDE_FLOAT32_C(  -330.38),
                         SIMDE_FLOAT32_C(   197.25), SIMDE_FLOAT32_C(   358.04), SIMDE_FLOAT32_C(   348.19), SIMDE_FLOAT32_C(  -974.37)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -766.40), SIMDE_FLOAT32_C(  -462.89), SIMDE_FLOAT32_C(  -495.88), SIMDE_FLOAT32_C(  -905.06),
                         SIMDE_FLOAT32_C(   156.66), SIMDE_FLOAT32_C(   658.18), SIMDE_FLOAT32_C(   198.89), SIMDE_FLOAT32_C(  -330.38),
                         SIMDE_FLOAT32_C(    74.85), SIMDE_FLOAT32_C(  -705.33), SIMDE_FLOAT32_C(   127.81), SIMDE_FLOAT32_C(   699.62),
                         SIMDE_FLOAT32_C(   197.25), SIMDE_FLOAT32_C(   358.04), SIMDE_FLOAT32_C(   348.19), SIMDE_FLOAT32_C(  -974.37)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   156.66), SIMDE_FLOAT32_C(   658.18), SIMDE_FLOAT32_C(   198.89), SIMDE_FLOAT32_C(  -330.38),
                         SIMDE_FLOAT32_C(  -794.42), SIMDE_FLOAT32_C(   266.49), SIMDE_FLOAT32_C(  -263.27), SIMDE_FLOAT32_C(  -537.47),
                         SIMDE_FLOAT32_C(    74.85), SIMDE_FLOAT32_C(  -705.33), SIMDE_FLOAT32_C(   127.81), SIMDE_FLOAT32_C(   699.62),
                         SIMDE_FLOAT32_C(   197.25), SIMDE_FLOAT32_C(   358.04), SIMDE_FLOAT32_C(   348.19), SIMDE_FLOAT32_C(  -974.37)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512 r;
    r = simde_mm512_insertf32x4(test_vec[i].a, test_vec[i].b, 0);
    simde_assert_m512_close(r, test_vec[i].r0, 1);
    r = simde_mm512_insertf32x4(test_vec[i].a, test_vec[i].b, 1);
    simde_assert_m512_close(r, test_vec[i].r1, 1);
    r = simde_mm512_insertf32x4(test_vec[i].a, test_vec[i].b, 2);
    simde_assert_m512_close(r, test_vec[i].r2, 1);
    r = simde_mm512_insertf32x4(test_vec[i].a, test_vec[i].b, 3);
    simde_assert_m512_close(r, test_vec[i].r3, 1);
  }

  return 0;
}

static int
test_simde_mm512_mask_insertf32x4(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512 src;
    simde__mmask16 k;
    simde__m512 a;
    simde__m128 b;
    simde__m512 r0;
    simde__m512 r1;
    simde__m512 r2;
    simde__m512 r3;
  } test_vec[8] = {
    { simde_mm512_set_ps(SIMDE_FLOAT32_C(   903.50), SIMDE_FLOAT32_C(   -43.35), SIMDE_FLOAT32_C(   309.91), SIMDE_FLOAT32_C(   846.15),
                         SIMDE_FLOAT32_C(  -514.56), SIMDE_FLOAT32_C(  -860.98), SIMDE_FLOAT32_C(  -280.30), SIMDE_FLOAT32_C(   128.51),
                         SIMDE_FLOAT32_C(   522.06), SIMDE_FLOAT32_C(  -932.28), SIMDE_FLOAT32_C(   600.12), SIMDE_FLOAT32_C(  -491.12),
                         SIMDE_FLOAT32_C(  -139.11), SIMDE_FLOAT32_C(  -268.86), SIMDE_FLOAT32_C(   -71.72), SIMDE_FLOAT32_C(    98.47)),
      UINT16_C(21335),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   483.08), SIMDE_FLOAT32_C(   232.04), SIMDE_FLOAT32_C(   774.81), SIMDE_FLOAT32_C(  -599.01),
                         SIMDE_FLOAT32_C(    69.04), SIMDE_FLOAT32_C(  -149.02), SIMDE_FLOAT32_C(   240.79), SIMDE_FLOAT32_C(  -839.80),
                         SIMDE_FLOAT32_C(  -556.90), SIMDE_FLOAT32_C(   160.98), SIMDE_FLOAT32_C(   391.82), SIMDE_FLOAT32_C(  -569.99),
                         SIMDE_FLOAT32_C(  -327.63), SIMDE_FLOAT32_C(  -172.36), SIMDE_FLOAT32_C(   393.53), SIMDE_FLOAT32_C(    36.69)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(  -921.00), SIMDE_FLOAT32_C(   283.06), SIMDE_FLOAT32_C(  -471.60), SIMDE_FLOAT32_C(  -333.94)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   903.50), SIMDE_FLOAT32_C(   232.04), SIMDE_FLOAT32_C(   309.91), SIMDE_FLOAT32_C(  -599.01),
                         SIMDE_FLOAT32_C(  -514.56), SIMDE_FLOAT32_C(  -860.98), SIMDE_FLOAT32_C(   240.79), SIMDE_FLOAT32_C(  -839.80),
                         SIMDE_FLOAT32_C(   522.06), SIMDE_FLOAT32_C(   160.98), SIMDE_FLOAT32_C(   600.12), SIMDE_FLOAT32_C(  -569.99),
                         SIMDE_FLOAT32_C(  -139.11), SIMDE_FLOAT32_C(   283.06), SIMDE_FLOAT32_C(  -471.60), SIMDE_FLOAT32_C(  -333.94)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   903.50), SIMDE_FLOAT32_C(   232.04), SIMDE_FLOAT32_C(   309.91), SIMDE_FLOAT32_C(  -599.01),
                         SIMDE_FLOAT32_C(  -514.56), SIMDE_FLOAT32_C(  -860.98), SIMDE_FLOAT32_C(   240.79), SIMDE_FLOAT32_C(  -839.80),
                         SIMDE_FLOAT32_C(   522.06), SIMDE_FLOAT32_C(   283.06), SIMDE_FLOAT32_C(   600.12), SIMDE_FLOAT32_C(  -333.94),
                         SIMDE_FLOAT32_C(  -139.11), SIMDE_FLOAT32_C(  -172.36), SIMDE_FLOAT32_C(   393.53), SIMDE_FLOAT32_C(    36.69)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   903.50), SIMDE_FLOAT32_C(   232.04), SIMDE_FLOAT32_C(   309.91), SIMDE_FLOAT32_C(  -599.01),
                         SIMDE_FLOAT32_C(  -514.56), SIMDE_FLOAT32_C(  -860.98), SIMDE_FLOAT32_C(  -471.60), SIMDE_FLOAT32_C(  -333.94),
                         SIMDE_FLOAT32_C(   522.06), SIMDE_FLOAT32_C(   160.98), SIMDE_FLOAT32_C(   600.12), SIMDE_FLOAT32_C(  -569.99),
                         SIMDE_FLOAT32_C(  -139.11), SIMDE_FLOAT32_C(  -172.36), SIMDE_FLOAT32_C(   393.53), SIMDE_FLOAT32_C(    36.69)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   903.50), SIMDE_FLOAT32_C(   283.06), SIMDE_FLOAT32_C(   309.91), SIMDE_FLOAT32_C(  -333.94),
                         SIMDE_FLOAT32_C(  -514.56), SIMDE_FLOAT32_C(  -860.98), SIMDE_FLOAT32_C(   240.79), SIMDE_FLOAT32_C(  -839.80),
                         SIMDE_FLOAT32_C(   522.06), SIMDE_FLOAT32_C(   160.98), SIMDE_FLOAT32_C(   600.12), SIMDE_FLOAT32_C(  -569.99),
                         SIMDE_FLOAT32_C(  -139.11), SIMDE_FLOAT32_C(  -172.36), SIMDE_FLOAT32_C(   393.53), SIMDE_FLOAT32_C(    36.69)) },
    { simde_mm512_set_ps(SIMDE_FLOAT32_C(  -657.02), SIMDE_FLOAT32_C(  -629.37), SIMDE_FLOAT32_C(   337.35), SIMDE_FLOAT32_C(  -278.32),
                         SIMDE_FLOAT32_C(  -744.41), SIMDE_FLOAT32_C(    39.32), SIMDE_FLOAT32_C(    29.68), SIMDE_FLOAT32_C(  -490.28),
                         SIMDE_FLOAT32_C(   841.53), SIMDE_FLOAT32_C(   526.21), SIMDE_FLOAT32_C(  -203.04), SIMDE_FLOAT32_C(   -80.71),
                         SIMDE_FLOAT32_C(   632.01), SIMDE_FLOAT32_C(   456.89), SIMDE_FLOAT32_C(    51.33), SIMDE_FLOAT32_C(  -868.59)),
      UINT16_C(45677),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -213.75), SIMDE_FLOAT32_C(   403.00), SIMDE_FLOAT32_C(  -198.67), SIMDE_FLOAT32_C(   447.98),
                         SIMDE_FLOAT32_C(  -925.69), SIMDE_FLOAT32_C(   717.83), SIMDE_FLOAT32_C(  -489.88), SIMDE_FLOAT32_C(   -37.49),
                         SIMDE_FLOAT32_C(  -373.66), SIMDE_FLOAT32_C(  -292.35), SIMDE_FLOAT32_C(  -835.53), SIMDE_FLOAT32_C(   571.79),
                         SIMDE_FLOAT32_C(   675.92), SIMDE_FLOAT32_C(   490.41), SIMDE_FLOAT32_C(    47.59), SIMDE_FLOAT32_C(  -895.71)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(   907.23), SIMDE_FLOAT32_C(   957.37), SIMDE_FLOAT32_C(  -359.60), SIMDE_FLOAT32_C(  -934.92)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -213.75), SIMDE_FLOAT32_C(  -629.37), SIMDE_FLOAT32_C(  -198.67), SIMDE_FLOAT32_C(   447.98),
                         SIMDE_FLOAT32_C(  -744.41), SIMDE_FLOAT32_C(    39.32), SIMDE_FLOAT32_C(  -489.88), SIMDE_FLOAT32_C(  -490.28),
                         SIMDE_FLOAT32_C(   841.53), SIMDE_FLOAT32_C(  -292.35), SIMDE_FLOAT32_C(  -835.53), SIMDE_FLOAT32_C(   -80.71),
                         SIMDE_FLOAT32_C(   907.23), SIMDE_FLOAT32_C(   957.37), SIMDE_FLOAT32_C(    51.33), SIMDE_FLOAT32_C(  -934.92)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -213.75), SIMDE_FLOAT32_C(  -629.37), SIMDE_FLOAT32_C(  -198.67), SIMDE_FLOAT32_C(   447.98),
                         SIMDE_FLOAT32_C(  -744.41), SIMDE_FLOAT32_C(    39.32), SIMDE_FLOAT32_C(  -489.88), SIMDE_FLOAT32_C(  -490.28),
                         SIMDE_FLOAT32_C(   841.53), SIMDE_FLOAT32_C(   957.37), SIMDE_FLOAT32_C(  -359.60), SIMDE_FLOAT32_C(   -80.71),
                         SIMDE_FLOAT32_C(   675.92), SIMDE_FLOAT32_C(   490.41), SIMDE_FLOAT32_C(    51.33), SIMDE_FLOAT32_C(  -895.71)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -213.75), SIMDE_FLOAT32_C(  -629.37), SIMDE_FLOAT32_C(  -198.67), SIMDE_FLOAT32_C(   447.98),
                         SIMDE_FLOAT32_C(  -744.41), SIMDE_FLOAT32_C(    39.32), SIMDE_FLOAT32_C(  -359.60), SIMDE_FLOAT32_C(  -490.28),
                         SIMDE_FLOAT32_C(   841.53), SIMDE_FLOAT32_C(  -292.35), SIMDE_FLOAT32_C(  -835.53), SIMDE_FLOAT32_C(   -80.71),
                         SIMDE_FLOAT32_C(   675.92), SIMDE_FLOAT32_C(   490.41), SIMDE_FLOAT32_C(    51.33), SIMDE_FLOAT32_C(  -895.71)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   907.23), SIMDE_FLOAT32_C(  -629.37), SIMDE_FLOAT32_C(  -359.60), SIMDE_FLOAT32_C(  -934.92),
                         SIMDE_FLOAT32_C(  -744.41), SIMDE_FLOAT32_C(    39.32), SIMDE_FLOAT32_C(  -489.88), SIMDE_FLOAT32_C(  -490.28),
                         SIMDE_FLOAT32_C(   841.53), SIMDE_FLOAT32_C(  -292.35), SIMDE_FLOAT32_C(  -835.53), SIMDE_FLOAT32_C(   -80.71),
                         SIMDE_FLOAT32_C(   675.92), SIMDE_FLOAT32_C(   490.41), SIMDE_FLOAT32_C(    51.33), SIMDE_FLOAT32_C(  -895.71)) },
    { simde_mm512_set_ps(SIMDE_FLOAT32_C(   799.57), SIMDE_FLOAT32_C(  -820.22), SIMDE_FLOAT32_C(  -959.11), SIMDE_FLOAT32_C(   268.99),
                         SIMDE_FLOAT32_C(  -207.87), SIMDE_FLOAT32_C(  -765.42), SIMDE_FLOAT32_C(   138.83), SIMDE_FLOAT32_C(   699.07),
                         SIMDE_FLOAT32_C(  -143.73), SIMDE_FLOAT32_C(   709.96), SIMDE_FLOAT32_C(  -767.34), SIMDE_FLOAT32_C(  -588.28),
                         SIMDE_FLOAT32_C(   586.29), SIMDE_FLOAT32_C(  -760.88), SIMDE_FLOAT32_C(  -617.12), SIMDE_FLOAT32_C(  -751.58)),
      UINT16_C( 7353),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -786.23), SIMDE_FLOAT32_C(   873.30), SIMDE_FLOAT32_C(   241.45), SIMDE_FLOAT32_C(  -432.13),
                         SIMDE_FLOAT32_C(  -842.15), SIMDE_FLOAT32_C(   908.84), SIMDE_FLOAT32_C(  -315.78), SIMDE_FLOAT32_C(   -86.06),
                         SIMDE_FLOAT32_C(  -413.85), SIMDE_FLOAT32_C(   752.26), SIMDE_FLOAT32_C(   609.29), SIMDE_FLOAT32_C(   878.85),
                         SIMDE_FLOAT32_C(   846.67), SIMDE_FLOAT32_C(   670.52), SIMDE_FLOAT32_C(   149.72), SIMDE_FLOAT32_C(   213.24)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(   989.70), SIMDE_FLOAT32_C(  -433.33), SIMDE_FLOAT32_C(  -695.21), SIMDE_FLOAT32_C(    48.49)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   799.57), SIMDE_FLOAT32_C(  -820.22), SIMDE_FLOAT32_C(  -959.11), SIMDE_FLOAT32_C(  -432.13),
                         SIMDE_FLOAT32_C(  -842.15), SIMDE_FLOAT32_C(   908.84), SIMDE_FLOAT32_C(   138.83), SIMDE_FLOAT32_C(   699.07),
                         SIMDE_FLOAT32_C(  -413.85), SIMDE_FLOAT32_C(   709.96), SIMDE_FLOAT32_C(   609.29), SIMDE_FLOAT32_C(   878.85),
                         SIMDE_FLOAT32_C(   989.70), SIMDE_FLOAT32_C(  -760.88), SIMDE_FLOAT32_C(  -617.12), SIMDE_FLOAT32_C(    48.49)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   799.57), SIMDE_FLOAT32_C(  -820.22), SIMDE_FLOAT32_C(  -959.11), SIMDE_FLOAT32_C(  -432.13),
                         SIMDE_FLOAT32_C(  -842.15), SIMDE_FLOAT32_C(   908.84), SIMDE_FLOAT32_C(   138.83), SIMDE_FLOAT32_C(   699.07),
                         SIMDE_FLOAT32_C(   989.70), SIMDE_FLOAT32_C(   709.96), SIMDE_FLOAT32_C(  -695.21), SIMDE_FLOAT32_C(    48.49),
                         SIMDE_FLOAT32_C(   846.67), SIMDE_FLOAT32_C(  -760.88), SIMDE_FLOAT32_C(  -617.12), SIMDE_FLOAT32_C(   213.24)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   799.57), SIMDE_FLOAT32_C(  -820.22), SIMDE_FLOAT32_C(  -959.11), SIMDE_FLOAT32_C(  -432.13),
                         SIMDE_FLOAT32_C(   989.70), SIMDE_FLOAT32_C(  -433.33), SIMDE_FLOAT32_C(   138.83), SIMDE_FLOAT32_C(   699.07),
                         SIMDE_FLOAT32_C(  -413.85), SIMDE_FLOAT32_C(   709.96), SIMDE_FLOAT32_C(   609.29), SIMDE_FLOAT32_C(   878.85),
                         SIMDE_FLOAT32_C(   846.67), SIMDE_FLOAT32_C(  -760.88), SIMDE_FLOAT32_C(  -617.12), SIMDE_FLOAT32_C(   213.24)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   799.57), SIMDE_FLOAT32_C(  -820.22), SIMDE_FLOAT32_C(  -959.11), SIMDE_FLOAT32_C(    48.49),
                         SIMDE_FLOAT32_C(  -842.15), SIMDE_FLOAT32_C(   908.84), SIMDE_FLOAT32_C(   138.83), SIMDE_FLOAT32_C(   699.07),
                         SIMDE_FLOAT32_C(  -413.85), SIMDE_FLOAT32_C(   709.96), SIMDE_FLOAT32_C(   609.29), SIMDE_FLOAT32_C(   878.85),
                         SIMDE_FLOAT32_C(   846.67), SIMDE_FLOAT32_C(  -760.88), SIMDE_FLOAT32_C(  -617.12), SIMDE_FLOAT32_C(   213.24)) },
    { simde_mm512_set_ps(SIMDE_FLOAT32_C(  -282.31), SIMDE_FLOAT32_C(  -656.10), SIMDE_FLOAT32_C(  -789.54), SIMDE_FLOAT32_C(  -790.16),
                         SIMDE_FLOAT32_C(  -415.61), SIMDE_FLOAT32_C(   994.61), SIMDE_FLOAT32_C(  -659.70), SIMDE_FLOAT32_C(   493.30),
                         SIMDE_FLOAT32_C(   831.29), SIMDE_FLOAT32_C(  -619.50), SIMDE_FLOAT32_C(   952.47), SIMDE_FLOAT32_C(  -492.61),
                         SIMDE_FLOAT32_C(   -68.16), SIMDE_FLOAT32_C(   717.69), SIMDE_FLOAT32_C(  -663.74), SIMDE_FLOAT32_C(   179.29)),
      UINT16_C(58590),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -236.67), SIMDE_FLOAT32_C(  -211.91), SIMDE_FLOAT32_C(  -925.76), SIMDE_FLOAT32_C(  -915.62),
                         SIMDE_FLOAT32_C(   -30.05), SIMDE_FLOAT32_C(   -70.79), SIMDE_FLOAT32_C(   493.65), SIMDE_FLOAT32_C(    52.79),
                         SIMDE_FLOAT32_C(   835.54), SIMDE_FLOAT32_C(  -712.24), SIMDE_FLOAT32_C(   518.12), SIMDE_FLOAT32_C(  -173.80),
                         SIMDE_FLOAT32_C(   487.08), SIMDE_FLOAT32_C(   180.78), SIMDE_FLOAT32_C(  -289.23), SIMDE_FLOAT32_C(   918.52)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(   280.87), SIMDE_FLOAT32_C(  -904.81), SIMDE_FLOAT32_C(   380.83), SIMDE_FLOAT32_C(    50.50)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -236.67), SIMDE_FLOAT32_C(  -211.91), SIMDE_FLOAT32_C(  -925.76), SIMDE_FLOAT32_C(  -790.16),
                         SIMDE_FLOAT32_C(  -415.61), SIMDE_FLOAT32_C(   -70.79), SIMDE_FLOAT32_C(  -659.70), SIMDE_FLOAT32_C(   493.30),
                         SIMDE_FLOAT32_C(   835.54), SIMDE_FLOAT32_C(  -712.24), SIMDE_FLOAT32_C(   952.47), SIMDE_FLOAT32_C(  -173.80),
                         SIMDE_FLOAT32_C(   280.87), SIMDE_FLOAT32_C(  -904.81), SIMDE_FLOAT32_C(   380.83), SIMDE_FLOAT32_C(   179.29)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -236.67), SIMDE_FLOAT32_C(  -211.91), SIMDE_FLOAT32_C(  -925.76), SIMDE_FLOAT32_C(  -790.16),
                         SIMDE_FLOAT32_C(  -415.61), SIMDE_FLOAT32_C(   -70.79), SIMDE_FLOAT32_C(  -659.70), SIMDE_FLOAT32_C(   493.30),
                         SIMDE_FLOAT32_C(   280.87), SIMDE_FLOAT32_C(  -904.81), SIMDE_FLOAT32_C(   952.47), SIMDE_FLOAT32_C(    50.50),
                         SIMDE_FLOAT32_C(   487.08), SIMDE_FLOAT32_C(   180.78), SIMDE_FLOAT32_C(  -289.23), SIMDE_FLOAT32_C(   179.29)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -236.67), SIMDE_FLOAT32_C(  -211.91), SIMDE_FLOAT32_C(  -925.76), SIMDE_FLOAT32_C(  -790.16),
                         SIMDE_FLOAT32_C(  -415.61), SIMDE_FLOAT32_C(  -904.81), SIMDE_FLOAT32_C(  -659.70), SIMDE_FLOAT32_C(   493.30),
                         SIMDE_FLOAT32_C(   835.54), SIMDE_FLOAT32_C(  -712.24), SIMDE_FLOAT32_C(   952.47), SIMDE_FLOAT32_C(  -173.80),
                         SIMDE_FLOAT32_C(   487.08), SIMDE_FLOAT32_C(   180.78), SIMDE_FLOAT32_C(  -289.23), SIMDE_FLOAT32_C(   179.29)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   280.87), SIMDE_FLOAT32_C(  -904.81), SIMDE_FLOAT32_C(   380.83), SIMDE_FLOAT32_C(  -790.16),
                         SIMDE_FLOAT32_C(  -415.61), SIMDE_FLOAT32_C(   -70.79), SIMDE_FLOAT32_C(  -659.70), SIMDE_FLOAT32_C(   493.30),
                         SIMDE_FLOAT32_C(   835.54), SIMDE_FLOAT32_C(  -712.24), SIMDE_FLOAT32_C(   952.47), SIMDE_FLOAT32_C(  -173.80),
                         SIMDE_FLOAT32_C(   487.08), SIMDE_FLOAT32_C(   180.78), SIMDE_FLOAT32_C(  -289.23), SIMDE_FLOAT32_C(   179.29)) },
    { simde_mm512_set_ps(SIMDE_FLOAT32_C(  -318.40), SIMDE_FLOAT32_C(  -844.73), SIMDE_FLOAT32_C(   757.65), SIMDE_FLOAT32_C(   677.41),
                         SIMDE_FLOAT32_C(  -352.24), SIMDE_FLOAT32_C(  -479.79), SIMDE_FLOAT32_C(   602.83), SIMDE_FLOAT32_C(     2.55),
                         SIMDE_FLOAT32_C(  -388.47), SIMDE_FLOAT32_C(  -643.43), SIMDE_FLOAT32_C(  -331.34), SIMDE_FLOAT32_C(    72.67),
                         SIMDE_FLOAT32_C(  -870.79), SIMDE_FLOAT32_C(  -722.44), SIMDE_FLOAT32_C(   529.44), SIMDE_FLOAT32_C(  -949.73)),
      UINT16_C(51237),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   915.68), SIMDE_FLOAT32_C(   -53.79), SIMDE_FLOAT32_C(   703.31), SIMDE_FLOAT32_C(   930.79),
                         SIMDE_FLOAT32_C(   111.33), SIMDE_FLOAT32_C(  -176.75), SIMDE_FLOAT32_C(  -316.94), SIMDE_FLOAT32_C(   639.68),
                         SIMDE_FLOAT32_C(  -783.00), SIMDE_FLOAT32_C(  -102.18), SIMDE_FLOAT32_C(   960.00), SIMDE_FLOAT32_C(    22.93),
                         SIMDE_FLOAT32_C(  -395.13), SIMDE_FLOAT32_C(   145.63), SIMDE_FLOAT32_C(  -149.04), SIMDE_FLOAT32_C(   214.37)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(  -668.43), SIMDE_FLOAT32_C(  -235.48), SIMDE_FLOAT32_C(  -210.00), SIMDE_FLOAT32_C(   476.89)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   915.68), SIMDE_FLOAT32_C(   -53.79), SIMDE_FLOAT32_C(   757.65), SIMDE_FLOAT32_C(   677.41),
                         SIMDE_FLOAT32_C(   111.33), SIMDE_FLOAT32_C(  -479.79), SIMDE_FLOAT32_C(   602.83), SIMDE_FLOAT32_C(     2.55),
                         SIMDE_FLOAT32_C(  -388.47), SIMDE_FLOAT32_C(  -643.43), SIMDE_FLOAT32_C(   960.00), SIMDE_FLOAT32_C(    72.67),
                         SIMDE_FLOAT32_C(  -870.79), SIMDE_FLOAT32_C(  -235.48), SIMDE_FLOAT32_C(   529.44), SIMDE_FLOAT32_C(   476.89)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   915.68), SIMDE_FLOAT32_C(   -53.79), SIMDE_FLOAT32_C(   757.65), SIMDE_FLOAT32_C(   677.41),
                         SIMDE_FLOAT32_C(   111.33), SIMDE_FLOAT32_C(  -479.79), SIMDE_FLOAT32_C(   602.83), SIMDE_FLOAT32_C(     2.55),
                         SIMDE_FLOAT32_C(  -388.47), SIMDE_FLOAT32_C(  -643.43), SIMDE_FLOAT32_C(  -210.00), SIMDE_FLOAT32_C(    72.67),
                         SIMDE_FLOAT32_C(  -870.79), SIMDE_FLOAT32_C(   145.63), SIMDE_FLOAT32_C(   529.44), SIMDE_FLOAT32_C(   214.37)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   915.68), SIMDE_FLOAT32_C(   -53.79), SIMDE_FLOAT32_C(   757.65), SIMDE_FLOAT32_C(   677.41),
                         SIMDE_FLOAT32_C(  -668.43), SIMDE_FLOAT32_C(  -479.79), SIMDE_FLOAT32_C(   602.83), SIMDE_FLOAT32_C(     2.55),
                         SIMDE_FLOAT32_C(  -388.47), SIMDE_FLOAT32_C(  -643.43), SIMDE_FLOAT32_C(   960.00), SIMDE_FLOAT32_C(    72.67),
                         SIMDE_FLOAT32_C(  -870.79), SIMDE_FLOAT32_C(   145.63), SIMDE_FLOAT32_C(   529.44), SIMDE_FLOAT32_C(   214.37)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -668.43), SIMDE_FLOAT32_C(  -235.48), SIMDE_FLOAT32_C(   757.65), SIMDE_FLOAT32_C(   677.41),
                         SIMDE_FLOAT32_C(   111.33), SIMDE_FLOAT32_C(  -479.79), SIMDE_FLOAT32_C(   602.83), SIMDE_FLOAT32_C(     2.55),
                         SIMDE_FLOAT32_C(  -388.47), SIMDE_FLOAT32_C(  -643.43), SIMDE_FLOAT32_C(   960.00), SIMDE_FLOAT32_C(    72.67),
                         SIMDE_FLOAT32_C(  -870.79), SIMDE_FLOAT32_C(   145.63), SIMDE_FLOAT32_C(   529.44), SIMDE_FLOAT32_C(   214.37)) },
    { simde_mm512_set_ps(SIMDE_FLOAT32_C(   -96.70), SIMDE_FLOAT32_C(   -44.05), SIMDE_FLOAT32_C(   432.42), SIMDE_FLOAT32_C(   421.92),
                         SIMDE_FLOAT32_C(   718.96), SIMDE_FLOAT32_C(  -864.59), SIMDE_FLOAT32_C(  -334.42), SIMDE_FLOAT32_C(   660.53),
                         SIMDE_FLOAT32_C(   748.73), SIMDE_FLOAT32_C(   996.15), SIMDE_FLOAT32_C(  -607.82), SIMDE_FLOAT32_C(   296.47),
                         SIMDE_FLOAT32_C(  -327.04), SIMDE_FLOAT32_C(   -23.06), SIMDE_FLOAT32_C(   -95.21), SIMDE_FLOAT32_C(    10.75)),
      UINT16_C(44895),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   409.27), SIMDE_FLOAT32_C(   481.83), SIMDE_FLOAT32_C(   601.37), SIMDE_FLOAT32_C(  -660.24),
                         SIMDE_FLOAT32_C(  -675.56), SIMDE_FLOAT32_C(  -194.09), SIMDE_FLOAT32_C(   149.22), SIMDE_FLOAT32_C(   161.52),
                         SIMDE_FLOAT32_C(   632.78), SIMDE_FLOAT32_C(   346.90), SIMDE_FLOAT32_C(  -777.05), SIMDE_FLOAT32_C(   621.95),
                         SIMDE_FLOAT32_C(  -116.18), SIMDE_FLOAT32_C(   909.84), SIMDE_FLOAT32_C(   696.35), SIMDE_FLOAT32_C(  -644.31)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(   744.11), SIMDE_FLOAT32_C(   849.34), SIMDE_FLOAT32_C(   350.11), SIMDE_FLOAT32_C(   112.68)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   409.27), SIMDE_FLOAT32_C(   -44.05), SIMDE_FLOAT32_C(   601.37), SIMDE_FLOAT32_C(   421.92),
                         SIMDE_FLOAT32_C(  -675.56), SIMDE_FLOAT32_C(  -194.09), SIMDE_FLOAT32_C(   149.22), SIMDE_FLOAT32_C(   161.52),
                         SIMDE_FLOAT32_C(   748.73), SIMDE_FLOAT32_C(   346.90), SIMDE_FLOAT32_C(  -607.82), SIMDE_FLOAT32_C(   621.95),
                         SIMDE_FLOAT32_C(   744.11), SIMDE_FLOAT32_C(   849.34), SIMDE_FLOAT32_C(   350.11), SIMDE_FLOAT32_C(   112.68)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   409.27), SIMDE_FLOAT32_C(   -44.05), SIMDE_FLOAT32_C(   601.37), SIMDE_FLOAT32_C(   421.92),
                         SIMDE_FLOAT32_C(  -675.56), SIMDE_FLOAT32_C(  -194.09), SIMDE_FLOAT32_C(   149.22), SIMDE_FLOAT32_C(   161.52),
                         SIMDE_FLOAT32_C(   748.73), SIMDE_FLOAT32_C(   849.34), SIMDE_FLOAT32_C(  -607.82), SIMDE_FLOAT32_C(   112.68),
                         SIMDE_FLOAT32_C(  -116.18), SIMDE_FLOAT32_C(   909.84), SIMDE_FLOAT32_C(   696.35), SIMDE_FLOAT32_C(  -644.31)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   409.27), SIMDE_FLOAT32_C(   -44.05), SIMDE_FLOAT32_C(   601.37), SIMDE_FLOAT32_C(   421.92),
                         SIMDE_FLOAT32_C(   744.11), SIMDE_FLOAT32_C(   849.34), SIMDE_FLOAT32_C(   350.11), SIMDE_FLOAT32_C(   112.68),
                         SIMDE_FLOAT32_C(   748.73), SIMDE_FLOAT32_C(   346.90), SIMDE_FLOAT32_C(  -607.82), SIMDE_FLOAT32_C(   621.95),
                         SIMDE_FLOAT32_C(  -116.18), SIMDE_FLOAT32_C(   909.84), SIMDE_FLOAT32_C(   696.35), SIMDE_FLOAT32_C(  -644.31)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   744.11), SIMDE_FLOAT32_C(   -44.05), SIMDE_FLOAT32_C(   350.11), SIMDE_FLOAT32_C(   421.92),
                         SIMDE_FLOAT32_C(  -675.56), SIMDE_FLOAT32_C(  -194.09), SIMDE_FLOAT32_C(   149.22), SIMDE_FLOAT32_C(   161.52),
                         SIMDE_FLOAT32_C(   748.73), SIMDE_FLOAT32_C(   346.90), SIMDE_FLOAT32_C(  -607.82), SIMDE_FLOAT32_C(   621.95),
                         SIMDE_FLOAT32_C(  -116.18), SIMDE_FLOAT32_C(   909.84), SIMDE_FLOAT32_C(   696.35), SIMDE_FLOAT32_C(  -644.31)) },
    { simde_mm512_set_ps(SIMDE_FLOAT32_C(  -291.83), SIMDE_FLOAT32_C(   951.57), SIMDE_FLOAT32_C(   272.52), SIMDE_FLOAT32_C(  -735.05),
                         SIMDE_FLOAT32_C(     5.84), SIMDE_FLOAT32_C(    39.14), SIMDE_FLOAT32_C(   124.68), SIMDE_FLOAT32_C(  -448.70),
                         SIMDE_FLOAT32_C(   122.69), SIMDE_FLOAT32_C(    65.13), SIMDE_FLOAT32_C(  -972.27), SIMDE_FLOAT32_C(   628.22),
                         SIMDE_FLOAT32_C(   383.31), SIMDE_FLOAT32_C(   641.22), SIMDE_FLOAT32_C(  -747.07), SIMDE_FLOAT32_C(  -762.67)),
      UINT16_C(25691),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   830.24), SIMDE_FLOAT32_C(   903.53), SIMDE_FLOAT32_C(  -831.08), SIMDE_FLOAT32_C(   815.07),
                         SIMDE_FLOAT32_C(   196.06), SIMDE_FLOAT32_C(   -83.06), SIMDE_FLOAT32_C(   687.82), SIMDE_FLOAT32_C(  -517.82),
                         SIMDE_FLOAT32_C(  -294.36), SIMDE_FLOAT32_C(   702.71), SIMDE_FLOAT32_C(  -920.22), SIMDE_FLOAT32_C(  -923.04),
                         SIMDE_FLOAT32_C(  -251.41), SIMDE_FLOAT32_C(   223.24), SIMDE_FLOAT32_C(  -528.18), SIMDE_FLOAT32_C(   813.86)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(   757.18), SIMDE_FLOAT32_C(   318.14), SIMDE_FLOAT32_C(   214.84), SIMDE_FLOAT32_C(   399.19)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -291.83), SIMDE_FLOAT32_C(   903.53), SIMDE_FLOAT32_C(  -831.08), SIMDE_FLOAT32_C(  -735.05),
                         SIMDE_FLOAT32_C(     5.84), SIMDE_FLOAT32_C(   -83.06), SIMDE_FLOAT32_C(   124.68), SIMDE_FLOAT32_C(  -448.70),
                         SIMDE_FLOAT32_C(   122.69), SIMDE_FLOAT32_C(   702.71), SIMDE_FLOAT32_C(  -972.27), SIMDE_FLOAT32_C(  -923.04),
                         SIMDE_FLOAT32_C(   757.18), SIMDE_FLOAT32_C(   641.22), SIMDE_FLOAT32_C(   214.84), SIMDE_FLOAT32_C(   399.19)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -291.83), SIMDE_FLOAT32_C(   903.53), SIMDE_FLOAT32_C(  -831.08), SIMDE_FLOAT32_C(  -735.05),
                         SIMDE_FLOAT32_C(     5.84), SIMDE_FLOAT32_C(   -83.06), SIMDE_FLOAT32_C(   124.68), SIMDE_FLOAT32_C(  -448.70),
                         SIMDE_FLOAT32_C(   122.69), SIMDE_FLOAT32_C(   318.14), SIMDE_FLOAT32_C(  -972.27), SIMDE_FLOAT32_C(   399.19),
                         SIMDE_FLOAT32_C(  -251.41), SIMDE_FLOAT32_C(   641.22), SIMDE_FLOAT32_C(  -528.18), SIMDE_FLOAT32_C(   813.86)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -291.83), SIMDE_FLOAT32_C(   903.53), SIMDE_FLOAT32_C(  -831.08), SIMDE_FLOAT32_C(  -735.05),
                         SIMDE_FLOAT32_C(     5.84), SIMDE_FLOAT32_C(   318.14), SIMDE_FLOAT32_C(   124.68), SIMDE_FLOAT32_C(  -448.70),
                         SIMDE_FLOAT32_C(   122.69), SIMDE_FLOAT32_C(   702.71), SIMDE_FLOAT32_C(  -972.27), SIMDE_FLOAT32_C(  -923.04),
                         SIMDE_FLOAT32_C(  -251.41), SIMDE_FLOAT32_C(   641.22), SIMDE_FLOAT32_C(  -528.18), SIMDE_FLOAT32_C(   813.86)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -291.83), SIMDE_FLOAT32_C(   318.14), SIMDE_FLOAT32_C(   214.84), SIMDE_FLOAT32_C(  -735.05),
                         SIMDE_FLOAT32_C(     5.84), SIMDE_FLOAT32_C(   -83.06), SIMDE_FLOAT32_C(   124.68), SIMDE_FLOAT32_C(  -448.70),
                         SIMDE_FLOAT32_C(   122.69), SIMDE_FLOAT32_C(   702.71), SIMDE_FLOAT32_C(  -972.27), SIMDE_FLOAT32_C(  -923.04),
                         SIMDE_FLOAT32_C(  -251.41), SIMDE_FLOAT32_C(   641.22), SIMDE_FLOAT32_C(  -528.18), SIMDE_FLOAT32_C(   813.86)) },
    { simde_mm512_set_ps(SIMDE_FLOAT32_C(  -836.14), SIMDE_FLOAT32_C(   203.81), SIMDE_FLOAT32_C(   976.04), SIMDE_FLOAT32_C(  -539.32),
                         SIMDE_FLOAT32_C(  -223.45), SIMDE_FLOAT32_C(   385.89), SIMDE_FLOAT32_C(   181.57), SIMDE_FLOAT32_C(   739.21),
                         SIMDE_FLOAT32_C(   355.61), SIMDE_FLOAT32_C(  -450.77), SIMDE_FLOAT32_C(   343.42), SIMDE_FLOAT32_C(  -703.95),
                         SIMDE_FLOAT32_C(   169.29), SIMDE_FLOAT32_C(   932.53), SIMDE_FLOAT32_C(  -653.71), SIMDE_FLOAT32_C(   371.73)),
      UINT16_C(40766),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -508.71), SIMDE_FLOAT32_C(  -257.73), SIMDE_FLOAT32_C(   937.76), SIMDE_FLOAT32_C(  -978.21),
                         SIMDE_FLOAT32_C(   677.79), SIMDE_FLOAT32_C(   768.71), SIMDE_FLOAT32_C(  -498.71), SIMDE_FLOAT32_C(   101.56),
                         SIMDE_FLOAT32_C(   211.34), SIMDE_FLOAT32_C(  -159.54), SIMDE_FLOAT32_C(   297.01), SIMDE_FLOAT32_C(   147.67),
                         SIMDE_FLOAT32_C(  -855.53), SIMDE_FLOAT32_C(   391.08), SIMDE_FLOAT32_C(  -710.54), SIMDE_FLOAT32_C(  -140.51)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(   397.77), SIMDE_FLOAT32_C(   348.86), SIMDE_FLOAT32_C(    24.57), SIMDE_FLOAT32_C(  -908.02)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -508.71), SIMDE_FLOAT32_C(   203.81), SIMDE_FLOAT32_C(   976.04), SIMDE_FLOAT32_C(  -978.21),
                         SIMDE_FLOAT32_C(   677.79), SIMDE_FLOAT32_C(   768.71), SIMDE_FLOAT32_C(  -498.71), SIMDE_FLOAT32_C(   101.56),
                         SIMDE_FLOAT32_C(   355.61), SIMDE_FLOAT32_C(  -450.77), SIMDE_FLOAT32_C(   297.01), SIMDE_FLOAT32_C(   147.67),
                         SIMDE_FLOAT32_C(   397.77), SIMDE_FLOAT32_C(   348.86), SIMDE_FLOAT32_C(    24.57), SIMDE_FLOAT32_C(   371.73)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -508.71), SIMDE_FLOAT32_C(   203.81), SIMDE_FLOAT32_C(   976.04), SIMDE_FLOAT32_C(  -978.21),
                         SIMDE_FLOAT32_C(   677.79), SIMDE_FLOAT32_C(   768.71), SIMDE_FLOAT32_C(  -498.71), SIMDE_FLOAT32_C(   101.56),
                         SIMDE_FLOAT32_C(   355.61), SIMDE_FLOAT32_C(  -450.77), SIMDE_FLOAT32_C(    24.57), SIMDE_FLOAT32_C(  -908.02),
                         SIMDE_FLOAT32_C(  -855.53), SIMDE_FLOAT32_C(   391.08), SIMDE_FLOAT32_C(  -710.54), SIMDE_FLOAT32_C(   371.73)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -508.71), SIMDE_FLOAT32_C(   203.81), SIMDE_FLOAT32_C(   976.04), SIMDE_FLOAT32_C(  -978.21),
                         SIMDE_FLOAT32_C(   397.77), SIMDE_FLOAT32_C(   348.86), SIMDE_FLOAT32_C(    24.57), SIMDE_FLOAT32_C(  -908.02),
                         SIMDE_FLOAT32_C(   355.61), SIMDE_FLOAT32_C(  -450.77), SIMDE_FLOAT32_C(   297.01), SIMDE_FLOAT32_C(   147.67),
                         SIMDE_FLOAT32_C(  -855.53), SIMDE_FLOAT32_C(   391.08), SIMDE_FLOAT32_C(  -710.54), SIMDE_FLOAT32_C(   371.73)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(   397.77), SIMDE_FLOAT32_C(   203.81), SIMDE_FLOAT32_C(   976.04), SIMDE_FLOAT32_C(  -908.02),
                         SIMDE_FLOAT32_C(   677.79), SIMDE_FLOAT32_C(   768.71), SIMDE_FLOAT32_C(  -498.71), SIMDE_FLOAT32_C(   101.56),
                         SIMDE_FLOAT32_C(   355.61), SIMDE_FLOAT32_C(  -450.77), SIMDE_FLOAT32_C(   297.01), SIMDE_FLOAT32_C(   147.67),
                         SIMDE_FLOAT32_C(  -855.53), SIMDE_FLOAT32_C(   391.08), SIMDE_FLOAT32_C(  -710.54), SIMDE_FLOAT32_C(   371.73)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512 r;
    r = simde_mm512_mask_insertf32x4(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b, 0);
    simde_assert_m512_close(r, test_vec[i].r0, 1);
    r = simde_mm512_mask_insertf32x4(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b, 1);
    simde_assert_m512_close(r, test_vec[i].r1, 1);
    r = simde_mm512_mask_insertf32x4(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b, 2);
    simde_assert_m512_close(r, test_vec[i].r2, 1);
    r = simde_mm512_mask_insertf32x4(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b, 3);
    simde_assert_m512_close(r, test_vec[i].r3, 1);
  }

  return 0;
}

static int
test_simde_mm512_maskz_insertf32x4(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask16 k;
    simde__m512 a;
    simde__m128 b;
    simde__m512 r0;
    simde__m512 r1;
    simde__m512 r2;
    simde__m512 r3;
  } test_vec[8] = {
    { UINT16_C(21335),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -556.90), SIMDE_FLOAT32_C(   522.06), SIMDE_FLOAT32_C(   160.98), SIMDE_FLOAT32_C(  -932.28),
                         SIMDE_FLOAT32_C(   391.82), SIMDE_FLOAT32_C(   600.12), SIMDE_FLOAT32_C(  -569.99), SIMDE_FLOAT32_C(  -491.12),
                         SIMDE_FLOAT32_C(  -327.63), SIMDE_FLOAT32_C(  -139.11), SIMDE_FLOAT32_C(  -172.36), SIMDE_FLOAT32_C(  -268.86),
                         SIMDE_FLOAT32_C(   393.53), SIMDE_FLOAT32_C(   -71.72), SIMDE_FLOAT32_C(    36.69), SIMDE_FLOAT32_C(    98.47)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(   240.79), SIMDE_FLOAT32_C(  -280.30), SIMDE_FLOAT32_C(  -839.80), SIMDE_FLOAT32_C(   128.51)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   522.06), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -932.28),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -569.99), SIMDE_FLOAT32_C(  -491.12),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -139.11), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -268.86),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -280.30), SIMDE_FLOAT32_C(  -839.80), SIMDE_FLOAT32_C(   128.51)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   522.06), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -932.28),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -569.99), SIMDE_FLOAT32_C(  -491.12),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -280.30), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   128.51),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   -71.72), SIMDE_FLOAT32_C(    36.69), SIMDE_FLOAT32_C(    98.47)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   522.06), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -932.28),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -839.80), SIMDE_FLOAT32_C(   128.51),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -139.11), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -268.86),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   -71.72), SIMDE_FLOAT32_C(    36.69), SIMDE_FLOAT32_C(    98.47)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -280.30), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   128.51),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -569.99), SIMDE_FLOAT32_C(  -491.12),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -139.11), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -268.86),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   -71.72), SIMDE_FLOAT32_C(    36.69), SIMDE_FLOAT32_C(    98.47)) },
    { UINT16_C(30312),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -736.92), SIMDE_FLOAT32_C(  -921.00), SIMDE_FLOAT32_C(   283.06), SIMDE_FLOAT32_C(  -471.60),
                         SIMDE_FLOAT32_C(  -333.94), SIMDE_FLOAT32_C(   483.08), SIMDE_FLOAT32_C(   903.50), SIMDE_FLOAT32_C(   232.04),
                         SIMDE_FLOAT32_C(   -43.35), SIMDE_FLOAT32_C(   774.81), SIMDE_FLOAT32_C(   309.91), SIMDE_FLOAT32_C(  -599.01),
                         SIMDE_FLOAT32_C(   846.15), SIMDE_FLOAT32_C(    69.04), SIMDE_FLOAT32_C(  -514.56), SIMDE_FLOAT32_C(  -149.02)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(    47.59), SIMDE_FLOAT32_C(    51.33), SIMDE_FLOAT32_C(  -895.71), SIMDE_FLOAT32_C(  -868.59)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -921.00), SIMDE_FLOAT32_C(   283.06), SIMDE_FLOAT32_C(  -471.60),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   483.08), SIMDE_FLOAT32_C(   903.50), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   774.81), SIMDE_FLOAT32_C(   309.91), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(    47.59), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -921.00), SIMDE_FLOAT32_C(   283.06), SIMDE_FLOAT32_C(  -471.60),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   483.08), SIMDE_FLOAT32_C(   903.50), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(    51.33), SIMDE_FLOAT32_C(  -895.71), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(   846.15), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -921.00), SIMDE_FLOAT32_C(   283.06), SIMDE_FLOAT32_C(  -471.60),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(    51.33), SIMDE_FLOAT32_C(  -895.71), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   774.81), SIMDE_FLOAT32_C(   309.91), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(   846.15), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(    51.33), SIMDE_FLOAT32_C(  -895.71), SIMDE_FLOAT32_C(  -868.59),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   483.08), SIMDE_FLOAT32_C(   903.50), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   774.81), SIMDE_FLOAT32_C(   309.91), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(   846.15), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00)) },
    { UINT16_C(24099),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(    39.32), SIMDE_FLOAT32_C(  -489.88), SIMDE_FLOAT32_C(    29.68), SIMDE_FLOAT32_C(   -37.49),
                         SIMDE_FLOAT32_C(  -490.28), SIMDE_FLOAT32_C(  -373.66), SIMDE_FLOAT32_C(   841.53), SIMDE_FLOAT32_C(  -292.35),
                         SIMDE_FLOAT32_C(   526.21), SIMDE_FLOAT32_C(  -835.53), SIMDE_FLOAT32_C(  -203.04), SIMDE_FLOAT32_C(   571.79),
                         SIMDE_FLOAT32_C(   -80.71), SIMDE_FLOAT32_C(   675.92), SIMDE_FLOAT32_C(   632.01), SIMDE_FLOAT32_C(   490.41)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(  -278.32), SIMDE_FLOAT32_C(  -925.69), SIMDE_FLOAT32_C(  -744.41), SIMDE_FLOAT32_C(   717.83)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -489.88), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   -37.49),
                         SIMDE_FLOAT32_C(  -490.28), SIMDE_FLOAT32_C(  -373.66), SIMDE_FLOAT32_C(   841.53), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -203.04), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -744.41), SIMDE_FLOAT32_C(   717.83)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -489.88), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   -37.49),
                         SIMDE_FLOAT32_C(  -490.28), SIMDE_FLOAT32_C(  -373.66), SIMDE_FLOAT32_C(   841.53), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -744.41), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   632.01), SIMDE_FLOAT32_C(   490.41)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -489.88), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   -37.49),
                         SIMDE_FLOAT32_C(  -278.32), SIMDE_FLOAT32_C(  -925.69), SIMDE_FLOAT32_C(  -744.41), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -203.04), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   632.01), SIMDE_FLOAT32_C(   490.41)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -925.69), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   717.83),
                         SIMDE_FLOAT32_C(  -490.28), SIMDE_FLOAT32_C(  -373.66), SIMDE_FLOAT32_C(   841.53), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -203.04), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   632.01), SIMDE_FLOAT32_C(   490.41)) },
    { UINT16_C(31949),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -760.88), SIMDE_FLOAT32_C(   149.72), SIMDE_FLOAT32_C(  -617.12), SIMDE_FLOAT32_C(   213.24),
                         SIMDE_FLOAT32_C(  -751.58), SIMDE_FLOAT32_C(  -577.36), SIMDE_FLOAT32_C(   907.23), SIMDE_FLOAT32_C(   957.37),
                         SIMDE_FLOAT32_C(  -359.60), SIMDE_FLOAT32_C(  -934.92), SIMDE_FLOAT32_C(  -213.75), SIMDE_FLOAT32_C(  -657.02),
                         SIMDE_FLOAT32_C(   403.00), SIMDE_FLOAT32_C(  -629.37), SIMDE_FLOAT32_C(  -198.67), SIMDE_FLOAT32_C(   337.35)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(  -588.28), SIMDE_FLOAT32_C(   846.67), SIMDE_FLOAT32_C(   586.29), SIMDE_FLOAT32_C(   670.52)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   149.72), SIMDE_FLOAT32_C(  -617.12), SIMDE_FLOAT32_C(   213.24),
                         SIMDE_FLOAT32_C(  -751.58), SIMDE_FLOAT32_C(  -577.36), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(  -359.60), SIMDE_FLOAT32_C(  -934.92), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(  -588.28), SIMDE_FLOAT32_C(   846.67), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   670.52)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   149.72), SIMDE_FLOAT32_C(  -617.12), SIMDE_FLOAT32_C(   213.24),
                         SIMDE_FLOAT32_C(  -751.58), SIMDE_FLOAT32_C(  -577.36), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(  -588.28), SIMDE_FLOAT32_C(   846.67), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(   403.00), SIMDE_FLOAT32_C(  -629.37), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   337.35)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   149.72), SIMDE_FLOAT32_C(  -617.12), SIMDE_FLOAT32_C(   213.24),
                         SIMDE_FLOAT32_C(  -588.28), SIMDE_FLOAT32_C(   846.67), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(  -359.60), SIMDE_FLOAT32_C(  -934.92), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(   403.00), SIMDE_FLOAT32_C(  -629.37), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   337.35)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   846.67), SIMDE_FLOAT32_C(   586.29), SIMDE_FLOAT32_C(   670.52),
                         SIMDE_FLOAT32_C(  -751.58), SIMDE_FLOAT32_C(  -577.36), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(  -359.60), SIMDE_FLOAT32_C(  -934.92), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(   403.00), SIMDE_FLOAT32_C(  -629.37), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   337.35)) },
    { UINT16_C(10665),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -432.13), SIMDE_FLOAT32_C(   268.99), SIMDE_FLOAT32_C(  -842.15), SIMDE_FLOAT32_C(  -207.87),
                         SIMDE_FLOAT32_C(   908.84), SIMDE_FLOAT32_C(  -765.42), SIMDE_FLOAT32_C(  -315.78), SIMDE_FLOAT32_C(   138.83),
                         SIMDE_FLOAT32_C(   -86.06), SIMDE_FLOAT32_C(   699.07), SIMDE_FLOAT32_C(  -413.85), SIMDE_FLOAT32_C(  -143.73),
                         SIMDE_FLOAT32_C(   752.26), SIMDE_FLOAT32_C(   709.96), SIMDE_FLOAT32_C(   609.29), SIMDE_FLOAT32_C(  -767.34)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(   873.30), SIMDE_FLOAT32_C(  -820.22), SIMDE_FLOAT32_C(   241.45), SIMDE_FLOAT32_C(  -959.11)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -842.15), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(   908.84), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   138.83),
                         SIMDE_FLOAT32_C(   -86.06), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -413.85), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(   873.30), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -959.11)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -842.15), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(   908.84), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   138.83),
                         SIMDE_FLOAT32_C(   873.30), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   241.45), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(   752.26), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -767.34)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -842.15), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(   873.30), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -959.11),
                         SIMDE_FLOAT32_C(   -86.06), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -413.85), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(   752.26), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -767.34)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   241.45), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(   908.84), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   138.83),
                         SIMDE_FLOAT32_C(   -86.06), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -413.85), SIMDE_FLOAT32_C(     0.00),
                         SIMDE_FLOAT32_C(   752.26), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -767.34)) },
    { UINT16_C(12797),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -173.80), SIMDE_FLOAT32_C(  -492.61), SIMDE_FLOAT32_C(   487.08), SIMDE_FLOAT32_C(   -68.16),
                         SIMDE_FLOAT32_C(   180.78), SIMDE_FLOAT32_C(   717.69), SIMDE_FLOAT32_C(  -289.23), SIMDE_FLOAT32_C(  -663.74),
                         SIMDE_FLOAT32_C(   918.52), SIMDE_FLOAT32_C(   179.29), SIMDE_FLOAT32_C(  -422.76), SIMDE_FLOAT32_C(   989.70),
                         SIMDE_FLOAT32_C(  -433.33), SIMDE_FLOAT32_C(  -695.21), SIMDE_FLOAT32_C(    48.49), SIMDE_FLOAT32_C(  -786.23)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(  -712.24), SIMDE_FLOAT32_C(  -619.50), SIMDE_FLOAT32_C(   518.12), SIMDE_FLOAT32_C(   952.47)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   487.08), SIMDE_FLOAT32_C(   -68.16),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -663.74),
                         SIMDE_FLOAT32_C(   918.52), SIMDE_FLOAT32_C(   179.29), SIMDE_FLOAT32_C(  -422.76), SIMDE_FLOAT32_C(   989.70),
                         SIMDE_FLOAT32_C(  -712.24), SIMDE_FLOAT32_C(  -619.50), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   952.47)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   487.08), SIMDE_FLOAT32_C(   -68.16),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -663.74),
                         SIMDE_FLOAT32_C(  -712.24), SIMDE_FLOAT32_C(  -619.50), SIMDE_FLOAT32_C(   518.12), SIMDE_FLOAT32_C(   952.47),
                         SIMDE_FLOAT32_C(  -433.33), SIMDE_FLOAT32_C(  -695.21), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -786.23)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   487.08), SIMDE_FLOAT32_C(   -68.16),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   952.47),
                         SIMDE_FLOAT32_C(   918.52), SIMDE_FLOAT32_C(   179.29), SIMDE_FLOAT32_C(  -422.76), SIMDE_FLOAT32_C(   989.70),
                         SIMDE_FLOAT32_C(  -433.33), SIMDE_FLOAT32_C(  -695.21), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -786.23)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   518.12), SIMDE_FLOAT32_C(   952.47),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -663.74),
                         SIMDE_FLOAT32_C(   918.52), SIMDE_FLOAT32_C(   179.29), SIMDE_FLOAT32_C(  -422.76), SIMDE_FLOAT32_C(   989.70),
                         SIMDE_FLOAT32_C(  -433.33), SIMDE_FLOAT32_C(  -695.21), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -786.23)) },
    { UINT16_C(46928),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -282.31), SIMDE_FLOAT32_C(  -211.91), SIMDE_FLOAT32_C(  -656.10), SIMDE_FLOAT32_C(  -925.76),
                         SIMDE_FLOAT32_C(  -789.54), SIMDE_FLOAT32_C(  -915.62), SIMDE_FLOAT32_C(  -790.16), SIMDE_FLOAT32_C(   -30.05),
                         SIMDE_FLOAT32_C(  -415.61), SIMDE_FLOAT32_C(   -70.79), SIMDE_FLOAT32_C(   994.61), SIMDE_FLOAT32_C(   493.65),
                         SIMDE_FLOAT32_C(  -659.70), SIMDE_FLOAT32_C(    52.79), SIMDE_FLOAT32_C(   493.30), SIMDE_FLOAT32_C(   835.54)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(  -904.81), SIMDE_FLOAT32_C(   380.83), SIMDE_FLOAT32_C(    50.50), SIMDE_FLOAT32_C(  -236.67)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -282.31), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -656.10), SIMDE_FLOAT32_C(  -925.76),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -915.62), SIMDE_FLOAT32_C(  -790.16), SIMDE_FLOAT32_C(   -30.05),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   -70.79), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   493.65),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -282.31), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -656.10), SIMDE_FLOAT32_C(  -925.76),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -915.62), SIMDE_FLOAT32_C(  -790.16), SIMDE_FLOAT32_C(   -30.05),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   380.83), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -236.67),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -282.31), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -656.10), SIMDE_FLOAT32_C(  -925.76),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   380.83), SIMDE_FLOAT32_C(    50.50), SIMDE_FLOAT32_C(  -236.67),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   -70.79), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   493.65),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -904.81), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(    50.50), SIMDE_FLOAT32_C(  -236.67),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -915.62), SIMDE_FLOAT32_C(  -790.16), SIMDE_FLOAT32_C(   -30.05),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   -70.79), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   493.65),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00)) },
    { UINT16_C(30100),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(  -388.47), SIMDE_FLOAT32_C(  -102.18), SIMDE_FLOAT32_C(  -643.43), SIMDE_FLOAT32_C(   960.00),
                         SIMDE_FLOAT32_C(  -331.34), SIMDE_FLOAT32_C(    22.93), SIMDE_FLOAT32_C(    72.67), SIMDE_FLOAT32_C(  -395.13),
                         SIMDE_FLOAT32_C(  -870.79), SIMDE_FLOAT32_C(   145.63), SIMDE_FLOAT32_C(  -722.44), SIMDE_FLOAT32_C(  -149.04),
                         SIMDE_FLOAT32_C(   529.44), SIMDE_FLOAT32_C(   214.37), SIMDE_FLOAT32_C(  -949.73), SIMDE_FLOAT32_C(  -453.25)),
      simde_mm_set_ps(SIMDE_FLOAT32_C(   602.83), SIMDE_FLOAT32_C(   639.68), SIMDE_FLOAT32_C(     2.55), SIMDE_FLOAT32_C(  -783.00)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -102.18), SIMDE_FLOAT32_C(  -643.43), SIMDE_FLOAT32_C(   960.00),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(    22.93), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -395.13),
                         SIMDE_FLOAT32_C(  -870.79), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -149.04),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   639.68), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -102.18), SIMDE_FLOAT32_C(  -643.43), SIMDE_FLOAT32_C(   960.00),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(    22.93), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -395.13),
                         SIMDE_FLOAT32_C(   602.83), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -783.00),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   214.37), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -102.18), SIMDE_FLOAT32_C(  -643.43), SIMDE_FLOAT32_C(   960.00),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   639.68), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -783.00),
                         SIMDE_FLOAT32_C(  -870.79), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -149.04),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   214.37), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00)),
      simde_mm512_set_ps(SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   639.68), SIMDE_FLOAT32_C(     2.55), SIMDE_FLOAT32_C(  -783.00),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(    22.93), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -395.13),
                         SIMDE_FLOAT32_C(  -870.79), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(  -149.04),
                         SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(   214.37), SIMDE_FLOAT32_C(     0.00), SIMDE_FLOAT32_C(     0.00)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512 r;
    r = simde_mm512_maskz_insertf32x4(test_vec[i].k, test_vec[i].a, test_vec[i].b, 0);
    simde_assert_m512_close(r, test_vec[i].r0, 1);
    r = simde_mm512_maskz_insertf32x4(test_vec[i].k, test_vec[i].a, test_vec[i].b, 1);
    simde_assert_m512_close(r, test_vec[i].r1, 1);
    r = simde_mm512_maskz_insertf32x4(test_vec[i].k, test_vec[i].a, test_vec[i].b, 2);
    simde_assert_m512_close(r, test_vec[i].r2, 1);
    r = simde_mm512_maskz_insertf32x4(test_vec[i].k, test_vec[i].a, test_vec[i].b, 3);
    simde_assert_m512_close(r, test_vec[i].r3, 1);
  }

  return 0;
}

static int
test_simde_mm512_insertf64x4(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512d a;
    simde__m256d b;
    simde__m512d r0;
    simde__m512d r1;
  } test_vec[8] = {
    { simde_mm512_set_pd(SIMDE_FLOAT64_C( -431.26), SIMDE_FLOAT64_C(  481.25),
                         SIMDE_FLOAT64_C(  -57.75), SIMDE_FLOAT64_C( -784.26),
                         SIMDE_FLOAT64_C(  438.04), SIMDE_FLOAT64_C(  549.03),
                         SIMDE_FLOAT64_C(  729.46), SIMDE_FLOAT64_C(  582.53)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C( -465.05), SIMDE_FLOAT64_C(  439.15),
                         SIMDE_FLOAT64_C( -104.57), SIMDE_FLOAT64_C(  -28.15)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -431.26), SIMDE_FLOAT64_C(  481.25),
                         SIMDE_FLOAT64_C(  -57.75), SIMDE_FLOAT64_C( -784.26),
                         SIMDE_FLOAT64_C( -465.05), SIMDE_FLOAT64_C(  439.15),
                         SIMDE_FLOAT64_C( -104.57), SIMDE_FLOAT64_C(  -28.15)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -465.05), SIMDE_FLOAT64_C(  439.15),
                         SIMDE_FLOAT64_C( -104.57), SIMDE_FLOAT64_C(  -28.15),
                         SIMDE_FLOAT64_C(  438.04), SIMDE_FLOAT64_C(  549.03),
                         SIMDE_FLOAT64_C(  729.46), SIMDE_FLOAT64_C(  582.53)) },
    { simde_mm512_set_pd(SIMDE_FLOAT64_C( -202.49), SIMDE_FLOAT64_C( -470.36),
                         SIMDE_FLOAT64_C(  966.37), SIMDE_FLOAT64_C(  135.20),
                         SIMDE_FLOAT64_C( -563.83), SIMDE_FLOAT64_C(  799.30),
                         SIMDE_FLOAT64_C(  938.85), SIMDE_FLOAT64_C( -576.01)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C(  355.11), SIMDE_FLOAT64_C( -787.72),
                         SIMDE_FLOAT64_C(  472.82), SIMDE_FLOAT64_C( -703.51)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -202.49), SIMDE_FLOAT64_C( -470.36),
                         SIMDE_FLOAT64_C(  966.37), SIMDE_FLOAT64_C(  135.20),
                         SIMDE_FLOAT64_C(  355.11), SIMDE_FLOAT64_C( -787.72),
                         SIMDE_FLOAT64_C(  472.82), SIMDE_FLOAT64_C( -703.51)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  355.11), SIMDE_FLOAT64_C( -787.72),
                         SIMDE_FLOAT64_C(  472.82), SIMDE_FLOAT64_C( -703.51),
                         SIMDE_FLOAT64_C( -563.83), SIMDE_FLOAT64_C(  799.30),
                         SIMDE_FLOAT64_C(  938.85), SIMDE_FLOAT64_C( -576.01)) },
    { simde_mm512_set_pd(SIMDE_FLOAT64_C(  120.10), SIMDE_FLOAT64_C(  -64.06),
                         SIMDE_FLOAT64_C( -620.03), SIMDE_FLOAT64_C(  559.81),
                         SIMDE_FLOAT64_C(  185.23), SIMDE_FLOAT64_C( -423.61),
                         SIMDE_FLOAT64_C(  -11.91), SIMDE_FLOAT64_C(  407.56)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C( -743.10), SIMDE_FLOAT64_C( -688.01),
                         SIMDE_FLOAT64_C(  442.76), SIMDE_FLOAT64_C(  931.17)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  120.10), SIMDE_FLOAT64_C(  -64.06),
                         SIMDE_FLOAT64_C( -620.03), SIMDE_FLOAT64_C(  559.81),
                         SIMDE_FLOAT64_C( -743.10), SIMDE_FLOAT64_C( -688.01),
                         SIMDE_FLOAT64_C(  442.76), SIMDE_FLOAT64_C(  931.17)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -743.10), SIMDE_FLOAT64_C( -688.01),
                         SIMDE_FLOAT64_C(  442.76), SIMDE_FLOAT64_C(  931.17),
                         SIMDE_FLOAT64_C(  185.23), SIMDE_FLOAT64_C( -423.61),
                         SIMDE_FLOAT64_C(  -11.91), SIMDE_FLOAT64_C(  407.56)) },
    { simde_mm512_set_pd(SIMDE_FLOAT64_C(  208.07), SIMDE_FLOAT64_C(  -94.60),
                         SIMDE_FLOAT64_C(  834.28), SIMDE_FLOAT64_C(  260.50),
                         SIMDE_FLOAT64_C( -859.51), SIMDE_FLOAT64_C(  -69.45),
                         SIMDE_FLOAT64_C(   40.36), SIMDE_FLOAT64_C(   95.61)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C(  193.01), SIMDE_FLOAT64_C( -435.27),
                         SIMDE_FLOAT64_C(  -84.06), SIMDE_FLOAT64_C(  298.40)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  208.07), SIMDE_FLOAT64_C(  -94.60),
                         SIMDE_FLOAT64_C(  834.28), SIMDE_FLOAT64_C(  260.50),
                         SIMDE_FLOAT64_C(  193.01), SIMDE_FLOAT64_C( -435.27),
                         SIMDE_FLOAT64_C(  -84.06), SIMDE_FLOAT64_C(  298.40)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  193.01), SIMDE_FLOAT64_C( -435.27),
                         SIMDE_FLOAT64_C(  -84.06), SIMDE_FLOAT64_C(  298.40),
                         SIMDE_FLOAT64_C( -859.51), SIMDE_FLOAT64_C(  -69.45),
                         SIMDE_FLOAT64_C(   40.36), SIMDE_FLOAT64_C(   95.61)) },
    { simde_mm512_set_pd(SIMDE_FLOAT64_C(  -98.08), SIMDE_FLOAT64_C(  464.19),
                         SIMDE_FLOAT64_C(  711.12), SIMDE_FLOAT64_C(  282.83),
                         SIMDE_FLOAT64_C( -774.08), SIMDE_FLOAT64_C(  841.24),
                         SIMDE_FLOAT64_C( -414.07), SIMDE_FLOAT64_C(   79.76)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C( -157.33), SIMDE_FLOAT64_C( -819.46),
                         SIMDE_FLOAT64_C(  541.44), SIMDE_FLOAT64_C(  112.81)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  -98.08), SIMDE_FLOAT64_C(  464.19),
                         SIMDE_FLOAT64_C(  711.12), SIMDE_FLOAT64_C(  282.83),
                         SIMDE_FLOAT64_C( -157.33), SIMDE_FLOAT64_C( -819.46),
                         SIMDE_FLOAT64_C(  541.44), SIMDE_FLOAT64_C(  112.81)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -157.33), SIMDE_FLOAT64_C( -819.46),
                         SIMDE_FLOAT64_C(  541.44), SIMDE_FLOAT64_C(  112.81),
                         SIMDE_FLOAT64_C( -774.08), SIMDE_FLOAT64_C(  841.24),
                         SIMDE_FLOAT64_C( -414.07), SIMDE_FLOAT64_C(   79.76)) },
    { simde_mm512_set_pd(SIMDE_FLOAT64_C(  375.27), SIMDE_FLOAT64_C( -966.90),
                         SIMDE_FLOAT64_C( -512.98), SIMDE_FLOAT64_C( -737.78),
                         SIMDE_FLOAT64_C(  664.52), SIMDE_FLOAT64_C( -224.13),
                         SIMDE_FLOAT64_C(  633.65), SIMDE_FLOAT64_C( -834.15)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C(   -2.60), SIMDE_FLOAT64_C(  -38.88),
                         SIMDE_FLOAT64_C(  165.88), SIMDE_FLOAT64_C(  218.73)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  375.27), SIMDE_FLOAT64_C( -966.90),
                         SIMDE_FLOAT64_C( -512.98), SIMDE_FLOAT64_C( -737.78),
                         SIMDE_FLOAT64_C(   -2.60), SIMDE_FLOAT64_C(  -38.88),
                         SIMDE_FLOAT64_C(  165.88), SIMDE_FLOAT64_C(  218.73)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(   -2.60), SIMDE_FLOAT64_C(  -38.88),
                         SIMDE_FLOAT64_C(  165.88), SIMDE_FLOAT64_C(  218.73),
                         SIMDE_FLOAT64_C(  664.52), SIMDE_FLOAT64_C( -224.13),
                         SIMDE_FLOAT64_C(  633.65), SIMDE_FLOAT64_C( -834.15)) },
    { simde_mm512_set_pd(SIMDE_FLOAT64_C(  141.08), SIMDE_FLOAT64_C( -832.50),
                         SIMDE_FLOAT64_C( -990.15), SIMDE_FLOAT64_C(  438.46),
                         SIMDE_FLOAT64_C( -887.47), SIMDE_FLOAT64_C(  336.35),
                         SIMDE_FLOAT64_C( -396.24), SIMDE_FLOAT64_C(   99.21)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C(  -99.37), SIMDE_FLOAT64_C( -151.02),
                         SIMDE_FLOAT64_C(  551.65), SIMDE_FLOAT64_C(  155.58)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  141.08), SIMDE_FLOAT64_C( -832.50),
                         SIMDE_FLOAT64_C( -990.15), SIMDE_FLOAT64_C(  438.46),
                         SIMDE_FLOAT64_C(  -99.37), SIMDE_FLOAT64_C( -151.02),
                         SIMDE_FLOAT64_C(  551.65), SIMDE_FLOAT64_C(  155.58)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  -99.37), SIMDE_FLOAT64_C( -151.02),
                         SIMDE_FLOAT64_C(  551.65), SIMDE_FLOAT64_C(  155.58),
                         SIMDE_FLOAT64_C( -887.47), SIMDE_FLOAT64_C(  336.35),
                         SIMDE_FLOAT64_C( -396.24), SIMDE_FLOAT64_C(   99.21)) },
    { simde_mm512_set_pd(SIMDE_FLOAT64_C(  666.32), SIMDE_FLOAT64_C(  364.80),
                         SIMDE_FLOAT64_C(  759.27), SIMDE_FLOAT64_C( -524.19),
                         SIMDE_FLOAT64_C( -726.51), SIMDE_FLOAT64_C(  381.71),
                         SIMDE_FLOAT64_C(  819.12), SIMDE_FLOAT64_C(  145.28)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C( -179.98), SIMDE_FLOAT64_C(  258.23),
                         SIMDE_FLOAT64_C(  246.22), SIMDE_FLOAT64_C(   97.85)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  666.32), SIMDE_FLOAT64_C(  364.80),
                         SIMDE_FLOAT64_C(  759.27), SIMDE_FLOAT64_C( -524.19),
                         SIMDE_FLOAT64_C( -179.98), SIMDE_FLOAT64_C(  258.23),
                         SIMDE_FLOAT64_C(  246.22), SIMDE_FLOAT64_C(   97.85)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -179.98), SIMDE_FLOAT64_C(  258.23),
                         SIMDE_FLOAT64_C(  246.22), SIMDE_FLOAT64_C(   97.85),
                         SIMDE_FLOAT64_C( -726.51), SIMDE_FLOAT64_C(  381.71),
                         SIMDE_FLOAT64_C(  819.12), SIMDE_FLOAT64_C(  145.28)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512d r;
    r = simde_mm512_insertf64x4(test_vec[i].a, test_vec[i].b, 0);
    simde_assert_m512d_close(r, test_vec[i].r0, 1);
    r = simde_mm512_insertf64x4(test_vec[i].a, test_vec[i].b, 1);
    simde_assert_m512d_close(r, test_vec[i].r1, 1);
  }

  return 0;
}

static int
test_simde_mm512_mask_insertf64x4(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512d src;
    simde__mmask8 k;
    simde__m512d a;
    simde__m256d b;
    simde__m512d r0;
    simde__m512d r1;
  } test_vec[8] = {
    { simde_mm512_set_pd(SIMDE_FLOAT64_C(  160.98), SIMDE_FLOAT64_C( -932.28),
                         SIMDE_FLOAT64_C( -569.99), SIMDE_FLOAT64_C( -327.63),
                         SIMDE_FLOAT64_C( -172.36), SIMDE_FLOAT64_C(  393.53),
                         SIMDE_FLOAT64_C(  128.51), SIMDE_FLOAT64_C( -556.90)),
      UINT8_C( 67),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  522.06), SIMDE_FLOAT64_C( -932.28),
                         SIMDE_FLOAT64_C(  600.12), SIMDE_FLOAT64_C( -491.12),
                         SIMDE_FLOAT64_C( -139.11), SIMDE_FLOAT64_C( -268.86),
                         SIMDE_FLOAT64_C(  -71.72), SIMDE_FLOAT64_C(   98.47)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C( -280.30), SIMDE_FLOAT64_C( -839.80),
                         SIMDE_FLOAT64_C(  128.51), SIMDE_FLOAT64_C( -556.90)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  160.98), SIMDE_FLOAT64_C( -932.28),
                         SIMDE_FLOAT64_C( -569.99), SIMDE_FLOAT64_C( -327.63),
                         SIMDE_FLOAT64_C( -172.36), SIMDE_FLOAT64_C(  393.53),
                         SIMDE_FLOAT64_C(  128.51), SIMDE_FLOAT64_C( -556.90)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  160.98), SIMDE_FLOAT64_C( -839.80),
                         SIMDE_FLOAT64_C( -569.99), SIMDE_FLOAT64_C( -327.63),
                         SIMDE_FLOAT64_C( -172.36), SIMDE_FLOAT64_C(  393.53),
                         SIMDE_FLOAT64_C(  -71.72), SIMDE_FLOAT64_C(   98.47)) },
    { simde_mm512_set_pd(SIMDE_FLOAT64_C(  283.06), SIMDE_FLOAT64_C( -333.94),
                         SIMDE_FLOAT64_C(  903.50), SIMDE_FLOAT64_C(  232.04),
                         SIMDE_FLOAT64_C(  309.91), SIMDE_FLOAT64_C(  846.15),
                         SIMDE_FLOAT64_C( -514.56), SIMDE_FLOAT64_C( -736.92)),
      UINT8_C( 17),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -921.00), SIMDE_FLOAT64_C( -471.60),
                         SIMDE_FLOAT64_C(  483.08), SIMDE_FLOAT64_C(  232.04),
                         SIMDE_FLOAT64_C(  774.81), SIMDE_FLOAT64_C( -599.01),
                         SIMDE_FLOAT64_C(   69.04), SIMDE_FLOAT64_C( -149.02)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C(   51.33), SIMDE_FLOAT64_C( -895.71),
                         SIMDE_FLOAT64_C( -868.59), SIMDE_FLOAT64_C( -736.92)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  283.06), SIMDE_FLOAT64_C( -333.94),
                         SIMDE_FLOAT64_C(  903.50), SIMDE_FLOAT64_C(  232.04),
                         SIMDE_FLOAT64_C(  309.91), SIMDE_FLOAT64_C(  846.15),
                         SIMDE_FLOAT64_C( -514.56), SIMDE_FLOAT64_C( -736.92)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  283.06), SIMDE_FLOAT64_C( -333.94),
                         SIMDE_FLOAT64_C(  903.50), SIMDE_FLOAT64_C( -736.92),
                         SIMDE_FLOAT64_C(  309.91), SIMDE_FLOAT64_C(  846.15),
                         SIMDE_FLOAT64_C( -514.56), SIMDE_FLOAT64_C( -149.02)) },
    { simde_mm512_set_pd(SIMDE_FLOAT64_C(   29.68), SIMDE_FLOAT64_C( -490.28),
                         SIMDE_FLOAT64_C( -373.66), SIMDE_FLOAT64_C(  526.21),
                         SIMDE_FLOAT64_C( -925.69), SIMDE_FLOAT64_C(  -80.71),
                         SIMDE_FLOAT64_C(  717.83), SIMDE_FLOAT64_C(   39.32)),
      UINT8_C( 43),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -489.88), SIMDE_FLOAT64_C(  -37.49),
                         SIMDE_FLOAT64_C( -373.66), SIMDE_FLOAT64_C( -292.35),
                         SIMDE_FLOAT64_C( -835.53), SIMDE_FLOAT64_C(  571.79),
                         SIMDE_FLOAT64_C(  675.92), SIMDE_FLOAT64_C(  490.41)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C( -925.69), SIMDE_FLOAT64_C( -744.41),
                         SIMDE_FLOAT64_C(  717.83), SIMDE_FLOAT64_C(   39.32)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(   29.68), SIMDE_FLOAT64_C( -490.28),
                         SIMDE_FLOAT64_C( -373.66), SIMDE_FLOAT64_C(  526.21),
                         SIMDE_FLOAT64_C( -925.69), SIMDE_FLOAT64_C(  -80.71),
                         SIMDE_FLOAT64_C(  717.83), SIMDE_FLOAT64_C(   39.32)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(   29.68), SIMDE_FLOAT64_C( -490.28),
                         SIMDE_FLOAT64_C(  717.83), SIMDE_FLOAT64_C(  526.21),
                         SIMDE_FLOAT64_C( -835.53), SIMDE_FLOAT64_C(  -80.71),
                         SIMDE_FLOAT64_C(  675.92), SIMDE_FLOAT64_C(  490.41)) },
    { simde_mm512_set_pd(SIMDE_FLOAT64_C( -617.12), SIMDE_FLOAT64_C(  213.24),
                         SIMDE_FLOAT64_C( -577.36), SIMDE_FLOAT64_C(  957.37),
                         SIMDE_FLOAT64_C(  846.67), SIMDE_FLOAT64_C(  403.00),
                         SIMDE_FLOAT64_C( -198.67), SIMDE_FLOAT64_C(  447.98)),
      UINT8_C(120),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  149.72), SIMDE_FLOAT64_C(  213.24),
                         SIMDE_FLOAT64_C( -577.36), SIMDE_FLOAT64_C(  957.37),
                         SIMDE_FLOAT64_C( -934.92), SIMDE_FLOAT64_C( -657.02),
                         SIMDE_FLOAT64_C( -629.37), SIMDE_FLOAT64_C(  337.35)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C(  846.67), SIMDE_FLOAT64_C(  586.29),
                         SIMDE_FLOAT64_C(  670.52), SIMDE_FLOAT64_C( -760.88)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -617.12), SIMDE_FLOAT64_C(  213.24),
                         SIMDE_FLOAT64_C( -577.36), SIMDE_FLOAT64_C(  957.37),
                         SIMDE_FLOAT64_C(  846.67), SIMDE_FLOAT64_C(  403.00),
                         SIMDE_FLOAT64_C( -198.67), SIMDE_FLOAT64_C(  447.98)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -617.12), SIMDE_FLOAT64_C(  586.29),
                         SIMDE_FLOAT64_C(  670.52), SIMDE_FLOAT64_C( -760.88),
                         SIMDE_FLOAT64_C( -934.92), SIMDE_FLOAT64_C(  403.00),
                         SIMDE_FLOAT64_C( -198.67), SIMDE_FLOAT64_C(  447.98)) },
    { simde_mm512_set_pd(SIMDE_FLOAT64_C(  268.99), SIMDE_FLOAT64_C( -207.87),
                         SIMDE_FLOAT64_C( -765.42), SIMDE_FLOAT64_C(  138.83),
                         SIMDE_FLOAT64_C( -413.85), SIMDE_FLOAT64_C(  241.45),
                         SIMDE_FLOAT64_C(  609.29), SIMDE_FLOAT64_C( -432.13)),
      UINT8_C(245),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  268.99), SIMDE_FLOAT64_C( -207.87),
                         SIMDE_FLOAT64_C( -765.42), SIMDE_FLOAT64_C(  138.83),
                         SIMDE_FLOAT64_C(  699.07), SIMDE_FLOAT64_C( -143.73),
                         SIMDE_FLOAT64_C(  709.96), SIMDE_FLOAT64_C( -767.34)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C( -820.22), SIMDE_FLOAT64_C(  241.45),
                         SIMDE_FLOAT64_C( -959.11), SIMDE_FLOAT64_C( -432.13)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  268.99), SIMDE_FLOAT64_C( -207.87),
                         SIMDE_FLOAT64_C( -765.42), SIMDE_FLOAT64_C(  138.83),
                         SIMDE_FLOAT64_C( -413.85), SIMDE_FLOAT64_C(  241.45),
                         SIMDE_FLOAT64_C(  609.29), SIMDE_FLOAT64_C( -432.13)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -820.22), SIMDE_FLOAT64_C(  241.45),
                         SIMDE_FLOAT64_C( -959.11), SIMDE_FLOAT64_C( -432.13),
                         SIMDE_FLOAT64_C( -413.85), SIMDE_FLOAT64_C( -143.73),
                         SIMDE_FLOAT64_C(  609.29), SIMDE_FLOAT64_C( -767.34)) },
    { simde_mm512_set_pd(SIMDE_FLOAT64_C(  487.08), SIMDE_FLOAT64_C(  -68.16),
                         SIMDE_FLOAT64_C( -289.23), SIMDE_FLOAT64_C(  918.52),
                         SIMDE_FLOAT64_C( -422.76), SIMDE_FLOAT64_C(  518.12),
                         SIMDE_FLOAT64_C(  952.47), SIMDE_FLOAT64_C( -173.80)),
      UINT8_C( 71),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -492.61), SIMDE_FLOAT64_C(  -68.16),
                         SIMDE_FLOAT64_C(  717.69), SIMDE_FLOAT64_C( -663.74),
                         SIMDE_FLOAT64_C(  179.29), SIMDE_FLOAT64_C(  989.70),
                         SIMDE_FLOAT64_C( -695.21), SIMDE_FLOAT64_C( -786.23)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C( -619.50), SIMDE_FLOAT64_C(  518.12),
                         SIMDE_FLOAT64_C(  952.47), SIMDE_FLOAT64_C( -173.80)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  487.08), SIMDE_FLOAT64_C(  -68.16),
                         SIMDE_FLOAT64_C( -289.23), SIMDE_FLOAT64_C(  918.52),
                         SIMDE_FLOAT64_C( -422.76), SIMDE_FLOAT64_C(  518.12),
                         SIMDE_FLOAT64_C(  952.47), SIMDE_FLOAT64_C( -173.80)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  487.08), SIMDE_FLOAT64_C(  518.12),
                         SIMDE_FLOAT64_C( -289.23), SIMDE_FLOAT64_C(  918.52),
                         SIMDE_FLOAT64_C( -422.76), SIMDE_FLOAT64_C(  989.70),
                         SIMDE_FLOAT64_C( -695.21), SIMDE_FLOAT64_C( -786.23)) },
    { simde_mm512_set_pd(SIMDE_FLOAT64_C( -656.10), SIMDE_FLOAT64_C( -789.54),
                         SIMDE_FLOAT64_C( -790.16), SIMDE_FLOAT64_C(  -30.05),
                         SIMDE_FLOAT64_C(  994.61), SIMDE_FLOAT64_C(   50.50),
                         SIMDE_FLOAT64_C(  493.30), SIMDE_FLOAT64_C(  831.29)),
      UINT8_C( 20),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -211.91), SIMDE_FLOAT64_C( -925.76),
                         SIMDE_FLOAT64_C( -915.62), SIMDE_FLOAT64_C(  -30.05),
                         SIMDE_FLOAT64_C(  -70.79), SIMDE_FLOAT64_C(  493.65),
                         SIMDE_FLOAT64_C(   52.79), SIMDE_FLOAT64_C(  835.54)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C(  380.83), SIMDE_FLOAT64_C(   50.50),
                         SIMDE_FLOAT64_C( -236.67), SIMDE_FLOAT64_C( -282.31)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -656.10), SIMDE_FLOAT64_C( -789.54),
                         SIMDE_FLOAT64_C( -790.16), SIMDE_FLOAT64_C(  -30.05),
                         SIMDE_FLOAT64_C(  994.61), SIMDE_FLOAT64_C(   50.50),
                         SIMDE_FLOAT64_C(  493.30), SIMDE_FLOAT64_C(  831.29)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -656.10), SIMDE_FLOAT64_C( -789.54),
                         SIMDE_FLOAT64_C( -790.16), SIMDE_FLOAT64_C( -282.31),
                         SIMDE_FLOAT64_C(  994.61), SIMDE_FLOAT64_C(  493.65),
                         SIMDE_FLOAT64_C(  493.30), SIMDE_FLOAT64_C(  831.29)) },
    { simde_mm512_set_pd(SIMDE_FLOAT64_C( -643.43), SIMDE_FLOAT64_C( -331.34),
                         SIMDE_FLOAT64_C(   22.93), SIMDE_FLOAT64_C( -395.13),
                         SIMDE_FLOAT64_C(  639.68), SIMDE_FLOAT64_C(    2.55),
                         SIMDE_FLOAT64_C( -949.73), SIMDE_FLOAT64_C( -388.47)),
      UINT8_C( 61),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -102.18), SIMDE_FLOAT64_C(  960.00),
                         SIMDE_FLOAT64_C(   22.93), SIMDE_FLOAT64_C( -395.13),
                         SIMDE_FLOAT64_C(  145.63), SIMDE_FLOAT64_C( -149.04),
                         SIMDE_FLOAT64_C(  214.37), SIMDE_FLOAT64_C( -453.25)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C(  639.68), SIMDE_FLOAT64_C(    2.55),
                         SIMDE_FLOAT64_C( -783.00), SIMDE_FLOAT64_C( -388.47)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -643.43), SIMDE_FLOAT64_C( -331.34),
                         SIMDE_FLOAT64_C(   22.93), SIMDE_FLOAT64_C( -395.13),
                         SIMDE_FLOAT64_C(  639.68), SIMDE_FLOAT64_C(    2.55),
                         SIMDE_FLOAT64_C( -949.73), SIMDE_FLOAT64_C( -388.47)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -643.43), SIMDE_FLOAT64_C( -331.34),
                         SIMDE_FLOAT64_C( -783.00), SIMDE_FLOAT64_C( -388.47),
                         SIMDE_FLOAT64_C(  145.63), SIMDE_FLOAT64_C( -149.04),
                         SIMDE_FLOAT64_C( -949.73), SIMDE_FLOAT64_C( -453.25)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512d r;
    r = simde_mm512_mask_insertf64x4(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b, 0);
    simde_assert_m512d_close(r, test_vec[i].r0, 1);
    r = simde_mm512_mask_insertf64x4(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b, 1);
    simde_assert_m512d_close(r, test_vec[i].r1, 1);
  }

  return 0;
}

static int
test_simde_mm512_maskz_insertf64x4(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask8 k;
    simde__m512d a;
    simde__m256d b;
    simde__m512d r0;
    simde__m512d r1;
  } test_vec[8] = {
    { UINT8_C( 32),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -139.11), SIMDE_FLOAT64_C( -172.36),
                         SIMDE_FLOAT64_C( -268.86), SIMDE_FLOAT64_C(  393.53),
                         SIMDE_FLOAT64_C(  -71.72), SIMDE_FLOAT64_C(   36.69),
                         SIMDE_FLOAT64_C(   98.47), SIMDE_FLOAT64_C( -135.52)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C(  600.12), SIMDE_FLOAT64_C( -569.99),
                         SIMDE_FLOAT64_C( -491.12), SIMDE_FLOAT64_C( -327.63)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C( -268.86), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C( -491.12), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00)) },
    { UINT8_C(109),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  240.79), SIMDE_FLOAT64_C( -280.30),
                         SIMDE_FLOAT64_C( -839.80), SIMDE_FLOAT64_C(  128.51),
                         SIMDE_FLOAT64_C( -556.90), SIMDE_FLOAT64_C(  522.06),
                         SIMDE_FLOAT64_C(  160.98), SIMDE_FLOAT64_C( -932.28)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C(   69.04), SIMDE_FLOAT64_C( -514.56),
                         SIMDE_FLOAT64_C( -149.02), SIMDE_FLOAT64_C( -860.98)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C( -280.30),
                         SIMDE_FLOAT64_C( -839.80), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C(   69.04), SIMDE_FLOAT64_C( -514.56),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C( -860.98)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C( -514.56),
                         SIMDE_FLOAT64_C( -149.02), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C( -556.90), SIMDE_FLOAT64_C(  522.06),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C( -932.28)) },
    { UINT8_C( 64),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -333.94), SIMDE_FLOAT64_C(  483.08),
                         SIMDE_FLOAT64_C(  903.50), SIMDE_FLOAT64_C(  232.04),
                         SIMDE_FLOAT64_C(  -43.35), SIMDE_FLOAT64_C(  774.81),
                         SIMDE_FLOAT64_C(  309.91), SIMDE_FLOAT64_C( -599.01)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C( -736.92), SIMDE_FLOAT64_C( -921.00),
                         SIMDE_FLOAT64_C(  283.06), SIMDE_FLOAT64_C( -471.60)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(  483.08),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C( -921.00),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00)) },
    { UINT8_C(  7),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  -80.71), SIMDE_FLOAT64_C(  675.92),
                         SIMDE_FLOAT64_C(  632.01), SIMDE_FLOAT64_C(  490.41),
                         SIMDE_FLOAT64_C(  456.89), SIMDE_FLOAT64_C(   47.59),
                         SIMDE_FLOAT64_C(   51.33), SIMDE_FLOAT64_C( -895.71)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C(  526.21), SIMDE_FLOAT64_C( -835.53),
                         SIMDE_FLOAT64_C( -203.04), SIMDE_FLOAT64_C(  571.79)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C( -835.53),
                         SIMDE_FLOAT64_C( -203.04), SIMDE_FLOAT64_C(  571.79)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(   47.59),
                         SIMDE_FLOAT64_C(   51.33), SIMDE_FLOAT64_C( -895.71)) },
    { UINT8_C(100),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  717.83), SIMDE_FLOAT64_C(   39.32),
                         SIMDE_FLOAT64_C( -489.88), SIMDE_FLOAT64_C(   29.68),
                         SIMDE_FLOAT64_C(  -37.49), SIMDE_FLOAT64_C( -490.28),
                         SIMDE_FLOAT64_C( -373.66), SIMDE_FLOAT64_C(  841.53)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C(  447.98), SIMDE_FLOAT64_C( -278.32),
                         SIMDE_FLOAT64_C( -925.69), SIMDE_FLOAT64_C( -744.41)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(   39.32),
                         SIMDE_FLOAT64_C( -489.88), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C( -278.32),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C( -278.32),
                         SIMDE_FLOAT64_C( -925.69), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C( -490.28),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00)) },
    { UINT8_C( 84),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  957.37), SIMDE_FLOAT64_C( -359.60),
                         SIMDE_FLOAT64_C( -934.92), SIMDE_FLOAT64_C( -213.75),
                         SIMDE_FLOAT64_C( -657.02), SIMDE_FLOAT64_C(  403.00),
                         SIMDE_FLOAT64_C( -629.37), SIMDE_FLOAT64_C( -198.67)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C(  213.24), SIMDE_FLOAT64_C( -751.58),
                         SIMDE_FLOAT64_C( -577.36), SIMDE_FLOAT64_C(  907.23)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C( -359.60),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C( -213.75),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C( -751.58),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C( -751.58),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(  907.23),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(  403.00),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00)) },
    { UINT8_C( 14),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -767.34), SIMDE_FLOAT64_C(  878.85),
                         SIMDE_FLOAT64_C( -588.28), SIMDE_FLOAT64_C(  846.67),
                         SIMDE_FLOAT64_C(  586.29), SIMDE_FLOAT64_C(  670.52),
                         SIMDE_FLOAT64_C( -760.88), SIMDE_FLOAT64_C(  149.72)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C( -143.73), SIMDE_FLOAT64_C(  752.26),
                         SIMDE_FLOAT64_C(  709.96), SIMDE_FLOAT64_C(  609.29)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C( -143.73), SIMDE_FLOAT64_C(  752.26),
                         SIMDE_FLOAT64_C(  709.96), SIMDE_FLOAT64_C(    0.00)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C(  586.29), SIMDE_FLOAT64_C(  670.52),
                         SIMDE_FLOAT64_C( -760.88), SIMDE_FLOAT64_C(    0.00)) },
    { UINT8_C(237),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -842.15), SIMDE_FLOAT64_C( -207.87),
                         SIMDE_FLOAT64_C(  908.84), SIMDE_FLOAT64_C( -765.42),
                         SIMDE_FLOAT64_C( -315.78), SIMDE_FLOAT64_C(  138.83),
                         SIMDE_FLOAT64_C(  -86.06), SIMDE_FLOAT64_C(  699.07)),
      simde_mm256_set_pd(SIMDE_FLOAT64_C(  241.45), SIMDE_FLOAT64_C( -959.11),
                         SIMDE_FLOAT64_C( -432.13), SIMDE_FLOAT64_C(  268.99)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C( -842.15), SIMDE_FLOAT64_C( -207.87),
                         SIMDE_FLOAT64_C(  908.84), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C(  241.45), SIMDE_FLOAT64_C( -959.11),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(  268.99)),
      simde_mm512_set_pd(SIMDE_FLOAT64_C(  241.45), SIMDE_FLOAT64_C( -959.11),
                         SIMDE_FLOAT64_C( -432.13), SIMDE_FLOAT64_C(    0.00),
                         SIMDE_FLOAT64_C( -315.78), SIMDE_FLOAT64_C(  138.83),
                         SIMDE_FLOAT64_C(    0.00), SIMDE_FLOAT64_C(  699.07)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512d r;
    r = simde_mm512_maskz_insertf64x4(test_vec[i].k, test_vec[i].a, test_vec[i].b, 0);
    simde_assert_m512d_close(r, test_vec[i].r0, 1);
    r = simde_mm512_maskz_insertf64x4(test_vec[i].k, test_vec[i].a, test_vec[i].b, 1);
    simde_assert_m512d_close(r, test_vec[i].r1, 1);
  }

  return 0;
}

static int
test_simde_mm512_inserti32x4(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i a;
    simde__m128i b;
    simde__m512i r0;
    simde__m512i r1;
    simde__m512i r2;
    simde__m512i r3;
  } test_vec[8] = {
    { simde_mm512_set_epi32(INT32_C(-1026363374), INT32_C(-1801776439), INT32_C(  145438126), INT32_C(-1306064352),
                            INT32_C( -858736392), INT32_C(  923442479), INT32_C( 1092805562), INT32_C( 1443901717),
                            INT32_C( 1848749100), INT32_C( 1777333881), INT32_C( 1570116932), INT32_C(-1302383354),
                            INT32_C( 1993455974), INT32_C(-2068684593), INT32_C(-1936012201), INT32_C( 1856459607)),
      simde_mm_set_epi32(INT32_C( 1545554432), INT32_C(  344023940), INT32_C(-1871515754), INT32_C(  951544639)),
      simde_mm512_set_epi32(INT32_C(-1026363374), INT32_C(-1801776439), INT32_C(  145438126), INT32_C(-1306064352),
                            INT32_C( -858736392), INT32_C(  923442479), INT32_C( 1092805562), INT32_C( 1443901717),
                            INT32_C( 1848749100), INT32_C( 1777333881), INT32_C( 1570116932), INT32_C(-1302383354),
                            INT32_C( 1545554432), INT32_C(  344023940), INT32_C(-1871515754), INT32_C(  951544639)),
      simde_mm512_set_epi32(INT32_C(-1026363374), INT32_C(-1801776439), INT32_C(  145438126), INT32_C(-1306064352),
                            INT32_C( -858736392), INT32_C(  923442479), INT32_C( 1092805562), INT32_C( 1443901717),
                            INT32_C( 1545554432), INT32_C(  344023940), INT32_C(-1871515754), INT32_C(  951544639),
                            INT32_C( 1993455974), INT32_C(-2068684593), INT32_C(-1936012201), INT32_C( 1856459607)),
      simde_mm512_set_epi32(INT32_C(-1026363374), INT32_C(-1801776439), INT32_C(  145438126), INT32_C(-1306064352),
                            INT32_C( 1545554432), INT32_C(  344023940), INT32_C(-1871515754), INT32_C(  951544639),
                            INT32_C( 1848749100), INT32_C( 1777333881), INT32_C( 1570116932), INT32_C(-1302383354),
                            INT32_C( 1993455974), INT32_C(-2068684593), INT32_C(-1936012201), INT32_C( 1856459607)),
      simde_mm512_set_epi32(INT32_C( 1545554432), INT32_C(  344023940), INT32_C(-1871515754), INT32_C(  951544639),
                            INT32_C( -858736392), INT32_C(  923442479), INT32_C( 1092805562), INT32_C( 1443901717),
                            INT32_C( 1848749100), INT32_C( 1777333881), INT32_C( 1570116932), INT32_C(-1302383354),
                            INT32_C( 1993455974), INT32_C(-2068684593), INT32_C(-1936012201), INT32_C( 1856459607)) },
    { simde_mm512_set_epi32(INT32_C(-1539616610), INT32_C( 1134735685), INT32_C( 1430356381), INT32_C(-1110068455),
                            INT32_C( -207240031), INT32_C(-1649179267), INT32_C( 2054398444), INT32_C( -483586503),
                            INT32_C(-1481960002), INT32_C(  861125508), INT32_C( -330381203), INT32_C(-1999224530),
                            INT32_C( 1042470181), INT32_C( 1827473477), INT32_C(  298546792), INT32_C(-1630396605)),
      simde_mm_set_epi32(INT32_C(  223952317), INT32_C(  282198336), INT32_C(  564965997), INT32_C(  169645898)),
      simde_mm512_set_epi32(INT32_C(-1539616610), INT32_C( 1134735685), INT32_C( 1430356381), INT32_C(-1110068455),
                            INT32_C( -207240031), INT32_C(-1649179267), INT32_C( 2054398444), INT32_C( -483586503),
                            INT32_C(-1481960002), INT32_C(  861125508), INT32_C( -330381203), INT32_C(-1999224530),
                            INT32_C(  223952317), INT32_C(  282198336), INT32_C(  564965997), INT32_C(  169645898)),
      simde_mm512_set_epi32(INT32_C(-1539616610), INT32_C( 1134735685), INT32_C( 1430356381), INT32_C(-1110068455),
                            INT32_C( -207240031), INT32_C(-1649179267), INT32_C( 2054398444), INT32_C( -483586503),
                            INT32_C(  223952317), INT32_C(  282198336), INT32_C(  564965997), INT32_C(  169645898),
                            INT32_C( 1042470181), INT32_C( 1827473477), INT32_C(  298546792), INT32_C(-1630396605)),
      simde_mm512_set_epi32(INT32_C(-1539616610), INT32_C( 1134735685), INT32_C( 1430356381), INT32_C(-1110068455),
                            INT32_C(  223952317), INT32_C(  282198336), INT32_C(  564965997), INT32_C(  169645898),
                            INT32_C(-1481960002), INT32_C(  861125508), INT32_C( -330381203), INT32_C(-1999224530),
                            INT32_C( 1042470181), INT32_C( 1827473477), INT32_C(  298546792), INT32_C(-1630396605)),
      simde_mm512_set_epi32(INT32_C(  223952317), INT32_C(  282198336), INT32_C(  564965997), INT32_C(  169645898),
                            INT32_C( -207240031), INT32_C(-1649179267), INT32_C( 2054398444), INT32_C( -483586503),
                            INT32_C(-1481960002), INT32_C(  861125508), INT32_C( -330381203), INT32_C(-1999224530),
                            INT32_C( 1042470181), INT32_C( 1827473477), INT32_C(  298546792), INT32_C(-1630396605)) },
    { simde_mm512_set_epi32(INT32_C( 2066979701), INT32_C( 1094609712), INT32_C( 1345059025), INT32_C( -340318359),
                            INT32_C( 1519671047), INT32_C(-1017461983), INT32_C(  353198331), INT32_C( 1711460779),
                            INT32_C( -919570191), INT32_C( 1974152373), INT32_C( -695949043), INT32_C( -790242624),
                            INT32_C(-1094331335), INT32_C(-1166320093), INT32_C(-2045280751), INT32_C(-2037261521)),
      simde_mm_set_epi32(INT32_C( -605945909), INT32_C(-2063050181), INT32_C( 1095467003), INT32_C(-2083755741)),
      simde_mm512_set_epi32(INT32_C( 2066979701), INT32_C( 1094609712), INT32_C( 1345059025), INT32_C( -340318359),
                            INT32_C( 1519671047), INT32_C(-1017461983), INT32_C(  353198331), INT32_C( 1711460779),
                            INT32_C( -919570191), INT32_C( 1974152373), INT32_C( -695949043), INT32_C( -790242624),
                            INT32_C( -605945909), INT32_C(-2063050181), INT32_C( 1095467003), INT32_C(-2083755741)),
      simde_mm512_set_epi32(INT32_C( 2066979701), INT32_C( 1094609712), INT32_C( 1345059025), INT32_C( -340318359),
                            INT32_C( 1519671047), INT32_C(-1017461983), INT32_C(  353198331), INT32_C( 1711460779),
                            INT32_C( -605945909), INT32_C(-2063050181), INT32_C( 1095467003), INT32_C(-2083755741),
                            INT32_C(-1094331335), INT32_C(-1166320093), INT32_C(-2045280751), INT32_C(-2037261521)),
      simde_mm512_set_epi32(INT32_C( 2066979701), INT32_C( 1094609712), INT32_C( 1345059025), INT32_C( -340318359),
                            INT32_C( -605945909), INT32_C(-2063050181), INT32_C( 1095467003), INT32_C(-2083755741),
                            INT32_C( -919570191), INT32_C( 1974152373), INT32_C( -695949043), INT32_C( -790242624),
                            INT32_C(-1094331335), INT32_C(-1166320093), INT32_C(-2045280751), INT32_C(-2037261521)),
      simde_mm512_set_epi32(INT32_C( -605945909), INT32_C(-2063050181), INT32_C( 1095467003), INT32_C(-2083755741),
                            INT32_C( 1519671047), INT32_C(-1017461983), INT32_C(  353198331), INT32_C( 1711460779),
                            INT32_C( -919570191), INT32_C( 1974152373), INT32_C( -695949043), INT32_C( -790242624),
                            INT32_C(-1094331335), INT32_C(-1166320093), INT32_C(-2045280751), INT32_C(-2037261521)) },
    { simde_mm512_set_epi32(INT32_C(  533478787), INT32_C(  907615417), INT32_C( -199229058), INT32_C(  -91537812),
                            INT32_C( 1375258232), INT32_C(  139748399), INT32_C( 1688468565), INT32_C(  736544549),
                            INT32_C(-1282057552), INT32_C(  795925067), INT32_C( 1720852541), INT32_C(-1423023772),
                            INT32_C(-1185448755), INT32_C( 1549802795), INT32_C(  159583350), INT32_C(  548883180)),
      simde_mm_set_epi32(INT32_C(  513515868), INT32_C(-1825967755), INT32_C(  822222164), INT32_C(-1689559027)),
      simde_mm512_set_epi32(INT32_C(  533478787), INT32_C(  907615417), INT32_C( -199229058), INT32_C(  -91537812),
                            INT32_C( 1375258232), INT32_C(  139748399), INT32_C( 1688468565), INT32_C(  736544549),
                            INT32_C(-1282057552), INT32_C(  795925067), INT32_C( 1720852541), INT32_C(-1423023772),
                            INT32_C(  513515868), INT32_C(-1825967755), INT32_C(  822222164), INT32_C(-1689559027)),
      simde_mm512_set_epi32(INT32_C(  533478787), INT32_C(  907615417), INT32_C( -199229058), INT32_C(  -91537812),
                            INT32_C( 1375258232), INT32_C(  139748399), INT32_C( 1688468565), INT32_C(  736544549),
                            INT32_C(  513515868), INT32_C(-1825967755), INT32_C(  822222164), INT32_C(-1689559027),
                            INT32_C(-1185448755), INT32_C( 1549802795), INT32_C(  159583350), INT32_C(  548883180)),
      simde_mm512_set_epi32(INT32_C(  533478787), INT32_C(  907615417), INT32_C( -199229058), INT32_C(  -91537812),
                            INT32_C(  513515868), INT32_C(-1825967755), INT32_C(  822222164), INT32_C(-1689559027),
                            INT32_C(-1282057552), INT32_C(  795925067), INT32_C( 1720852541), INT32_C(-1423023772),
                            INT32_C(-1185448755), INT32_C( 1549802795), INT32_C(  159583350), INT32_C(  548883180)),
      simde_mm512_set_epi32(INT32_C(  513515868), INT32_C(-1825967755), INT32_C(  822222164), INT32_C(-1689559027),
                            INT32_C( 1375258232), INT32_C(  139748399), INT32_C( 1688468565), INT32_C(  736544549),
                            INT32_C(-1282057552), INT32_C(  795925067), INT32_C( 1720852541), INT32_C(-1423023772),
                            INT32_C(-1185448755), INT32_C( 1549802795), INT32_C(  159583350), INT32_C(  548883180)) },
    { simde_mm512_set_epi32(INT32_C(  503748315), INT32_C( 1469355417), INT32_C(-1849349632), INT32_C( 1962664621),
                            INT32_C( -646247370), INT32_C( 1258747662), INT32_C( 1838830023), INT32_C( -532007659),
                            INT32_C( -622852205), INT32_C( -839037220), INT32_C(  499633910), INT32_C( -260167255),
                            INT32_C(  884163960), INT32_C( -329275629), INT32_C( -888441293), INT32_C( -707551350)),
      simde_mm_set_epi32(INT32_C(-1569831145), INT32_C(  338985942), INT32_C( 1701079465), INT32_C( -195770682)),
      simde_mm512_set_epi32(INT32_C(  503748315), INT32_C( 1469355417), INT32_C(-1849349632), INT32_C( 1962664621),
                            INT32_C( -646247370), INT32_C( 1258747662), INT32_C( 1838830023), INT32_C( -532007659),
                            INT32_C( -622852205), INT32_C( -839037220), INT32_C(  499633910), INT32_C( -260167255),
                            INT32_C(-1569831145), INT32_C(  338985942), INT32_C( 1701079465), INT32_C( -195770682)),
      simde_mm512_set_epi32(INT32_C(  503748315), INT32_C( 1469355417), INT32_C(-1849349632), INT32_C( 1962664621),
                            INT32_C( -646247370), INT32_C( 1258747662), INT32_C( 1838830023), INT32_C( -532007659),
                            INT32_C(-1569831145), INT32_C(  338985942), INT32_C( 1701079465), INT32_C( -195770682),
                            INT32_C(  884163960), INT32_C( -329275629), INT32_C( -888441293), INT32_C( -707551350)),
      simde_mm512_set_epi32(INT32_C(  503748315), INT32_C( 1469355417), INT32_C(-1849349632), INT32_C( 1962664621),
                            INT32_C(-1569831145), INT32_C(  338985942), INT32_C( 1701079465), INT32_C( -195770682),
                            INT32_C( -622852205), INT32_C( -839037220), INT32_C(  499633910), INT32_C( -260167255),
                            INT32_C(  884163960), INT32_C( -329275629), INT32_C( -888441293), INT32_C( -707551350)),
      simde_mm512_set_epi32(INT32_C(-1569831145), INT32_C(  338985942), INT32_C( 1701079465), INT32_C( -195770682),
                            INT32_C( -646247370), INT32_C( 1258747662), INT32_C( 1838830023), INT32_C( -532007659),
                            INT32_C( -622852205), INT32_C( -839037220), INT32_C(  499633910), INT32_C( -260167255),
                            INT32_C(  884163960), INT32_C( -329275629), INT32_C( -888441293), INT32_C( -707551350)) },
    { simde_mm512_set_epi32(INT32_C( 1526367108), INT32_C(  722122834), INT32_C( -174985661), INT32_C(-1762469023),
                            INT32_C( 1239606494), INT32_C(  -22119232), INT32_C( 1216907749), INT32_C(  654527510),
                            INT32_C(-2043358500), INT32_C(  459072440), INT32_C( -430427651), INT32_C( -272088075),
                            INT32_C(  386072301), INT32_C(-1628984154), INT32_C(   87817524), INT32_C( 1219490517)),
      simde_mm_set_epi32(INT32_C(-1101477862), INT32_C( 2001101785), INT32_C(-1759250988), INT32_C( -606254738)),
      simde_mm512_set_epi32(INT32_C( 1526367108), INT32_C(  722122834), INT32_C( -174985661), INT32_C(-1762469023),
                            INT32_C( 1239606494), INT32_C(  -22119232), INT32_C( 1216907749), INT32_C(  654527510),
                            INT32_C(-2043358500), INT32_C(  459072440), INT32_C( -430427651), INT32_C( -272088075),
                            INT32_C(-1101477862), INT32_C( 2001101785), INT32_C(-1759250988), INT32_C( -606254738)),
      simde_mm512_set_epi32(INT32_C( 1526367108), INT32_C(  722122834), INT32_C( -174985661), INT32_C(-1762469023),
                            INT32_C( 1239606494), INT32_C(  -22119232), INT32_C( 1216907749), INT32_C(  654527510),
                            INT32_C(-1101477862), INT32_C( 2001101785), INT32_C(-1759250988), INT32_C( -606254738),
                            INT32_C(  386072301), INT32_C(-1628984154), INT32_C(   87817524), INT32_C( 1219490517)),
      simde_mm512_set_epi32(INT32_C( 1526367108), INT32_C(  722122834), INT32_C( -174985661), INT32_C(-1762469023),
                            INT32_C(-1101477862), INT32_C( 2001101785), INT32_C(-1759250988), INT32_C( -606254738),
                            INT32_C(-2043358500), INT32_C(  459072440), INT32_C( -430427651), INT32_C( -272088075),
                            INT32_C(  386072301), INT32_C(-1628984154), INT32_C(   87817524), INT32_C( 1219490517)),
      simde_mm512_set_epi32(INT32_C(-1101477862), INT32_C( 2001101785), INT32_C(-1759250988), INT32_C( -606254738),
                            INT32_C( 1239606494), INT32_C(  -22119232), INT32_C( 1216907749), INT32_C(  654527510),
                            INT32_C(-2043358500), INT32_C(  459072440), INT32_C( -430427651), INT32_C( -272088075),
                            INT32_C(  386072301), INT32_C(-1628984154), INT32_C(   87817524), INT32_C( 1219490517)) },
    { simde_mm512_set_epi32(INT32_C( 2082954477), INT32_C( 1254960767), INT32_C( 1995459397), INT32_C(  -11572946),
                            INT32_C(-1087388220), INT32_C(  730787370), INT32_C(-2034110695), INT32_C(-1088138491),
                            INT32_C( -353174912), INT32_C( -362301616), INT32_C(  617951303), INT32_C(  817116152),
                            INT32_C(-1034835761), INT32_C( -102069057), INT32_C( 1774242298), INT32_C( 1089620040)),
      simde_mm_set_epi32(INT32_C(  159429100), INT32_C(  451955897), INT32_C(  181201098), INT32_C(  450627934)),
      simde_mm512_set_epi32(INT32_C( 2082954477), INT32_C( 1254960767), INT32_C( 1995459397), INT32_C(  -11572946),
                            INT32_C(-1087388220), INT32_C(  730787370), INT32_C(-2034110695), INT32_C(-1088138491),
                            INT32_C( -353174912), INT32_C( -362301616), INT32_C(  617951303), INT32_C(  817116152),
                            INT32_C(  159429100), INT32_C(  451955897), INT32_C(  181201098), INT32_C(  450627934)),
      simde_mm512_set_epi32(INT32_C( 2082954477), INT32_C( 1254960767), INT32_C( 1995459397), INT32_C(  -11572946),
                            INT32_C(-1087388220), INT32_C(  730787370), INT32_C(-2034110695), INT32_C(-1088138491),
                            INT32_C(  159429100), INT32_C(  451955897), INT32_C(  181201098), INT32_C(  450627934),
                            INT32_C(-1034835761), INT32_C( -102069057), INT32_C( 1774242298), INT32_C( 1089620040)),
      simde_mm512_set_epi32(INT32_C( 2082954477), INT32_C( 1254960767), INT32_C( 1995459397), INT32_C(  -11572946),
                            INT32_C(  159429100), INT32_C(  451955897), INT32_C(  181201098), INT32_C(  450627934),
                            INT32_C( -353174912), INT32_C( -362301616), INT32_C(  617951303), INT32_C(  817116152),
                            INT32_C(-1034835761), INT32_C( -102069057), INT32_C( 1774242298), INT32_C( 1089620040)),
      simde_mm512_set_epi32(INT32_C(  159429100), INT32_C(  451955897), INT32_C(  181201098), INT32_C(  450627934),
                            INT32_C(-1087388220), INT32_C(  730787370), INT32_C(-2034110695), INT32_C(-1088138491),
                            INT32_C( -353174912), INT32_C( -362301616), INT32_C(  617951303), INT32_C(  817116152),
                            INT32_C(-1034835761), INT32_C( -102069057), INT32_C( 1774242298), INT32_C( 1089620040)) },
    { simde_mm512_set_epi32(INT32_C(  277470244), INT32_C(-1834748849), INT32_C(  596054477), INT32_C( 1827419510),
                            INT32_C(-1010527612), INT32_C(-1687118128), INT32_C(  107945377), INT32_C( 1174128677),
                            INT32_C(-1544325740), INT32_C(  204417556), INT32_C(-1329665093), INT32_C(-2039025377),
                            INT32_C( 1639231015), INT32_C( 1541217841), INT32_C( 1692413538), INT32_C(  738521275)),
      simde_mm_set_epi32(INT32_C( 1435935141), INT32_C(-2098236580), INT32_C(-1991433794), INT32_C( 1298943776)),
      simde_mm512_set_epi32(INT32_C(  277470244), INT32_C(-1834748849), INT32_C(  596054477), INT32_C( 1827419510),
                            INT32_C(-1010527612), INT32_C(-1687118128), INT32_C(  107945377), INT32_C( 1174128677),
                            INT32_C(-1544325740), INT32_C(  204417556), INT32_C(-1329665093), INT32_C(-2039025377),
                            INT32_C( 1435935141), INT32_C(-2098236580), INT32_C(-1991433794), INT32_C( 1298943776)),
      simde_mm512_set_epi32(INT32_C(  277470244), INT32_C(-1834748849), INT32_C(  596054477), INT32_C( 1827419510),
                            INT32_C(-1010527612), INT32_C(-1687118128), INT32_C(  107945377), INT32_C( 1174128677),
                            INT32_C( 1435935141), INT32_C(-2098236580), INT32_C(-1991433794), INT32_C( 1298943776),
                            INT32_C( 1639231015), INT32_C( 1541217841), INT32_C( 1692413538), INT32_C(  738521275)),
      simde_mm512_set_epi32(INT32_C(  277470244), INT32_C(-1834748849), INT32_C(  596054477), INT32_C( 1827419510),
                            INT32_C( 1435935141), INT32_C(-2098236580), INT32_C(-1991433794), INT32_C( 1298943776),
                            INT32_C(-1544325740), INT32_C(  204417556), INT32_C(-1329665093), INT32_C(-2039025377),
                            INT32_C( 1639231015), INT32_C( 1541217841), INT32_C( 1692413538), INT32_C(  738521275)),
      simde_mm512_set_epi32(INT32_C( 1435935141), INT32_C(-2098236580), INT32_C(-1991433794), INT32_C( 1298943776),
                            INT32_C(-1010527612), INT32_C(-1687118128), INT32_C(  107945377), INT32_C( 1174128677),
                            INT32_C(-1544325740), INT32_C(  204417556), INT32_C(-1329665093), INT32_C(-2039025377),
                            INT32_C( 1639231015), INT32_C( 1541217841), INT32_C( 1692413538), INT32_C(  738521275)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r;
    r = simde_mm512_inserti32x4(test_vec[i].a, test_vec[i].b, 0);
    simde_assert_m512i_i32(r, ==, test_vec[i].r0);
    r = simde_mm512_inserti32x4(test_vec[i].a, test_vec[i].b, 1);
    simde_assert_m512i_i32(r, ==, test_vec[i].r1);
    r = simde_mm512_inserti32x4(test_vec[i].a, test_vec[i].b, 2);
    simde_assert_m512i_i32(r, ==, test_vec[i].r2);
    r = simde_mm512_inserti32x4(test_vec[i].a, test_vec[i].b, 3);
    simde_assert_m512i_i32(r, ==, test_vec[i].r3);
  }

  return 0;
}

static int
test_simde_mm512_mask_inserti32x4(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i src;
    simde__mmask16 k;
    simde__m512i a;
    simde__m128i b;
    simde__m512i r0;
    simde__m512i r1;
    simde__m512i r2;
    simde__m512i r3;
  } test_vec[8] = {
    { simde_mm512_set_epi32(INT32_C(-1026363374), INT32_C(-1801776439), INT32_C(  145438126), INT32_C(-1306064352),
                            INT32_C( -858736392), INT32_C(  923442479), INT32_C( 1092805562), INT32_C( 1443901717),
                            INT32_C( 1848749100), INT32_C( 1777333881), INT32_C( 1570116932), INT32_C(-1302383354),
                            INT32_C( 1993455974), INT32_C(-2068684593), INT32_C(-1936012201), INT32_C( 1856459607)),
      UINT16_C(27455),
      simde_mm512_set_epi32(INT32_C(-1110068455), INT32_C( -207240031), INT32_C(-1649179267), INT32_C( 2054398444),
                            INT32_C( -483586503), INT32_C(-1481960002), INT32_C(  861125508), INT32_C( -330381203),
                            INT32_C(-1999224530), INT32_C( 1042470181), INT32_C( 1827473477), INT32_C(  298546792),
                            INT32_C(-1630396605), INT32_C( 1545554432), INT32_C(  344023940), INT32_C(-1871515754)),
      simde_mm_set_epi32(INT32_C(  169645898), INT32_C(-1539616610), INT32_C( 1134735685), INT32_C( 1430356381)),
      simde_mm512_set_epi32(INT32_C(-1026363374), INT32_C( -207240031), INT32_C(-1649179267), INT32_C(-1306064352),
                            INT32_C( -483586503), INT32_C(  923442479), INT32_C(  861125508), INT32_C( -330381203),
                            INT32_C( 1848749100), INT32_C( 1777333881), INT32_C( 1827473477), INT32_C(  298546792),
                            INT32_C(  169645898), INT32_C(-1539616610), INT32_C( 1134735685), INT32_C( 1430356381)),
      simde_mm512_set_epi32(INT32_C(-1026363374), INT32_C( -207240031), INT32_C(-1649179267), INT32_C(-1306064352),
                            INT32_C( -483586503), INT32_C(  923442479), INT32_C(  861125508), INT32_C( -330381203),
                            INT32_C( 1848749100), INT32_C( 1777333881), INT32_C( 1134735685), INT32_C( 1430356381),
                            INT32_C(-1630396605), INT32_C( 1545554432), INT32_C(  344023940), INT32_C(-1871515754)),
      simde_mm512_set_epi32(INT32_C(-1026363374), INT32_C( -207240031), INT32_C(-1649179267), INT32_C(-1306064352),
                            INT32_C(  169645898), INT32_C(  923442479), INT32_C( 1134735685), INT32_C( 1430356381),
                            INT32_C( 1848749100), INT32_C( 1777333881), INT32_C( 1827473477), INT32_C(  298546792),
                            INT32_C(-1630396605), INT32_C( 1545554432), INT32_C(  344023940), INT32_C(-1871515754)),
      simde_mm512_set_epi32(INT32_C(-1026363374), INT32_C(-1539616610), INT32_C( 1134735685), INT32_C(-1306064352),
                            INT32_C( -483586503), INT32_C(  923442479), INT32_C(  861125508), INT32_C( -330381203),
                            INT32_C( 1848749100), INT32_C( 1777333881), INT32_C( 1827473477), INT32_C(  298546792),
                            INT32_C(-1630396605), INT32_C( 1545554432), INT32_C(  344023940), INT32_C(-1871515754)) },
    { simde_mm512_set_epi32(INT32_C( -340318359), INT32_C( 1519671047), INT32_C(-1017461983), INT32_C(  353198331),
                            INT32_C( 1711460779), INT32_C( -919570191), INT32_C( 1974152373), INT32_C( -695949043),
                            INT32_C( -790242624), INT32_C(-1094331335), INT32_C(-1166320093), INT32_C(-2045280751),
                            INT32_C(-2037261521), INT32_C(  223952317), INT32_C(  282198336), INT32_C(  564965997)),
      UINT16_C(63697),
      simde_mm512_set_epi32(INT32_C( 1688468565), INT32_C(  736544549), INT32_C(-1282057552), INT32_C(  795925067),
                            INT32_C( 1720852541), INT32_C(-1423023772), INT32_C(-1185448755), INT32_C( 1549802795),
                            INT32_C(  159583350), INT32_C(  548883180), INT32_C( -605945909), INT32_C(-2063050181),
                            INT32_C( 1095467003), INT32_C(-2083755741), INT32_C( 2066979701), INT32_C( 1094609712)),
      simde_mm_set_epi32(INT32_C( -199229058), INT32_C(  -91537812), INT32_C( 1375258232), INT32_C(  139748399)),
      simde_mm512_set_epi32(INT32_C( 1688468565), INT32_C(  736544549), INT32_C(-1282057552), INT32_C(  795925067),
                            INT32_C( 1720852541), INT32_C( -919570191), INT32_C( 1974152373), INT32_C( -695949043),
                            INT32_C(  159583350), INT32_C(  548883180), INT32_C(-1166320093), INT32_C(-2063050181),
                            INT32_C(-2037261521), INT32_C(  223952317), INT32_C(  282198336), INT32_C(  139748399)),
      simde_mm512_set_epi32(INT32_C( 1688468565), INT32_C(  736544549), INT32_C(-1282057552), INT32_C(  795925067),
                            INT32_C( 1720852541), INT32_C( -919570191), INT32_C( 1974152373), INT32_C( -695949043),
                            INT32_C( -199229058), INT32_C(  -91537812), INT32_C(-1166320093), INT32_C(  139748399),
                            INT32_C(-2037261521), INT32_C(  223952317), INT32_C(  282198336), INT32_C( 1094609712)),
      simde_mm512_set_epi32(INT32_C( 1688468565), INT32_C(  736544549), INT32_C(-1282057552), INT32_C(  795925067),
                            INT32_C( -199229058), INT32_C( -919570191), INT32_C( 1974152373), INT32_C( -695949043),
                            INT32_C(  159583350), INT32_C(  548883180), INT32_C(-1166320093), INT32_C(-2063050181),
                            INT32_C(-2037261521), INT32_C(  223952317), INT32_C(  282198336), INT32_C( 1094609712)),
      simde_mm512_set_epi32(INT32_C( -199229058), INT32_C(  -91537812), INT32_C( 1375258232), INT32_C(  139748399),
                            INT32_C( 1720852541), INT32_C( -919570191), INT32_C( 1974152373), INT32_C( -695949043),
                            INT32_C(  159583350), INT32_C(  548883180), INT32_C(-1166320093), INT32_C(-2063050181),
                            INT32_C(-2037261521), INT32_C(  223952317), INT32_C(  282198336), INT32_C( 1094609712)) },
    { simde_mm512_set_epi32(INT32_C( 1838830023), INT32_C( -532007659), INT32_C( -622852205), INT32_C( -839037220),
                            INT32_C(  499633910), INT32_C( -260167255), INT32_C(  884163960), INT32_C( -329275629),
                            INT32_C( -888441293), INT32_C( -707551350), INT32_C(  513515868), INT32_C(-1825967755),
                            INT32_C(  822222164), INT32_C(-1689559027), INT32_C(  533478787), INT32_C(  907615417)),
      UINT16_C(63246),
      simde_mm512_set_epi32(INT32_C(  459072440), INT32_C( -430427651), INT32_C( -272088075), INT32_C(  386072301),
                            INT32_C(-1628984154), INT32_C(   87817524), INT32_C( 1219490517), INT32_C(-1569831145),
                            INT32_C(  338985942), INT32_C( 1701079465), INT32_C( -195770682), INT32_C(  503748315),
                            INT32_C( 1469355417), INT32_C(-1849349632), INT32_C( 1962664621), INT32_C( -646247370)),
      simde_mm_set_epi32(INT32_C(  -22119232), INT32_C( 1216907749), INT32_C(  654527510), INT32_C(-2043358500)),
      simde_mm512_set_epi32(INT32_C(  459072440), INT32_C( -430427651), INT32_C( -272088075), INT32_C(  386072301),
                            INT32_C(  499633910), INT32_C(   87817524), INT32_C( 1219490517), INT32_C(-1569831145),
                            INT32_C( -888441293), INT32_C( -707551350), INT32_C(  513515868), INT32_C(-1825967755),
                            INT32_C(  -22119232), INT32_C( 1216907749), INT32_C(  654527510), INT32_C(  907615417)),
      simde_mm512_set_epi32(INT32_C(  459072440), INT32_C( -430427651), INT32_C( -272088075), INT32_C(  386072301),
                            INT32_C(  499633910), INT32_C(   87817524), INT32_C( 1219490517), INT32_C(-1569831145),
                            INT32_C( -888441293), INT32_C( -707551350), INT32_C(  513515868), INT32_C(-1825967755),
                            INT32_C( 1469355417), INT32_C(-1849349632), INT32_C( 1962664621), INT32_C(  907615417)),
      simde_mm512_set_epi32(INT32_C(  459072440), INT32_C( -430427651), INT32_C( -272088075), INT32_C(  386072301),
                            INT32_C(  499633910), INT32_C( 1216907749), INT32_C(  654527510), INT32_C(-2043358500),
                            INT32_C( -888441293), INT32_C( -707551350), INT32_C(  513515868), INT32_C(-1825967755),
                            INT32_C( 1469355417), INT32_C(-1849349632), INT32_C( 1962664621), INT32_C(  907615417)),
      simde_mm512_set_epi32(INT32_C(  -22119232), INT32_C( 1216907749), INT32_C(  654527510), INT32_C(-2043358500),
                            INT32_C(  499633910), INT32_C(   87817524), INT32_C( 1219490517), INT32_C(-1569831145),
                            INT32_C( -888441293), INT32_C( -707551350), INT32_C(  513515868), INT32_C(-1825967755),
                            INT32_C( 1469355417), INT32_C(-1849349632), INT32_C( 1962664621), INT32_C(  907615417)) },
    { simde_mm512_set_epi32(INT32_C( -362301616), INT32_C(  617951303), INT32_C(  817116152), INT32_C(-1034835761),
                            INT32_C( -102069057), INT32_C( 1774242298), INT32_C( 1089620040), INT32_C(-1101477862),
                            INT32_C( 2001101785), INT32_C(-1759250988), INT32_C( -606254738), INT32_C( 1526367108),
                            INT32_C(  722122834), INT32_C( -174985661), INT32_C(-1762469023), INT32_C( 1239606494)),
      UINT16_C(64128),
      simde_mm512_set_epi32(INT32_C( 1639231015), INT32_C( 1541217841), INT32_C( 1692413538), INT32_C(  738521275),
                            INT32_C(  159429100), INT32_C(  451955897), INT32_C(  181201098), INT32_C(  450627934),
                            INT32_C( 2082954477), INT32_C( 1254960767), INT32_C( 1995459397), INT32_C(  -11572946),
                            INT32_C(-1087388220), INT32_C(  730787370), INT32_C(-2034110695), INT32_C(-1088138491)),
      simde_mm_set_epi32(INT32_C(-1544325740), INT32_C(  204417556), INT32_C(-1329665093), INT32_C(-2039025377)),
      simde_mm512_set_epi32(INT32_C( 1639231015), INT32_C( 1541217841), INT32_C( 1692413538), INT32_C(  738521275),
                            INT32_C(  159429100), INT32_C( 1774242298), INT32_C(  181201098), INT32_C(-1101477862),
                            INT32_C( 2082954477), INT32_C(-1759250988), INT32_C( -606254738), INT32_C( 1526367108),
                            INT32_C(  722122834), INT32_C( -174985661), INT32_C(-1762469023), INT32_C( 1239606494)),
      simde_mm512_set_epi32(INT32_C( 1639231015), INT32_C( 1541217841), INT32_C( 1692413538), INT32_C(  738521275),
                            INT32_C(  159429100), INT32_C( 1774242298), INT32_C(  181201098), INT32_C(-1101477862),
                            INT32_C(-1544325740), INT32_C(-1759250988), INT32_C( -606254738), INT32_C( 1526367108),
                            INT32_C(  722122834), INT32_C( -174985661), INT32_C(-1762469023), INT32_C( 1239606494)),
      simde_mm512_set_epi32(INT32_C( 1639231015), INT32_C( 1541217841), INT32_C( 1692413538), INT32_C(  738521275),
                            INT32_C(-1544325740), INT32_C( 1774242298), INT32_C(-1329665093), INT32_C(-1101477862),
                            INT32_C( 2082954477), INT32_C(-1759250988), INT32_C( -606254738), INT32_C( 1526367108),
                            INT32_C(  722122834), INT32_C( -174985661), INT32_C(-1762469023), INT32_C( 1239606494)),
      simde_mm512_set_epi32(INT32_C(-1544325740), INT32_C(  204417556), INT32_C(-1329665093), INT32_C(-2039025377),
                            INT32_C(  159429100), INT32_C( 1774242298), INT32_C(  181201098), INT32_C(-1101477862),
                            INT32_C( 2082954477), INT32_C(-1759250988), INT32_C( -606254738), INT32_C( 1526367108),
                            INT32_C(  722122834), INT32_C( -174985661), INT32_C(-1762469023), INT32_C( 1239606494)) },
    { simde_mm512_set_epi32(INT32_C( 1313258175), INT32_C( 1928049651), INT32_C(  765730488), INT32_C(  -85899231),
                            INT32_C( 1435935141), INT32_C(-2098236580), INT32_C(-1991433794), INT32_C( 1298943776),
                            INT32_C(  277470244), INT32_C(-1834748849), INT32_C(  596054477), INT32_C( 1827419510),
                            INT32_C(-1010527612), INT32_C(-1687118128), INT32_C(  107945377), INT32_C( 1174128677)),
      UINT16_C(52232),
      simde_mm512_set_epi32(INT32_C( -181070601), INT32_C( 1463729035), INT32_C( 2031968571), INT32_C(  333434400),
                            INT32_C( -637142874), INT32_C( -520435756), INT32_C( -148623413), INT32_C( -692754616),
                            INT32_C(-1908406411), INT32_C( 1391053429), INT32_C( 1767908668), INT32_C( 1117151413),
                            INT32_C( 1466854108), INT32_C( -852914371), INT32_C( -773785464), INT32_C(-2142007253)),
      simde_mm_set_epi32(INT32_C(  712044568), INT32_C( 1641785760), INT32_C( 1696516135), INT32_C(-1123374630)),
      simde_mm512_set_epi32(INT32_C( -181070601), INT32_C( 1463729035), INT32_C(  765730488), INT32_C(  -85899231),
                            INT32_C( -637142874), INT32_C( -520435756), INT32_C(-1991433794), INT32_C( 1298943776),
                            INT32_C(  277470244), INT32_C(-1834748849), INT32_C(  596054477), INT32_C( 1827419510),
                            INT32_C(  712044568), INT32_C(-1687118128), INT32_C(  107945377), INT32_C( 1174128677)),
      simde_mm512_set_epi32(INT32_C( -181070601), INT32_C( 1463729035), INT32_C(  765730488), INT32_C(  -85899231),
                            INT32_C( -637142874), INT32_C( -520435756), INT32_C(-1991433794), INT32_C( 1298943776),
                            INT32_C(  277470244), INT32_C(-1834748849), INT32_C(  596054477), INT32_C( 1827419510),
                            INT32_C( 1466854108), INT32_C(-1687118128), INT32_C(  107945377), INT32_C( 1174128677)),
      simde_mm512_set_epi32(INT32_C( -181070601), INT32_C( 1463729035), INT32_C(  765730488), INT32_C(  -85899231),
                            INT32_C(  712044568), INT32_C( 1641785760), INT32_C(-1991433794), INT32_C( 1298943776),
                            INT32_C(  277470244), INT32_C(-1834748849), INT32_C(  596054477), INT32_C( 1827419510),
                            INT32_C( 1466854108), INT32_C(-1687118128), INT32_C(  107945377), INT32_C( 1174128677)),
      simde_mm512_set_epi32(INT32_C(  712044568), INT32_C( 1641785760), INT32_C(  765730488), INT32_C(  -85899231),
                            INT32_C( -637142874), INT32_C( -520435756), INT32_C(-1991433794), INT32_C( 1298943776),
                            INT32_C(  277470244), INT32_C(-1834748849), INT32_C(  596054477), INT32_C( 1827419510),
                            INT32_C( 1466854108), INT32_C(-1687118128), INT32_C(  107945377), INT32_C( 1174128677)) },
    { simde_mm512_set_epi32(INT32_C( -539592973), INT32_C(-1402526875), INT32_C(   -8263463), INT32_C(  478788156),
                            INT32_C(  842200487), INT32_C( -811849174), INT32_C(-1510825074), INT32_C( 1897985966),
                            INT32_C( 1445172644), INT32_C( -193622280), INT32_C( 2097959091), INT32_C( -652080500),
                            INT32_C( 1943026961), INT32_C(  763848022), INT32_C(-2124387583), INT32_C(-1102663841)),
      UINT16_C(53796),
      simde_mm512_set_epi32(INT32_C(-1268587914), INT32_C( 1939823644), INT32_C(-1112752789), INT32_C( 2052878307),
                            INT32_C( -856056848), INT32_C(-1218860495), INT32_C(  729621709), INT32_C(-1241407128),
                            INT32_C(  696721321), INT32_C( -603523965), INT32_C( 1730687689), INT32_C(  290786615),
                            INT32_C(-1827031380), INT32_C( 1429317129), INT32_C(-1800615955), INT32_C( -728999228)),
      simde_mm_set_epi32(INT32_C( -549528402), INT32_C( -323547130), INT32_C(-1395624565), INT32_C(-1905505546)),
      simde_mm512_set_epi32(INT32_C(-1268587914), INT32_C( 1939823644), INT32_C(   -8263463), INT32_C( 2052878307),
                            INT32_C(  842200487), INT32_C( -811849174), INT32_C(  729621709), INT32_C( 1897985966),
                            INT32_C( 1445172644), INT32_C( -193622280), INT32_C( 1730687689), INT32_C( -652080500),
                            INT32_C( 1943026961), INT32_C( -323547130), INT32_C(-2124387583), INT32_C(-1102663841)),
      simde_mm512_set_epi32(INT32_C(-1268587914), INT32_C( 1939823644), INT32_C(   -8263463), INT32_C( 2052878307),
                            INT32_C(  842200487), INT32_C( -811849174), INT32_C(  729621709), INT32_C( 1897985966),
                            INT32_C( 1445172644), INT32_C( -193622280), INT32_C(-1395624565), INT32_C( -652080500),
                            INT32_C( 1943026961), INT32_C( 1429317129), INT32_C(-2124387583), INT32_C(-1102663841)),
      simde_mm512_set_epi32(INT32_C(-1268587914), INT32_C( 1939823644), INT32_C(   -8263463), INT32_C( 2052878307),
                            INT32_C(  842200487), INT32_C( -811849174), INT32_C(-1395624565), INT32_C( 1897985966),
                            INT32_C( 1445172644), INT32_C( -193622280), INT32_C( 1730687689), INT32_C( -652080500),
                            INT32_C( 1943026961), INT32_C( 1429317129), INT32_C(-2124387583), INT32_C(-1102663841)),
      simde_mm512_set_epi32(INT32_C( -549528402), INT32_C( -323547130), INT32_C(   -8263463), INT32_C(-1905505546),
                            INT32_C(  842200487), INT32_C( -811849174), INT32_C(  729621709), INT32_C( 1897985966),
                            INT32_C( 1445172644), INT32_C( -193622280), INT32_C( 1730687689), INT32_C( -652080500),
                            INT32_C( 1943026961), INT32_C( 1429317129), INT32_C(-2124387583), INT32_C(-1102663841)) },
    { simde_mm512_set_epi32(INT32_C(-1884003639), INT32_C( -638430290), INT32_C(-2007622482), INT32_C(  171336877),
                            INT32_C(   59553613), INT32_C(  165266600), INT32_C( -798384264), INT32_C( 1607584815),
                            INT32_C(-1324336584), INT32_C(-1668086905), INT32_C( -770469750), INT32_C( 1013231130),
                            INT32_C(  543156562), INT32_C( -399740514), INT32_C(  509655415), INT32_C( -160537509)),
      UINT16_C(22542),
      simde_mm512_set_epi32(INT32_C( -364563113), INT32_C( 1520783126), INT32_C( -207159885), INT32_C( -104006691),
                            INT32_C(  362759403), INT32_C(-1562242573), INT32_C( -397133039), INT32_C(  568974515),
                            INT32_C(-1726442446), INT32_C(-2134949944), INT32_C( 1969107101), INT32_C(-2063427243),
                            INT32_C( -670405092), INT32_C(-1879729053), INT32_C( 1035482990), INT32_C( 1183910939)),
      simde_mm_set_epi32(INT32_C( -521443925), INT32_C(-1464291783), INT32_C(-1686112999), INT32_C(-1290233716)),
      simde_mm512_set_epi32(INT32_C(-1884003639), INT32_C( 1520783126), INT32_C(-2007622482), INT32_C( -104006691),
                            INT32_C(  362759403), INT32_C(  165266600), INT32_C( -798384264), INT32_C( 1607584815),
                            INT32_C(-1324336584), INT32_C(-1668086905), INT32_C( -770469750), INT32_C( 1013231130),
                            INT32_C( -521443925), INT32_C(-1464291783), INT32_C(-1686112999), INT32_C( -160537509)),
      simde_mm512_set_epi32(INT32_C(-1884003639), INT32_C( 1520783126), INT32_C(-2007622482), INT32_C( -104006691),
                            INT32_C(  362759403), INT32_C(  165266600), INT32_C( -798384264), INT32_C( 1607584815),
                            INT32_C(-1324336584), INT32_C(-1668086905), INT32_C( -770469750), INT32_C( 1013231130),
                            INT32_C( -670405092), INT32_C(-1879729053), INT32_C( 1035482990), INT32_C( -160537509)),
      simde_mm512_set_epi32(INT32_C(-1884003639), INT32_C( 1520783126), INT32_C(-2007622482), INT32_C( -104006691),
                            INT32_C( -521443925), INT32_C(  165266600), INT32_C( -798384264), INT32_C( 1607584815),
                            INT32_C(-1324336584), INT32_C(-1668086905), INT32_C( -770469750), INT32_C( 1013231130),
                            INT32_C( -670405092), INT32_C(-1879729053), INT32_C( 1035482990), INT32_C( -160537509)),
      simde_mm512_set_epi32(INT32_C(-1884003639), INT32_C(-1464291783), INT32_C(-2007622482), INT32_C(-1290233716),
                            INT32_C(  362759403), INT32_C(  165266600), INT32_C( -798384264), INT32_C( 1607584815),
                            INT32_C(-1324336584), INT32_C(-1668086905), INT32_C( -770469750), INT32_C( 1013231130),
                            INT32_C( -670405092), INT32_C(-1879729053), INT32_C( 1035482990), INT32_C( -160537509)) },
    { simde_mm512_set_epi32(INT32_C(-1383827159), INT32_C( 1804875719), INT32_C( 1179452315), INT32_C(-1509656190),
                            INT32_C(-1409992701), INT32_C(-1830359468), INT32_C(  635753031), INT32_C(  310246197),
                            INT32_C(-1783943034), INT32_C(-1307643183), INT32_C( -144888334), INT32_C(  621611179),
                            INT32_C(  743650285), INT32_C( 1845744981), INT32_C(-1349190316), INT32_C(-1403674818)),
      UINT16_C( 4521),
      simde_mm512_set_epi32(INT32_C( 1055036471), INT32_C(  351897115), INT32_C( 1594003471), INT32_C(-1709813294),
                            INT32_C( -133653364), INT32_C(  -51462036), INT32_C(   46796230), INT32_C(  989301899),
                            INT32_C( -691937914), INT32_C( 1667629581), INT32_C( -496700661), INT32_C(-1318801755),
                            INT32_C( 1076515270), INT32_C(-1757573505), INT32_C(-1929379353), INT32_C( -560036292)),
      simde_mm_set_epi32(INT32_C(-1293286075), INT32_C(-1398303881), INT32_C(-2094713086), INT32_C(  197529411)),
      simde_mm512_set_epi32(INT32_C(-1383827159), INT32_C( 1804875719), INT32_C( 1179452315), INT32_C(-1709813294),
                            INT32_C(-1409992701), INT32_C(-1830359468), INT32_C(  635753031), INT32_C(  989301899),
                            INT32_C( -691937914), INT32_C(-1307643183), INT32_C( -496700661), INT32_C(  621611179),
                            INT32_C(-1293286075), INT32_C( 1845744981), INT32_C(-1349190316), INT32_C(  197529411)),
      simde_mm512_set_epi32(INT32_C(-1383827159), INT32_C( 1804875719), INT32_C( 1179452315), INT32_C(-1709813294),
                            INT32_C(-1409992701), INT32_C(-1830359468), INT32_C(  635753031), INT32_C(  989301899),
                            INT32_C(-1293286075), INT32_C(-1307643183), INT32_C(-2094713086), INT32_C(  621611179),
                            INT32_C( 1076515270), INT32_C( 1845744981), INT32_C(-1349190316), INT32_C( -560036292)),
      simde_mm512_set_epi32(INT32_C(-1383827159), INT32_C( 1804875719), INT32_C( 1179452315), INT32_C(-1709813294),
                            INT32_C(-1409992701), INT32_C(-1830359468), INT32_C(  635753031), INT32_C(  197529411),
                            INT32_C( -691937914), INT32_C(-1307643183), INT32_C( -496700661), INT32_C(  621611179),
                            INT32_C( 1076515270), INT32_C( 1845744981), INT32_C(-1349190316), INT32_C( -560036292)),
      simde_mm512_set_epi32(INT32_C(-1383827159), INT32_C( 1804875719), INT32_C( 1179452315), INT32_C(  197529411),
                            INT32_C(-1409992701), INT32_C(-1830359468), INT32_C(  635753031), INT32_C(  989301899),
                            INT32_C( -691937914), INT32_C(-1307643183), INT32_C( -496700661), INT32_C(  621611179),
                            INT32_C( 1076515270), INT32_C( 1845744981), INT32_C(-1349190316), INT32_C( -560036292)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r;
    r = simde_mm512_mask_inserti32x4(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b, 0);
    simde_assert_m512i_i32(r, ==, test_vec[i].r0);
    r = simde_mm512_mask_inserti32x4(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b, 1);
    simde_assert_m512i_i32(r, ==, test_vec[i].r1);
    r = simde_mm512_mask_inserti32x4(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b, 2);
    simde_assert_m512i_i32(r, ==, test_vec[i].r2);
    r = simde_mm512_mask_inserti32x4(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b, 3);
    simde_assert_m512i_i32(r, ==, test_vec[i].r3);
  }

  return 0;
}

static int
test_simde_mm512_maskz_inserti32x4(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask16 k;
    simde__m512i a;
    simde__m128i b;
    simde__m512i r0;
    simde__m512i r1;
    simde__m512i r2;
    simde__m512i r3;
  } test_vec[8] = {
    { UINT16_C(21335),
      simde_mm512_set_epi32(INT32_C(  951544639), INT32_C(-1026363374), INT32_C(-1801776439), INT32_C(  145438126),
                            INT32_C(-1306064352), INT32_C( -858736392), INT32_C(  923442479), INT32_C( 1092805562),
                            INT32_C( 1443901717), INT32_C( 1848749100), INT32_C( 1777333881), INT32_C( 1570116932),
                            INT32_C(-1302383354), INT32_C( 1993455974), INT32_C(-2068684593), INT32_C(-1936012201)),
      simde_mm_set_epi32(INT32_C(-1630396605), INT32_C( 1545554432), INT32_C(  344023940), INT32_C(-1871515754)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C(-1026363374), INT32_C(          0), INT32_C(  145438126),
                            INT32_C(          0), INT32_C(          0), INT32_C(  923442479), INT32_C( 1092805562),
                            INT32_C(          0), INT32_C( 1848749100), INT32_C(          0), INT32_C( 1570116932),
                            INT32_C(          0), INT32_C( 1545554432), INT32_C(  344023940), INT32_C(-1871515754)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C(-1026363374), INT32_C(          0), INT32_C(  145438126),
                            INT32_C(          0), INT32_C(          0), INT32_C(  923442479), INT32_C( 1092805562),
                            INT32_C(          0), INT32_C( 1545554432), INT32_C(          0), INT32_C(-1871515754),
                            INT32_C(          0), INT32_C( 1993455974), INT32_C(-2068684593), INT32_C(-1936012201)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C(-1026363374), INT32_C(          0), INT32_C(  145438126),
                            INT32_C(          0), INT32_C(          0), INT32_C(  344023940), INT32_C(-1871515754),
                            INT32_C(          0), INT32_C( 1848749100), INT32_C(          0), INT32_C( 1570116932),
                            INT32_C(          0), INT32_C( 1993455974), INT32_C(-2068684593), INT32_C(-1936012201)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C( 1545554432), INT32_C(          0), INT32_C(-1871515754),
                            INT32_C(          0), INT32_C(          0), INT32_C(  923442479), INT32_C( 1092805562),
                            INT32_C(          0), INT32_C( 1848749100), INT32_C(          0), INT32_C( 1570116932),
                            INT32_C(          0), INT32_C( 1993455974), INT32_C(-2068684593), INT32_C(-1936012201)) },
    { UINT16_C(30312),
      simde_mm512_set_epi32(INT32_C(  564965997), INT32_C(  169645898), INT32_C(-1539616610), INT32_C( 1134735685),
                            INT32_C( 1430356381), INT32_C(-1110068455), INT32_C( -207240031), INT32_C(-1649179267),
                            INT32_C( 2054398444), INT32_C( -483586503), INT32_C(-1481960002), INT32_C(  861125508),
                            INT32_C( -330381203), INT32_C(-1999224530), INT32_C( 1042470181), INT32_C( 1827473477)),
      simde_mm_set_epi32(INT32_C(-2045280751), INT32_C(-2037261521), INT32_C(  223952317), INT32_C(  282198336)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C(  169645898), INT32_C(-1539616610), INT32_C( 1134735685),
                            INT32_C(          0), INT32_C(-1110068455), INT32_C( -207240031), INT32_C(          0),
                            INT32_C(          0), INT32_C( -483586503), INT32_C(-1481960002), INT32_C(          0),
                            INT32_C(-2045280751), INT32_C(          0), INT32_C(          0), INT32_C(          0)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C(  169645898), INT32_C(-1539616610), INT32_C( 1134735685),
                            INT32_C(          0), INT32_C(-1110068455), INT32_C( -207240031), INT32_C(          0),
                            INT32_C(          0), INT32_C(-2037261521), INT32_C(  223952317), INT32_C(          0),
                            INT32_C( -330381203), INT32_C(          0), INT32_C(          0), INT32_C(          0)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C(  169645898), INT32_C(-1539616610), INT32_C( 1134735685),
                            INT32_C(          0), INT32_C(-2037261521), INT32_C(  223952317), INT32_C(          0),
                            INT32_C(          0), INT32_C( -483586503), INT32_C(-1481960002), INT32_C(          0),
                            INT32_C( -330381203), INT32_C(          0), INT32_C(          0), INT32_C(          0)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C(-2037261521), INT32_C(  223952317), INT32_C(  282198336),
                            INT32_C(          0), INT32_C(-1110068455), INT32_C( -207240031), INT32_C(          0),
                            INT32_C(          0), INT32_C( -483586503), INT32_C(-1481960002), INT32_C(          0),
                            INT32_C( -330381203), INT32_C(          0), INT32_C(          0), INT32_C(          0)) },
    { UINT16_C(24099),
      simde_mm512_set_epi32(INT32_C(-2063050181), INT32_C( 1095467003), INT32_C(-2083755741), INT32_C( 2066979701),
                            INT32_C( 1094609712), INT32_C( 1345059025), INT32_C( -340318359), INT32_C( 1519671047),
                            INT32_C(-1017461983), INT32_C(  353198331), INT32_C( 1711460779), INT32_C( -919570191),
                            INT32_C( 1974152373), INT32_C( -695949043), INT32_C( -790242624), INT32_C(-1094331335)),
      simde_mm_set_epi32(INT32_C( 1549802795), INT32_C(  159583350), INT32_C(  548883180), INT32_C( -605945909)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C( 1095467003), INT32_C(          0), INT32_C( 2066979701),
                            INT32_C( 1094609712), INT32_C( 1345059025), INT32_C( -340318359), INT32_C(          0),
                            INT32_C(          0), INT32_C(          0), INT32_C( 1711460779), INT32_C(          0),
                            INT32_C(          0), INT32_C(          0), INT32_C(  548883180), INT32_C( -605945909)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C( 1095467003), INT32_C(          0), INT32_C( 2066979701),
                            INT32_C( 1094609712), INT32_C( 1345059025), INT32_C( -340318359), INT32_C(          0),
                            INT32_C(          0), INT32_C(          0), INT32_C(  548883180), INT32_C(          0),
                            INT32_C(          0), INT32_C(          0), INT32_C( -790242624), INT32_C(-1094331335)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C( 1095467003), INT32_C(          0), INT32_C( 2066979701),
                            INT32_C( 1549802795), INT32_C(  159583350), INT32_C(  548883180), INT32_C(          0),
                            INT32_C(          0), INT32_C(          0), INT32_C( 1711460779), INT32_C(          0),
                            INT32_C(          0), INT32_C(          0), INT32_C( -790242624), INT32_C(-1094331335)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C(  159583350), INT32_C(          0), INT32_C( -605945909),
                            INT32_C( 1094609712), INT32_C( 1345059025), INT32_C( -340318359), INT32_C(          0),
                            INT32_C(          0), INT32_C(          0), INT32_C( 1711460779), INT32_C(          0),
                            INT32_C(          0), INT32_C(          0), INT32_C( -790242624), INT32_C(-1094331335)) },
    { UINT16_C(31949),
      simde_mm512_set_epi32(INT32_C(  513515868), INT32_C(-1825967755), INT32_C(  822222164), INT32_C(-1689559027),
                            INT32_C(  533478787), INT32_C(  907615417), INT32_C( -199229058), INT32_C(  -91537812),
                            INT32_C( 1375258232), INT32_C(  139748399), INT32_C( 1688468565), INT32_C(  736544549),
                            INT32_C(-1282057552), INT32_C(  795925067), INT32_C( 1720852541), INT32_C(-1423023772)),
      simde_mm_set_epi32(INT32_C(  884163960), INT32_C( -329275629), INT32_C( -888441293), INT32_C( -707551350)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C(-1825967755), INT32_C(  822222164), INT32_C(-1689559027),
                            INT32_C(  533478787), INT32_C(  907615417), INT32_C(          0), INT32_C(          0),
                            INT32_C( 1375258232), INT32_C(  139748399), INT32_C(          0), INT32_C(          0),
                            INT32_C(  884163960), INT32_C( -329275629), INT32_C(          0), INT32_C( -707551350)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C(-1825967755), INT32_C(  822222164), INT32_C(-1689559027),
                            INT32_C(  533478787), INT32_C(  907615417), INT32_C(          0), INT32_C(          0),
                            INT32_C(  884163960), INT32_C( -329275629), INT32_C(          0), INT32_C(          0),
                            INT32_C(-1282057552), INT32_C(  795925067), INT32_C(          0), INT32_C(-1423023772)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C(-1825967755), INT32_C(  822222164), INT32_C(-1689559027),
                            INT32_C(  884163960), INT32_C( -329275629), INT32_C(          0), INT32_C(          0),
                            INT32_C( 1375258232), INT32_C(  139748399), INT32_C(          0), INT32_C(          0),
                            INT32_C(-1282057552), INT32_C(  795925067), INT32_C(          0), INT32_C(-1423023772)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C( -329275629), INT32_C( -888441293), INT32_C( -707551350),
                            INT32_C(  533478787), INT32_C(  907615417), INT32_C(          0), INT32_C(          0),
                            INT32_C( 1375258232), INT32_C(  139748399), INT32_C(          0), INT32_C(          0),
                            INT32_C(-1282057552), INT32_C(  795925067), INT32_C(          0), INT32_C(-1423023772)) },
    { UINT16_C(10665),
      simde_mm512_set_epi32(INT32_C( 1219490517), INT32_C(-1569831145), INT32_C(  338985942), INT32_C( 1701079465),
                            INT32_C( -195770682), INT32_C(  503748315), INT32_C( 1469355417), INT32_C(-1849349632),
                            INT32_C( 1962664621), INT32_C( -646247370), INT32_C( 1258747662), INT32_C( 1838830023),
                            INT32_C( -532007659), INT32_C( -622852205), INT32_C( -839037220), INT32_C(  499633910)),
      simde_mm_set_epi32(INT32_C( -272088075), INT32_C(  386072301), INT32_C(-1628984154), INT32_C(   87817524)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(  338985942), INT32_C(          0),
                            INT32_C( -195770682), INT32_C(          0), INT32_C(          0), INT32_C(-1849349632),
                            INT32_C( 1962664621), INT32_C(          0), INT32_C( 1258747662), INT32_C(          0),
                            INT32_C( -272088075), INT32_C(          0), INT32_C(          0), INT32_C(   87817524)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(  338985942), INT32_C(          0),
                            INT32_C( -195770682), INT32_C(          0), INT32_C(          0), INT32_C(-1849349632),
                            INT32_C( -272088075), INT32_C(          0), INT32_C(-1628984154), INT32_C(          0),
                            INT32_C( -532007659), INT32_C(          0), INT32_C(          0), INT32_C(  499633910)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(  338985942), INT32_C(          0),
                            INT32_C( -272088075), INT32_C(          0), INT32_C(          0), INT32_C(   87817524),
                            INT32_C( 1962664621), INT32_C(          0), INT32_C( 1258747662), INT32_C(          0),
                            INT32_C( -532007659), INT32_C(          0), INT32_C(          0), INT32_C(  499633910)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(-1628984154), INT32_C(          0),
                            INT32_C( -195770682), INT32_C(          0), INT32_C(          0), INT32_C(-1849349632),
                            INT32_C( 1962664621), INT32_C(          0), INT32_C( 1258747662), INT32_C(          0),
                            INT32_C( -532007659), INT32_C(          0), INT32_C(          0), INT32_C(  499633910)) },
    { UINT16_C(12797),
      simde_mm512_set_epi32(INT32_C( 1774242298), INT32_C( 1089620040), INT32_C(-1101477862), INT32_C( 2001101785),
                            INT32_C(-1759250988), INT32_C( -606254738), INT32_C( 1526367108), INT32_C(  722122834),
                            INT32_C( -174985661), INT32_C(-1762469023), INT32_C( 1239606494), INT32_C(  -22119232),
                            INT32_C( 1216907749), INT32_C(  654527510), INT32_C(-2043358500), INT32_C(  459072440)),
      simde_mm_set_epi32(INT32_C(  617951303), INT32_C(  817116152), INT32_C(-1034835761), INT32_C( -102069057)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(-1101477862), INT32_C( 2001101785),
                            INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(  722122834),
                            INT32_C( -174985661), INT32_C(-1762469023), INT32_C( 1239606494), INT32_C(  -22119232),
                            INT32_C(  617951303), INT32_C(  817116152), INT32_C(          0), INT32_C( -102069057)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(-1101477862), INT32_C( 2001101785),
                            INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(  722122834),
                            INT32_C(  617951303), INT32_C(  817116152), INT32_C(-1034835761), INT32_C( -102069057),
                            INT32_C( 1216907749), INT32_C(  654527510), INT32_C(          0), INT32_C(  459072440)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(-1101477862), INT32_C( 2001101785),
                            INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C( -102069057),
                            INT32_C( -174985661), INT32_C(-1762469023), INT32_C( 1239606494), INT32_C(  -22119232),
                            INT32_C( 1216907749), INT32_C(  654527510), INT32_C(          0), INT32_C(  459072440)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(-1034835761), INT32_C( -102069057),
                            INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(  722122834),
                            INT32_C( -174985661), INT32_C(-1762469023), INT32_C( 1239606494), INT32_C(  -22119232),
                            INT32_C( 1216907749), INT32_C(  654527510), INT32_C(          0), INT32_C(  459072440)) },
    { UINT16_C(46928),
      simde_mm512_set_epi32(INT32_C( 1541217841), INT32_C( 1692413538), INT32_C(  738521275), INT32_C(  159429100),
                            INT32_C(  451955897), INT32_C(  181201098), INT32_C(  450627934), INT32_C( 2082954477),
                            INT32_C( 1254960767), INT32_C( 1995459397), INT32_C(  -11572946), INT32_C(-1087388220),
                            INT32_C(  730787370), INT32_C(-2034110695), INT32_C(-1088138491), INT32_C( -353174912)),
      simde_mm_set_epi32(INT32_C(  204417556), INT32_C(-1329665093), INT32_C(-2039025377), INT32_C( 1639231015)),
      simde_mm512_set_epi32(INT32_C( 1541217841), INT32_C(          0), INT32_C(  738521275), INT32_C(  159429100),
                            INT32_C(          0), INT32_C(  181201098), INT32_C(  450627934), INT32_C( 2082954477),
                            INT32_C(          0), INT32_C( 1995459397), INT32_C(          0), INT32_C(-1087388220),
                            INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(          0)),
      simde_mm512_set_epi32(INT32_C( 1541217841), INT32_C(          0), INT32_C(  738521275), INT32_C(  159429100),
                            INT32_C(          0), INT32_C(  181201098), INT32_C(  450627934), INT32_C( 2082954477),
                            INT32_C(          0), INT32_C(-1329665093), INT32_C(          0), INT32_C( 1639231015),
                            INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(          0)),
      simde_mm512_set_epi32(INT32_C( 1541217841), INT32_C(          0), INT32_C(  738521275), INT32_C(  159429100),
                            INT32_C(          0), INT32_C(-1329665093), INT32_C(-2039025377), INT32_C( 1639231015),
                            INT32_C(          0), INT32_C( 1995459397), INT32_C(          0), INT32_C(-1087388220),
                            INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(          0)),
      simde_mm512_set_epi32(INT32_C(  204417556), INT32_C(          0), INT32_C(-2039025377), INT32_C( 1639231015),
                            INT32_C(          0), INT32_C(  181201098), INT32_C(  450627934), INT32_C( 2082954477),
                            INT32_C(          0), INT32_C( 1995459397), INT32_C(          0), INT32_C(-1087388220),
                            INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(          0)) },
    { UINT16_C(30100),
      simde_mm512_set_epi32(INT32_C( 1313258175), INT32_C( 1928049651), INT32_C(  765730488), INT32_C(  -85899231),
                            INT32_C( 1435935141), INT32_C(-2098236580), INT32_C(-1991433794), INT32_C( 1298943776),
                            INT32_C(  277470244), INT32_C(-1834748849), INT32_C(  596054477), INT32_C( 1827419510),
                            INT32_C(-1010527612), INT32_C(-1687118128), INT32_C(  107945377), INT32_C( 1174128677)),
      simde_mm_set_epi32(INT32_C( -852914371), INT32_C( -773785464), INT32_C(-2142007253), INT32_C(  466013192)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C( 1928049651), INT32_C(  765730488), INT32_C(  -85899231),
                            INT32_C(          0), INT32_C(-2098236580), INT32_C(          0), INT32_C( 1298943776),
                            INT32_C(  277470244), INT32_C(          0), INT32_C(          0), INT32_C( 1827419510),
                            INT32_C(          0), INT32_C( -773785464), INT32_C(          0), INT32_C(          0)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C( 1928049651), INT32_C(  765730488), INT32_C(  -85899231),
                            INT32_C(          0), INT32_C(-2098236580), INT32_C(          0), INT32_C( 1298943776),
                            INT32_C( -852914371), INT32_C(          0), INT32_C(          0), INT32_C(  466013192),
                            INT32_C(          0), INT32_C(-1687118128), INT32_C(          0), INT32_C(          0)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C( 1928049651), INT32_C(  765730488), INT32_C(  -85899231),
                            INT32_C(          0), INT32_C( -773785464), INT32_C(          0), INT32_C(  466013192),
                            INT32_C(  277470244), INT32_C(          0), INT32_C(          0), INT32_C( 1827419510),
                            INT32_C(          0), INT32_C(-1687118128), INT32_C(          0), INT32_C(          0)),
      simde_mm512_set_epi32(INT32_C(          0), INT32_C( -773785464), INT32_C(-2142007253), INT32_C(  466013192),
                            INT32_C(          0), INT32_C(-2098236580), INT32_C(          0), INT32_C( 1298943776),
                            INT32_C(  277470244), INT32_C(          0), INT32_C(          0), INT32_C( 1827419510),
                            INT32_C(          0), INT32_C(-1687118128), INT32_C(          0), INT32_C(          0)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r;
    r = simde_mm512_maskz_inserti32x4(test_vec[i].k, test_vec[i].a, test_vec[i].b, 0);
    simde_assert_m512i_i32(r, ==, test_vec[i].r0);
    r = simde_mm512_maskz_inserti32x4(test_vec[i].k, test_vec[i].a, test_vec[i].b, 1);
    simde_assert_m512i_i32(r, ==, test_vec[i].r1);
    r = simde_mm512_maskz_inserti32x4(test_vec[i].k, test_vec[i].a, test_vec[i].b, 2);
    simde_assert_m512i_i32(r, ==, test_vec[i].r2);
    r = simde_mm512_maskz_inserti32x4(test_vec[i].k, test_vec[i].a, test_vec[i].b, 3);
    simde_assert_m512i_i32(r, ==, test_vec[i].r3);
  }

  return 0;
}

static int
test_simde_mm512_inserti64x4(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i a;
    simde__m256i b;
    simde__m512i r0;
    simde__m512i r1;
  } test_vec[8] = {
    { simde_mm512_set_epi64(INT64_C( 4022993628330696330), INT64_C( -564047204985781920),
                            INT64_C( 4934063986128071877), INT64_C( 8258886799903261224),
                            INT64_C( 5245738308211416456), INT64_C( 8690736315259258337),
                            INT64_C(-5183161890921602420), INT64_C(-2495336383094170141)),
      simde_mm256_set_epi64x(INT64_C(-5948029684411535130), INT64_C(-4862378680423071053),
                             INT64_C( 7355766231574189317), INT64_C( -310150959079746096)),
      simde_mm512_set_epi64(INT64_C( 4022993628330696330), INT64_C( -564047204985781920),
                            INT64_C( 4934063986128071877), INT64_C( 8258886799903261224),
                            INT64_C(-5948029684411535130), INT64_C(-4862378680423071053),
                            INT64_C( 7355766231574189317), INT64_C( -310150959079746096)),
      simde_mm512_set_epi64(INT64_C(-5948029684411535130), INT64_C(-4862378680423071053),
                            INT64_C( 7355766231574189317), INT64_C( -310150959079746096),
                            INT64_C( 5245738308211416456), INT64_C( 8690736315259258337),
                            INT64_C(-5183161890921602420), INT64_C(-2495336383094170141)) },
    { simde_mm512_set_epi64(INT64_C( 1295774678670654457), INT64_C(-8851107363323835123),
                            INT64_C( 2369486750103851747), INT64_C(-5139586436110975467),
                            INT64_C(-8115609027568940125), INT64_C( 3504612124823893047),
                            INT64_C(-7514888466798804666), INT64_C( 9113506312589344178)),
      simde_mm256_set_epi64x(INT64_C(-7443148953768886026), INT64_C( 8448077846545567514),
                             INT64_C(-7304267332935478206), INT64_C(-1528489088828046422)),
      simde_mm512_set_epi64(INT64_C( 1295774678670654457), INT64_C(-8851107363323835123),
                            INT64_C( 2369486750103851747), INT64_C(-5139586436110975467),
                            INT64_C(-7443148953768886026), INT64_C( 8448077846545567514),
                            INT64_C(-7304267332935478206), INT64_C(-1528489088828046422)),
      simde_mm512_set_epi64(INT64_C(-7443148953768886026), INT64_C( 8448077846545567514),
                            INT64_C(-7304267332935478206), INT64_C(-1528489088828046422),
                            INT64_C(-8115609027568940125), INT64_C( 3504612124823893047),
                            INT64_C(-7514888466798804666), INT64_C( 9113506312589344178)) },
    { simde_mm512_set_epi64(INT64_C(-3094219001013742557), INT64_C(-3379016320921474793),
                            INT64_C( 7772273849745001049), INT64_C(-4229480058937372017),
                            INT64_C( 8318730560275653847), INT64_C(-2664412856586094061),
                            INT64_C( 2083707536546841162), INT64_C( 5404230241318444880)),
      simde_mm256_set_epi64x(INT64_C( 9199350188047982974), INT64_C(-7693432910203882071),
                             INT64_C(-5762072963977532348), INT64_C( 4491924425059371454)),
      simde_mm512_set_epi64(INT64_C(-3094219001013742557), INT64_C(-3379016320921474793),
                            INT64_C( 7772273849745001049), INT64_C(-4229480058937372017),
                            INT64_C( 9199350188047982974), INT64_C(-7693432910203882071),
                            INT64_C(-5762072963977532348), INT64_C( 4491924425059371454)),
      simde_mm512_set_epi64(INT64_C( 9199350188047982974), INT64_C(-7693432910203882071),
                            INT64_C(-5762072963977532348), INT64_C( 4491924425059371454),
                            INT64_C( 8318730560275653847), INT64_C(-2664412856586094061),
                            INT64_C( 2083707536546841162), INT64_C( 5404230241318444880)) },
    { simde_mm512_set_epi64(INT64_C( 2522518958303333112), INT64_C(-1668307566098600867),
                            INT64_C( 8306832211054389426), INT64_C(-4135341282024622606),
                            INT64_C(-7922172549839933132), INT64_C(   90826243433254935),
                            INT64_C( 1037923706586637130), INT64_C( 5568688997300093349)),
      simde_mm256_set_epi64x(INT64_C( 7563354526679147255), INT64_C(-6952412028107066884),
                             INT64_C(-3077616107881632928), INT64_C(-2220298267656761827)),
      simde_mm512_set_epi64(INT64_C( 2522518958303333112), INT64_C(-1668307566098600867),
                            INT64_C( 8306832211054389426), INT64_C(-4135341282024622606),
                            INT64_C( 7563354526679147255), INT64_C(-6952412028107066884),
                            INT64_C(-3077616107881632928), INT64_C(-2220298267656761827)),
      simde_mm512_set_epi64(INT64_C( 7563354526679147255), INT64_C(-6952412028107066884),
                            INT64_C(-3077616107881632928), INT64_C(-2220298267656761827),
                            INT64_C(-7922172549839933132), INT64_C(   90826243433254935),
                            INT64_C( 1037923706586637130), INT64_C( 5568688997300093349)) },
    { simde_mm512_set_epi64(INT64_C(-6876215301736363293), INT64_C(-2253243373865166954),
                            INT64_C( 5866706473820467911), INT64_C(-1945184283153250111),
                            INT64_C(-6043663531296462836), INT64_C(-3201199251206898425),
                            INT64_C(-7517867743898200758), INT64_C( 5023666877462679332)),
      simde_mm256_set_epi64x(INT64_C( 1419500527032411112), INT64_C( 5424087511148175828),
                             INT64_C(-4780701435803039630), INT64_C( 6069825193561024149)),
      simde_mm512_set_epi64(INT64_C(-6876215301736363293), INT64_C(-2253243373865166954),
                            INT64_C( 5866706473820467911), INT64_C(-1945184283153250111),
                            INT64_C( 1419500527032411112), INT64_C( 5424087511148175828),
                            INT64_C(-4780701435803039630), INT64_C( 6069825193561024149)),
      simde_mm512_set_epi64(INT64_C( 1419500527032411112), INT64_C( 5424087511148175828),
                            INT64_C(-4780701435803039630), INT64_C( 6069825193561024149),
                            INT64_C(-6043663531296462836), INT64_C(-3201199251206898425),
                            INT64_C(-7517867743898200758), INT64_C( 5023666877462679332)) },
    { simde_mm512_set_epi64(INT64_C( 5698026186558744964), INT64_C( 6269499859520580584),
                            INT64_C( 7385991043015762011), INT64_C( 2173549174497415259),
                            INT64_C(  135432210503006619), INT64_C(-7059566968128636366),
                            INT64_C(-1295026765047609725), INT64_C( 5447800525707046939)),
      simde_mm256_set_epi64x(INT64_C(-7404082530836275478), INT64_C(-6011864495242619751),
                             INT64_C(-2639903919112693390), INT64_C( 3391502071027493622)),
      simde_mm512_set_epi64(INT64_C( 5698026186558744964), INT64_C( 6269499859520580584),
                            INT64_C( 7385991043015762011), INT64_C( 2173549174497415259),
                            INT64_C(-7404082530836275478), INT64_C(-6011864495242619751),
                            INT64_C(-2639903919112693390), INT64_C( 3391502071027493622)),
      simde_mm512_set_epi64(INT64_C(-7404082530836275478), INT64_C(-6011864495242619751),
                            INT64_C(-2639903919112693390), INT64_C( 3391502071027493622),
                            INT64_C(  135432210503006619), INT64_C(-7059566968128636366),
                            INT64_C(-1295026765047609725), INT64_C( 5447800525707046939)) },
    { simde_mm512_set_epi64(INT64_C(-7778482448656032654), INT64_C(-7388935565641111344),
                            INT64_C( 2154583157079273400), INT64_C( 4649728279138736034),
                            INT64_C( 1896125478609903946), INT64_C( 6795120210135498653),
                            INT64_C(-8532964392806396349), INT64_C(-8044512602622188161)),
      simde_mm256_set_epi64x(INT64_C(-7828848640852632692), INT64_C(-9058711782958006347),
                             INT64_C(-6631984369075385878), INT64_C(  312385656423386943)),
      simde_mm512_set_epi64(INT64_C(-7778482448656032654), INT64_C(-7388935565641111344),
                            INT64_C( 2154583157079273400), INT64_C( 4649728279138736034),
                            INT64_C(-7828848640852632692), INT64_C(-9058711782958006347),
                            INT64_C(-6631984369075385878), INT64_C(  312385656423386943)),
      simde_mm512_set_epi64(INT64_C(-7828848640852632692), INT64_C(-9058711782958006347),
                            INT64_C(-6631984369075385878), INT64_C(  312385656423386943),
                            INT64_C( 1896125478609903946), INT64_C( 6795120210135498653),
                            INT64_C(-8532964392806396349), INT64_C(-8044512602622188161)) },
    { simde_mm512_set_epi64(INT64_C(-8313572030703954107), INT64_C( 8197482817575228316),
                            INT64_C( 7734796813438689885), INT64_C(-7308014241195865956),
                            INT64_C( 8618855955534148826), INT64_C(-1358620153905394442),
                            INT64_C(-6300735262609682931), INT64_C(-6423460006708841158)),
      simde_mm256_set_epi64x(INT64_C( 2330675318709913935), INT64_C( 8512876982035459145),
                             INT64_C( -754385814369639096), INT64_C(-5873166547629617678)),
      simde_mm512_set_epi64(INT64_C(-8313572030703954107), INT64_C( 8197482817575228316),
                            INT64_C( 7734796813438689885), INT64_C(-7308014241195865956),
                            INT64_C( 2330675318709913935), INT64_C( 8512876982035459145),
                            INT64_C( -754385814369639096), INT64_C(-5873166547629617678)),
      simde_mm512_set_epi64(INT64_C( 2330675318709913935), INT64_C( 8512876982035459145),
                            INT64_C( -754385814369639096), INT64_C(-5873166547629617678),
                            INT64_C( 8618855955534148826), INT64_C(-1358620153905394442),
                            INT64_C(-6300735262609682931), INT64_C(-6423460006708841158)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r;
    r = simde_mm512_inserti64x4(test_vec[i].a, test_vec[i].b, 0);
    simde_assert_m512i_i64(r, ==, test_vec[i].r0);
    r = simde_mm512_inserti64x4(test_vec[i].a, test_vec[i].b, 1);
    simde_assert_m512i_i64(r, ==, test_vec[i].r1);
  }

  return 0;
}

static int
test_simde_mm512_mask_inserti64x4(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i src;
    simde__mmask8 k;
    simde__m512i a;
    simde__m256i b;
    simde__m512i r0;
    simde__m512i r1;
  } test_vec[8] = {
    { simde_mm512_set_epi64(INT64_C(-4408197122649025847), INT64_C(  624651997750430240),
                            INT64_C(-3688244718601593553), INT64_C( 4693564151120802069),
                            INT64_C( 7940316924786767481), INT64_C( 6743600876828439814),
                            INT64_C( 8561828216572109007), INT64_C(-8315109086095518889)),
      UINT8_C( 47),
      simde_mm512_set_epi64(INT64_C( -890089152921238147), INT64_C( 8823574133744668217),
                            INT64_C(-6364969741708969084), INT64_C(-1418976459802394322),
                            INT64_C( 4477375336277674053), INT64_C( 1282248710630285123),
                            INT64_C( 6638105739971879812), INT64_C(-8038098956427236545)),
      simde_mm256_set_epi64x(INT64_C(  961867877660623168), INT64_C( 2426510480636680010),
                             INT64_C(-6612602987193650875), INT64_C( 6143333881204814617)),
      simde_mm512_set_epi64(INT64_C(-4408197122649025847), INT64_C(  624651997750430240),
                            INT64_C(-6364969741708969084), INT64_C( 4693564151120802069),
                            INT64_C(  961867877660623168), INT64_C( 2426510480636680010),
                            INT64_C(-6612602987193650875), INT64_C( 6143333881204814617)),
      simde_mm512_set_epi64(INT64_C(-4408197122649025847), INT64_C(  624651997750430240),
                            INT64_C(-6612602987193650875), INT64_C( 4693564151120802069),
                            INT64_C( 4477375336277674053), INT64_C( 1282248710630285123),
                            INT64_C( 6638105739971879812), INT64_C(-8038098956427236545)) },
    { simde_mm512_set_epi64(INT64_C(-8949662758380266635), INT64_C( 4701312916269037777),
                            INT64_C(-1461656220613716217), INT64_C(-4369965941555109637),
                            INT64_C( 7350668077567080689), INT64_C( 8478919882954811661),
                            INT64_C(-3394066222784588743), INT64_C(-5009306653852991983)),
      UINT8_C( 51),
      simde_mm512_set_epi64(INT64_C( -393151907512138120), INT64_C(  600214805061827669),
                            INT64_C( 3163434753014979248), INT64_C( 3418472134552461373),
                            INT64_C(-6111840559061041971), INT64_C( 6656352319933975670),
                            INT64_C( 2357435311113502667), INT64_C(-8860733056306413573)),
      simde_mm256_set_epi64x(INT64_C(-3038909907977133732), INT64_C(-7842471790453318316),
                             INT64_C(-7256600765093102205), INT64_C( 3898178537456140670)),
      simde_mm512_set_epi64(INT64_C(-8949662758380266635), INT64_C( 4701312916269037777),
                            INT64_C( 3163434753014979248), INT64_C( 3418472134552461373),
                            INT64_C( 7350668077567080689), INT64_C( 8478919882954811661),
                            INT64_C(-7256600765093102205), INT64_C( 3898178537456140670)),
      simde_mm512_set_epi64(INT64_C(-8949662758380266635), INT64_C( 4701312916269037777),
                            INT64_C(-7256600765093102205), INT64_C( 3898178537456140670),
                            INT64_C( 7350668077567080689), INT64_C( 8478919882954811661),
                            INT64_C( 2357435311113502667), INT64_C(-8860733056306413573)) },
    { simde_mm512_set_epi64(INT64_C( 7306080674171373254), INT64_C( 2163582539809461657),
                            INT64_C(-7942896186346970451), INT64_C(-2775611318017263858),
                            INT64_C( 7897714815450887445), INT64_C(-2675129847260557604),
                            INT64_C( 2145911307457407401), INT64_C( 3797455296467543827)),
      UINT8_C(191),
      simde_mm512_set_epi64(INT64_C( -751557688731444383), INT64_C( 5324069355912068288),
                            INT64_C( 5226578984858504214), INT64_C(-8776157931044543560),
                            INT64_C(-1848672680316222475), INT64_C( 1658167909352451238),
                            INT64_C(  377173394815185621), INT64_C(-6742373427678247978)),
      simde_mm256_set_epi64x(INT64_C( 7620312646179506248), INT64_C(-4730811392556899367),
                             INT64_C(-7555925455226975890), INT64_C( 6555696811272222802)),
      simde_mm512_set_epi64(INT64_C( -751557688731444383), INT64_C( 2163582539809461657),
                            INT64_C( 5226578984858504214), INT64_C(-8776157931044543560),
                            INT64_C( 7620312646179506248), INT64_C(-4730811392556899367),
                            INT64_C(-7555925455226975890), INT64_C( 6555696811272222802)),
      simde_mm512_set_epi64(INT64_C( 7620312646179506248), INT64_C( 2163582539809461657),
                            INT64_C(-7555925455226975890), INT64_C( 6555696811272222802),
                            INT64_C(-1848672680316222475), INT64_C( 1658167909352451238),
                            INT64_C(  377173394815185621), INT64_C(-6742373427678247978)) },
    { simde_mm512_set_epi64(INT64_C( 1941135797030545610), INT64_C( 1935432241277000941),
                            INT64_C( 5390015454023535429), INT64_C(  -49705421380794940),
                            INT64_C( 3138707856740708121), INT64_C(-4673519228421997952),
                            INT64_C(-1556073591389999033), INT64_C( 3509487153133496527)),
      UINT8_C(191),
      simde_mm512_set_epi64(INT64_C(-7880186302232587827), INT64_C( 7848707034806784644),
                            INT64_C(-7246117184140796511), INT64_C( 5042844271761388948),
                            INT64_C(  877966720713550779), INT64_C(-8757547308289839577),
                            INT64_C( 6619480224799141474), INT64_C( 3171924723684651500)),
      simde_mm256_set_epi64x(INT64_C( 8280910196874944184), INT64_C( -368934386460614235),
                             INT64_C(-9011857488067354178), INT64_C( 5578921037540219940)),
      simde_mm512_set_epi64(INT64_C(-7880186302232587827), INT64_C( 1935432241277000941),
                            INT64_C(-7246117184140796511), INT64_C( 5042844271761388948),
                            INT64_C( 8280910196874944184), INT64_C( -368934386460614235),
                            INT64_C(-9011857488067354178), INT64_C( 5578921037540219940)),
      simde_mm512_set_epi64(INT64_C( 8280910196874944184), INT64_C( 1935432241277000941),
                            INT64_C(-9011857488067354178), INT64_C( 5578921037540219940),
                            INT64_C(  877966720713550779), INT64_C(-8757547308289839577),
                            INT64_C( 6619480224799141474), INT64_C( 3171924723684651500)) },
    { simde_mm512_set_epi64(INT64_C( 6286668337562607931), INT64_C( 1432089847019206822),
                            INT64_C(-2235254547542691893), INT64_C(-2975358417486477451),
                            INT64_C( 5974528986311566652), INT64_C( 4798128784982043356),
                            INT64_C(-3663239326212228984), INT64_C(-9199851098963784696)),
      UINT8_C(  9),
      simde_mm512_set_epi64(INT64_C(-3486865648830471282), INT64_C( 8151787653682140580),
                            INT64_C( -831601358278995789), INT64_C(-2800664419916301039),
                            INT64_C( 3280702275774868225), INT64_C(-4735905134864699368),
                            INT64_C( 7051416147935021095), INT64_C(-4824857292892203785)),
      simde_mm256_set_epi64x(INT64_C(-7733586635814839612), INT64_C(-3387038813920004365),
                             INT64_C(-6023807055599376167), INT64_C( 2056379472574346663)),
      simde_mm512_set_epi64(INT64_C( 6286668337562607931), INT64_C( 1432089847019206822),
                            INT64_C(-2235254547542691893), INT64_C(-2975358417486477451),
                            INT64_C(-7733586635814839612), INT64_C( 4798128784982043356),
                            INT64_C(-3663239326212228984), INT64_C( 2056379472574346663)),
      simde_mm512_set_epi64(INT64_C( 6286668337562607931), INT64_C( 1432089847019206822),
                            INT64_C(-2235254547542691893), INT64_C(-2975358417486477451),
                            INT64_C( 3280702275774868225), INT64_C( 4798128784982043356),
                            INT64_C(-3663239326212228984), INT64_C(-4824857292892203785)) },
    { simde_mm512_set_epi64(INT64_C(-1389624339165317749), INT64_C(-8184083999390244234),
                            INT64_C( 8331479114169761131), INT64_C( 8817045194671758320),
                            INT64_C(-5234965963681749811), INT64_C(-5331803015084564567),
                            INT64_C(-2592115690296560951), INT64_C( 1248919004007478956)),
      UINT8_C(200),
      simde_mm512_set_epi64(INT64_C(-2742037214038451026), INT64_C(  735886283373328205),
                            INT64_C(  709814645617696632), INT64_C( 6904524208941840952),
                            INT64_C(-7164378700336361334), INT64_C( 4351794567182281042),
                            INT64_C(-1716872434006574729), INT64_C( -689503347190866770)),
      simde_mm256_set_epi64x(INT64_C( 8457250603347908949), INT64_C(-2879367942796632989),
                             INT64_C( 4447365578798205979), INT64_C( 6508361231067538121)),
      simde_mm512_set_epi64(INT64_C(-2742037214038451026), INT64_C(  735886283373328205),
                            INT64_C( 8331479114169761131), INT64_C( 8817045194671758320),
                            INT64_C( 8457250603347908949), INT64_C(-5331803015084564567),
                            INT64_C(-2592115690296560951), INT64_C( 1248919004007478956)),
      simde_mm512_set_epi64(INT64_C( 8457250603347908949), INT64_C(-2879367942796632989),
                            INT64_C( 8331479114169761131), INT64_C( 8817045194671758320),
                            INT64_C(-7164378700336361334), INT64_C(-5331803015084564567),
                            INT64_C(-2592115690296560951), INT64_C( 1248919004007478956)) },
    { simde_mm512_set_epi64(INT64_C( 7927414333096918356), INT64_C(-6028737433755228757),
                            INT64_C(-6289085317177674471), INT64_C(-5541511610486147753),
                            INT64_C( 6531713794566454707), INT64_C( -446705336047418133),
                            INT64_C(-6709780755556058351), INT64_C( 2443726936750986290)),
      UINT8_C(108),
      simde_mm512_set_epi64(INT64_C(-8286621218977708484), INT64_C(-7274138402675197655),
                            INT64_C( 7751882187628938139), INT64_C(-6483923961368987645),
                            INT64_C(-7861334054348205497), INT64_C( 1332497272334397574),
                            INT64_C(-5616284701672264206), INT64_C( 2669799685376652269)),
      simde_mm256_set_epi64x(INT64_C(  200988278415395979), INT64_C(-2971850709824830963),
                             INT64_C(-2133313091920417115), INT64_C( 4623597880832003711)),
      simde_mm512_set_epi64(INT64_C( 7927414333096918356), INT64_C(-7274138402675197655),
                            INT64_C( 7751882187628938139), INT64_C(-5541511610486147753),
                            INT64_C(  200988278415395979), INT64_C(-2971850709824830963),
                            INT64_C(-6709780755556058351), INT64_C( 2443726936750986290)),
      simde_mm512_set_epi64(INT64_C( 7927414333096918356), INT64_C(-2971850709824830963),
                            INT64_C(-2133313091920417115), INT64_C(-5541511610486147753),
                            INT64_C(-7861334054348205497), INT64_C( 1332497272334397574),
                            INT64_C(-6709780755556058351), INT64_C( 2443726936750986290)) },
    { simde_mm512_set_epi64(INT64_C(-2107226359725098394), INT64_C(-4111796092278699383),
                            INT64_C(-7795021097560230286), INT64_C( -756190175563217595),
                            INT64_C(-6005669436564621566), INT64_C(  848382361298179127),
                            INT64_C( 1511386602075754511), INT64_C(-7343592175834719092)),
      UINT8_C(114),
      simde_mm512_set_epi64(INT64_C(-5446377680450598123), INT64_C( 6545920141858823590),
                            INT64_C(-6109676225565942508), INT64_C( 7950769636462343621),
                            INT64_C(-2554331370738443173), INT64_C( 3394005203063129217),
                            INT64_C(-2129862572478557053), INT64_C( 6740280704142266940)),
      simde_mm256_set_epi64x(INT64_C(-7150215929147729012), INT64_C( 4777590230543990164),
                             INT64_C(-7212709010936609343), INT64_C(-5423311652387614668)),
      simde_mm512_set_epi64(INT64_C(-2107226359725098394), INT64_C( 6545920141858823590),
                            INT64_C(-6109676225565942508), INT64_C( 7950769636462343621),
                            INT64_C(-6005669436564621566), INT64_C(  848382361298179127),
                            INT64_C(-7212709010936609343), INT64_C(-7343592175834719092)),
      simde_mm512_set_epi64(INT64_C(-2107226359725098394), INT64_C( 4777590230543990164),
                            INT64_C(-7212709010936609343), INT64_C(-5423311652387614668),
                            INT64_C(-6005669436564621566), INT64_C(  848382361298179127),
                            INT64_C(-2129862572478557053), INT64_C(-7343592175834719092)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r;
    r = simde_mm512_mask_inserti64x4(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b, 0);
    simde_assert_m512i_i64(r, ==, test_vec[i].r0);
    r = simde_mm512_mask_inserti64x4(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b, 1);
    simde_assert_m512i_i64(r, ==, test_vec[i].r1);
  }

  return 0;
}

static int
test_simde_mm512_maskz_inserti64x4(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask8 k;
    simde__m512i a;
    simde__m256i b;
    simde__m512i r0;
    simde__m512i r1;
  } test_vec[8] = {
    { UINT8_C( 46),
      simde_mm512_set_epi64(INT64_C(-4408197122649025847), INT64_C(  624651997750430240),
                            INT64_C(-3688244718601593553), INT64_C( 4693564151120802069),
                            INT64_C( 7940316924786767481), INT64_C( 6743600876828439814),
                            INT64_C( 8561828216572109007), INT64_C(-8315109086095518889)),
      simde_mm256_set_epi64x(INT64_C( 4477375336277674053), INT64_C( 1282248710630285123),
                             INT64_C( 6638105739971879812), INT64_C(-8038098956427236545)),
      simde_mm512_set_epi64(INT64_C(                   0), INT64_C(                   0),
                            INT64_C(-3688244718601593553), INT64_C(                   0),
                            INT64_C( 4477375336277674053), INT64_C( 1282248710630285123),
                            INT64_C( 6638105739971879812), INT64_C(                   0)),
      simde_mm512_set_epi64(INT64_C(                   0), INT64_C(                   0),
                            INT64_C( 6638105739971879812), INT64_C(                   0),
                            INT64_C( 7940316924786767481), INT64_C( 6743600876828439814),
                            INT64_C( 8561828216572109007), INT64_C(                   0)) },
    { UINT8_C(251),
      simde_mm512_set_epi64(INT64_C(-8749971605870264899), INT64_C( 1212032624670585453),
                            INT64_C(  728623586565902494), INT64_C( 4873652658109514141),
                            INT64_C(-4767707706458520415), INT64_C(-7083171014951853588),
                            INT64_C(-2076988212358998594), INT64_C( 3698505898575972461)),
      simde_mm256_set_epi64x(INT64_C( 7350668077567080689), INT64_C( 8478919882954811661),
                             INT64_C(-3394066222784588743), INT64_C(-5009306653852991983)),
      simde_mm512_set_epi64(INT64_C(-8749971605870264899), INT64_C( 1212032624670585453),
                            INT64_C(  728623586565902494), INT64_C( 4873652658109514141),
                            INT64_C( 7350668077567080689), INT64_C(                   0),
                            INT64_C(-3394066222784588743), INT64_C(-5009306653852991983)),
      simde_mm512_set_epi64(INT64_C( 7350668077567080689), INT64_C( 8478919882954811661),
                            INT64_C(-3394066222784588743), INT64_C(-5009306653852991983),
                            INT64_C(-4767707706458520415), INT64_C(                   0),
                            INT64_C(-2076988212358998594), INT64_C( 3698505898575972461)) },
    { UINT8_C(185),
      simde_mm512_set_epi64(INT64_C( 7391005387705442660), INT64_C(-5091463632259113685),
                            INT64_C(  685405269785004780), INT64_C(-2602517860068074949),
                            INT64_C( 4704994953943345443), INT64_C( 8877610218385468208),
                            INT64_C( 5776984527519295337), INT64_C( 6526937450820584225)),
      simde_mm256_set_epi64x(INT64_C( -855682284319457684), INT64_C( 5906689130134529071),
                             INT64_C( 7251917267735594789), INT64_C(-5506395256633894325)),
      simde_mm512_set_epi64(INT64_C( 7391005387705442660), INT64_C(                   0),
                            INT64_C(  685405269785004780), INT64_C(-2602517860068074949),
                            INT64_C( -855682284319457684), INT64_C(                   0),
                            INT64_C(                   0), INT64_C(-5506395256633894325)),
      simde_mm512_set_epi64(INT64_C( -855682284319457684), INT64_C(                   0),
                            INT64_C( 7251917267735594789), INT64_C(-5506395256633894325),
                            INT64_C( 4704994953943345443), INT64_C(                   0),
                            INT64_C(                   0), INT64_C( 6526937450820584225)) },
    { UINT8_C( 23),
      simde_mm512_set_epi64(INT64_C( 5406280044045291975), INT64_C(-2284955492954404973),
                            INT64_C(-3603637419527123210), INT64_C(-1117409850830928520),
                            INT64_C(-1414228054518303181), INT64_C(-3038909907977133732),
                            INT64_C(-7842471790453318316), INT64_C(-7256600765093102205)),
      simde_mm256_set_epi64x(INT64_C( 1455933536394832297), INT64_C( -840828676201867557),
                             INT64_C( 6310833464661060096), INT64_C( 8429580363859954742)),
      simde_mm512_set_epi64(INT64_C(                   0), INT64_C(                   0),
                            INT64_C(                   0), INT64_C(-1117409850830928520),
                            INT64_C(                   0), INT64_C( -840828676201867557),
                            INT64_C( 6310833464661060096), INT64_C( 8429580363859954742)),
      simde_mm512_set_epi64(INT64_C(                   0), INT64_C(                   0),
                            INT64_C(                   0), INT64_C( 8429580363859954742),
                            INT64_C(                   0), INT64_C(-3038909907977133732),
                            INT64_C(-7842471790453318316), INT64_C(-7256600765093102205)) },
    { UINT8_C(248),
      simde_mm512_set_epi64(INT64_C( 6555696811272222802), INT64_C( -751557688731444383),
                            INT64_C( 5324069355912068288), INT64_C( 5226578984858504214),
                            INT64_C(-8776157931044543560), INT64_C(-1848672680316222475),
                            INT64_C( 1658167909352451238), INT64_C(  377173394815185621)),
      simde_mm256_set_epi64x(INT64_C(-4444585746033374017), INT64_C( 7620312646179506248),
                             INT64_C(-4730811392556899367), INT64_C(-7555925455226975890)),
      simde_mm512_set_epi64(INT64_C( 6555696811272222802), INT64_C( -751557688731444383),
                            INT64_C( 5324069355912068288), INT64_C( 5226578984858504214),
                            INT64_C(-4444585746033374017), INT64_C(                   0),
                            INT64_C(                   0), INT64_C(                   0)),
      simde_mm512_set_epi64(INT64_C(-4444585746033374017), INT64_C( 7620312646179506248),
                            INT64_C(-4730811392556899367), INT64_C(-7555925455226975890),
                            INT64_C(-8776157931044543560), INT64_C(                   0),
                            INT64_C(                   0), INT64_C(                   0)) },
    { UINT8_C(161),
      simde_mm512_set_epi64(INT64_C( 3171924723684651500), INT64_C( 1941135797030545610),
                            INT64_C( 1935432241277000941), INT64_C( 5390015454023535429),
                            INT64_C(  -49705421380794940), INT64_C( 3138707856740708121),
                            INT64_C(-4673519228421997952), INT64_C(-1556073591389999033)),
      simde_mm256_set_epi64x(INT64_C( 5042844271761388948), INT64_C(  877966720713550779),
                             INT64_C(-8757547308289839577), INT64_C( 6619480224799141474)),
      simde_mm512_set_epi64(INT64_C( 3171924723684651500), INT64_C(                   0),
                            INT64_C( 1935432241277000941), INT64_C(                   0),
                            INT64_C(                   0), INT64_C(                   0),
                            INT64_C(                   0), INT64_C( 6619480224799141474)),
      simde_mm512_set_epi64(INT64_C( 5042844271761388948), INT64_C(                   0),
                            INT64_C(-8757547308289839577), INT64_C(                   0),
                            INT64_C(                   0), INT64_C(                   0),
                            INT64_C(                   0), INT64_C(-1556073591389999033)) },
    { UINT8_C(203),
      simde_mm512_set_epi64(INT64_C(-9199851098963784696), INT64_C( 5640400914757694451),
                            INT64_C( 3288787407719188513), INT64_C( 6167294471968879452),
                            INT64_C(-8553143016080257248), INT64_C( 1191725626053358671),
                            INT64_C( 2560034487176803702), INT64_C(-4340183042637127984)),
      simde_mm256_set_epi64x(INT64_C(-2975358417486477451), INT64_C( 5974528986311566652),
                             INT64_C( 4798128784982043356), INT64_C(-3663239326212228984)),
      simde_mm512_set_epi64(INT64_C(-9199851098963784696), INT64_C( 5640400914757694451),
                            INT64_C(                   0), INT64_C(                   0),
                            INT64_C(-2975358417486477451), INT64_C(                   0),
                            INT64_C( 4798128784982043356), INT64_C(-3663239326212228984)),
      simde_mm512_set_epi64(INT64_C(-2975358417486477451), INT64_C( 5974528986311566652),
                            INT64_C(                   0), INT64_C(                   0),
                            INT64_C(-8553143016080257248), INT64_C(                   0),
                            INT64_C( 2560034487176803702), INT64_C(-4340183042637127984)) },
    { UINT8_C(101),
      simde_mm512_set_epi64(INT64_C( 9010665687833774732), INT64_C( 8345237253505115478),
                            INT64_C(-9124175189821182113), INT64_C( 3058208134496233888),
                            INT64_C( 7286481320132913626), INT64_C( -777692308098335861),
                            INT64_C( 8727238559278288416), INT64_C(-2736507802934917164)),
      simde_mm256_set_epi64x(INT64_C(  -35491302857917892), INT64_C( 3617223551823391274),
                             INT64_C(-6488944280908793938), INT64_C( 6206969247155195640)),
      simde_mm512_set_epi64(INT64_C(                   0), INT64_C( 8345237253505115478),
                            INT64_C(-9124175189821182113), INT64_C(                   0),
                            INT64_C(                   0), INT64_C( 3617223551823391274),
                            INT64_C(                   0), INT64_C( 6206969247155195640)),
      simde_mm512_set_epi64(INT64_C(                   0), INT64_C( 3617223551823391274),
                            INT64_C(-6488944280908793938), INT64_C(                   0),
                            INT64_C(                   0), INT64_C( -777692308098335861),
                            INT64_C(                   0), INT64_C(-2736507802934917164)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r;
    r = simde_mm512_maskz_inserti64x4(test_vec[i].k, test_vec[i].a, test_vec[i].b, 0);
    simde_assert_m512i_i64(r, ==, test_vec[i].r0);
    r = simde_mm512_maskz_inserti64x4(test_vec[i].k, test_vec[i].a, test_vec[i].b, 1);
    simde_assert_m512i_i64(r, ==, test_vec[i].r1);
  }

  return 0;
}

SIMDE_TEST_FUNC_LIST_BEGIN
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_insertf32x4)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_mask_insertf32x4)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_maskz_insertf32x4)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_insertf64x4)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_mask_insertf64x4)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_maskz_insertf64x4)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_inserti32x4)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_mask_inserti32x4)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_maskz_inserti32x4)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_inserti64x4)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_mask_inserti64x4)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_maskz_inserti64x4)
SIMDE_TEST_FUNC_LIST_END

#include <test/x86/avx512/test-avx512-footer.h>
