/*
**  Sinek (Video Player)
**  Copyright (c) 2001 - 2002 the Sinek Team, see the AUTHORS file.
**
**  This code is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License.
**
**  screen saver control
*/

#include "common.h"

static struct scrsaver_data
{
	int x_disabled;
	int x_timeout;
	int x_interval;
	int x_prefer_blanking;
	int x_allow_exposures;
} *ssd = NULL;


void disable_blanking(void)
{
	if(!ssd)
	{
		ssd = malloc(sizeof(struct scrsaver_data));
		memset(ssd, 0, sizeof(struct scrsaver_data));
	}
	if(ssd->x_disabled == 0)
	{
		XGetScreenSaver(sinek.display, &ssd->x_timeout, &ssd->x_interval, &ssd->x_prefer_blanking, &ssd->x_allow_exposures);
		XSetScreenSaver(sinek.display, 0, 0, DontPreferBlanking, DontAllowExposures);
		ssd->x_disabled = 1;
	}
}


void enable_blanking(void)
{
	if(ssd && ssd->x_disabled)
	{
		XSetScreenSaver(sinek.display, ssd->x_timeout, ssd->x_interval, ssd->x_prefer_blanking, ssd->x_allow_exposures);
		ssd->x_disabled = 0;
	}
}
