#include <string>
#include <boost/bind.hpp>
#include "messagesinfotypes.h"
#include "messagebasictypes.h"
#include "messagecomplextypes.h"
#include "sinforequester.h"
using namespace std;
using namespace Msg;


SinfoRequester::SinfoRequester(ProtocolIO & protocolIO, SinfoData & _sinfoData)
    : waitForConnectionReadyTimer(protocolIO), periodicRequestTimer(protocolIO), requestUpdateTimer(protocolIO), sinfoData(_sinfoData)
{
  delay_millisec=1000;
  timeout_millisec=1000;
  stopAfterOneRequest=false;

  waitForConnectionReadyTimer.startAlarmAfter(boost::posix_time::millisec(timeout_millisec), boost::bind(&SinfoRequester::waitForConnectionReadyTimerExpiredEvent, this));
}


void SinfoRequester::waitForConnectionReadyTimerExpiredEvent()
{
  //cout << "SinfoRequester::waitForConnectionReadyTimerExpiredEvent()" << endl;
  timeoutSignal();
  // no new Event queued
}


void SinfoRequester::connectionReadySlot()
{
  waitForConnectionReadyTimer.stop();
  requestUpdate();
}


void SinfoRequester::requestUpdate()
{
  Message message;
  if (filterMarker.size()>0)
  {
    pushBackuint8(message,7);
    pushBackstring8(message,filterMarker);
  }
  else
  {
    pushBackuint8(message,5);
  }

  queueAndSendMessageSignal(message);

  requestUpdateTimer.startAlarmAfter(boost::posix_time::millisec(timeout_millisec), boost::bind(&SinfoRequester::requestUpdateTimerExpiredEvent, this));
}


void SinfoRequester::requestUpdateTimerExpiredEvent()
{
  //cout << "SinfoRequester::requestUpdateTimerExpiredEvent()" << endl;
  timeoutSignal();
  if (false==stopAfterOneRequest)
  {
    periodicRequestTimer.startAlarmAfter(boost::posix_time::millisec(delay_millisec), boost::bind(&SinfoRequester::periodicRequestTimerExpiredEvent, this));
  }
}


void SinfoRequester::receivedMessageSlot(Message & returnMessage)
{
  requestUpdateTimer.stop();

  unsigned char messageID;
  popFrontuint8(returnMessage, messageID);

  unsigned short wsinfocount = 0;
  popFrontuint16(returnMessage, wsinfocount);

  std::list < Wsinfo > & wsinfoList=sinfoData.wsinfoList;
  // delete all entries
  std::list < Wsinfo > ::iterator it = wsinfoList.begin();
  while (it != wsinfoList.end())
  {
    it = wsinfoList.erase(it);
  }
  // read data
  for (int i=0;i<wsinfocount;i++)
  {
    Wsinfo wsinfoTmp;
    popFrontWsinfo(returnMessage, wsinfoTmp);
    wsinfoList.push_back(wsinfoTmp);
  }
  wsinfoList.sort();
  // inform all observers that sinfoData has been changed
  sinfoData.changedSignal();

  if (false==stopAfterOneRequest)
  {
    periodicRequestTimer.startAlarmAfter(boost::posix_time::millisec(delay_millisec), boost::bind(&SinfoRequester::periodicRequestTimerExpiredEvent, this));
  }
}


void SinfoRequester::periodicRequestTimerExpiredEvent()
{
  requestUpdate();
}
