#ifndef _udpmessageserver_h
#define _udpmessageserver_h

#include <asio.hpp>
#include "messageserver.h"
#include "messageioconst.h"


class UDPMessageServer : public MessageServer
{
private:
  char data[maxMessageIOSize];
  asio::ip::udp::endpoint sender_endpoint;

  asio::io_service & ioservice;
  asio::ip::udp::socket sock;


  void handleReceiveFrom(const asio::error_code& err, size_t length);

public:
  UDPMessageServer(asio::io_service& io_service, const asio::ip::udp::endpoint & endpoint);
};


#endif
