/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.config.entities;

import com.opensymphony.xwork2.config.entities.Parameterizable;
import com.opensymphony.xwork2.util.location.Located;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class InterceptorConfig
extends Located
implements Parameterizable,
Serializable {
    Map params;
    String className;
    String name;

    public InterceptorConfig() {
    }

    public InterceptorConfig(String name, Class clazz, Map params) {
        this.name = name;
        this.className = clazz.getName();
        this.params = params;
    }

    public InterceptorConfig(String name, String className, Map params) {
        this.name = name;
        this.className = className;
        this.params = params;
    }

    public InterceptorConfig(InterceptorConfig parent, Map params) {
        this.name = parent.getName();
        this.className = parent.getClassName();
        this.params = new HashMap(parent.getParams());
        this.params.putAll(params);
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setParams(Map params) {
        this.params = params;
    }

    public Map getParams() {
        if (this.params == null) {
            this.params = new LinkedHashMap();
        }
        return this.params;
    }

    public void addParam(String name, Object value) {
        this.getParams().put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InterceptorConfig)) {
            return false;
        }
        InterceptorConfig interceptorConfig = (InterceptorConfig)o;
        if (this.className != null ? !this.className.equals(interceptorConfig.className) : interceptorConfig.className != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(interceptorConfig.name) : interceptorConfig.name != null) {
            return false;
        }
        return !(this.params != null ? !((Object)this.params).equals(interceptorConfig.params) : interceptorConfig.params != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 29 * result + (this.className != null ? this.className.hashCode() : 0);
        result = 29 * result + (this.params != null ? ((Object)this.params).hashCode() : 0);
        return result;
    }
}

