/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.xwork.ObjectUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.StrutsResultSupport;
import org.apache.struts2.views.util.UrlHelper;

public class ServletDispatcherResult
extends StrutsResultSupport {
    private static final long serialVersionUID = -1970659272360685627L;
    private static final Logger LOG = LoggerFactory.getLogger(ServletDispatcherResult.class);

    public ServletDispatcherResult() {
    }

    public ServletDispatcherResult(String location) {
        super(location);
    }

    public void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        PageContext pageContext;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Forwarding to location " + finalLocation, new String[0]);
        }
        if ((pageContext = ServletActionContext.getPageContext()) != null) {
            pageContext.include(finalLocation);
        } else {
            HttpServletRequest request = ServletActionContext.getRequest();
            HttpServletResponse response = ServletActionContext.getResponse();
            RequestDispatcher dispatcher = request.getRequestDispatcher(finalLocation);
            if (invocation != null && finalLocation != null && finalLocation.length() > 0 && finalLocation.indexOf("?") > 0) {
                String queryString = finalLocation.substring(finalLocation.indexOf("?") + 1);
                Map parameters = (Map)invocation.getInvocationContext().getContextMap().get("parameters");
                Map queryParams = UrlHelper.parseQueryString(queryString, true);
                if (queryParams != null && !queryParams.isEmpty()) {
                    parameters.putAll(queryParams);
                }
            }
            if (dispatcher == null) {
                response.sendError(404, "result '" + finalLocation + "' not found");
                return;
            }
            Boolean insideActionTag = (Boolean)ObjectUtils.defaultIfNull((Object)request.getAttribute("struts.actiontag.invocation"), (Object)Boolean.FALSE);
            if (!insideActionTag.booleanValue() && !response.isCommitted() && request.getAttribute("javax.servlet.include.servlet_path") == null) {
                request.setAttribute("struts.view_uri", (Object)finalLocation);
                request.setAttribute("struts.request_uri", (Object)request.getRequestURI());
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            } else {
                dispatcher.include((ServletRequest)request, (ServletResponse)response);
            }
        }
    }
}

