/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.collections;

import com.db4o.activation.Activator;
import com.db4o.collections.AbstractList4;
import com.db4o.ta.Activatable;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayList4<E>
extends AbstractList4<E>
implements Cloneable,
Serializable,
RandomAccess,
Activatable {
    private static final long serialVersionUID = 7971683768827646182L;
    private E[] elements;
    private int capacity;
    private int listSize;
    private transient Activator _activator;

    @Override
    public void activate() {
        if (this._activator != null) {
            this._activator.activate();
        }
    }

    @Override
    public void bind(Activator activator) {
        if (this._activator != null || activator == null) {
            throw new IllegalStateException();
        }
        this._activator = activator;
    }

    public ArrayList4() {
        this(10);
    }

    public ArrayList4(Collection<? extends E> collection) {
        Object[] objectArray = collection.toArray();
        this.capacity = objectArray.length;
        this.elements = new Object[this.capacity];
        this.listSize = objectArray.length;
        System.arraycopy(objectArray, 0, this.elements, 0, objectArray.length);
    }

    public ArrayList4(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = n;
        this.elements = new Object[n];
    }

    @Override
    public void add(int n, E e) {
        this.checkIndex(n, 0, this.size());
        this.ensureCapacity(this.size() + 1);
        System.arraycopy(this.elements, n, this.elements, n + 1, this.listSize - n);
        this.elements[n] = e;
        this.increaseSize(1);
        this.markModified();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        this.checkIndex(n, 0, this.size());
        int n2 = collection.size();
        if (n2 == 0) {
            return false;
        }
        this.ensureCapacity(this.size() + n2);
        Object[] objectArray = collection.toArray();
        System.arraycopy(this.elements, n, this.elements, n + n2, this.size() - n);
        System.arraycopy(objectArray, 0, this.elements, n, n2);
        this.increaseSize(n2);
        this.markModified();
        return true;
    }

    @Override
    public void clear() {
        int n = this.size();
        Arrays.fill(this.elements, 0, n, null);
        this.setSize(0);
        this.markModified();
    }

    public Object clone() {
        this.activate();
        try {
            ArrayList4 arrayList4 = (ArrayList4)super.clone();
            arrayList4.elements = (Object[])this.elements.clone();
            return arrayList4;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException);
        }
    }

    public void ensureCapacity(int n) {
        this.activate();
        if (n <= this.capacity) {
            return;
        }
        this.resize(n);
    }

    @Override
    public E get(int n) {
        this.checkIndex(n, 0, this.size() - 1);
        return this.elements[n];
    }

    @Override
    public int indexOf(Object object) {
        for (int i = 0; i < this.size(); ++i) {
            E e = this.get(i);
            if (!(object == null ? e == null : object.equals(e))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        for (int i = this.size() - 1; i >= 0; --i) {
            E e = this.get(i);
            if (!(object == null ? e == null : object.equals(e))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public E remove(int n) {
        int n2 = this.size();
        this.checkIndex(n, 0, n2 - 1);
        E e = this.elements[n];
        System.arraycopy(this.elements, n + 1, this.elements, n, n2 - n - 1);
        this.elements[n2 - 1] = null;
        this.decreaseSize(1);
        this.markModified();
        return e;
    }

    @Override
    protected void removeRange(int n, int n2) {
        int n3 = this.size();
        if (n < 0 || n >= n3 || n2 > n3 || n2 < n) {
            throw new IndexOutOfBoundsException();
        }
        if (n == n2) {
            return;
        }
        int n4 = n2 - n;
        System.arraycopy(this.elements, n2, this.elements, n, n3 - n2);
        Arrays.fill(this.elements, n3 - n4, n3, null);
        this.decreaseSize(n4);
        this.markModified();
    }

    @Override
    public E set(int n, E e) {
        this.checkIndex(n, 0, this.size() - 1);
        E e2 = this.elements[n];
        this.elements[n] = e;
        return e2;
    }

    @Override
    public int size() {
        this.activate();
        return this.listSize;
    }

    @Override
    public Object[] toArray() {
        int n = this.size();
        Object[] objectArray = new Object[n];
        System.arraycopy(this.elements, 0, objectArray, 0, n);
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        System.arraycopy(this.elements, 0, objectArray, 0, n);
        return objectArray;
    }

    public void trimToSize() {
        this.resize(this.size());
    }

    private void resize(int n) {
        this.markModified();
        Object[] objectArray = new Object[n];
        System.arraycopy(this.elements, 0, objectArray, 0, this.size());
        this.elements = objectArray;
        this.capacity = n;
    }

    void setSize(int n) {
        this.listSize = n;
    }

    void increaseSize(int n) {
        this.listSize += n;
    }

    void decreaseSize(int n) {
        this.listSize -= n;
    }

    void markModified() {
        ++this.modCount;
    }
}

