/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.DatabaseClosedException;
import com.db4o.DatabaseReadOnlyException;
import com.db4o.Db4oIOException;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.config.Configuration;
import com.db4o.constraints.UniqueFieldValueConstraintViolationException;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.Db4oUUID;
import com.db4o.ext.ExtObjectContainer;
import com.db4o.ext.InvalidIDException;
import com.db4o.ext.ObjectInfo;
import com.db4o.ext.StoredClass;
import com.db4o.ext.SystemInfo;
import com.db4o.foundation.NotSupportedException;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.HandlerRegistry;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectContainerSpec;
import com.db4o.internal.Transaction;
import com.db4o.internal.callbacks.Callbacks;
import com.db4o.internal.query.NativeQueryHandler;
import com.db4o.query.Predicate;
import com.db4o.query.Query;
import com.db4o.query.QueryComparator;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.generic.GenericReflector;
import com.db4o.replication.ReplicationConflictHandler;
import com.db4o.replication.ReplicationProcess;
import com.db4o.types.Db4oCollections;
import com.db4o.types.TransientClass;

public abstract class PartialEmbeddedClientObjectContainer
implements TransientClass,
ObjectContainerSpec {
    protected final LocalObjectContainer _server;
    protected final Transaction _transaction;
    private boolean _closed = false;

    public PartialEmbeddedClientObjectContainer(LocalObjectContainer localObjectContainer, Transaction transaction) {
        this._server = localObjectContainer;
        this._transaction = transaction;
        this._transaction.setOutSideRepresentation(PartialEmbeddedClientObjectContainer.cast(this));
    }

    public PartialEmbeddedClientObjectContainer(LocalObjectContainer localObjectContainer) {
        this(localObjectContainer, localObjectContainer.newTransaction(localObjectContainer.systemTransaction(), localObjectContainer.createReferenceSystem()));
    }

    public void backup(String string) throws Db4oIOException, DatabaseClosedException, NotSupportedException {
        throw new NotSupportedException();
    }

    public void bind(Object object, long l) throws InvalidIDException, DatabaseClosedException {
        this._server.bind(this._transaction, object, l);
    }

    public Db4oCollections collections() {
        return this._server.collections(this._transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration configure() {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.configure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object descend(Object object, String[] stringArray) {
        Object object2 = this.lock();
        synchronized (object2) {
            this.checkClosed();
            return this._server.descend(this._transaction, object, stringArray);
        }
    }

    private void checkClosed() {
        if (this.isClosed()) {
            throw new DatabaseClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getByID(long l) throws DatabaseClosedException, InvalidIDException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.getByID(this._transaction, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getByUUID(Db4oUUID db4oUUID) throws DatabaseClosedException, Db4oIOException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.getByUUID(this._transaction, db4oUUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getID(Object object) {
        Object object2 = this.lock();
        synchronized (object2) {
            this.checkClosed();
            return this._server.getID(this._transaction, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInfo getObjectInfo(Object object) {
        Object object2 = this.lock();
        synchronized (object2) {
            this.checkClosed();
            return this._server.getObjectInfo(this._transaction, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Db4oDatabase identity() {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.identity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive(Object object) {
        Object object2 = this.lock();
        synchronized (object2) {
            this.checkClosed();
            return this._server.isActive(this._transaction, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCached(long l) {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.isCached(this._transaction, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.lock();
        synchronized (object) {
            return this._closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStored(Object object) throws DatabaseClosedException {
        Object object2 = this.lock();
        synchronized (object2) {
            this.checkClosed();
            return this._server.isStored(this._transaction, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReflectClass[] knownClasses() {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.knownClasses();
        }
    }

    public Object lock() {
        return this._server.lock();
    }

    public void migrateFrom(ObjectContainer objectContainer) {
        throw new NotSupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peekPersisted(Object object, int n, boolean bl) {
        Object object2 = this.lock();
        synchronized (object2) {
            this.checkClosed();
            return this._server.peekPersisted(this._transaction, object, n, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            this._server.purge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(Object object) {
        Object object2 = this.lock();
        synchronized (object2) {
            this.checkClosed();
            this._server.purge(this._transaction, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericReflector reflector() {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.reflector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object object, int n) {
        Object object2 = this.lock();
        synchronized (object2) {
            this.checkClosed();
            this._server.refresh(this._transaction, object, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSemaphore(String string) {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            this._server.releaseSemaphore(this._transaction, string);
        }
    }

    public ReplicationProcess replicationBegin(ObjectContainer objectContainer, ReplicationConflictHandler replicationConflictHandler) {
        throw new NotSupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Object object, int n) {
        Object object2 = this.lock();
        synchronized (object2) {
            this.checkClosed();
            this._server.set(this._transaction, object, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSemaphore(String string, int n) {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.setSemaphore(this._transaction, string, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredClass storedClass(Object object) {
        Object object2 = this.lock();
        synchronized (object2) {
            this.checkClosed();
            return this._server.storedClass(this._transaction, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredClass[] storedClasses() {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.storedClasses(this._transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemInfo systemInfo() {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.systemInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long version() {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.version();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(Object object, int n) throws Db4oIOException, DatabaseClosedException {
        Object object2 = this.lock();
        synchronized (object2) {
            this.checkClosed();
            this._server.activate(this._transaction, object, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() throws Db4oIOException {
        Object object = this.lock();
        synchronized (object) {
            if (this.isClosed()) {
                return false;
            }
            if (!this._server.isClosed() && !this._server.configImpl().isReadOnly()) {
                this.commit();
            }
            this._transaction.close(false);
            this._closed = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws Db4oIOException, DatabaseClosedException, DatabaseReadOnlyException, UniqueFieldValueConstraintViolationException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            this._server.commit(this._transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(Object object, int n) throws DatabaseClosedException {
        Object object2 = this.lock();
        synchronized (object2) {
            this.checkClosed();
            this._server.deactivate(this._transaction, object, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Object object) throws Db4oIOException, DatabaseClosedException, DatabaseReadOnlyException {
        Object object2 = this.lock();
        synchronized (object2) {
            this.checkClosed();
            this._server.delete(this._transaction, object);
        }
    }

    public ExtObjectContainer ext() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectSet get(Object object) throws Db4oIOException, DatabaseClosedException {
        Object object2 = this.lock();
        synchronized (object2) {
            this.checkClosed();
            return this._server.get(this._transaction, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query query() throws DatabaseClosedException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.query(this._transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectSet query(Class clazz) throws Db4oIOException, DatabaseClosedException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.query(this._transaction, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectSet query(Predicate predicate) throws Db4oIOException, DatabaseClosedException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.query(this._transaction, predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectSet query(Predicate predicate, QueryComparator queryComparator) throws Db4oIOException, DatabaseClosedException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.query(this._transaction, predicate, queryComparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws Db4oIOException, DatabaseClosedException, DatabaseReadOnlyException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            this._server.rollback(this._transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Object object) throws DatabaseClosedException, DatabaseReadOnlyException {
        Object object2 = this.lock();
        synchronized (object2) {
            this.checkClosed();
            this._server.set(this._transaction, object);
        }
    }

    public ObjectContainerBase container() {
        return this._server;
    }

    public Transaction transaction() {
        return this._transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callbacks(Callbacks callbacks) {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            this._server.callbacks(callbacks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Callbacks callbacks() {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.callbacks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final NativeQueryHandler getNativeQueryHandler() {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.getNativeQueryHandler();
        }
    }

    public void onCommittedListener() {
    }

    private static ObjectContainer cast(PartialEmbeddedClientObjectContainer partialEmbeddedClientObjectContainer) {
        return partialEmbeddedClientObjectContainer;
    }

    public ClassMetadata classMetadataForReflectClass(ReflectClass reflectClass) {
        return this._server.classMetadataForReflectClass(reflectClass);
    }

    public ClassMetadata classMetadataForName(String string) {
        return this._server.classMetadataForName(string);
    }

    public ClassMetadata classMetadataForId(int n) {
        return this._server.classMetadataForId(n);
    }

    public HandlerRegistry handlers() {
        return this._server.handlers();
    }
}

