/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs;

import com.db4o.Db4o;
import com.db4o.foundation.Entry4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.PartialObjectContainer;
import com.db4o.internal.Transaction;

public class ClientTransactionPool {
    private final Hashtable4 _transaction2Container;
    private final Hashtable4 _fileName2Container;
    private final LocalObjectContainer _mainContainer;
    private boolean _closed;

    public ClientTransactionPool(LocalObjectContainer localObjectContainer) {
        ContainerCount containerCount = new ContainerCount(localObjectContainer, 1);
        this._transaction2Container = new Hashtable4();
        this._fileName2Container = new Hashtable4();
        this._fileName2Container.put(localObjectContainer.fileName(), (Object)containerCount);
        this._mainContainer = localObjectContainer;
    }

    public Transaction acquireMain() {
        return this.acquire(this._mainContainer.fileName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction acquire(String string) {
        Object object = this._mainContainer.lock();
        synchronized (object) {
            Object object2;
            ContainerCount containerCount = (ContainerCount)this._fileName2Container.get(string);
            if (containerCount == null) {
                object2 = (LocalObjectContainer)Db4o.openFile(string);
                ((PartialObjectContainer)object2).configImpl().setMessageRecipient(this._mainContainer.configImpl().messageRecipient());
                containerCount = new ContainerCount((LocalObjectContainer)object2);
                this._fileName2Container.put(string, (Object)containerCount);
            }
            object2 = containerCount.newTransaction();
            this._transaction2Container.put(object2, (Object)containerCount);
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Transaction transaction, boolean bl) {
        transaction.close(bl);
        Object object = this._mainContainer.lock();
        synchronized (object) {
            ContainerCount containerCount = (ContainerCount)this._transaction2Container.get(transaction);
            this._transaction2Container.remove(transaction);
            containerCount.release();
            if (containerCount.isEmpty()) {
                this._fileName2Container.remove(containerCount.fileName());
                containerCount.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this._mainContainer.lock();
        synchronized (object) {
            Iterator4 iterator4 = this._fileName2Container.iterator();
            while (iterator4.moveNext()) {
                Entry4 entry4 = (Entry4)iterator4.current();
                ((ContainerCount)entry4.value()).close();
            }
            this._closed = true;
        }
    }

    public int openFileCount() {
        return this.isClosed() ? 0 : this._fileName2Container.size();
    }

    public boolean isClosed() {
        return this._closed || this._mainContainer.isClosed();
    }

    private static class ContainerCount {
        private LocalObjectContainer _container;
        private int _count;

        public ContainerCount(LocalObjectContainer localObjectContainer) {
            this(localObjectContainer, 0);
        }

        public ContainerCount(LocalObjectContainer localObjectContainer, int n) {
            this._container = localObjectContainer;
            this._count = n;
        }

        public boolean isEmpty() {
            return this._count <= 0;
        }

        public Transaction newTransaction() {
            ++this._count;
            return this._container.newUserTransaction();
        }

        public void release() {
            if (this._count == 0) {
                throw new IllegalStateException();
            }
            --this._count;
        }

        public String fileName() {
            return this._container.fileName();
        }

        public void close() {
            this._container.close();
            this._container = null;
        }

        public int hashCode() {
            return this.fileName().hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ContainerCount containerCount = (ContainerCount)object;
            return this.fileName().equals(containerCount.fileName());
        }
    }
}

