/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.event;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.AbstractEvent;
import org.hibernate.event.Initializable;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.engine.DocumentBuilder;

public class FullTextIndexEventListener
implements PostDeleteEventListener,
PostInsertEventListener,
PostUpdateEventListener,
Initializable {
    private static final Log log = LogFactory.getLog(FullTextIndexEventListener.class);
    private boolean used;
    private SearchFactory searchFactory;

    public void initialize(Configuration cfg) {
        this.searchFactory = SearchFactory.getSearchFactory(cfg);
        this.used = this.searchFactory.getDocumentBuilders().size() != 0;
    }

    public SearchFactory getSearchFactory() {
        return this.searchFactory;
    }

    public void onPostDelete(PostDeleteEvent event) {
        if (this.used && this.searchFactory.getDocumentBuilders().containsKey(event.getEntity().getClass())) {
            this.processWork(event.getEntity(), event.getId(), WorkType.DELETE, (AbstractEvent)event);
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        if (this.used) {
            Object entity = event.getEntity();
            DocumentBuilder<Object> builder = this.searchFactory.getDocumentBuilders().get(entity.getClass());
            if (builder != null) {
                Serializable id = event.getId();
                this.processWork(entity, id, WorkType.ADD, (AbstractEvent)event);
            }
        }
    }

    public void onPostUpdate(PostUpdateEvent event) {
        if (this.used) {
            Object entity = event.getEntity();
            DocumentBuilder<Object> builder = this.searchFactory.getDocumentBuilders().get(entity.getClass());
            if (builder != null) {
                Serializable id = event.getId();
                this.processWork(entity, id, WorkType.UPDATE, (AbstractEvent)event);
            }
        }
    }

    private void processWork(Object entity, Serializable id, WorkType workType, AbstractEvent event) {
        this.searchFactory.getWorker().performWork(entity, id, workType, event.getSession());
    }
}

