=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download
 * Description: Document skin sample prepared for Gutenberg Project (first used with "War and Peace")
 * License: Same as SiSU see http://www.jus.uio.no/sisu
 * Notes: Site default appearance variables set in defaults.rb
     Generic site wide modifications set here scribe_skin.rb, and this file required by other "scribes" instead of defaults.rb
=end
module SiSU_Viz
  require "#{SiSU_lib}/defaults"
  class Skin
    #% path
    def path_root                                                                     # the only parameter that cannot be changed here
      './sisu/'
    end
    def path_rel
      '../'
    end
  #% url
    def url_home
      'http://www.gutenberg.net'
    end
    def url_txt                                                                      # text to go with url usually stripped url
      'www.gutenberg.net'
    end
    #% txt
    def txt_hp
      'www.gutenberg.net'
    end
    def txt_home
      'Gutenberg Project'
    end
    #% icon
    def icon_home_button
      'gutenberg.home.png'
    end
    def icon_home_banner
      icon_home_button
    end
    #% banner
    def banner_home_button
      %{<table summary="home button" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor=#{color_yellow_dark}><a href="#{url_home}">#{png_home}</a></td></tr></table>\n}
    end
    def banner_home_and_index_buttons
      %{<table><tr><td width="20%"><table summary="home and index buttons" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor=#{color_yellow_dark}><a href="#{url_home}" target="_top">#{png_home}</a></td></tr></table></td><td width="60%"><center><center><table summary="buttons" border="1" cellpadding="3" cellspacing="0"><tr><td align="center" bgcolor="#f1e8de"><font face="arial" size="2"><a href="toc.html" target="_top">&nbsp;This&nbsp;text&nbsp;sub-&nbsp;<br />&nbsp;Table&nbsp;of&nbsp;Contents&nbsp;</a></font></td></tr></table></center></center></td><td width="20%">&nbsp;</td></tr></table>}
    end
    def banner_band
      %{<table summary="band" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor=#{color_yellow_dark}><a href="#{url_home}" target="_top">#{png_home}</a>#{table_close}}
    end
    #% credits
    def credits_splash
      %{<table summary="credits" align="center"bgcolor="#ffffff"><tr><td><font color="black"><center><a href="http://www.gutenberg.net/"><img border="0" align="center" src="../_sisu/image_local/gutenberg_icon.png" alt="Gutenberg Project"><br />Courtesy of The Gutenberg Project</a></center></font></td></tr></table>}
    end
  end
  class TeX
    def header_center
      "\\chead{\\href{#{@vz.url_home}}{www.gutenberg.net}}"
    end
    def home_url
      "\\href{#{@vz.url_home}}{www.gutenberg.net}"
    end
    def home
      "\\href{#{@vz.url_home}}{Gutenberg Project}"
    end
    def owner_chapter
      "Document owner details"
    end
  end
  class Inserts
    def insert1
<<CONTENTS

3~ Project Gutenberg~#

4~ Project Gutenberg Notes~#

Copyright laws are changing all over the world, be sure to check the copyright laws for your country before posting these files!!~#

Please take a look at the important information in this header.  We encourage you to keep this file on your own disk, keeping an electronic path open for the next readers.  Do not remove this.~#

*{It must legally be the first thing seen when opening the book.}* In fact, our legal advisors said we can't even change margins.~#

*{Welcome To The World of Free Plain Vanilla Electronic Texts}*~#

*{Etexts Readable By Both Humans and By Computers, Since 1971}*~#

*{These Etexts Prepared By Hundreds of Volunteers and Donations}*~#

Information on contacting Project Gutenberg to get Etexts, and further information is included below.  We need your donations.~#

CONTENTS
    end
    def insert2                                                                  #note took out stop after http://promo.net/pg and created space after  this url repeated in subsequent paragraph, as broke latex/pdf, think of modifying regexs for urls
<<CONTENTS
Project Gutenberg Etexts are usually created from multiple editions, all of which are in the Public Domain in the United States, unless a copyright notice is included.  Therefore, we usually do NOT keep any of these books in compliance with any particular paper edition.~#

We are now trying to release all our books one month in advance of the official release dates, leaving time for better editing.~#

Please note:  neither this list nor its contents are final till midnight of the last day of the month of any such announcement.  The official release date of all Project Gutenberg Etexts is at Midnight, Central Time, of the last day of the stated month.  A preliminary version may often be posted for suggestion, comment and editing by those who wish to do so.  To be sure you have an up to date first edition [xxxxx10x.xxx] please check file sizes in the first week of the next month.  Since our ftp program has a bug in it that scrambles the date [tried to fix and failed] a look at the file size will have to do, but we will try to see a new copy has at least one byte more or less.~#

4~ Information about Project Gutenberg (one page)~#

We produce about two million dollars for each hour we work.  The time it takes us, a rather conservative estimate, is fifty hours to get any etext selected, entered, proofread, edited, copyright searched and analyzed, the copyright letters written, etc.  This projected audience is one hundred million readers.  If our value per text is nominally estimated at one dollar then we produce $2 million dollars per hour this year as we release thirty-six text files per month, or 432 more Etexts in 1999 for a total of 2000+ If these reach just 10% of the computerized population, then the total should reach over 200 billion Etexts given away this year.~#

The Goal of Project Gutenberg is to Give Away One Trillion Etext Files by December 31, 2001.  [10,000 x 100,000,000 = 1 Trillion] This is ten thousand titles each to one hundred million readers, which is only ~5% of the present number of computer users.  At our revised rates of production, we will reach only one-third of that goal by the end of 2001, or about 3,333 Etexts unless we manage to get some real funding; currently our funding is mostly from Michael Hart's salary at Carnegie-Mellon University, and an assortment of sporadic gifts; this salary is only good for a few more years, so we are looking for something to replace it, as we don't want Project Gutenberg to be so dependent on one person.~#

We need your donations more than ever!~#

All donations should be made to "Project Gutenberg/CMU": and are tax deductible to the extent allowable by law.  (CMU = Carnegie-Mellon University).~#

For these and other matters, please mail to:~#

Project Gutenberg~#

P. O. Box  2782~#

Champaign, IL 61825~#

When all other email fails. . .try our Executive Director: Michael S. Hart hart@pobox.com forwards to hart@prairienet.org and archive.org if your mail bounces from archive.org, I will still see it, if it bounces from prairienet.org, better resend later on. . . .~#

We would prefer to send you this information by email.~#

******~#

To access Project Gutenberg etexts, use any Web browser to view http://promo.net/pg  This site lists Etexts by author and by title, and includes information about how to get involved with Project Gutenberg.  You could also download our past Newsletters, or subscribe here.  This is one of our major sites, please email hart@pobox.com, for a more complete list of our various sites.~#

To go directly to the etext collections, use FTP or any Web browser to visit a Project Gutenberg mirror (mirror sites are available on 7 continents; mirrors are listed at http://promo.net/pg ).~#

Mac users, do NOT point and click, typing works better.~#

Example FTP session:~#

ftp metalab.unc.edu~#

login: anonymous~#

password: your@login~#

cd pub/docs/books/gutenberg~#

cd etext90 through etext99 or etext00 through etext01, etc.~#

dir [to see files]~#

get or mget [to get files. . .set bin for zip files]~#

GET GUTINDEX.??  [to get a year's listing of books, e.g., GUTINDEX.99]~#

GET GUTINDEX.ALL [to get a listing of ALL books]~#

***~#

3~ Information prepared by the Project Gutenberg legal advisor** (three pages)~#

4~ THE SMALL PRINT!**FOR PUBLIC DOMAIN ETEXTS~#

Why is this "Small Print!" statement here?  You know: lawyers.  They tell us you might sue us if there is something wrong with your copy of this etext, even if you got it for free from someone other than us, and even if what's wrong is not our fault.  So, among other things, this "Small Print!" statement disclaims most of our liability to you.  It also tells you how you can distribute copies of this etext if you want to.~#

5~ *BEFORE!* YOU USE OR READ THIS ETEXT~#

By using or reading any part of this PROJECT GUTENBERG-tm etext, you indicate that you understand, agree to and accept this "Small Print!" statement.  If you do not, you can receive a refund of the money (if any) you paid for this etext by sending a request within 30 days of receiving it to the person you got it from.  If you received this etext on a physical medium (such as a disk), you must return it with your request.~#

5~ ABOUT PROJECT GUTENBERG-TM ETEXTS~#

This PROJECT GUTENBERG-tm etext, like most PROJECT GUTENBERG-tm etexts, is a "public domain" work distributed by Professor Michael S. Hart through the Project Gutenberg Association at Carnegie-Mellon University (the "Project").  Among other things, this means that no one owns a United States copyright on or for this work, so the Project (and you!) can copy and distribute it in the United States without permission and without paying copyright royalties.  Special rules, set forth below, apply if you wish to copy and distribute this etext under the Project's "PROJECT GUTENBERG" trademark.~#

To create these etexts, the Project expends considerable efforts to identify, transcribe and proofread public domain works.  Despite these efforts, the Project's etexts and any medium they may be on may contain "Defects".  Among other things, Defects may take the form of incomplete, inaccurate or corrupt data, transcription errors, a copyright or other intellectual property infringement, a defective or damaged disk or other etext medium, a computer virus, or computer codes that damage or cannot be read by your equipment.~#

5~ LIMITED WARRANTY; DISCLAIMER OF DAMAGES~#

But for the "Right of Replacement or Refund" described below, [1] the Project (and any other party you may receive this etext from as a PROJECT GUTENBERG-tm etext) disclaims all liability to you for damages, costs and expenses, including legal fees, and [2] YOU HAVE NO REMEDIES FOR NEGLIGENCE OR UNDER STRICT LIABILITY, OR FOR BREACH OF WARRANTY OR CONTRACT, INCLUDING BUT NOT LIMITED TO INDIRECT, CONSEQUENTIAL, PUNITIVE OR INCIDENTAL DAMAGES, EVEN IF YOU GIVE NOTICE OF THE POSSIBILITY OF SUCH DAMAGES.~#

If you discover a Defect in this etext within 90 days of receiving it, you can receive a refund of the money (if any) you paid for it by sending an explanatory note within that time to the person you received it from.  If you received it on a physical medium, you must return it with your note, and such person may choose to alternatively give you a replacement copy.  If you received it electronically, such person may choose to alternatively give you a second opportunity to receive it electronically.~#

THIS ETEXT IS OTHERWISE PROVIDED TO YOU "AS-IS".  NO OTHER WARRANTIES OF ANY KIND, EXPRESS OR IMPLIED, ARE MADE TO YOU AS TO THE ETEXT OR ANY MEDIUM IT MAY BE ON, INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.~#

Some states do not allow disclaimers of implied warranties or the exclusion or limitation of consequential damages, so the above disclaimers and exclusions may not apply to you, and you may have other legal rights.~#

5~ INDEMNITY~#

You will indemnify and hold the Project, its directors, officers, members and agents harmless from all liability, cost and expense, including legal fees, that arise directly or indirectly from any of the following that you do or cause: [1] distribution of this etext, [2] alteration, modification, or addition to the etext, or [3] any Defect.~#

5~ DISTRIBUTION UNDER "PROJECT GUTENBERG-tm"~#

You may distribute copies of this etext electronically, or by disk, book or any other medium if you either delete this "Small Print!" and all other references to Project Gutenberg, or:~#

*{[1]}*  Only give exact copies of it.  Among other things, this requires that you do not remove, alter or modify the etext or this "small print!" statement.  You may however, if you wish, distribute this etext in machine readable binary, compressed, mark-up, or proprietary form, including any form resulting from conversion by word pro- cessing or hypertext software, but only so long as *{EITHER}*:~#

_1 *{[*]}*  The etext, when displayed, is clearly readable, and does *not* contain characters other than those intended by the author of the work, although tilde (~), asterisk (*) and underline (_) characters may be used to convey punctuation intended by the author, and additional characters may be used to indicate hypertext links; OR~#

_1 *{[*]}*  The etext may be readily converted by the reader at no expense into plain ASCII, EBCDIC or equivalent form by the program that displays the etext (as is the case, for instance, with most word processors); OR~#

_1 *{[*]}*  You provide, or agree to also provide on request at no additional cost, fee or expense, a copy of the etext in its original plain ASCII form (or in EBCDIC or other equivalent proprietary form).~#

*{[2]}*  Honor the etext refund and replacement provisions of this "Small Print!" statement.~#

*{[3]}*  Pay a trademark license fee to the Project of 20% of the net profits you derive calculated using the method you already use to calculate your applicable taxes.  If you don't derive profits, no royalty is due.  Royalties are payable to "Project Gutenberg Association/Carnegie-Mellon University" within the 60 days following each date you prepare (or were legally required to prepare) your annual (or equivalent periodic) tax return.~#

5~ WHAT IF YOU *WANT* TO SEND MONEY EVEN IF YOU DON'T HAVE TO?~#

The Project gratefully accepts contributions in money, time, scanning machines, OCR software, public domain etexts, royalty free copyright licenses, and every other sort of contribution you can think of.  Money should be paid to "Project Gutenberg Association / Carnegie-Mellon University".~#

We are planning on making some changes in our donation structure in 2000, so you might want to email me, hart@pobox.com beforehand.~#

*END THE SMALL PRINT! FOR PUBLIC DOMAIN ETEXTS*Ver.04.29.93*END*~#

<!pn!>

CONTENTS
    end
  end
end
__END__
