# encoding: utf-8
=begin

* Name: SiSU

** Description: documents, structuring, processing, publishing, search
*** share sisu source markup file, copy it to output directory!

** Author: Ralph Amissah
  [ralph@amissah.com]
  [ralph.amissah@gmail.com]

** Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
  2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Ralph Amissah,
  All Rights Reserved.

** License: GPL 3 or later:

  SiSU, a framework for document structuring, publishing and search

  Copyright (C) Ralph Amissah

  This program is free software: you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation, either version 3 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program. If not, see [http://www.gnu.org/licenses/].

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
  [http://www.fsf.org/licensing/licenses/gpl.html]
  [http://www.gnu.org/licenses/gpl.html]

** SiSU uses:
  * Standard SiSU markup syntax,
  * Standard SiSU meta-markup syntax, and the
  * Standard SiSU object citation numbering and system

** Hompages:
  [http://www.jus.uio.no/sisu]
  [http://www.sisudoc.org]

** Git
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary]
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/src_po4a_sstm.rb;hb=HEAD]

=end
module SiSU_Markup
  require_relative 'src_shared'                         # src_shared.rb
    include SiSU_Source
  require_relative 'src_po4a_share'                     # src_po4a_share.rb
  require_relative 'se'                                 # se.rb
    include SiSU_Env
  class Source_Po4a < SiSU_Source::SiSUpodSource
    def initialize(opt,build=nil,place=nil)
      super(opt,build,place)
      @opt=opt
      md=SiSU_Param::Parameters.new(opt).get
      @file=SiSU_Env::FileOp.new(md,opt.fno)
    end
    def dir_mk(dir)
      unless FileTest.directory?(dir)
        FileUtils::mkdir_p(dir)
      end
    end
    def make_paths
      dir_mk(@file.output_path.pot.dir)
      dir_mk(@file.output_path.po.dir)
    end
    def language
      def source_language_selected_str
        @opt.act[:po4a_lang][:src] \
        ? @opt.act[:po4a_lang][:src]
        : 'en'
      end
      self
    end
    def read
      unless @opt.act[:quiet][:set]==:on
        (@opt.act[:verbose][:set]==:on \
        || @opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on) \
        ? SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            'Share document markup text source',
            @opt.fns
          ).cyan_hi_blue
        : SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            'Share document markup text source',
            @opt.fns
          ).cyan_title_hi
      end
      make_paths
      if FileTest.directory?(@path_pod[:fnb])
        FileUtils::mkdir_p(@file.output_path.src.dir) \
          unless FileTest.directory?(@file.output_path.src.dir)
        v=(@opt.act[:maintenance][:set]==:on) \
        ? 'v' : ''
        system(%{
          #rsync -a#{v} #{@path_pod[:fnb]}/sisupod/doc/* #{@file.output_path.po4a.dir}
          rsync -a#{v} #{@path_pod[:fnb]}/sisupod/doc/#{language.source_language_selected_str}* #{@file.output_path.po4a.dir}
          chbk=`pwd`
          cd #{@file.output_path.sisupod.dir}
          for I in `find -type d` ; do chmod 755 $I ; done
          for I in `find -type f` ; do chmod 644 $I ; done
          cd ${chbk}
        })
        md=SiSU_Param::Parameters.new(@opt).get
        file=SiSU_Env::FileOp.new(md)
        SiSU_Po4a_Project::Po4aCfg.new(@opt,file).song
        SiSU_Po4a_Project::Po4aProject.new(@opt,file).song
      else
        if (@opt.act[:verbose][:set]==:on \
        || @opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on)
          SiSU_Screen::Ansi.new(
            '',
            "#{@opt.fno} not available"
          ).blue_tab
        end
      end
    end
  end
end
__END__
