#===========================================================================
# 

package Sitescooper::CacheFactory;

use Carp;
use Sitescooper::Main;

use Sitescooper::PerSiteCache;

@ISA = qw();
use vars qw{ @ISA };
use strict;

# ---------------------------------------------------------------------------

sub new {
  my $class = shift; $class = ref($class) || $class;

  my ($main) = @_;

  my $self = {
    'main'		=> $main,
  };

  bless ($self, $class);
  $self;
}

# ---------------------------------------------------------------------------

sub open_cache {
  my ($self) = @_;
  die "Unimplemented interface in CacheFactory";
}

sub close_cache {
  my ($self) = @_;
  die "Unimplemented interface in CacheFactory";
}

# should return an object of type Sitescooper::PerSiteCache
# to allow scooping one site. Once it's finished with, it's commit()
# method will be called to commit changes to the storage in this
# Factory object.
sub get_per_site_cache {
  my ($self, $robot, $sitename) = @_;
  die "Unimplemented interface in CacheFactory";
}

# ---------------------------------------------------------------------------

1;
