/*
 * Copyright (c) 1994  Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * Author:  Makoto Ishisone, Software Research Associates, Inc., Japan
 */
#include <stdio.h>
#include "im.h"
#include "XimP.h"

/*- IMQueueEmpty: returns true if the scheduler queue is empty -*/
int IMQueueEmpty( Widget w )
{
  if( IM_QUEUE( w ) == NULL )
    return True ;
  return False ;
}

/*- IMPushQueue: push connection to the scheduler queue -*/
void IMPushQueue( IMConnection *conn )
{
  Widget w = conn->protocol_widget ;

  conn->queue_next = IM_QUEUE( w ) ;
  IM_QUEUE( w )    = conn ;
  return ;
}

/*- IMPopQueue: pop connection from the scheduler queue */
IMConnection *IMPopQueue( Widget w )
{
  IMConnection *conn, *ret ;

  conn = IM_QUEUE( w ) ;
  if( conn != NULL ){
    ret = conn ;
    IM_QUEUE( w ) = conn->queue_next ;
  } else {
    ret = NULL ;
  }
  return ret ;
}

/*- IMIMHash: get IM hash table -*/
IMIM **IMIMHash( Widget w)
{
  return IM_IMHASH(w) ;
}

/*- IMICHash: get IC hash table -*/
IMIC **IMICHash( Widget w )
{
  return IM_ICHASH(w) ;
}

/*- IMNextIMID: return next IMID (it might be used, though) -*/
unsigned int IMNextIMID( Widget w )
{
  long id = IM_LASTIMID(w) + 1;	/* use long int to avoid overflow */

  if( id > 65535L )
    id = 1;
  IM_LASTIMID(w) = (unsigned int)id ;
  return (unsigned int)id ;
}

/*- IMNextICID: return next ICID (it might be used, though) -*/
unsigned int IMNextICID( Widget w )
{
  long id = IM_LASTICID(w) + 1;	/* use long int to avoid overflow */

  if( id > 65535L )
    id = 1 ;
  IM_LASTICID(w) = (unsigned int)id ;
  return (unsigned int)id ;
}

/*- IMInitHash: initialize IM/IC hash table -*/
void IMInitHash( Widget w )
{
  IMIM **impp ;
  IMIC **icpp ;
  int i ;

  impp = IM_IMHASH(w) ;
  icpp = IM_ICHASH(w) ;
  for (i = 0; i < IM_HASH_SIZE; i++)
    impp[i] = NULL ;
  for (i = 0; i < IC_HASH_SIZE; i++)
    icpp[i] = NULL ;
  IM_LASTIMID(w) = IM_LASTICID(w) = 0 ;
}

