/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/

#include "skgunitcombobox.h"
#include "skgmainpanel.h"
#include "skgdocumentbank.h"
#include "skgunitvalueobject.h"

SKGUnitComboBox::SKGUnitComboBox(QWidget* parent): SKGComboBox(parent), document(NULL), fillWhereClause("t_type!='I'")
{
}

SKGUnitComboBox::~SKGUnitComboBox()
{
    document=NULL;
}

void SKGUnitComboBox::setDocument(SKGDocumentBank* iDocument)
{
    document=iDocument;
    connect ( ( const QObject* ) document, SIGNAL(tableModified(QString, int)), this, SLOT(dataModified(QString, int)) );
    dataModified("", 0);
}

void SKGUnitComboBox::setWhereClauseCondition(const QString& iCondition)
{
    fillWhereClause=iCondition;
    dataModified("", 0);
}

SKGUnitObject SKGUnitComboBox::getUnit()
{
    SKGUnitObject unit ( document );
    QString unitName=text();
    if (document && !unitName.isEmpty())
    {
        SKGError err;
        err=unit.setSymbol ( unitName );
        if ( !unit.exist() )
        {
            if ( err.isSucceeded() ) err= unit.setName ( unitName );
            if ( err.isSucceeded() ) err = unit.save();

            SKGUnitValueObject unitVal;
            if ( err.isSucceeded() ) err=unit.addUnitValue ( unitVal );
            if ( err.isSucceeded() ) err=unitVal.setDate ( QDate::currentDate() );
            if ( err.isSucceeded() ) err=unitVal.setQuantity ( 1 );
            if ( err.isSucceeded() ) err=unitVal.save();

            if ( err.isSucceeded() ) document->sendMessage(i18nc("An information message",  "Unit '%1' has been created" , text() ), true );
        }
        else err=unit.load();
    }
    return unit;
}

void SKGUnitComboBox::setUnit(const SKGUnitObject& iUnit)
{
    setText(iUnit.getSymbol());
}

void SKGUnitComboBox::refershList()
{
    //Fill comboboxes
    if (document)
    {
        SKGMainPanel::fillWithDistinctValue ( this, document, "unit", "ifnull(t_symbol,t_name)", fillWhereClause );
        SKGServices::SKGUnitInfo primary= document->getPrimaryUnit();
        if ( !primary.Symbol.isEmpty() ) setText ( primary.Symbol );
    }
}

void SKGUnitComboBox::dataModified(const QString& iTableName, int iIdTransaction)
{
    Q_UNUSED(iIdTransaction);

    //Refresh widgets
    if (document)
    {
        QSqlDatabase* db = document->getDatabase();
        setEnabled ( db!=NULL );
        if ( db!=NULL && (iTableName=="unit" || iTableName.isEmpty())) refershList();
    }
}

#include "skgunitcombobox.moc"
