/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGDEFINEBANK_H
#define SKGDEFINEBANK_H
/** @file
 * This file defines some macros and constants.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgdefine.h"

/**
 * @def DUMPUNIT
 * To display units and values
 * @see dump
 */
#define DUMPUNIT              (2<<10)

/**
 * @def DUMPACCOUNT
 * To display accounts
 * @see dump
 */
#define DUMPACCOUNT              (2<<11)

/**
 * @def DUMPOPERATION
 * To display accounts
 * @see dump
 */
#define DUMPOPERATION              (2<<12)

/**
 * @def DUMPCATEGORY
 * To display categories
 * @see dump
 */
#define DUMPCATEGORY		(2<<13)

/**
 * @def DUMPPAYEE
 * To display payees
 * @see dump
 */
#define DUMPPAYEE		(2<<14)

/**
 * @def DUMPBANKOBJECT
 * To display categories
 * @see dump
 */
#define DUMPBANKOBJECT		DUMPUNIT|DUMPACCOUNT|DUMPOPERATION|DUMPCATEGORY|DUMPPAYEE
#endif
