/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGIMPORTSKG_H
#define SKGIMPORTSKG_H
/** @file
 * This file defines classes SKGImportSkg.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgerror.h"
#include "skgobjectbase.h"
#include "skgbankmodeler_export.h"

#include <QObject>
class SKGDocumentBank;
class SKGImportExportManager;

/**
 *Manage import of SKROOGE file
 */
class SKGBANKMODELER_EXPORT SKGImportSkg : public QObject
{
    Q_OBJECT;

public:
    /**
     * Import a skg file.
     * @param iImporter the pointer on the importer.
     * @param iDocument the document where to import.
     * @return an object managing the error.
     *   @see SKGError
     */
    static SKGError importFile(SKGImportExportManager* iImporter, SKGDocumentBank* iDocument);

    /**
     * Export a skg file.
     * @param iImporter the pointer on the importer.
     * @param iDocument the document to export.
     * @param iSqliteFile to export as a sqlite file only (not skrooge header)).
     * @return an object managing the error.
     *   @see SKGError
     */
    static SKGError exportFile(SKGImportExportManager* iImporter, SKGDocumentBank* iDocument, bool iSqliteFile=false);

private:

    static SKGError copyParameters(const SKGObjectBase& iFrom, const SKGObjectBase& iTo);
};

#endif
