/*
	skyeye_option.h - definitions of the device options structures.
	Copyright (C) 2004 Skyeye Develop Group
	for help please send mail to <skyeye-developer@lists.gro.clinux.org>
	
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 
*/
/*
 * 05/16/2004  	initial version
 *
 *		walimis <wlm@student.dlut.edu.cn> 
 * */

#ifndef __SKYEYE_OPTION_H_
#define __SKYEYE_OPTION_H_
#include "skyeye.h"

//koodailar add for mingw 2005.12.18 ----------------------------------------
#ifdef __MINGW32__
#include "device/skyeye_device.h"
#else
#include "skyeye_device.h"
#endif
// end ----------------------------------------------------------------------

/* uart simulation type*/
#define UART_SIM_STD    0	/*      use stdin and stdout as fd */
#define UART_SIM_FIL    1	/*      use file (pipe file) or device(/dev/ttyS1) as fd */
#define UART_SIM_NET    2	/*      use tcp port as fd */

struct uart_option
{
	char fd_name[MAX_STR_NAME];

	/* uart simulation type */
	int type;
};

struct timer_option
{
};



struct net_option
{
	unsigned char macaddr[6];
	unsigned char hostip[4];
	int ethmod;
};
struct lcd_option
{
	/* display mode. e.g. gtk, qt, X, sdl */
	int mod;

	int width;
	int height;

	int depth;
};
struct flash_option
{
};

#endif /*__SKYEYE_OPTION_H_ */
