
require("tess");

static define simple_cast(obj,newtype) { () = typecast(obj,newtype); }

static define updown_cast(obj,uptype,downtype)
{
   obj = typecast(obj,uptype);
   obj = typecast(obj,downtype);
}

variable window   = gtk_window_new (GTK_WINDOW_TOPLEVEL);
gtk_widget_realize(window);

variable drawable = gtk_widget_get_window(window);
variable pixmap   = gdk_pixmap_new(NULL,100,100,8);
variable ttips    = gtk_tooltips_new();
variable label    = gtk_label_new("meaningless label");

variable gc = gdk_gc_new(drawable);
variable button = gtk_button_new_with_label("foo");
variable cursor = gdk_cursor_new(GDK_HEART);

variable texttag = gtk_text_tag_new("dummy_text_tag");
variable textbuf = gtk_text_buffer_new(NULL);
variable anchor  = gtk_text_child_anchor_new();

() = printf("\n");

static define dummy_callback(w) {}

% Pass/Fail here connotes whether or not an S-Lang error is signaled.

tess_invoke(1, &gtk_window_set_title, drawable, "fail");
tess_invoke(1, &gtk_window_set_title, pixmap, "fail");
tess_invoke(0, &gtk_button_set_label, window, "pass, but issues GTK critical");
tess_invoke(0, &gtk_window_set_title, label, "'pass, but issues GTK critical");
tess_invoke(0, &gtk_window_set_title, window, "pass, all good");


tess_invoke(1, &gtk_widget_realize, ttips);	% fail, b/c ttips not a widget

tess_invoke(1, &g_signal_connect, cursor,	% fail, b/c cursor not object
		"clicked",&dummy_callback);

tess_invoke(0, &g_signal_connect, ttips,	% pass, b/c ttips an object
		"notify",&dummy_callback);


tess_invoke(1, &simple_cast, gc, GdkCursor);	% fail, sibling casts illegal
tess_invoke(1, &simple_cast, drawable, GdkGC);	
tess_invoke(0, &simple_cast, gc, GObject);	% pass, upcasts are legal
tess_invoke(0, &simple_cast, ttips, GObject);
tess_invoke(0, &updown_cast, button, GObject, GtkWidget);
tess_invoke(1, &updown_cast, button, GObject, GtkAdjustment);
