
/*
 * slmon
 *
 * Copyright (C) 2000 Krzysztof Luks <m00se@iq.pl>
 *
 * This program is based on WMMon.app.
 *
 * WMMon.app is copyright (c) 1997, 1998 by Martijn Pieterse and
 * Antoine Nulle.
 *
 * This program is distributed under the GPL license. For details see
 * COPYING text.
 *
 * Author: Krzysztof Luks <m00se@iq.pl>
 *
 */

#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <unistd.h>
#include <utmp.h>

#ifdef HAVE_SLANG_H
#include <slang.h>
#endif

#ifdef HAVE_SLANG_SLANG_H
#include<slang/slang.h>
#endif

#include <signal.h>
#include <sys/utsname.h>
#include <sys/file.h>

#ifdef HAVE_POPT
#include <popt.h>
#endif

#ifdef HAVE_GTOP
/* Glibtop */
#include <glibtop/cpu.h>
#include <glibtop/uptime.h>
#include <glibtop/mem.h>
#include <glibtop/swap.h>
#include <glibtop/loadavg.h>
#endif

/* slmon specific defines */

#ifndef SLMON
#define SLMON

#define MAXCPU 9

#ifdef HAVE_SLANG
#define MODE_H 0		/* Histogram */
#define MODE_G 1		/* Gauge */

#define COL_NORM 241		/* Default text color     */
#define COL_VALU 242		/* Values color           */
#define COL_STAT 243		/* Status line text       */
#define COL_STBA 244		/* Status line background */
#define COL_BACK 245		/* Background color       */
#define COL_GRA1 246		/* Gradient 1st color     */
#define COL_GRA2 247		/* Gradient 2nd color     */
#define COL_GRA3 248		/* Gradient 3rd color     */
#endif

struct last {
    double idlelast;
    double totallast;
};

static int unit_div[3] = { 1, 1024, 1048576 };
static char unit_name[3] = { 'b', 'k', 'M' };

int redraw, pos, cpus;
int mode, cur_cpu, mem;

int gauge_len;

#ifdef HAVE_SLANG
int rspace, cspace, do_bold, height;

char *col_norm;
char *col_valu;
char *col_stat;
char *col_stba;
char *col_back;
char *col_gra1;
char *col_gra2;
char *col_gra3;

static char *slangColors[] = { "black", "red", "green", "brown",
    "blue", "magenta", "cyan", "lightgray", "gray", "brightred",
    "brightgreen", "yellow", "brightblue", "brightmagenta",
    "brightcyan", "white", "default"
};
#endif

/* Command line options */

static int version;

#ifdef HAVE_POPT
static struct poptOption optionsTable[] = {
    POPT_AUTOHELP {"version", 'v', POPT_ARG_NONE, &version, 0,
		   "Display version and copying information", NULL},
    {"byte", 'b', POPT_ARG_NONE, 0, 'b', "Display memory in bytes",
     NULL},
    {"kbyte", 'k', POPT_ARG_NONE, 0, 'k', "Display memory in kilobytes",
     NULL},
    {"mbyte", 'm', POPT_ARG_NONE, 0, 'm', "Display memory in megabytes",
     NULL},
#ifdef HAVE_SLANG
    {"bold", 'B', POPT_ARG_NONE, 0, 'B',
     "Turn bold on monochrome terminals on", NULL},
    {"gauge", 'G', POPT_ARG_NONE, 0, 'g',
     "Start in gauge mode (default)", NULL},
    {"hist", 'H', POPT_ARG_NONE, 0, 'h', "Start in histogram mode", NULL},

    {"gauge_len", '\0', POPT_ARG_INT, &gauge_len, 0,
     "Set the length of the gauge to <num>", "num"},
    {"height", 'E', POPT_ARG_INT, &height, 0,
     "Set display height to <num> lines", "num"},
    {"rspace", '\0', POPT_ARG_INT, &rspace, 0,
     "Set the distance between horizontal edges of screen and beginning of graph to <num>",
     "num"},
    {"cspace", '\0', POPT_ARG_INT, &cspace, 0,
     "Set the distance between vertical edges of screen and beginning of graph to <num>",
     "num"},
    {"color-primary", '\0', POPT_ARG_STRING, 0, COL_NORM,
     "Set primary color to <color>", "color"},
    {"color-secondary", '\0', POPT_ARG_STRING, 0, COL_VALU,
     "Set secondary color to <color>", "color"},
    {"color-background", '\0', POPT_ARG_STRING, 0, COL_BACK,
     "Set background color to <color>", "color"},
    {"color-status", '\0', POPT_ARG_STRING, 0, COL_STAT,
     "Set status-line color to <color>", "color"},
    {"color-status-background", '\0', POPT_ARG_STRING, 0, COL_STBA,
     "Set status-line background color to <color>", "color"},
    {"color-gradient1", '\0', POPT_ARG_STRING, 0, COL_GRA1,
     "Set 1st gradient color to <color>", "color"},
    {"color-gradient2", '\0', POPT_ARG_STRING, 0, COL_GRA2,
     "Set 2nd gradient color to <color>", "color"},
    {"color-gradient3", '\0', POPT_ARG_STRING, 0, COL_GRA3,
     "Set 3rd gradient color to <color>", "color"},
#endif
    {NULL, 0, 0, NULL, 0}
};
#endif

#endif
