/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmallEiffel@loria.fr
--                       http://www.loria.fr/SmallEiffel
--
*/
/*
   GNU Eiffel's VP (Virtual Processor) garbage collector for Elate.
   (c) 2000 Rudi Chiarito <rudi@amiga.com>

   Thanks to Andy Stout and Kevin Croombs at Tao Group for their
   precious help!

   ChangeLog:
   - 2000-06-12 Rudi Chiarito <rudi@amiga.com>
     * Version 1.0
   - 2001-01-01 Joseph Kiniry <kiniry@acm.org>
     * Integrated with new SE 0.75b

*/

__inline__ void mark_stack_and_registers(void)
{

  void *pointer_to_gc_mark = &gc_mark;

  __asm__ __volatile__
  (
    /*
      WARNING: funky code ahead!
      \t and \n are needed to make the final output easier to read
      while debugging. Hopefully you'll never have to bother with all
      of this.
    */

   "sync\n"                          /* spill all the registers */
   "\tsyncreg\n"                       /* to the stack */

   "\tcpy.p %0,p1\n"                   /* pointer to gc_mark */

   /* mark the current stack block */

   "\tcpy.p [gp+PROC_STACK],p0\n"      /* pointer to current stack block */


/* "\tcpy {[p0 + (STK_LENGTH-STK_SIZE)] - (STK_SIZE+4)},i0\n" // get size */
/* "\tcpy.p {p0 + i0},p2\n"            // pointer to the top of the block */
/* "\tcpy {{p2i p2} - {p2i sp}},i0\n"  // used amount */
/* "\tgos mark_block, {p0 p1 i0 : -}\n"   // mark any valid references */

   "\tcpy.p (p0 + ([p0 + (STK_LENGTH-STK_SIZE)] - (STK_SIZE+4))),p2\n"
   "\tgos !mark_block!, (p0,p1,((p2i p2) - (p2i sp)).i: -)\n"
      /* scan stack extensions */

   "\twhile {[p0+(STK_LINK - STK_SIZE)] <> NULL}\n"     /* next list item */
   "\t\tcpy.p [p0+(STK_LINK-STK_SIZE)],p0\n"            /* get block size */
   "\t\tcpy {[p0 +(STK_LENGTH-STK_SIZE)] - (STK_SIZE+4)},i0\n"
   /* "\t\tgos mark_block,{p0 p1 i0 : -}\n"   // mark any valid references */
   "\t\tgos !mark_block!, (p0,p1,i0 : -)\n"
   "\tendwhile\n"
   "\tret\n"

   /* mark a whole range */

   "!mark_block!:\n"
   "\tent  p0 p1 i0: -\n"
   "\tcpy p0,p2\n"
   "\twhile i0<>0\n"                /* mark the reference (if valid) */
   "\t\tgos [p1],(p2 : -)\n"        /* move to next value */
   "\t\tadd.p 4,p2\n"
   "\t\tsub.i 4,i0\n"
   "\tendwhile\n"
   "\tret\n"
      : /* no output */
   : "p" (pointer_to_gc_mark)
   : "p0", "p1", "p2", "i0"
   );
}
