/***************************************************************************
                          smb4kprintinfo  -  description
                             -------------------
    begin                : Mo Apr 19 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/


// application specific includes
#include "smb4kprintinfo.h"


Smb4KPrintInfo::Smb4KPrintInfo( const QString &workgroup, const QString &host, const QString &ip, const QString &printer, const QString &path, int copies ) : m_workgroup( workgroup ), m_host( host ), m_ip( ip ), m_printer( printer ), m_path( path ), m_copies( copies )
{
}


Smb4KPrintInfo::~ Smb4KPrintInfo()
{
}


/****************************************************************************
   Returns the path to the file to print.
****************************************************************************/

QString Smb4KPrintInfo::path() const
{
  return m_path;
}


/****************************************************************************
   Returns the host name.
****************************************************************************/

QString Smb4KPrintInfo::host() const
{
  return m_host;
}


/****************************************************************************
   Returns the IP address of the host.
****************************************************************************/

QString Smb4KPrintInfo::ip() const
{
  return m_ip;
}


/****************************************************************************
   Returns the printer name.
****************************************************************************/

QString Smb4KPrintInfo::printer() const
{
  return m_printer;
}


/****************************************************************************
   Returns the workgroup name.
****************************************************************************/

QString Smb4KPrintInfo::workgroup() const
{
  return m_workgroup;
}


/****************************************************************************
   Sets the path to the file to print.
****************************************************************************/

void Smb4KPrintInfo::setPath( const QString &path )
{
  m_path = path;
}


/****************************************************************************
   Returns the number of copies the user wants to have.
****************************************************************************/

int Smb4KPrintInfo::copies() const
{
  return m_copies;
}


/****************************************************************************
   Sets the number of copies the user wants to print.
****************************************************************************/

void Smb4KPrintInfo::setCopies( int num )
{
  m_copies = num;
}

