/***************************************************************************
    smb4kappearance.cpp  -  description
                             -------------------
    begin                : Di Okt 28 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qbuttongroup.h>

// KDE includes
#include <klocale.h>

// application specific includes
#include "smb4kappearanceoptions.h"


Smb4KAppearanceOptions::Smb4KAppearanceOptions( QWidget *parent, const char *name ) : QWidget( parent, name )
{
  QGridLayout *layout = new QGridLayout( this );
  layout->setSpacing( 10 );

  // Appearance of the browser widget.
  QButtonGroup *browserGroup = new QButtonGroup( i18n( "Network Browser" ), this, "BrowserGroupBox" );
  m_showHidden = new QCheckBox( i18n( "Show hidden shares" ), browserGroup );
  m_showHidden->setGeometry( QRect( 10, 25, m_showHidden->sizeHint().width(), m_showHidden->sizeHint().height() ) );
  m_showIPC = new QCheckBox( i18n( "Show IPC$ shares" ), browserGroup );
  m_showIPC->setGeometry( QRect( 30, m_showHidden->frameGeometry().bottom()+5, m_showIPC->sizeHint().width(), m_showIPC->sizeHint().height() ) );
  m_showIPC->setEnabled( false );
  m_showAdmin = new QCheckBox( i18n( "Show ADMIN$ shares" ), browserGroup );
  m_showAdmin->setGeometry( QRect( 30, m_showIPC->frameGeometry().bottom()+5, m_showAdmin->sizeHint().width(), m_showAdmin->sizeHint().height() ) );
  m_showAdmin->setEnabled( false );
  m_showPrinter = new QCheckBox( i18n( "Show printer shares" ), browserGroup );
  m_showPrinter->setGeometry( QRect( 10, m_showAdmin->frameGeometry().bottom()+5, m_showPrinter->sizeHint().width(), m_showPrinter->sizeHint().height() ) );
  m_showType = new QCheckBox( i18n( "Show type" ), browserGroup );
  m_showType->setGeometry( 10, m_showPrinter->frameGeometry().bottom()+5, m_showType->sizeHint().width(), m_showType->sizeHint().height() );
  m_showIP = new QCheckBox( i18n( "Show IP address" ), browserGroup );
  m_showIP->setGeometry( QRect( 10, m_showType->frameGeometry().bottom()+5, m_showIP->sizeHint().width(), m_showIP->sizeHint().height() ) );
  m_showComment = new QCheckBox( i18n( "Show comment" ), browserGroup );
  m_showComment->setGeometry( QRect( 10, m_showIP->frameGeometry().bottom()+5, m_showComment->sizeHint().width(), m_showComment->sizeHint().height() ) );

  // Appearance of the share widget.
  QButtonGroup *shareIconGroup = new QButtonGroup( 1, QButtonGroup::Horizontal, i18n( "Shares" ), this, "SharesIconGroupBox" );
  m_description = new QCheckBox( i18n( "Show mount point instead of share name" ), shareIconGroup, 0 );
  m_shareview = new QCheckBox( i18n( "Show shares as list instead of as icons" ), shareIconGroup, 0 );
  m_external = new QCheckBox( i18n( "Show all shares that are mounted on the system" ), shareIconGroup, 0 );

  // Tooltips
  QButtonGroup *tooltipGroup = new QButtonGroup( 1, QButtonGroup::Horizontal, i18n( "Tooltips" ), this, "NetworkItemTooltipGroupBox" );
  m_showNetworkItemTooltip = new QCheckBox( i18n( "Show tooltip with information about a network item" ), tooltipGroup, 0 );
  m_showShareTooltip = new QCheckBox( i18n( "Show tooltip with information about a share" ), tooltipGroup, 0 );

  QSpacerItem *spacer = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  layout->addWidget( browserGroup, 0, 0, 0 );
  layout->addWidget( shareIconGroup, 1, 0, 0 );
  layout->addWidget( tooltipGroup, 2, 0, 0 );
  layout->addItem( spacer, 3, 0 );

  connect( m_showHidden, SIGNAL( stateChanged( int ) ),
           this,         SLOT( slotShowHiddenShares( int ) ) );
}


Smb4KAppearanceOptions::~Smb4KAppearanceOptions()
{
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////


void Smb4KAppearanceOptions::slotShowHiddenShares( int state )
{
  if ( state == QCheckBox::On )
  {
    m_showIPC->setEnabled( true );
    m_showAdmin->setEnabled( true );
  }
  else if ( state == QCheckBox::Off )
  {
    m_showIPC->setEnabled( false );
    m_showAdmin->setEnabled( false );
  }
}

#include "smb4kappearanceoptions.moc"
