/***************************************************************************
    smb4ksynchronizeoptions  -  description
                             -------------------
    begin                : So Nov 20 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSYNCHRONIZEOPTIONS_H
#define SMB4KSYNCHRONIZEOPTIONS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qtabwidget.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qradiobutton.h>

// KDE includes
#include <kurlrequester.h>
#include <klineedit.h>
#include <knuminput.h>
#include <klineedit.h>

class Smb4KRsyncOptions : public QTabWidget
{
  Q_OBJECT

  friend class Smb4KOptionsDlg;

  public:
    /**
     * The constructor.
     *
     * @param parent        The parent widget
     *
     * @param name          The name of this widget
     */
    Smb4KRsyncOptions( QWidget *parent = 0, const char *name = 0 );

    /**
     * The destructor
     */
    ~Smb4KRsyncOptions();

  protected slots:
    /**
     * This slot ss invoked if the "Archive mode" checkbox has been
     * toggled.
     *
     * @param on            Is TRUE if the checkbox is checked and FALSE otherwise.
     */
    void slotArchiveToggled( bool on );

    /**
     * This slot is invoked if the --archive option has to be switched
     * off.
     *
     * @param on            Is FALSE if one of the connected checkboxes is unchecked
     *                      and TRUE otherwise.
     */
    void slotUncheckArchive( bool on );

    /**
     * This slot is invoked when the m_existing check box has been
     * toggled.
     *
     * @param on            Is TRUE if the m_existing check box has been checked
     *                      and FALSE otherwise.
     */
    void slotExistingToggled( bool on );

    /**
     * This slot is invoked when the m_ignore_existing check box has been
     * toggled.
     *
     * @param on            Is TRUE if the m_ignore_existing check box has been
     *                      checked and FALSE otherwise.
     */
    void slotIgnoreExistingToggled( bool on );

    /**
     * This slot is called, when the backup checkbox has been toggled.
     * It enables/disables all other backup options according to the
     * state the backup button is in.
     *
     * @param on            Is TRUE if the m_backup check box has been
     *                      checked and FALSE otherwise.
     */
    void slotBackupToggled( bool on );

    /**
     * This slot is called if the '-F' shortcut has been toggled.
     * It unchecks the '-F -F' shortcut.
     *
     * @param on            Is TRUE is m_f_filter is checked and FALSE otherwise.
     */
    void slotFShortcutToggled( bool on );

    /**
     * This slot is called if the '-F -F' shortcut has been toggled.
     * It unchecks the '-F' shortcut.
     *
     * @param on            Is TRUE is m_ff_filter is checked and FALSE otherwise.
     */
    void slotFFShortcutToggled( bool on );

  private:
    /**
     * This is the "Rsync prefix" label
     */
    QLabel *m_rsync_prefix_label;

    /**
     * This KURLRequester holds the sync prefix.
     */
    KURLRequester *m_rsync_prefix;

    /**
     * --archive option
     */
    QCheckBox *m_archive;

    /**
     * --recursive option
     */
    QCheckBox *m_recursive;

    /**
     * --links option
     */
    QCheckBox *m_links;

    /**
     * --perms option
     */
    QCheckBox *m_perms;

    /**
     * --times option
     */
    QCheckBox *m_times;

    /**
     * --group option
     */
    QCheckBox *m_group;

    /**
     * --owner option
     */
    QCheckBox *m_owner;

    /**
     * --devices option
     */
    QCheckBox *m_devices;

    /**
     * --relative option
     */
    QCheckBox *m_relative;

    /**
     * --omit-dir-times option
     */
    QCheckBox *m_omit_dir_times;

    /**
     * --no-implied-dirs option
     */
    QCheckBox *m_no_implied_dirs;

    /**
     * --update option
     */
    QCheckBox *m_update;

    /**
     * --inplace option
     */
    QCheckBox *m_inplace;

    /**
     * --dirs option
     */
    QCheckBox *m_dirs;

    /**
     * --copy-links option
     */
    QCheckBox *m_copy_links;

    /**
     * --copy-unsafe-links option
     */
    QCheckBox *m_copy_unsafe_links;

    /**
     * --safe-links option
     */
    QCheckBox *m_safe_links;

    /**
     * --hard-links option
     */
    QCheckBox *m_hard_links;

    /**
     * --keep-dirlinks option
     */
    QCheckBox *m_keep_dirlinks;

    /**
     * --delete option
     */
    QCheckBox *m_delete;

    /**
     * --remove-sent-files option
     */
    QCheckBox *m_remove_sent_files;

    /**
     * --delete-before option
     */
    QCheckBox *m_delete_before;

    /**
     * --delete-during option
     */
    QCheckBox *m_delete_during;

    /**
     * --delete-after option
     */
    QCheckBox *m_delete_after;

    /**
     * --delete-excluded option
     */
    QCheckBox *m_delete_excluded;

    /**
     * --ignore-errors option
     */
    QCheckBox *m_ignore_errors;

    /**
     * --force option
     */
    QCheckBox *m_force;

    /**
     * --whole-file option
     */
    QCheckBox *m_whole_file;

    /**
     * --sparse option
     */
    QCheckBox *m_sparse;

    /**
     * --one-file-system option
     */
    QCheckBox *m_one_file_system;

    /**
     * --existing option
     */
    QCheckBox *m_existing;

    /**
     * --ignore-existing option
     */
    QCheckBox *m_ignore_existing;

    /**
     * --delay-updates option
     */
    QCheckBox *m_delay_updates;

    /**
     * --compress option
     */
    QCheckBox *m_compress;

    /**
     * --backup option
     */
    QCheckBox *m_backup;

    /**
     * --backup-dir option
     */
    QCheckBox *m_backup_dir;

    /**
     * The url requester for the backup directory
     */
    KURLRequester *m_backup_dir_requester;

    /**
     * --suffix option
     */
    QCheckBox *m_suffix;

    /**
     * The backup suffix line edit.
     */
    KLineEdit *m_suffix_line;

    /**
     * --max-delete=NUM option
     */
    QCheckBox *m_max_delete;

    /**
     * The NUM input for --max-delete=NUM option
     */
    KIntNumInput *m_max_delete_input;

    /**
     * --checksum option
     */
    QCheckBox *m_checksum;

    /**
     * --block-size=NUM option
     */
    QCheckBox *m_block_size;

    /**
     * The block size NUM input.
     */
    KIntNumInput *m_block_size_input;

    /**
     * --checksum-seed=NUM option
     */
    QCheckBox *m_checksum_seed;

    /**
     * The checksum seed NUM input
     */
    KIntNumInput *m_checksum_seed_input;

    /**
     * This is the filter text box.
     */
    KLineEdit *m_filter_input;

    /**
     * --min-size=SIZE option
     */
    QCheckBox *m_min_size;

    /**
     * The value for the --min-size=SIZE option
     */
    KIntNumInput *m_min_size_input;

    /**
     * --max-size=NUM option
     */
    QCheckBox *m_max_size;

    /**
     * The value for the --max-size=SIZE option
     */
    KIntNumInput *m_max_size_input;

    /**
     * --partial option
     */
    QCheckBox *m_partial;

    /**
     * --partial-dir=DIR option
     */
    QCheckBox *m_partial_dir;

    /**
     * The directory for --partial-dir=DIR option
     */
    KURLRequester *m_partial_dir_requester;

    /**
     * --cvs-exclude option
     */
    QCheckBox *m_cvs_exclude;

    /**
     * -F shortcut option
     */
    QCheckBox *m_f_filter;

    /**
     * -F -F shortcut option
     */
    QCheckBox *m_ff_filter;

    /**
     * --exclude=PATTERN option
     */
    QCheckBox *m_exclude;

    /**
     * The PATTERN line edit for the --exclude=PATTERN option.
     */
    KLineEdit *m_exclude_input;

    /**
     * --exclude-from=FILE option
     */
    QCheckBox *m_exclude_from;

    /**
     * The file input for --exclude-from=FILE
     */
    KURLRequester *m_exclude_from_input;

    /**
     * --include=PATTERN option.
     */
    QCheckBox *m_include;

    /**
     * The PATTERN line edit for the --include=PATTERN option
     */
    KLineEdit *m_include_input;

    /**
     * --include-from=FILE option
     */
    QCheckBox *m_include_from;

    /**
     * The file input for --include-from=FILE
     */
    KURLRequester *m_include_from_input;
};

#endif
