/***************************************************************************
    smb4ksharesmenuwidget  -  description
                             -------------------
    begin                : Mi Mr 16 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSHARESMENUWIDET_H
#define SMB4KSHARESMENUWIDET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <kactionclasses.h>
#include <kactioncollection.h>

/**
 * This class provides a KActionMenu filled with all mounted shares.
 * Each share is layed out as KAction. Clicking one of them will open
 * the mount point in Konqueror.
 *
 * @author  Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KSharesMenuWidget : public KActionMenu
{
  Q_OBJECT

  public:
    /**
     * The constructor.
     *
     * @param parent      the parent widget
     *
     * @param name        the name of the class
     */
    Smb4KSharesMenuWidget( QObject *parent = 0, const char *name = 0 );
    /**
     * The destructor.
     */
    ~Smb4KSharesMenuWidget();
    /**
     * This function returns a pointer to the action collection of this class.
     * You should use it to include the action into the action collection of the
     * main action collection (e.g. KMainWindow::actionCollection()).
     *
     * The actions in this collection are members of the group "MountedShares".
     *
     * @returns       a pointer to the action collection of this class
     */
    KActionCollection *action_collection() { return m_collection; }

  protected slots:
    /**
     * This slot should be called when the list of mounted shares changed.
     */
    void slotUpdatedShareList();
    /**
     * This slot is invoked if an action of the action collection is highlighted.
     *
     * @param action      the action that's highlighted
     */
    void slotActionHighlighted( KAction *action );
    /**
     * This slot is invoked if an unmount action has been activated.
     */
    void slotUnmount();
    /**
     * This slot is invoked when the user activated the synchronize action.
     */
    void slotSynchronize();
    /**
     * This slot is invoked when the user wants to force the unmounting of a share.
     */
    void slotForceUnmount();
    /**
     * This slot is invoked when the user wants to open the share in the filemanager.
     */
    void slotFilemanager();


  private:
    /**
     * The action collection of this class.
     */
    KActionCollection *m_collection;
    /**
     * The currently highlighted KAction.
     */
    KAction *m_action;
};

#endif
