/***************************************************************************
                          smb4ksharewidgetitem  -  description
                             -------------------
    begin                : So Aug 7 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qimage.h>

// KDE includes
#include <kiconloader.h>
#include <kiconeffect.h>
#include <kapplication.h>

// application specific includes
#include "smb4ksharewidgetitem.h"
#include "smb4ksharewidget.h"


Smb4KShareWidgetItem::Smb4KShareWidgetItem( Smb4KShare *share, Smb4KShareWidget *parent, int alignment, bool mp )
: KIconViewItem( parent, QString::null ), m_share( *share ), m_alignment( alignment ), m_mountpoint( mp )
{
  setupItem( alignment, mp );
}


Smb4KShareWidgetItem::~Smb4KShareWidgetItem()
{
}

/****************************************************************************
   Paints an item.
****************************************************************************/


void Smb4KShareWidgetItem::paintItem( QPainter *p, const QColorGroup &cg )
{
  QColorGroup colorgrp( cg );

  if ( m_share.isForeign() )
  {
    colorgrp.setColor( QColorGroup::Text, Qt::gray );
  }

  QIconViewItem::paintItem( p, colorgrp );
}


void Smb4KShareWidgetItem::setupItem( int alignment, bool mountpoint )
{
  QPixmap pix;

  int icon_state = m_share.isForeign() ? KIcon::DisabledState : KIcon::DefaultState;

  if ( m_share.isBroken() )
  {
    QImage over = kapp->iconLoader()->loadIcon( "button_cancel", alignment == Icons ? KIcon::Desktop : KIcon::Small, 0, icon_state, 0L, false ).convertToImage();
    QImage src = kapp->iconLoader()->loadIcon( "hdd_mount", alignment == Icons ? KIcon::Desktop : KIcon::Small, 0, icon_state, 0L, false ).convertToImage();

    QImage over_desk = kapp->iconLoader()->loadIcon( "button_cancel", KIcon::Desktop, 0, icon_state, 0L, false ).convertToImage();
    QImage src_desk = kapp->iconLoader()->loadIcon( "hdd_mount", KIcon::Desktop, 0, icon_state, 0L, false ).convertToImage();

    KIconEffect e;
    e.semiTransparent( over );
    e.overlay( src, over );
    e.semiTransparent( over_desk );
    e.overlay( src_desk, over_desk );

    pix = QPixmap( src );
    m_desktop_pixmap = QPixmap( src_desk );
  }
  else
  {
    pix = kapp->iconLoader()->loadIcon( "hdd_mount", alignment == Icons ? KIcon::Desktop : KIcon::Small, 0, icon_state, 0L, false );

    m_desktop_pixmap = kapp->iconLoader()->loadIcon( "hdd_mount", KIcon::Desktop, 0, icon_state, 0L, false );
  }

  setPixmap( pix );
  setText( mountpoint ? m_share.path() : m_share.name() );

  m_alignment = alignment;
  m_mountpoint = mountpoint;
}


void Smb4KShareWidgetItem::replaceShareObject( Smb4KShare *share )
{
  bool setup = m_share.isBroken() == share->isBroken() ? false : true;

  m_share = *share;

  if ( setup )
  {
    setupItem( m_alignment, m_mountpoint );
  }
}
