#ifndef __config_h
#define __config_h

#include <map>
#include <string>
#include <iostream>

class Config {
	typedef std::map<const std::string, std::string> Params;
	Params params;

	void ReadFile(const std::string &filename = "");
	void ReadEnv();
	void ReadConfigFiles();
	std::string EmailAddress();
public:
	Config();

	void ReRead(const std::string &name);
	std::string &operator[](const std::string &name) { return params[name]; };
	void AddLine(const std::string &line);
	bool isTrue(const std::string &s);
	
	std::string ParseConfigLine(const std::string &line);
	void ReParse();
	
	friend std::ostream &operator<<(std::ostream &, Config &);
};

#endif
