/*==================================================================
 * sequencer.h - Header for sequencer routines
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef __SEQUENCER_H__
#define __SEQUENCER_H__

#include "config.h"

#include <glib.h>
#include "sfont.h"

enum
{
  SEQ_NONE,
#ifdef ALSA_SUPPORT
  SEQ_ALSA,
#endif
#ifdef OSS_SUPPORT
  SEQ_OSS,
#endif
  SEQ_COUNT
} SeqDriverType;

/* sequencer driver information and function pointers */
typedef struct
{
  char *name;			/* textual name of driver */
  void (*config) (void);	/* load driver local config vars (smurfcfg) */
  gint (*init) (void);		/* initialize driver */
  void (*close) (void);		/* close driver */
  void (*set_bank) (gint chan, gint bank); /* set active bank */  
  void (*set_preset) (gint chan, gint preset); /* set active preset */
  void (*start_note) (gint chan, gint note, gint vel);
  void (*stop_note) (gint chan, gint note, gint vel);
  void (*pitch_bender) (gint chan, gint bendval);
  void (*pitch_bend_range) (gint chan, gint val);
  void (*main_volume) (gint chan, gint val);
  void (*chorus) (gint chan, gint val);
  void (*reverb) (gint chan, gint val);
} SeqDriverInfo;

extern SeqDriverInfo seq_drivers[];	/* array of sequencer driver info */

gint seq_driver;
gboolean seq_active;

gint seq_init_from_config (void);
gint seq_auto_init (void);
void seq_set_driver (guint drvr_id);
gint seq_locate_byname (gchar * name);

gint seq_init (void);
void seq_close (void);
void seq_set_bank (gint chan, gint bank);
void seq_set_preset (gint chan, gint preset);
void seq_note_on (gint chan, gint note, gint vel);
void seq_note_off (gint chan, gint note, gint vel);
void seq_pitch_bender (gint chan, gint bendval);
void seq_pitch_bend_range (gint chan, gint val);
void seq_main_volume (gint chan, gint val);
void seq_chorus (gint chan, gint val);
void seq_reverb (gint chan, gint val);

#endif	/* __SEQUENCER_H__ */
