/*==================================================================
 * uif_sftree.h - Header file for Sound font tree routines
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef __UIF_SFTREE__
#define __UIF_SFTREE__

#include <gtk/gtk.h>
#include "sfont.h"

/* SFItemIDs in sftree_sfitems will not have this value, i.e. equiv. to NULL */
#define SFITEMID_NONE	0

/* for the "pos" argument of sftree_add_(pzone|inst|izone|sample) functions, to
   specify to append item */
#define SFTREE_NODE_APPEND -1

/* sound font tree node types (see rmu_array in uif_treemenu.c if altered) */
typedef enum
{
  NODE_NONE, NODE_SFONT,
  NODE_PRESETROOT, NODE_MELODIC, NODE_PERCUSS, NODE_PRESET, NODE_PZONE,
  NODE_INSTROOT, NODE_INST, NODE_IZONE,
  NODE_SAMPLEROOT, NODE_USER, NODE_ROM, NODE_SAMPLE,
  NODE_VBANK, NODE_VBNK_DEFBANK, NODE_VBNK_MAPROOT, NODE_VBNK_MAP,
  NODE_LAST
}
SFNodeType;

/* each node in the tree points to one of these */
typedef struct _SFTreeRef
{
  SFNodeType type;		/* the type of node */
  SFItemID itemid;		/* sound font item ID */
  gpointer dptr;		/* pointer to data associated with this type */
}
SFTreeRef;

/* major nodes for an individual sound font in the tree */
typedef struct _SFTreeNodes
{
  GtkCTreeNode *sfont;
  GtkCTreeNode *preset;
  GtkCTreeNode *melodic;
  GtkCTreeNode *percuss;
  GtkCTreeNode *inst;
  GtkCTreeNode *sample;
  GtkCTreeNode *loaded;
  GtkCTreeNode *rom;
}
SFTreeNodes;

/* major nodes for a virtual bank in the tree */
typedef struct _VBnkNodes
{
  GtkCTreeNode *vbank;
  GtkCTreeNode *defbank;
  GtkCTreeNode *inclroot;
  GtkCTreeNode *maproot;
} VBnkNodes;


/* hack to fix UISFont/SFTreeNodes header mutual dependancy */
#include "uif_sfont.h"

#define SFTREE_LOOKUP_ITEMID(id) GTK_CTREE_NODE (sfont_lookup_itemid (id))

#define SFTREE_NODE_REF(node) ((SFTreeRef *)gtk_ctree_node_get_row_data \
  (sftree_widg, node))

#define SFTREE_NODE_DATA(node) (((SFTreeRef *)gtk_ctree_node_get_row_data \
  (sftree_widg, node))->dptr)

/* convenience macros for root sound font CTree nodes */
#define SFTREE_SFNODE_UISF(node) ((UISFont *)(SFTREE_NODE_REF(node)->dptr))
#define SFTREE_SFNODE_SFONT(node) ((UISFont *)(SFTREE_NODE_REF(node)->dptr))->sf
#define SFTREE_SFNODE_UIVB(node) ((UIVBank *)(SFTREE_NODE_REF(node)->dptr))

#define SFTREE_SELECTION()	(GTK_CLIST(sftree_widg)->selection)
#define SFTREE_SELECTION_IS_SINGLE() (SFTREE_SELECTION () && \
				     !SFTREE_SELECTION ()->next)
#define SFTREE_SELECTION_IS_MULTI() (SFTREE_SELECTION () && \
				    SFTREE_SELECTION ()->next)
#define SFTREE_REMOVE_NODE(node) gtk_ctree_remove_node(sftree_widg, node)

#define SFTREE_FREEZE() gtk_clist_freeze (GTK_CLIST (sftree_widg))
#define SFTREE_THAW() gtk_clist_thaw (GTK_CLIST (sftree_widg))

/* parent upward find convenience macros */
#define SFTREE_UPFIND_UISF(node) ((UISFont *)sftree_find_parent_data_by_type(node, NODE_SFONT))
#define SFTREE_UPFIND_UIVB(node) ((UIVBank *)sftree_find_parent_data_by_type(node, NODE_VBANK))

/* global data */

GtkCTree *sftree_widg;
SFItemID sftree_rclicked_itemid;

/* Prototypes */
GtkCTreeNode *sftree_add_sfont (UISFont * uisf);
void sftree_remove_sfont (UISFont * uisf);
GtkCTreeNode *sftree_add_preset (GSList * preset, GtkCTreeNode * pos,
  SFTreeNodes * sfnodes);
GtkCTreeNode *sftree_add_preset_sorted (GSList * plist,
  SFTreeNodes * sfnodes);
GtkCTreeNode *sftree_add_pzone (GSList *lzone, GtkCTreeNode *parent, gint pos);
GtkCTreeNode *sftree_add_inst (GSList * linst,SFTreeNodes * sfnodes, gint pos);
GtkCTreeNode *sftree_add_izone (GSList *lzone, GtkCTreeNode *parent, gint pos);
GtkCTreeNode *sftree_add_sample (GSList * lsample, SFTreeNodes * sfnodes,
				 gint pos);
GtkCTreeNode *sftree_add_vbank (UIVBank * uivb);
GtkCTreeNode *sftree_add_vbank_map (GSList *lmap, GtkCTreeNode *pos,
				    VBnkNodes *nodes);
GtkCTreeNode *sftree_add_vbank_map_sorted (GSList *lmap, VBnkNodes *nodes);
void sftree_remove_vbank (UIVBank *uivb);

GtkWidget *sftree_create (void);

void sftree_update_sfont_node_label (UISFont * uisf);
void sftree_update_vbank_node_label (UIVBank * uivb);
void sftree_set_tree_node_label (GtkCTreeNode * node, gchar * text);
GList *sftree_get_selection (void);
SFItemID sftree_get_selection_single (void);
GList *sftree_get_selection_multi (void);
void sftree_set_selection (GList *sel);
void sftree_set_selection_single (SFItemID qnode);
void sftree_unset_selection (void);
gboolean sftree_is_node_selected (GtkCTreeNode *node);
void sftree_clear_selection (void);

GtkCTreeNode *sftree_find_parent_by_type (GtkCTreeNode * node,
  SFNodeType type);
void *sftree_find_parent_data_by_type (GtkCTreeNode * node, SFNodeType type);
GList *sftree_find_nodes (gint type, gpointer dptr, GtkCTreeNode * under);
void sftree_spotlight_node (GtkCTreeNode * node);

void sftree_set_highlight (GtkCTreeNode *node, GtkStateType state);
void sftree_unset_highlight (GtkCTreeNode *node);
void sftree_set_aux_pixmap (GtkCTreeNode *node, gchar **xpm);

#endif /* __UIF_SFTREE__ */
