/*==================================================================
 * piano.h - Header file for piano widget
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef __PIANO_H__
#define __PIANO_H__

#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>

#define PIANO(obj)	GTK_CHECK_CAST(obj, piano_get_type(), Piano)
#define PIANO_CLASS(klass)	GTK_CHECK_CLASS_CAST(klass, piano_get_type(), PianoClass)
#define IS_PIANO(obj)	GTK_CHECK_TYPE(obj, piano_get_type ())

#define PIANO_DEFAULT_SIZEX	676
#define PIANO_DEFAULT_SIZEY	48

typedef struct _Piano Piano;
typedef struct _PianoClass PianoClass;

struct _Piano
{
  GtkWidget widget;

  GdkPixmap *keyb_pm;		/* The entire keyboard pixmap */
  GdkPixmap *selw_pm;		/* white key selected pixmap */
  GdkPixmap *unsw_pm;		/* white key unselected pixmap */
  GdkPixmap *selb_pm;		/* black key selected pixmap */
  GdkPixmap *unsb_pm;		/* black key unselected pixmap */

  GdkGC *shadowgc;		/* graphics context for shadow key line */
  GdkColor shadclr;		/* shadow color for shadow key line */

  gboolean *selkeys;		/* ptr to array of 128 boolean flags of active keys */
  guint8 key_mouse;		/* mouse selected key >127 = none */
  guint8 key_lospan;		/* selected zone lo span key >127 = none */
  guint8 key_hispan;		/* selected zone hi span key >127 = none */
  guint8 key_root;		/* selected zone root key > 127 = none */
};

struct _PianoClass
{
  GtkWidgetClass parent_class;

  void (*note_on) (Piano * piano, guint keynum);
  void (*note_off) (Piano * piano, guint keynum);
};

GtkWidget *piano_new (gboolean * selkeys);
guint piano_get_type (void);
void piano_note_on (Piano * piano, guint8 keynum);
void piano_note_off (Piano * piano, guint8 keynum);
gint piano_key_to_xpos (guint8 keynum);
guint8 piano_xpos_to_key (gint xpos);

#endif /* __PIANO_H__ */
