/*
 * ----------------------------------------------------------------
 *  Compose the ARMee board from Electronic magazine elektor
 *
 * (C) 2005 Jochen Karrer 
 *   Author: Jochen Karrer
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ----------------------------------------------------------------
 */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>

#include <idecode.h>
#include <signode.h>
#include <mmu.h>
#include <fio.h>
#include <bus.h>
#include <configfile.h>
#include <debugserver.h>
#include <loader.h>
#include <i2c_serdes.h>
#include <m24cxx.h>
#include <boards.h>
#include <lpcflash.h>
#include <sram.h>
#include <pc16550.h>
#include <pl190_irq.h>
#include <lpc2106_timer.h>
#include <lpc2106_gpio.h>
#include <lpc2106_scb.h>

/*
 * ---------------------------------------------------------------
 * Link some Electrical signals in the same way as in schematics
 * This has to be done when all devices are created, because
 * you can not link nonexisting Signals
 * ---------------------------------------------------------------
 */
static void
create_signal_links()
{
	SigName_Link("arm.irq","vic.irq");
	SigName_Link("arm.fiq","vic.fiq");
	SigName_Link("timer0.irq","vic.nVICINTSOURCE4");
	SigName_Link("timer1.irq","vic.nVICINTSOURCE5");
	SigName_Link("uart0.irq","vic.nVICINTSOURCE6");
	SigName_Link("uart1.irq","vic.nVICINTSOURCE7");
}
static int
board_armee_create()
{
        ArmCoprocessor *copro;
	BusDevice *dev;

        Bus_Init(MMU_InvalidateTlb,4*1024);
        ARM9_New();
	/* Copro is created but not registered (1:1 translation is bootup default) */
        copro = MMU_Create("mmu",TARGET_BYTEORDER);

	dev = PL190_New("vic");
	Mem_AreaAddMapping(dev,0xfffff000,0x1000,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);

	dev = SRam_New("iram");
	Mem_AreaAddMapping(dev,0x40000000,256*1024,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);

	dev = LPCFlash_New("iflash"); 
	Mem_AreaAddMapping(dev,0x00000000,128*1024,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);

	dev = LPC2106Timer_New("timer0");
	Mem_AreaAddMapping(dev,0xE0004000,0x20,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);

	dev = LPC2106Timer_New("timer1");
	Mem_AreaAddMapping(dev,0xE0008000,0x20,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);

	dev = PC16550_New("uart0",2);
	Mem_AreaAddMapping(dev,0xE000C000,0x20,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);

	dev = PC16550_New("uart1",2);
	Mem_AreaAddMapping(dev,0xE0010000,0x20,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);

	LPC2106_GpioNew("gpio");

	dev = LPC2106_ScbNew("scb");
	Mem_AreaAddMapping(dev,0xE01FC000,0x200,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);

	create_signal_links();
	return 0;
}

static void
board_armee_run(Board *bd) {
        ARM9_Run();
}

#define DEFAULTCONFIG \
"[global]\n" \
"start_address: 0\n"\
"[iram]\n" \
"size: 64k\n" \
"\n" \
"[loader]\n" \
"load_address: 0x0\n"\
"\n" \
"[iflash]\n"\
"size: 128k\n"\
"\n"

Board board_armee = {
        .name = "ARMee",
        .description =  "Elektor ARMee Board",
        .createBoard =  board_armee_create,
        .runBoard =     board_armee_run,
        .defaultconfig = DEFAULTCONFIG
};

void
_init() {
        fprintf(stderr,"Loading ARMee Board module\n");
        Board_Register(&board_armee);
}

