/*
 * --------------------------------------------------------------------
 * USB printer 
 * --------------------------------------------------------------------
 */

#include <stdio.h>
#include <stdint.h>
#include <stdint.h>
#include <string.h>
#include <usbdevice.h>

typedef struct UsbPrinter {
	UsbDevice *usbdev;	
	UsbEndpoint ep[3]; /* control, bulk out,bulk in */
} UsbPrinter;

/* Endpoint 0 */
static int 
Control_ToDevice(UsbDev_Endpoint *,const UsbRequest *) 
{

}
static int
Control_FromDevice(UsbDev_Endpoint *,UsbRequest*) 
{

}

/* Endpoint 1: Bulk IN endpoint */
static int
Bulk_FromDevice(UsbDev_Endpoint *,UsbRequest*) 
{

}

/* Endpoint 2: Bulk OUT endpoint */

Bulk_ToDevice(UsbDev_Endpoint *epnt,const UsbRequest *req)
{
	
}

static void
UsbPrinter_New(const char *name) 
{
	UsbPrint *prn = malloc(sizeof(UsbPrinter));
	UsbDevice *udev;
	if(!prn) {
		fprintf(stderr,"Out of memory allocating USB-Printer\n");
		exit(1);
	}
	memset(prn,0,sizeof(*prn));
	udev = prn->usbdev = UsbDevice_New();
	prn.ep[0].type = EPNT_TYPE_CONTROL;
	prn.ep[0].toDevice = Control_ToDevice;
	prn.ep[0].fromDevice = Control_FromDevice;

	prn.ep[1].type = EPNT_TYPE_BULK;
	prn.ep[1].toDevice = Bulk_ToDevice;

	prn.ep[2].type = EPNT_TYPE_BULK;
	prn.ep[2].fromDevice = Bulk_FromDevice;

	UsbDevice_RegisterEndpoint(udev,&prn.ep[0],0);
	UsbDevice_RegisterEndpoint(udev,&prn.ep[1],1);
	/* Optional */
	UsbDevice_RegisterEndpoint(udev,&prn.ep[2],2);
}
