/*
 * ----------------------------------------------------------------------
 *
 * PCL3 Interpreter
 *
 * (C) 2006 Jochen Karrer
 *   Author: Jochen Karrer
 *
 * state:	No commands implemented. 
 *		Understands only the UEL Escape sequence to exit to PJL 
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ----------------------------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include "pcl3.h"

#define STATE_IDLE   (0)
#define STATE_PCLCMD (1)
#define STATE_DATA   (2)

struct PCL3_Interp  {
	int state;
	char cmdbuf[30];
	int cmd_wp;
	int data_expected;
};

/*
 * ------------------------------------------------------------------------------------------
 * Eval PCL3 Command returns <0 when no command was recoginzed (incomplete for example)
 * returns the number of following data bytes when a command was recognized
 * ------------------------------------------------------------------------------------------
 */

static int
eval_pcl3_cmd(PCL3_Interp *interp,int *done) 
{
	if(strcmp("%-12345X",interp->cmdbuf) == 0) {
		fprintf(stderr,"Exiting from PCL3 Interpreter because of UEL\n");
		*done=1;
		return 0;
	}	
	return -1;
}

/*
 * --------------------------------------------------------
 * Feed the PCL3 interpreter with commands
 * --------------------------------------------------------
 */
int
PCL3Interp_Feed(PCL3_Interp *interp,uint8_t *buf,int len,int *done)
{

	int count;
	int result;
	*done = 0;
	for(count=0;count < len;count++) {
		switch(interp->state) {
			case STATE_IDLE:
				if(buf[count] == 0x1b) {
					interp->state = STATE_PCLCMD;
					interp->cmd_wp = 0;
					break;
				} else {
					// print text
				}	
				break;
			case STATE_PCLCMD:
				if((interp->cmd_wp+1) >= sizeof(interp->cmdbuf)) {
					interp->state = STATE_IDLE;
					interp->cmd_wp = 0;
				}	
				if(buf[count] == 0x1b) {
					// Premature end or unimplemented command
					interp->state = STATE_PCLCMD;
					interp->cmd_wp = 0;
				} else {
					interp->cmdbuf[interp->cmd_wp++] = buf[count];
					interp->cmdbuf[interp->cmd_wp] = 0;
					result = eval_pcl3_cmd(interp,done); 
					if(result < 0) {
						break;
					} else if (result == 0) {
						/* next command */
						interp->state = STATE_IDLE;
						interp->cmd_wp = 0;
						if(*done == 1) {
							return count;
						}
					} else if(result > 0) {
						/* Data phase follows */
						/* Should set a limit on expected data */
						interp->cmd_wp = 0;
						interp->state = STATE_DATA;
						interp->data_expected = result;
					}
				}
				break;
			case STATE_DATA:
				/* 
				 * Currently eat up data and do nothing because nothing is 
				 * implemented
				 */
				interp->data_expected--;
				if(interp->data_expected == 0) {
					interp->state = STATE_IDLE;
					interp->cmd_wp = 0;
				}
				break;
		}
	}
	return count;
}

void
PCL3Interp_Reset(PCL3_Interp *interp)
{
}

PCL3_Interp *
PCL3Interp_New(void)
{
	PCL3_Interp *interp = malloc(sizeof(*interp));
	if(!interp) {
		fprintf(stderr,"Out of memory allocating PCL3 Interpreter\n");
		exit(1);
	}
	interp->state = STATE_IDLE;
	return interp;
}
